/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import symantec.beans.Beans;
import symantec.itools.awt.InfoTipManager;
import symantec.itools.util.Timer;

public abstract class ButtonBase
extends Canvas {
    protected boolean pressed = false;
    protected boolean released = true;
    protected boolean inButton;
    protected boolean notifyWhilePressed = false;
    protected boolean showInfoTip = false;
    protected boolean running = false;
    protected boolean notified = false;
    protected boolean showFocus;
    protected boolean doInfoTip;
    protected int bevel = 1;
    protected int notifyDelay = 1000;
    protected int infoTipDelay = 1000;
    protected int pressedAdjustment = 0;
    protected String infoTipText;
    protected Color infoTipTextColor = Color.black;
    protected Timer notifyTimer = null;
    protected Timer infoTipTimer = null;
    protected int infoTipX;
    protected int infoTipY;
    protected LayoutManager infoTipLayoutManager;

    protected ButtonBase() {
        this.resize(10, 10);
    }

    public void setBevelHeight(int size) {
        try {
            this.checkBevelSize(size);
        }
        catch (AWTException aWTException) {
            System.err.println("Invalid Bevel Size " + size);
        }
        this.bevel = size;
        this.invalidate();
    }

    public int getBevelHeight() {
        return this.bevel;
    }

    public void setNotifyWhilePressed(boolean f) {
        this.notifyWhilePressed = f;
        if (this.notifyWhilePressed) {
            this.notifyTimer = new Timer((Component)this, this.notifyDelay, true, 1001);
            return;
        }
        if (this.notifyTimer != null) {
            this.notifyTimer = null;
        }
    }

    public boolean getNotifyWhilePressed() {
        return this.notifyWhilePressed;
    }

    public void setNotifyDelay(int d) {
        this.notifyDelay = d;
    }

    public int getNotifyDelay() {
        return this.notifyDelay;
    }

    public void setShowInfoTip(boolean f) {
        this.showInfoTip = f;
        if (this.showInfoTip) {
            this.infoTipTimer = new Timer((Component)this, this.notifyDelay, true, 1001);
            return;
        }
        if (this.infoTipTimer != null) {
            this.infoTipTimer = null;
        }
    }

    public boolean getShowInfoTip() {
        return this.showInfoTip;
    }

    public void setInfoTipDelay(int d) {
        this.infoTipDelay = d;
    }

    public int getInfoTipDelay() {
        return this.infoTipDelay;
    }

    public void setShowFocus(boolean f) {
        this.showFocus = f;
    }

    public boolean getShowFocus() {
        return this.showFocus;
    }

    public void setInfoTipText(String t) {
        this.infoTipText = t;
    }

    public String getInfoTipText() {
        return this.infoTipText;
    }

    public void setInfoTipTextColor(Color c) {
        this.infoTipTextColor = c;
    }

    public Color getInfoTipTextColor() {
        return this.infoTipTextColor;
    }

    public boolean mouseUp(Event e, int x, int y) {
        if (this.running) {
            this.running = false;
            this.notifyTimer.stop();
        }
        if (this.pressed) {
            this.pressed = false;
            this.pressedAdjustment = 0;
            if (!this.notifyWhilePressed || !this.notified) {
                this.postEvent(new Event(this, 1001, null));
            }
        }
        this.released = true;
        this.repaint();
        return true;
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (this.notifyWhilePressed && !this.running) {
            this.running = true;
            this.notifyTimer.start();
        }
        this.pressed = true;
        this.released = false;
        this.pressedAdjustment = this.bevel;
        this.repaint();
        return true;
    }

    public boolean mouseEnter(Event e, int x, int y) {
        this.inButton = true;
        if (this.showInfoTip) {
            this.infoTipX = x;
            this.infoTipY = y;
            this.infoTipTimer.start();
        }
        if (!this.released) {
            this.mouseDown(e, x, y);
        }
        return true;
    }

    public boolean mouseExit(Event e, int x, int y) {
        this.inButton = false;
        if (this.showInfoTip) {
            this.infoTipTimer.stop();
            Panel infoTipPanel = InfoTipManager.getInfoTipPanel();
            infoTipPanel.getParent().setLayout(this.infoTipLayoutManager);
            infoTipPanel.hide();
        }
        if (this.pressed) {
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        return true;
    }

    public boolean action(Event e, Object o) {
        if (this.notifyWhilePressed && e.target == this.notifyTimer && !Beans.isDesignTime()) {
            this.postEvent(new Event(this, 1001, null));
            return true;
        }
        if (this.showInfoTip && e.target == this.infoTipTimer) {
            this.doInfoTip = true;
            this.repaint();
            this.infoTipTimer.stop();
            return true;
        }
        return super.action(e, o);
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        this.repaint();
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.notifyTimer != null) {
                this.notifyTimer.stop();
            }
            if (this.infoTipTimer != null) {
                this.infoTipTimer.stop();
            }
            this.pressed = false;
            this.pressedAdjustment = 0;
        }
        this.repaint();
    }

    public void update(Graphics g) {
        Dimension s = this.size();
        g.clipRect(0, 0, s.width, s.height);
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension s = this.size();
        int width = s.width;
        int height = s.height;
        int x = this.bevel + 1;
        int y = this.bevel + 1;
        int w = width - 1;
        int h = height - 1;
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, width, height);
        if (this.pressed) {
            y = x += this.bevel > 0 ? 2 : 1;
            g.setColor(Color.lightGray);
            int i = 1;
            while (i < this.bevel + 1) {
                g.drawLine(i, h - i, w - i, h - i);
                g.drawLine(w - i, h - i, w - i, i);
                ++i;
            }
            g.setColor(Color.gray);
            i = 1;
            while (i < this.bevel + 1) {
                g.drawLine(i, h, i, i);
                g.drawLine(i, i, w, i);
                ++i;
            }
        } else {
            g.setColor(Color.white);
            int i = 1;
            while (i < this.bevel + 1) {
                g.drawLine(i, h - i, i, i);
                g.drawLine(i, i, w - i, i);
                ++i;
            }
            g.setColor(Color.gray);
            i = 1;
            while (i < this.bevel + 2) {
                g.drawLine(i, h - i, w - i, h - i);
                g.drawLine(w - i, h - i, w - i, i);
                ++i;
            }
        }
        g.setColor(Color.black);
        g.drawLine(1, 0, width - 2, 0);
        g.drawLine(0, 1, 0, height - 2);
        g.drawLine(1, height - 1, width - 2, height - 1);
        g.drawLine(width - 1, height - 2, width - 1, 1);
        if (this.showInfoTip && this.doInfoTip) {
            this.drawInfoTip();
        }
    }

    protected void drawInfoTip() {
        this.doInfoTip = false;
        Point p = this.location();
        Panel infoTipPanel = InfoTipManager.getInfoTipPanel();
        this.infoTipX += p.x;
        this.infoTipY += p.y;
        this.infoTipLayoutManager = infoTipPanel.getParent().getLayout();
        InfoTipManager.draw((int)this.infoTipX, (int)this.infoTipY, (String)this.infoTipText, (FontMetrics)this.getFontMetrics(this.getFont()), (Color)Color.yellow, (Color)Color.black);
    }

    private void checkBevelSize(int i) throws AWTException {
        Dimension s = this.size();
        if (i < 0 || i >= s.width / 2 || i >= s.height / 2) {
            throw new AWTException("invalid bevel size");
        }
    }
}

