#include <stdio.h>
#include "chartdir.h"

void anglepie(int angle, bool clockwise, const char *filename)
{
	//The data for the pie chart
	double data[] = { 25, 18, 15, 12, 8, 30, 35 };

	//The labels for the pie chart
	const char *labels[] = { "Labor", "Licenses", "Taxes", "Legal",
		"Insurance", "Facilities", "Production" }; 
	
	//First, create a PieChart of size 280 pixels x 240 pixels
	PieChart *c = PieChart::create(280, 240);

	//Set the center of the pie at (140, 130) and the radius to 80 pixels
	c->setPieSize(140, 130, 80);
	
	//add a title to the pie to show the start angle and direction
	char buffer[256];
	sprintf(buffer, "Start Angle = %d degrees\nDirection = %s", 
		angle, clockwise ? "Clockwise" : "AntiClockwise");
	c->addTitle(buffer);
	
	//Set the pie start angle and direction
	c->setStartAngle(angle, clockwise);

	//Draw the pie in 3D
	c->set3D();

	//Set the pie data and the pie labels
	c->setData(sizeof(data)/sizeof(data[0]), data, labels);

	//Explode the 1st sector
	c->sector(0)->setExplode();

	//output the chart
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	anglepie(0, true, "angle0pie.png");
	anglepie(90, false, "angle_90pie.png");
	return 0;
}