#include "chartdir.h"

void gridBar(const char *filename, const char *bgimage = 0)
{
	//The data for the chart
	double data[] = {85, 156, 179.5, 211, 123};
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//First, create a XYChart of size 250 pixels x 250 pixels
	XYChart *c = XYChart::create(250, 250);

	//Set the plotarea at (100, 40) and of size 200(w) x 200(h)
	PlotArea *p = c->setPlotArea(25, 15, 200, 200);
	
	if (bgimage != 0)
	{
		//use the given background image as the plot area background
		p->setBackground(bgimage);
		//turn off the grid by setting it to Transparent
		p->setGridColor(Transparent);
	}
	else
	{
		//no background image, use white and gray as two alternate
		//plotarea background colors
		p->setBackground(0xffffff, 0xe0e0e0);
		//enable horizontal and vertical grid by setting their colors
		p->setGridColor(0xc0c0c0, 0xc0c0c0);
	}

	//Set the labels on the x axis
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add a 3D bar layer with the given data
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data)->set3D();

	//output the chart
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	gridBar("gridband.png");
	gridBar("gridbg.png", "bg.png");
	return 0;
}
