use perlchartdir;


sub gapbar
{
	my ($bargap, $filename) = @_;

	#The data for the bar chart
	my $data = [100, 125, 245.78, 147, 67];

	#The labels for the bar chart
	my $labels = ["Mon", "Tue", "Wed", "Thu", "Fri"];

	#First, create a XYChart of size 150 pixels x 150 pixels
	$c = new XYChart(150, 150); 
	
	#Set the plotarea at (25, 20) and dimension 120(w) x 100(h) 
	$c->setPlotArea(25, 20, 120, 100);

	#add a title to display to bar gap using 8 point arial font
	$c->addTitle(sprintf("      Bar Gap = %0.2f", $bargap), "arial.ttf", 8);

	#Set the x axis labels using the supplied labels
	$c->xAxis()->setLabels($labels);

	#Add a bar chart layer using the supplied data and set the bar gap
	$c->addBarLayer($data)->setBarGap($bargap);

	#output the chart
	$c->makeChart($filename);
}


gapbar(0, "gapbar00.png");
gapbar(0.25, "gapbar25.png");
gapbar(0.5, "gapbar50.png");
gapbar(0.75, "gapbar75.png");
 