from pychartdir import *


######################################/
#
#	This function demonstrates a chart with two synchronous y-axis.
#
######################################/
def syncaxis() :

	#data for the chart
	data = [100, 125, 265, 147, 67, 105]
	labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

	#create a XYChart object of size 300(w) x 180(h)
	c = XYChart(300, 180)
	
	#set the plot area at (50, 20) and of size 200(w) x 130(h)
	c.setPlotArea(50, 20, 200, 130)

	#add a title to the chart using 8 point Arial font (arial.ttf)
	c.addTitle("Synchronous Y-Axis Demo", "arial.ttf", 8)

	#Set the x axis labels using the supplied labels
	c.xAxis().setLabels(labels)
	
	#add a title to the primary (left) y-axis
	c.yAxis().setTitle("Length (meter)")

	#add a title to the secondary (right) y-axis
	c.yAxis2().setTitle("Length (foot)")

	#set the two axis so that y2 = 3.28 x y1  (1 meter = 3.28 feet)
	c.syncYAxis(3.28)
	
	#add a bar layer to represent the data
	c.addBarLayer(data)

	#output the chart as a PNG file
	c.makeChart("syncyaxis.png")


######################################/
#
#	This function demonstrates a chart with two independent y-axis.
#
######################################/
def dualaxis() :

	#data for the chart
	data0 = [0.05, 0.06, 0.48, 0.1, 0.01, 0.05]
	data1 = [100, 125, 265, 147, 67, 105]
	labels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun"]

	#create a XYChart object of size 300(w) x 180(h)
	c = XYChart(300, 180)
	
	#set the plot area at (50, 20) and of size 200(w) x 130(h)
	c.setPlotArea(50, 20, 200, 130)

	#add a title to the chart using 8 point Arial font (arial.ttf)
	c.addTitle("Independent Y-Axis Demo", "arial.ttf", 8)

	#Set the x axis labels using the supplied labels
	c.xAxis().setLabels(labels)

	#add a title to the primary (left) y-axis
	c.yAxis().setTitle("Throughtput (MBytes)")

	#set the axis, label and title colors for the primary y axis to red
	#to represent the first data set
	c.yAxis().setColors(0xC00000, 0xC00000, 0xC00000)
	
	#add a title to the secondary (right) y-axis
	c.yAxis2().setTitle("Packet Drop Rate (%)")

	#set the axis, label and title colors for the primary y axis to green
	#to represent the second data set
	c.yAxis2().setColors(0x00C000, 0x00C000, 0x00C000)
	
	#add a line layer to represent the first data set using red color and
	#set the line width to 3 pixels
	c.addLineLayer(data0, 0xC00000).setLineWidth(3)
	
	#add a bar layer to represent the second data set using green color and 
	#bind the data set to the secondary (right) y-axis
	c.addBarLayer().addDataSet(data1, 0x00C000).setUseYAxis2()
	
	#output the chart as a PNG file
	c.makeChart("dualyaxis.png")


def main() :

	syncaxis()
	dualaxis()


if __name__ == '__main__':
    main()
    
