/*=============================================================================}
{ Example of new item type for RichView:                                       }
{ - TRVBlendBitmapItemInfo                                                     }
{   (semi-transparent image)                                                   }
{ - TRVHotBlendBitmapItemInfo                                                  }
{   (semi-transparent image - hypertext link)                                  }
{------------------------------------------------------------------------------}
{ (c) Sergey Tkachenko (svt@trichview.com)                                     }
{ http://www.trichview.com                                                     }
{=============================================================================*/
#include <vcl.h>
#include <shellapi.h>
#pragma hdrstop

#include "Unit1.h"
#include "RVBlendBitmap.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
 // Note: not very fast drawing, so do not use for large images
 // Note: you can save RVF documents with semitransparent images
 //       (RVF reader must have RVBlendBMP.pas unit in order to
 //       load such files)

  RichView1->AddBreak();
  RichView1->AddNL("Example of Semitransparent Image",1,1);
  RichView1->AddBreak();

  int i;
  for (i=0; i<=10; i++)
    RichView1->AddNL("some text",0,0);

  Graphics::TBitmap* bmp = new Graphics::TBitmap;
  bmp->Assign(Image1->Picture->Bitmap);
  TRVHotBlendBitmapItemInfo* item = new TRVHotBlendBitmapItemInfo(RichView1->RVData, bmp, rvvaBaseline);
  item->Transparency = 100;
  item->HotTransparency = 0;
  // 0 - no transparency,
  // 255 - fully transparent (invisible)
  item->ParaNo = 1;
  RichView1->AddItem("", item);
  RichView1->AddNL("www.trichview.com",4,1);

  for (i=0; i<=10; i++)
    RichView1->AddNL("some text",0,0);

  bmp = new Graphics::TBitmap;
  bmp->Assign(Image2->Picture->Bitmap);
  item = new TRVHotBlendBitmapItemInfo(RichView1->RVData, bmp, rvvaBaseline);
  item->Transparency = 200;
  item->HotTransparency = 100;
  item->ParaNo = 1;
  RichView1->AddItem("", item);
  RichView1->AddNL("www.trichview.com",4,1);

  for (i=0; i<=10; i++)
    RichView1->AddNL("some text",0,0);

  RichView1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1Jump(TObject *Sender, int id)
{
  ShellExecute(0, "open", "http://www.trichview.com/", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------
