
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Object (image, break, table) properties         }
{       dialog                                          }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit ItemPropRVFrm;

interface

{$I RV_Defs.inc}
{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, BaseRVFrm, ComCtrls, StdCtrls, ImgList, ExtCtrls, RVSpinEdit,
  {$IFDEF USERVKSDEVTE}
  te_controls, te_extctrls,
  {$ENDIF}
  {$IFDEF USERVTNT}
  TntComCtrls, TntStdCtrls,
  {$ENDIF}
  RVColorCombo, CRVData, RVItem, RVEdit, RVFuncs, RVStyle, ExtDlgs,
  RVOfficeRadioBtn, Buttons, RVTable, RVALocalize, RVTypes;

type
  TfrmRVItemProp = class(TfrmRVBase)
    btnOk: TButton;
    btnCancel: TButton;
    pc: TPageControl;
    tsImage: TTabSheet;
    Panel1: TPanel;
    tsImgLayout: TTabSheet;
    gbVAlign: TGroupBox;
    lblAlignTo: TLabel;
    cmbAlignTo: TComboBox;
    lblVShift: TLabel;
    seVShift: TRVSpinEdit;
    cmbVShiftType: TComboBox;
    gbSize: TGroupBox;
    seWidth: TRVSpinEdit;
    cmbWType: TComboBox;
    seHeight: TRVSpinEdit;
    cmbHType: TComboBox;
    img: TImage;
    btnChangeImage: TButton;
    gbTransp: TGroupBox;
    lblTrColor: TLabel;
    cmbColor: TRVColorCombo;
    cbTransp: TCheckBox;
    lblPreview: TLabel;
    tsBreak: TTabSheet;
    lblWidth: TLabel;
    lblHeight: TLabel;
    lblDefSize: TLabel;
    gbBreak: TGroupBox;
    lblBreakColor: TLabel;
    lblBreakWidth: TLabel;
    cmbBreakColor: TRVColorCombo;
    cmbWidth: TComboBox;
    tsTable: TTabSheet;
    gbTableSize: TGroupBox;
    seTableWidth: TRVSpinEdit;
    cmbTWType: TComboBox;
    ImageList1: TImageList;
    lblTableColor: TLabel;
    cmbTableColor: TRVColorCombo;
    lblCellPadding: TLabel;
    seCellPadding: TRVSpinEdit;
    seCellSpacing: TRVSpinEdit;
    lblCellSpacing: TLabel;
    btnSpacing: TButton;
    tsCells: TTabSheet;
    gbCellBorder: TGroupBox;
    lblCellBorderColor: TLabel;
    lblCellBorderLightColor: TLabel;
    cmbCellBorderColor: TRVColorCombo;
    cmbCellBorderLightColor: TRVColorCombo;
    btnTop: TSpeedButton;
    btnLeft: TSpeedButton;
    btnRight: TSpeedButton;
    btnBottom: TSpeedButton;
    lblVS: TLabel;
    gbCells: TGroupBox;
    seCellBestWidth: TRVSpinEdit;
    cmbCellBWType: TComboBox;
    seCellBestHeight: TRVSpinEdit;
    rgCellVAlign: TRVOfficeRadioGroup;
    Bevel2: TBevel;
    btnTableBorder: TButton;
    btnCellBorder: TButton;
    lblTableWidth: TLabel;
    lblCellColor: TLabel;
    cmbCellColor: TRVColorCombo;
    tsRows: TTabSheet;
    rgRowVAlign: TRVOfficeRadioGroup;
    cbCellWidth: TCheckBox;
    cbCellHeight: TCheckBox;
    lblPixels: TLabel;
    gbTablePrint: TGroupBox;
    cbNoSplit: TCheckBox;
    lblHeadingRows: TLabel;
    seHRC: TRVSpinEdit;
    lblHeadingRowsTip: TLabel;
    btnTableBack: TButton;
    btnCellBack: TButton;
    gbWeb: TGroupBox;
    lblAlt: TLabel;
    txtAlt: TEdit;
    gbSpacing: TGroupBox;
    lblSpacing: TLabel;
    seSpacing: TRVSpinEdit;
    procedure FormActivate(Sender: TObject);
    procedure cmbColorColorChange(Sender: TObject);
    procedure cmbVShiftTypeClick(Sender: TObject);
    procedure cmbWTypeClick(Sender: TObject);
    procedure cmbHTypeClick(Sender: TObject);
    procedure btnChangeImageClick(Sender: TObject);
    procedure cmbWidthDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure cmbBreakColorColorChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure seTableWidthChange(Sender: TObject);
    procedure btnSpacingClick(Sender: TObject);
    procedure seCellSpacingChange(Sender: TObject);
    procedure btnTableBorderClick(Sender: TObject);
    procedure btnCellBordersClick(Sender: TObject);
    procedure cmbCellBorderColorColorChange(Sender: TObject);
    procedure cmbCellBorderLightColorColorChange(Sender: TObject);
    procedure seCellBestWidthChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnTopClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnTableBackClick(Sender: TObject);
    procedure btnCellBackClick(Sender: TObject);
  private
    { Private declarations }
    CellHSpacing, CellVSpacing, BorderHSpacing, BorderVSpacing: Integer;
    BorderStyle: TRVTableBorderStyle;
    BorderColorD, BorderColorL: TColor;
    CellBorderStyle: TRVTableBorderStyle;
    CellBorderColorD, CellBorderColorL: TColor;
    BorderWidth, CellBorderWidth: Integer;
    FDefCellColorD, FDefCellColorL: Boolean;
    TableBackgroundImage: TGraphic;
    TableBackgroundStyle: TRVItemBackgroundStyle;
    TableBackgroundChanged: Boolean;
    CellBackgroundImage: TGraphic;
    CellBackgroundStyle: TRVItemBackgroundStyle;
    CellBackgroundChanged: Boolean;
    ImageFileName, CellImageFileName: String;
    ImageFileNameChanged: Boolean;
    procedure UpdateCellBorders;
  protected
    _gbTransp, _gbSize, _gbCellBorder,
    _cbTransp, _cbCellWidth, _cbCellHeight, _cbNoSplit,
    _cmbAlignTo, _cmbVShiftType, _cmbWType, _cmbHType, _cmbWidth, _cmbTWType,
    _cmbCellBWType,
    _tsImage, _tsImgLayout, _tsBreak, _tsTable, _tsCells, _tsRows,
    _lblDefSize, _lblCellBorderColor, _lblCellBorderLightColor, _txtAlt: TControl;
    _pc : TWinControl;
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    function IsThemeAllowedFor(Component: TComponent): Boolean; override;
    {$ENDIF}
    {$IFDEF USERVKSDEVTE}
    procedure tecmbWidthDrawItem(Control: TWinControl; Canvas: TCanvas; Index: Integer;
    Rect: TRect; State: TOwnerDrawState);
    {$ENDIF}
  public
    { Public declarations }
    ColorDialog: TColorDialog;
    Filter, BackgroundFilter: String;
    StoreImageFileName: Boolean;
    function SetItem(rve: TCustomRichViewEdit): Boolean;
    procedure SetTable(table: TRVTableItemInfo; TableOnly: Boolean);
    procedure GetItem(rve: TCustomRichViewEdit);
    procedure GetTable(rve: TCustomRichViewEdit; table: TRVTableItemInfo);
    procedure Localize; override;
  end;


implementation
uses RichViewActions, SpacingRVFrm, TableBrdrRVFrm, TableBackRVFrm;
{$R *.dfm}

{ TfrmRVItemProp }

function TfrmRVItemProp.SetItem(rve: TCustomRichViewEdit): Boolean;
var item: TCustomRVItemInfo;
    v: Integer;
begin
  Result := False;
  item := rve.GetCurrentItem;
  {........................................}
  if item is TRVGraphicItemInfo then begin
    Result := True;
    HelpContext := 90800;
    _pc.HandleNeeded;
    HideTabSheet(_tsBreak);
    HideTabSheet(_tsTable);
    HideTabSheet(_tsCells);
    HideTabSheet(_tsRows);
    SetPageControlActivePage(_pc, _tsImage);
    img.Picture.Graphic := TRVGraphicItemInfo(item).Image;
    if TRVGraphicItemInfo(item).Image is TBitmap then begin
      SetCheckBoxChecked(_cbTransp, TBitmap(TRVGraphicItemInfo(item).Image).Transparent);
      if TBitmap(TRVGraphicItemInfo(item).Image).TransparentMode = tmAuto then
        cmbColor.ChosenColor := cmbColor.AutoColor
      else
        cmbColor.ChosenColor := TBitmap(TRVGraphicItemInfo(item).Image).TransparentColor;
      end
    else
      _gbTransp.Visible := False;
    img.Stretch := (img.Picture.Graphic.Width>img.Width) or (img.Picture.Graphic.Height>img.Height);
    SetXBoxItemIndex(_cmbAlignTo, ord(TRVGraphicItemInfo(item).VAlign));

    seVShift.Value := TRVGraphicItemInfo(item).VShift;
    if TRVGraphicItemInfo(item).VShiftAbs then
      SetXBoxItemIndex(_cmbVShiftType, 1)
    else
      SetXBoxItemIndex(_cmbVShiftType, 0);
    SetXBoxItemIndex(_cmbWType, 1);
    SetXBoxItemIndex(_cmbHType, 1);
    if TRVGraphicItemInfo(item).ImageWidth<>0 then
      seWidth.Value := TRVGraphicItemInfo(item).ImageWidth;
    if TRVGraphicItemInfo(item).ImageHeight<>0 then
      seHeight.Value := TRVGraphicItemInfo(item).ImageHeight;
    SetControlCaption(_lblDefSize, Format(RVA_GetS(rvam_ip_DefaultSize), [img.Picture.Graphic.Width, img.Picture.Graphic.Height]));
    _gbSize.Visible := not (img.Picture.Graphic is TIcon);
    seSpacing.Value := TRVGraphicItemInfo(item).Spacing;
    SetControlCaption(_txtAlt, TRVGraphicItemInfo(item).Alt);
  end;
  {........................................}
  if item is TRVBreakItemInfo then begin
    Result := True;
    HelpContext := 90900;
    _pc.HandleNeeded;
    HideTabSheet(_tsImage);
    HideTabSheet(_tsImgLayout);
    HideTabSheet(_tsTable);
    HideTabSheet(_tsCells);
    HideTabSheet(_tsRows);
    SetPageControlActivePage(_pc, _tsBreak);
    cmbBreakColor.ChosenColor := TRVBreakItemInfo(item).Color;
    v := TRVBreakItemInfo(item).LineWidth-1;
    if (v<0) then
      v := 0;
    if (v>=GetXBoxItemCount(_cmbWidth)) then
      v := GetXBoxItemCount(_cmbWidth)-1;
    SetXBoxItemIndex(_cmbWidth, v);
  end;
  {........................................}
  if item is TRVTableItemInfo then begin
    Result := True;
    SetTable(TRVTableItemInfo(item), False);
  end;
end;

procedure TfrmRVItemProp.GetItem(rve: TCustomRichViewEdit);
var gr: TGraphic;
    Data: Integer;
begin
  rve := rve.TopLevelEditor;
  rve.BeginUndoGroup(rvutModifyItem);
  rve.SetUndoGroupMode(True);
  try
    {........................................}
    if rve.GetCurrentItem is TRVGraphicItemInfo then begin
      gr := RV_CreateGraphics(TGraphicClass(img.Picture.Graphic.ClassType));
      gr.Assign(img.Picture.Graphic);
      if gr is TBitmap then begin
         TBitmap(gr).Transparent := GetCheckBoxChecked(_cbTransp);
         if cmbColor.ChosenColor=cmbColor.AutoColor then
           TBitmap(gr).TransparentMode := tmAuto
         else begin
           TBitmap(gr).TransparentMode := tmFixed;
           TBitmap(gr).TransparentColor := cmbColor.ChosenColor;
         end;
      end;
      rve.SetCurrentPictureInfo(rve.GetCurrentItemTextA, gr,
        TRVVAlign(GetXBoxItemIndex(_cmbAlignTo)), rve.GetCurrentTag);
      rve.BeginCurrentItemModify(Data);
      if not seWidth.Indeterminate then
        if GetXBoxItemIndex(_cmbWType)=1 then
          rve.SetCurrentItemExtraIntProperty(rvepImageWidth, seWidth.AsInteger, False)
        else
          rve.SetCurrentItemExtraIntProperty(rvepImageWidth, Round(seWidth.AsInteger*gr.Width/100) , False)
      else
        rve.SetCurrentItemExtraIntProperty(rvepImageWidth, 0 , False);
      if not seHeight.Indeterminate then
        if GetXBoxItemIndex(_cmbHType)=1 then
          rve.SetCurrentItemExtraIntProperty(rvepImageHeight, seHeight.AsInteger, False)
        else
          rve.SetCurrentItemExtraIntProperty(rvepImageHeight, Round(seHeight.AsInteger*gr.Height/100) , False)
      else
        rve.SetCurrentItemExtraIntProperty(rvepImageHeight, 0 , False);
      if GetXBoxItemIndex(_cmbVShiftType)=0 then
        rve.SetCurrentItemExtraIntProperty(rvepVShiftAbs, 0, False)
      else
        rve.SetCurrentItemExtraIntProperty(rvepVShiftAbs, 1, False);
      rve.SetCurrentItemExtraIntProperty(rvepVShift, seVShift.AsInteger, False);
      if not seSpacing.Indeterminate then
        rve.SetCurrentItemExtraIntProperty(rvepSpacing, seSpacing.AsInteger, False);
      rve.SetCurrentItemExtraStrProperty(rvespAlt, GetEditText(_txtAlt), False);
      if StoreImageFileName and ImageFileNameChanged then
        rve.SetCurrentItemExtraStrProperty(rvespImageFileName, ImageFileName, False);
      rve.EndCurrentItemModify(Data);
      rve.Change;
      end
    {........................................}
    else if rve.GetCurrentItem is TRVBreakItemInfo then begin
      rve.SetCurrentBreakInfo(GetXBoxItemIndex(_cmbWidth)+1, rvbsLine,
        cmbBreakColor.ChosenColor, rve.GetCurrentTag);
      end
    else if rve.GetCurrentItem is TRVTableItemInfo then begin
      GetTable(rve, TRVTableItemInfo(rve.GetCurrentItem));
    end;
  finally
    rve.SetUndoGroupMode(False);
  end;
end;

procedure TfrmRVItemProp.FormActivate(Sender: TObject);
begin
  inherited;
  cmbColor.ColorDialog := ColorDialog;
  cmbBreakColor.ColorDialog := ColorDialog;
  cmbTableColor.ColorDialog := ColorDialog;
  cmbCellColor.ColorDialog := ColorDialog;
end;


procedure TfrmRVItemProp.cmbColorColorChange(Sender: TObject);
begin
  if Visible then
    SetCheckBoxChecked(_cbTransp, True);
end;

procedure TfrmRVItemProp.cmbVShiftTypeClick(Sender: TObject);
begin
  if not Visible or (img.Picture.Graphic.Height=0) then
    exit;
  if GetXBoxItemIndex(_cmbVShiftType)=0 then
    // convert to percents
    seVShift.Value := Round (seVShift.Value * 100 / img.Picture.Graphic.Height)
  else
    // convert to pixels
    seVShift.Value := Round (seVShift.Value * img.Picture.Graphic.Height / 100);
end;

procedure TfrmRVItemProp.cmbWTypeClick(Sender: TObject);
begin
  if not Visible or (img.Picture.Graphic.Width=0) or seWidth.Indeterminate then
    exit;
  if GetXBoxItemIndex(_cmbWType)=0 then
    // convert to percents
    seWidth.Value := Round (seWidth.Value * 100 / img.Picture.Graphic.Width)
  else
    // convert to pixels
    seWidth.Value := Round (seWidth.Value * img.Picture.Graphic.Width / 100);
end;

procedure TfrmRVItemProp.cmbHTypeClick(Sender: TObject);
begin
  if not Visible or (img.Picture.Graphic.Height=0) or seHeight.Indeterminate then
    exit;
  if GetXBoxItemIndex(_cmbHType)=0 then
    // convert to percents
    seHeight.Value := Round (seHeight.Value * 100 / img.Picture.Graphic.Height)
  else
    // convert to pixels
    seHeight.Value := Round (seHeight.Value * img.Picture.Graphic.Height / 100);
end;

procedure TfrmRVItemProp.btnChangeImageClick(Sender: TObject);
var opd: TOpenPictureDialog;
begin
  opd := TOpenPictureDialog.Create(Self);
  try
    if Filter<>'' then
      opd.Filter := Filter;
    if opd.Execute then begin
      img.Picture.LoadFromFile(opd.FileName);
      ImageFileName := opd.FileName;
      ImageFileNameChanged := True;
      img.Stretch := (img.Picture.Graphic.Width>img.Width) or (img.Picture.Graphic.Height>img.Height);
    end;
  finally
    SetControlCaption(_lblDefSize, Format(RVA_GetS(rvam_ip_DefaultSize), [img.Picture.Graphic.Width, img.Picture.Graphic.Height]));
    _gbTransp.Visible := img.Picture.Graphic is TBitmap;
    opd.Free;
  end;
end;

procedure TfrmRVItemProp.cmbBreakColorColorChange(Sender: TObject);
begin
  _cmbWidth.Invalidate;
end;

procedure TfrmRVItemProp.FormCreate(Sender: TObject);
begin
  _gbTransp     := gbTransp;
  _gbSize       := gbSize;
  _gbCellBorder := gbCellBorder;
  _cbTransp     := cbTransp;
  _cbCellWidth  := cbCellWidth;
  _cbCellHeight := cbCellHeight;
  _cbNoSplit    := cbNoSplit;
  _cmbAlignTo   := cmbAlignTo;
  _cmbVShiftType := cmbVShiftType;
  _cmbWType     := cmbWType;
  _cmbHType     := cmbHType;
  _cmbWidth     := cmbWidth;
  _cmbTWType    := cmbTWType;
  _cmbCellBWType := cmbCellBWType;
  _pc           := pc;
  _tsImage      := tsImage;
  _tsImgLayout  := tsImgLayout;
  _tsBreak      := tsBreak;
  _tsTable      := tsTable;
  _tsCells      := tsCells;
  _tsRows       := tsRows;
  _lblDefSize   := lblDefSize;
  _lblCellBorderColor := lblCellBorderColor;
  _lblCellBorderLightColor := lblCellBorderLightColor;
  _txtAlt := txtAlt;
  if RVA_UserInterface=rvauiHTML then
    btnSpacing.Visible := False;
  inherited;
  {$IFDEF RICHVIEWDEF6}
  img.Proportional := True;
  {$ENDIF}
end;

procedure TfrmRVItemProp.SetTable(table: TRVTableItemInfo;
  TableOnly: Boolean);
var r,c,sr,sc,rs,cs: Integer;
    rowselected, firstrow: Boolean;
    EditedCell, FirstCell, CurCell: TRVTableCellData;
begin
  HelpContext := 91000;
  _pc.HandleNeeded;
  HideTabSheet(_tsBreak);
  HideTabSheet(_tsImage);
  HideTabSheet(_tsImgLayout);
  if TableOnly then begin
    HideTabSheet(_tsCells);
    HideTabSheet(_tsRows);
  end;
  SetPageControlActivePage(_pc, _tsTable);

  if table.BestWidth>0 then begin
    SetXBoxItemIndex(_cmbTWType, 1);
    seTableWidth.Value := table.BestWidth;
    end
  else if table.BestWidth<0 then begin
    SetXBoxItemIndex(_cmbTWType, 0);
    seTableWidth.Value := -table.BestWidth;
  end;
  SetCheckBoxChecked(_cbNoSplit, not (rvtoRowsSplit in table.PrintOptions));
  seHRC.Value := table.HeadingRowCount;
  cmbTableColor.ChosenColor := table.Color;
  seCellPadding.Value := table.CellPadding;
  CellHSpacing := table.CellHSpacing;
  CellVSpacing := table.CellVSpacing;
  BorderHSpacing := table.BorderHSpacing;
  BorderVSpacing := table.BorderVSpacing;
  if (CellHSpacing=CellVSpacing) and
     (BorderHSpacing=BorderVSpacing) and
     (BorderHSpacing=CellHSpacing) then
    seCellSpacing.Value := BorderHSpacing;
  BorderWidth := table.BorderWidth;
  BorderStyle := table.BorderStyle;
  BorderColorD := table.BorderColor;
  BorderColorL := table.BorderLightColor;
  CellBorderWidth := table.CellBorderWidth;
  CellBorderColorD := table.CellBorderColor;
  CellBorderColorL := table.CellBorderLightColor;
  CellBorderStyle := table.CellBorderStyle;

  if table.BackgroundImage=nil then
    TableBackgroundImage := nil
  else begin
    try
      TableBackgroundImage := RV_CreateGraphics(TGraphicClass(table.BackgroundImage.ClassType));
      TableBackgroundImage.Assign(table.BackgroundImage);
    except;
    end;
  end;
  TableBackgroundStyle := table.BackgroundStyle;

  if TableOnly then
    exit;
  if not table.GetNormalizedSelectionBounds(True, sr,sc,cs,rs) then begin
    HideTabSheet(_tsCells);
    HideTabSheet(_tsRows);
    exit;
  end;
  if table.GetEditedCell(r,c)<>nil then
    EditedCell := table.Cells[r,c]
  else
    EditedCell := nil;
  firstrow := True;
  FirstCell := nil;
  FDefCellColorD := True;
  FDefCellColorL := True;
  if EditedCell<>nil then begin
    CellBackgroundStyle := EditedCell.BackgroundStyle;
    if EditedCell.BackgroundImage=nil then
      CellBackgroundImage := nil
    else begin
      try
        CellBackgroundImage := RV_CreateGraphics(TGraphicClass(EditedCell.BackgroundImage.ClassType));
        CellBackgroundImage.Assign(EditedCell.BackgroundImage);
      except;
      end;
    end;
  end;
  for r := 0 to table.Rows.Count-1 do begin
    rowselected := False;
    for c := 0 to table.Rows[r].Count-1 do
      if (table.Cells[r,c]<>nil) and
         (table.IsCellSelected(r,c) or (EditedCell=table.Cells[r,c])) then begin
        rowselected := True;
        if CellBackgroundImage=nil then begin
          CellBackgroundStyle := table.Cells[r,c].BackgroundStyle;
          if table.Cells[r,c].BackgroundImage=nil then
            CellBackgroundImage := nil
          else begin
            try
              CellBackgroundImage := RV_CreateGraphics(TGraphicClass(table.Cells[r,c].BackgroundImage.ClassType));
              CellBackgroundImage.Assign(table.Cells[r,c].BackgroundImage);
            except;
            end;
          end;
        end;
        if FirstCell=nil then begin
          FirstCell := table.Cells[r,c];
          if FirstCell.BestWidth>0 then begin
            seCellBestWidth.Value := FirstCell.BestWidth;
            SetXBoxItemIndex(_cmbCellBWType, 1);
            end
          else if FirstCell.BestWidth<0 then begin
            seCellBestWidth.Value := -FirstCell.BestWidth;
            SetXBoxItemIndex(_cmbCellBWType, 0);
          end;
          if FirstCell.BestHeight>0 then
            seCellBestHeight.Value := FirstCell.BestHeight;
          cmbCellColor.ChosenColor := FirstCell.Color;
          rgCellVAlign.ItemIndex := ord(FirstCell.VAlign);
          btnLeft.Down := FirstCell.VisibleBorders.Left;
          btnTop.Down := FirstCell.VisibleBorders.Top;
          btnRight.Down := FirstCell.VisibleBorders.Right;
          btnBottom.Down := FirstCell.VisibleBorders.Bottom;
          cmbCellBorderColor.ChosenColor := FirstCell.BorderColor;
          cmbCellBorderLightColor.ChosenColor := FirstCell.BorderLightColor;
          FDefCellColorD := FirstCell.BorderColor=clNone;
          FDefCellColorL := FirstCell.BorderLightColor=clNone;
         end
        else begin
          CurCell := table.Cells[r,c];
          if CurCell.BestWidth<>FirstCell.BestWidth then
            SetCheckBoxState(_cbCellWidth, cbGrayed);
          if CurCell.BestHeight<>FirstCell.BestHeight then
            SetCheckBoxState(_cbCellHeight, cbGrayed);
          if CurCell.Color<>FirstCell.Color then
            cmbCellColor.Indeterminate := True;
          if CurCell.VAlign<>FirstCell.VAlign then
            rgCellVAlign.ItemIndex := -1;
          if CurCell.VisibleBorders.Left<>FirstCell.VisibleBorders.Left then begin
            btnLeft.Down := False;
            btnLeft.Flat := True;
          end;
          if CurCell.VisibleBorders.Top<>FirstCell.VisibleBorders.Top then begin
            btnTop.Down := False;
            btnTop.Flat := True;
          end;
          if CurCell.VisibleBorders.Right<>FirstCell.VisibleBorders.Right then begin
            btnRight.Down := False;
            btnRight.Flat := True;
          end;
          if CurCell.VisibleBorders.Bottom<>FirstCell.VisibleBorders.Bottom then begin
            btnBottom.Down := False;
            btnBottom.Flat := True;
          end;
          if CurCell.BorderColor<>FirstCell.BorderColor then begin
            cmbCellBorderColor.Indeterminate := True;
            FDefCellColorD := False;
          end;
          if CurCell.BorderLightColor<>FirstCell.BorderLightColor then begin
            cmbCellBorderLightColor.Indeterminate := True;
            FDefCellColorL := False;
          end;
        end;
      end;
    if rowselected then
      if firstrow then begin
        firstrow := False;
        case table.Rows[r].VAlign of
          rvcMiddle:
            rgRowVAlign.ItemIndex := 1;
          rvcBottom:
            rgRowVAlign.ItemIndex := 2;
          else
            rgRowVAlign.ItemIndex := 0;
        end
        end
      else begin
        if ((rgRowVAlign.ItemIndex=0) and not (table.Rows[r].VAlign in [rvcVDefault, rvcTop])) or
           ((rgRowVAlign.ItemIndex=1) and (table.Rows[r].VAlign<>rvcMiddle)) or
           ((rgRowVAlign.ItemIndex=2) and (table.Rows[r].VAlign<>rvcBottom)) then
          rgRowVAlign.ItemIndex := -1;
      end;
  end;
  UpdateCellBorders;
end;

procedure TfrmRVItemProp.GetTable(rve: TCustomRichViewEdit; table: TRVTableItemInfo);
var Data, ItemNo: Integer;
var r,c,sr,sc,rs,cs,v: Integer;
    rowselected: Boolean;
    EditedCell: TRVTableCellData;
    vl, vt, vr, vb: Boolean;

    function SetVB(def: Boolean; btn: TSpeedButton): Boolean;
    begin
      if btn.Flat then
        Result := def
      else
        Result := btn.Down;
    end;

begin
  ItemNo := table.GetMyItemNo;
  rve.BeginItemModify(ItemNo, Data);
  if seTableWidth.Indeterminate or (seTableWidth.AsInteger=0) then
    table.BestWidth := 0
  else if GetXBoxItemIndex(_cmbTWType) = 0 then begin
    if seTableWidth.AsInteger>100 then
      table.BestWidth := -100
    else
      table.BestWidth := - seTableWidth.AsInteger;
    end
  else  if GetXBoxItemIndex(_cmbTWType) = 1 then
    table.BestWidth := seTableWidth.AsInteger;
  if not cmbTableColor.Indeterminate then
    table.Color := cmbTableColor.ChosenColor;
  if not seCellPadding.Indeterminate then
    table.CellPadding := seCellPadding.AsInteger;
  table.CellHSpacing := CellHSpacing;
  table.CellVSpacing := CellVSpacing;
  table.BorderHSpacing := BorderHSpacing;
  table.BorderVSpacing := BorderVSpacing;
  table.BorderWidth      := BorderWidth;
  table.BorderStyle      := BorderStyle;
  table.BorderColor      := BorderColorD;
  table.BorderLightColor := BorderColorL;
  table.CellBorderWidth  := CellBorderWidth;
  table.CellBorderColor  := CellBorderColorD;
  table.CellBorderLightColor := CellBorderColorL;
  table.CellBorderStyle  := CellBorderStyle;
  if TableBackgroundChanged then begin
    table.BackgroundStyle := TableBackgroundStyle;
    table.BackgroundImage := TableBackgroundImage;
    if StoreImageFileName then
      rve.SetItemExtraStrPropertyEd(ItemNo, rvespImageFileName, ImageFileName, False);
  end;
  if GetCheckBoxChecked(_cbNoSplit) then
    table.PrintOptions := table.PrintOptions - [rvtoRowsSplit]
  else
    table.PrintOptions := table.PrintOptions + [rvtoRowsSplit];
  table.HeadingRowCount := seHRC.AsInteger;
  if IsTabSheetVisible(_tsRows) and (rgRowVAlign.ItemIndex>=0) then begin
    if not table.GetNormalizedSelectionBounds(True, sr,sc,cs,rs) then
      exit;
    if table.GetEditedCell(r,c)<>nil then
      EditedCell := table.Cells[r,c]
    else
      EditedCell := nil;
    for r := 0 to table.Rows.Count-1 do begin
      rowselected := False;
      for c := 0 to table.Rows[r].Count-1 do
        if (table.Cells[r,c]<>nil) and
         (table.IsCellSelected(r,c) or (EditedCell=table.Cells[r,c])) then begin
          rowselected := True;
          if CellBackgroundChanged then begin
            table.SetCellBackgroundStyle(CellBackgroundStyle, r,c);
            table.SetCellBackgroundImage(CellBackgroundImage, r,c);
            if StoreImageFileName then
              table.SetCellBackgroundImageFileName(CellImageFileName, r, c);
          end;
          if GetCheckBoxState(_cbCellWidth)=cbChecked then begin
            if seCellBestWidth.Indeterminate then
              v := 0
            else if GetXBoxItemIndex(_cmbCellBWType)=0 then begin
              v := -seCellBestWidth.AsInteger;
              if v<-100 then
                v := -100;
              end
            else
              v := seCellBestWidth.AsInteger;
            table.SetCellBestWidth(v, r, c);
          end;
          if GetCheckBoxState(_cbCellHeight)=cbChecked then
            if seCellBestHeight.Indeterminate then
              table.SetCellBestHeight(0, r, c)
            else
              table.SetCellBestHeight(seCellBestHeight.AsInteger, r, c);
          if not cmbCellColor.Indeterminate then
            table.SetCellColor(cmbCellColor.ChosenColor, r,c);
          if rgCellVAlign.ItemIndex>=0 then
            table.SetCellVAlign(TRVCellVAlign(rgCellVAlign.ItemIndex), r, c);
          if _gbCellBorder.Visible then begin
            vl := SetVB(table.Cells[r,c].VisibleBorders.Left,   btnLeft);
            vt := SetVB(table.Cells[r,c].VisibleBorders.Top,    btnTop);
            vr := SetVB(table.Cells[r,c].VisibleBorders.Right,  btnRight);
            vb := SetVB(table.Cells[r,c].VisibleBorders.Bottom, btnBottom);
            table.SetCellVisibleBorders(vl,vt,vr,vb, r, c);
            if cmbCellBorderColor.Visible and not cmbCellBorderColor.Indeterminate then
              if cmbCellBorderColor.ChosenColor=cmbCellBorderColor.AutoColor then
                table.SetCellBorderColor(clNone, r,c)
              else
                table.SetCellBorderColor(cmbCellBorderColor.ChosenColor, r,c);
            if cmbCellBorderLightColor.Visible and not cmbCellBorderLightColor.Indeterminate then
              if cmbCellBorderLightColor.ChosenColor=cmbCellBorderLightColor.AutoColor then
                table.SetCellBorderLightColor(clNone, r,c)
              else
                table.SetCellBorderLightColor(cmbCellBorderLightColor.ChosenColor, r,c);
          end;
        end;
      if rowselected then
        case rgRowVAlign.ItemIndex of
          0:
            table.Rows[r].VAlign := rvcTop;
          1:
            table.Rows[r].VAlign := rvcMiddle;
          2:
            table.Rows[r].VAlign := rvcBottom;
        end;
    end;
  end;
  rve.EndItemModify(ItemNo, Data);
  rve.Change;
end;

procedure TfrmRVItemProp.seTableWidthChange(Sender: TObject);
begin
  if not Visible then
    exit;
  if not seTableWidth.Indeterminate and (GetXBoxItemIndex(_cmbTWType)<0) then
    SetXBoxItemIndex(_cmbTWType, 1);
end;

procedure TfrmRVItemProp.btnSpacingClick(Sender: TObject);
var frm:TfrmRVSpacing;
    BHS, CHS, BVS, CVS: Integer;
    UBHS, UCHS, UBVS, UCVS: Boolean;
begin
  frm := TfrmRVSpacing.Create(Application);
  try
    frm.SetValues(BorderHSpacing, CellHSpacing, BorderVSpacing, CellVSpacing,
                  True,True,True,True);
    if frm.ShowModal=mrOk then begin
      frm.GetValues(BHS, CHS, BVS, CVS, UBHS, UCHS, UBVS, UCVS);
      if UBHS then
        BorderHSpacing := BHS;
      if UBVS then
        BorderVSpacing := BVS;
      if UCHS then
        CellHSpacing := CHS;
      if UCVS then
        CellVSpacing := CVS;
      if (CellHSpacing=CellVSpacing) and
         (BorderHSpacing=BorderVSpacing) and
         (BorderHSpacing=CellHSpacing) then
        seCellSpacing.Value := BorderHSpacing
      else
        seCellSpacing.Indeterminate := True;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVItemProp.seCellSpacingChange(Sender: TObject);
begin
  if not Visible then
    exit;
  if not seCellSpacing.Indeterminate then begin
    BorderHSpacing := seCellSpacing.AsInteger;
    BorderVSpacing := BorderHSpacing;
    CellHSpacing := BorderHSpacing;
    CellVSpacing := BorderHSpacing;
  end;
end;

procedure TfrmRVItemProp.btnTableBorderClick(Sender: TObject);
var frm: TfrmRVTableBrdr;
begin
  frm := TfrmRVTableBrdr.Create(Application);
  try
    frm.ColorDialog := ColorDialog;
    frm.SetFormCaption(RVA_GetS(rvam_ip_TableBorderTitle));
    frm.SetData(BorderStyle, BorderColorL, BorderColorD, BorderWidth);
    if frm.ShowModal=mrOk then begin
      frm.GetData(BorderStyle, BorderColorL, BorderColorD, BorderWidth);
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVItemProp.btnCellBordersClick(Sender: TObject);
var frm: TfrmRVTableBrdr;
begin
  frm := TfrmRVTableBrdr.Create(Application);
  try
    frm.ColorDialog := ColorDialog;
    frm.SetFormCaption(RVA_GetS(rvam_ip_CellBorderTitle));
    frm.SetData(CellBorderStyle, CellBorderColorL, CellBorderColorD, CellBorderWidth);
    if frm.ShowModal=mrOk then begin
      frm.GetData(CellBorderStyle, CellBorderColorL, CellBorderColorD, CellBorderWidth);
      UpdateCellBorders;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVItemProp.UpdateCellBorders;
begin
  if CellBorderWidth=0 then begin
    _gbCellBorder.Visible := False;
    exit;
  end;
  _gbCellBorder.Visible := True;
  case CellBorderStyle of
   rvtbRaised, rvtbLowered:
     begin
       _lblCellBorderColor.Visible := False;
       cmbCellBorderColor.Visible := False;
       _lblCellBorderLightColor.Visible := False;
       cmbCellBorderLightColor.Visible := False;
     end;
   rvtbRaisedColor, rvtbLoweredColor:
     begin
       _lblCellBorderColor.Visible := True;
       cmbCellBorderColor.Visible := True;
       _lblCellBorderLightColor.Visible := True;
       cmbCellBorderLightColor.Visible := True;
       cmbCellBorderColor.AutoColor := CellBorderColorD;
       cmbCellBorderLightColor.AutoColor := CellBorderColorL;
       SetControlCaption(_lblCellBorderColor, RVA_GetS(rvam_ip_CellShadowColor));
       if FDefCellColorD and not cmbCellBorderColor.Indeterminate then
         cmbCellBorderColor.ChosenColor := cmbCellBorderColor.AutoColor;
       if FDefCellColorL and not cmbCellBorderLightColor.Indeterminate then
         cmbCellBorderLightColor.ChosenColor := cmbCellBorderLightColor.AutoColor;
     end;
   rvtbColor:
     begin
       _lblCellBorderColor.Visible := True;
       cmbCellBorderColor.Visible := True;
       _lblCellBorderLightColor.Visible := False;
       cmbCellBorderLightColor.Visible := False;
       cmbCellBorderColor.AutoColor := CellBorderColorD;
       SetControlCaption(_lblCellBorderColor,  RVA_GetS(rvam_ip_CellBorderColor));
       if FDefCellColorD and not cmbCellBorderColor.Indeterminate then
         cmbCellBorderColor.ChosenColor := cmbCellBorderColor.AutoColor;
     end;
  end;
end;

procedure TfrmRVItemProp.cmbCellBorderColorColorChange(Sender: TObject);
begin
  if not cmbCellBorderColor.Indeterminate then
    FDefCellColorD := cmbCellBorderColor.ChosenColor=cmbCellBorderColor.AutoColor;
end;

procedure TfrmRVItemProp.cmbCellBorderLightColorColorChange(
  Sender: TObject);
begin
  if not cmbCellBorderLightColor.Indeterminate then
    FDefCellColorL := cmbCellBorderLightColor.ChosenColor=cmbCellBorderLightColor.AutoColor;
end;

procedure TfrmRVItemProp.seCellBestWidthChange(Sender: TObject);
begin
  if not Visible then
    exit;
  if not seCellBestWidth.Indeterminate then
    SetXBoxItemIndex(_cmbCellBWType, 1);
end;

procedure TfrmRVItemProp.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

   procedure SwitchBtn(btn: TSpeedButton);
   begin
     btn.Down := not btn.Down;
     if Assigned(btn.OnClick) then
       btn.OnClick(btn);
   end;

begin
  if not IsTabSheetVisible(_tsCells) or not _gbCellBorder.Visible then
    exit;
  if ssCtrl in Shift then
    case Key of
    ord('L'):
      SwitchBtn(btnLeft);
    ord('T'):
      SwitchBtn(btnTop);
    ord('R'):
      SwitchBtn(btnRight);
    ord('B'):
      SwitchBtn(btnBottom);
    end;
end;

procedure TfrmRVItemProp.btnTopClick(Sender: TObject);
begin
  if Sender is TSpeedButton then
    TSpeedButton(Sender).Flat := False;
end;

procedure TfrmRVItemProp.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_ip_Title));
  tsImage.Caption := RVA_GetSH(rvam_ip_ImageTab);
  tsImgLayout.Caption := RVA_GetSH(rvam_ip_LayoutTab);
  tsBreak.Caption := RVA_GetSH(rvam_ip_LineTab);
  tsTable.Caption := RVA_GetSH(rvam_ip_TableTab);
  tsRows.Caption := RVA_GetSH(rvam_ip_RowsTab);
  tsCells.Caption := RVA_GetSH(rvam_ip_CellsTab);
  lblPreview.Caption := RVA_GetS(rvam_ip_Preview);
  gbTransp.Caption := RVA_GetSH(rvam_ip_Transparency);
  cbTransp.Caption := RVA_GetS(rvam_ip_Transparent);
  lblTrColor.Caption := RVA_GetS(rvam_ip_TrColor);
  btnChangeImage.Caption := RVA_GetS(rvam_ip_Change);
  gbVAlign.Caption := RVA_GetSH(rvam_ip_VAlign);
  lblAlignTo.Caption := RVA_GetS(rvam_ip_VAlignValue);
  cmbAlignTo.Items[0] := RVA_GetS(rvam_ip_VAlign1);
  cmbAlignTo.Items[1] := RVA_GetS(rvam_ip_VAlign2);
  cmbAlignTo.Items[2] := RVA_GetS(rvam_ip_VAlign3);
  cmbAlignTo.Items[3] := RVA_GetS(rvam_ip_VAlign4);
  cmbAlignTo.Items[4] := RVA_GetS(rvam_ip_VAlign5);      
  lblVShift.Caption := RVA_GetS(rvam_ip_ShiftBy);
  gbSize.Caption := RVA_GetSH(rvam_ip_Stretch);
  lblWidth.Caption := RVA_GetS(rvam_ip_Width);
  lblHeight.Caption := RVA_GetS(rvam_ip_Height);
  cmbVShiftType.Items[0] := RVA_GetS(rvam_Percents);
  cmbVShiftType.Items[1] := RVA_GetS(rvam_Pixels);
  cmbWType.Items[0] := RVA_GetS(rvam_Percents);
  cmbWType.Items[1] := RVA_GetS(rvam_Pixels);
  cmbHType.Items[0] := RVA_GetS(rvam_Percents);
  cmbHType.Items[1] := RVA_GetS(rvam_Pixels);
  gbBreak.Caption :=  RVA_GetSH(rvam_ip_HorzLine);
  lblBreakColor.Caption := RVA_GetS(rvam_ip_HLColor);
  lblBreakWidth.Caption := RVA_GetS(rvam_ip_HLWidth);

  gbTableSize.Caption := RVA_GetSH(rvam_ip_TableGB);
  lblTableWidth.Caption := RVA_GetS(rvam_ip_TableWidth);
  lblTableColor.Caption := RVA_GetS(rvam_ip_TableColor);
  lblCellPadding.Caption := RVA_GetS(rvam_ip_CellPadding);
  lblCellSpacing.Caption := RVA_GetS(rvam_ip_CellSpacing);
  btnTableBorder.Caption := RVA_GetS(rvam_ip_TableBorder);
  btnCellBorder.Caption := RVA_GetS(rvam_ip_CellBorder);
  btnSpacing.Caption := RVA_GetS(rvam_ip_More);

  gbTablePrint.Caption := RVA_GetSH(rvam_ip_TablePrinting);
  cbNoSplit.Caption := RVA_GetS(rvam_ip_KeepOnPage);
  lblHeadingRows.Caption := RVA_GetS(rvam_ip_HeadingRows);
  lblHeadingRowsTip.Caption := RVA_GetS(rvam_ip_HeadingRowsTip);
  cmbTWType.Items[0] := RVA_GetS(rvam_Percents);
  cmbTWType.Items[1] := RVA_GetS(rvam_Pixels);
  rgRowVAlign.Caption := RVA_GetSH(rvam_ip_VAlign);
  rgRowVAlign.Items[0].Caption := RVA_GetS(rvam_ip_VATop);
  rgRowVAlign.Items[1].Caption := RVA_GetS(rvam_ip_VACenter);
  rgRowVAlign.Items[2].Caption := RVA_GetS(rvam_ip_VABottom);
  gbCells.Caption := RVA_GetSH(rvam_ip_CellSettings);
  cbCellWidth.Caption := RVA_GetS(rvam_ip_CellBestWidth);
  cbCellHeight.Caption := RVA_GetS(rvam_ip_CellBestHeight);
  lblCellColor.Caption := RVA_GetS(rvam_ip_CellFillColor);
  cmbCellBWType.Items[0] := RVA_GetS(rvam_Percents);
  cmbCellBWType.Items[1] := RVA_GetS(rvam_Pixels);
  lblPixels.Caption := RVA_GetS(rvam_Pixels);
  rgCellVAlign.Caption := RVA_GetSH(rvam_ip_VAlign);
  rgCellVAlign.Items[0].Caption := RVA_GetS(rvam_ip_VATop);
  rgCellVAlign.Items[1].Caption := RVA_GetS(rvam_ip_VACenter);
  rgCellVAlign.Items[2].Caption := RVA_GetS(rvam_ip_VABottom);
  rgCellVAlign.Items[3].Caption := RVA_GetS(rvam_ip_VADefault);
  gbCellBorder.Caption := RVA_GetSH(rvam_ip_CellBorderGB);
  lblVS.Caption := RVA_GetS(rvam_ip_VisibleSides);
  btnTop.Hint    := RVA_GetS(rvam_TopSide)    + ' (Ctrl+T)|';
  btnLeft.Hint   := RVA_GetS(rvam_LeftSide)   + ' (Ctrl+L)|';
  btnBottom.Hint := RVA_GetS(rvam_BottomSide) + ' (Ctrl+B)|';
  btnRight.Hint  := RVA_GetS(rvam_RightSide)  + ' (Ctrl+R)|';
  lblCellBorderColor.Caption := RVA_GetS(rvam_ip_CellShadowColor);
  lblCellBorderLightColor.Caption := RVA_GetS(rvam_ip_CellLightColor);
  cmbColor.DefaultCaption := RVA_GetS(rvam_ip_TrAutoColor);
  btnTableBack.Caption := RVA_GetS(rvam_ip_BackgroundImage);
  btnCellBack.Caption := RVA_GetS(rvam_ip_BackgroundImage);
  gbSpacing.Caption := RVA_GetSH(rvam_ip_SpacingGB);
  lblSpacing.Caption := RVA_GetS(rvam_ip_Spacing);
  gbWeb.Caption := RVA_GetSH(rvam_ip_Web);
  lblAlt.Caption := RVA_GetS(rvam_ip_Alt);
end;

procedure TfrmRVItemProp.FormDestroy(Sender: TObject);
begin
  inherited;
  TableBackgroundImage.Free;
end;

procedure TfrmRVItemProp.btnTableBackClick(Sender: TObject);
var frm: TfrmRVTableBack;
    Color: TColor;
begin
  frm := TfrmRVTableBack.Create(Application);
  try
    Color := clNone;
    if not cmbTableColor.Indeterminate then
      Color := cmbTableColor.ChosenColor;
    frm.Init(Color, TableBackgroundStyle, TableBackgroundImage);
    frm.Filter := BackgroundFilter;    
    if frm.ShowModal=mrOk then begin
      frm.GetResult(TableBackgroundStyle, TableBackgroundImage, ImageFileName);
      TableBackgroundChanged := True;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVItemProp.btnCellBackClick(Sender: TObject);
var frm: TfrmRVTableBack;
    Color: TColor;
begin
  frm := TfrmRVTableBack.Create(Application);
  try
    Color := clNone;
    frm.Init(Color, CellBackgroundStyle, CellBackgroundImage);
    frm.Filter := BackgroundFilter;
    if frm.ShowModal=mrOk then begin
      frm.GetResult(CellBackgroundStyle, CellBackgroundImage, CellImageFileName);
      CellBackgroundChanged := True;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVItemProp.cmbWidthDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  {$IFDEF USERVTNT}
  RVA_DrawCmbWidthItem(TTntComboBox(_cmbWidth).Canvas, Rect, Index, cmbBreakColor.ChosenColor, State);
  {$ELSE}
  RVA_DrawCmbWidthItem(TComboBox(_cmbWidth).Canvas, Rect, Index, cmbBreakColor.ChosenColor, State);
  {$ENDIF}
end;

{$IFDEF USERVKSDEVTE}
procedure TfrmRVItemProp.tecmbWidthDrawItem(Control: TWinControl;
  Canvas: TCanvas; Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  RVA_DrawCmbWidthItem(Canvas, Rect, Index, cmbBreakColor.ChosenColor, State);
end;
{$ENDIF}

{$IFDEF RVASKINNED}
procedure TfrmRVItemProp.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl =_gbTransp then
    _gbTransp := NewControl
  else if OldControl =_gbSize then
    _gbSize := NewControl
  else if OldControl =_txtAlt then
    _txtAlt := NewControl
  else if OldControl =_gbCellBorder then
    _gbCellBorder := NewControl
  else if OldControl =_cbTransp then
    _cbTransp := NewControl
  else if OldControl =_cbCellWidth then
    _cbCellWidth := NewControl
  else if OldControl =_cbCellHeight then
    _cbCellHeight := NewControl
  else if OldControl =_cbNoSplit then
    _cbNoSplit := NewControl
  else if OldControl =_cmbAlignTo then
    _cmbAlignTo := NewControl
  else if OldControl =_cmbVShiftType then
    _cmbVShiftType := NewControl
  else if OldControl =_cmbWType then
    _cmbWType := NewControl
  else if OldControl =_cmbHType then
    _cmbHType := NewControl
  else if OldControl =_cmbWidth then begin
    _cmbWidth := NewControl;
    {$IFDEF USERVKSDEVTE}
    TTeComboBox(_cmbWidth).OnDrawItem := tecmbWidthDrawItem;
    {$ENDIF}
    end
  else if OldControl =_cmbTWType then
    _cmbTWType := NewControl
  else if OldControl =_cmbCellBWType then
    _cmbCellBWType := NewControl
  else if OldControl =_lblDefSize then
    _lblDefSize := NewControl
  else if OldControl =_lblCellBorderColor then
    _lblCellBorderColor := NewControl
  else if OldControl =_lblCellBorderLightColor then
    _lblCellBorderLightColor := NewControl
  else if OldControl =_pc then begin
    _pc := TWinControl(NewControl);
    {$IFDEF USERVKSDEVTE}
    _tsImage      := TTePageControl(_pc).Pages[0];
    _tsImgLayout  := TTePageControl(_pc).Pages[1];
    _tsBreak      := TTePageControl(_pc).Pages[2];
    _tsTable      := TTePageControl(_pc).Pages[3];
    _tsRows       := TTePageControl(_pc).Pages[4];
    _tsCells      := TTePageControl(_pc).Pages[5];
    {$ENDIF}
    {$IFDEF USERVTNT}
    _tsImage      := TTntPageControl(_pc).Pages[0];
    _tsImgLayout  := TTntPageControl(_pc).Pages[1];
    _tsBreak      := TTntPageControl(_pc).Pages[2];
    _tsTable      := TTntPageControl(_pc).Pages[3];
    _tsRows       := TTntPageControl(_pc).Pages[4];
    _tsCells      := TTntPageControl(_pc).Pages[5];
    {$ENDIF}
  end;
end;

function TfrmRVItemProp.IsThemeAllowedFor(Component: TComponent): Boolean; 
begin
  if Component is TSpeedButton then
    Result := False
  else
    Result := inherited IsThemeAllowedFor(Component);
end;
{$ENDIF}



end.
