
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Split-cells dialog                              }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit SplitRVFrm;

{$I RichViewActions.inc}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, BaseRVFrm, RVSpinEdit, RVALocalize;

type
  TfrmRVSplit = class(TfrmRVBase)
    panUnmerge: TGroupBox;
    cbUnmergeRows: TCheckBox;
    cbUnmergeCols: TCheckBox;
    btnOk: TButton;
    btnCancel: TButton;
    GroupBox1: TGroupBox;
    rbSplit: TRadioButton;
    rbUnmerge: TRadioButton;
    panSplit: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    seColumns: TRVSpinEdit;
    seRows: TRVSpinEdit;
    cbMerge: TCheckBox;
    procedure rbClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _rbSplit: TControl;
    _rbUnmerge: TControl;
    _panUnmerge, _panSplit,
    _cbUnmergeRows, _cbUnmergeCols, _cbMerge: TControl;
    procedure Localize; override;
  end;

implementation

{$R *.dfm}

procedure TfrmRVSplit.rbClick(Sender: TObject);
begin
  _panSplit.Visible := GetRadioButtonChecked(_rbSplit);
  _panUnmerge.Visible := GetRadioButtonChecked(_rbUnmerge);
end;

procedure TfrmRVSplit.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_spl_Title));
  GroupBox1.Caption := RVA_GetSH(rvam_spl_SplitTo);
  rbSplit.Caption := RVA_GetS(rvam_spl_Specified);
  rbUnmerge.Caption := RVA_GetS(rvam_spl_Original);
  cbUnmergeRows.Caption := RVA_GetS(rvam_spl_OriginalRows);
  cbUnmergeCols.Caption := RVA_GetS(rvam_spl_OriginalCols);
  Label1.Caption := RVA_GetS(rvam_spl_nCols);
  Label2.Caption := RVA_GetS(rvam_spl_nRows);
  cbMerge.Caption := RVA_GetS(rvam_spl_Merge);
end;

{$IFDEF RVASKINNED}
procedure TfrmRVSplit.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _rbSplit then
    _rbSplit := NewControl
  else if OldControl = _rbUnmerge then
    _rbUnmerge := NewControl
  else if OldControl = _panUnmerge then
    _panUnmerge := NewControl
  else if OldControl = _panSplit then
    _panSplit := NewControl
  else if OldControl = _cbUnmergeRows then
    _cbUnmergeRows := NewControl
  else if OldControl = _cbUnmergeCols then
    _cbUnmergeCols := NewControl
  else if OldControl = _cbMerge then
    _cbMerge := NewControl;
end;
{$ENDIF}

procedure TfrmRVSplit.FormCreate(Sender: TObject);
begin
  _rbSplit   := rbSplit;
  _rbUnmerge := rbUnmerge;
  _panUnmerge := panUnmerge;
  _panSplit := panSplit;
  _cbUnmergeRows := cbUnmergeRows;
  _cbUnmergeCols := cbUnmergeCols;
  _cbMerge       := cbMerge;
  inherited;
end;

end.
