
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Demo project.                                   }
{       You can use it as a basis for your              }
{       applications.                                   }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       Copyright (c) Ilya Zelenskiy                    }
{       ilya@trichview.com                              }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit Unit3;

interface

{$I RV_Defs.inc}          // contains defines about Delphi compiler versions

{
  Remove dots from the defines below to enable support for Gif and Png.

  GifImage (by Anders Melander)
    http://www.torry.net/vcl/graphics/gif/gifimage.exe (original)
    http://www.trichview.com/resources/thirdparty/gifimage.zip (update)
  Note: for Delphi 2007+, use the built in TGifImage instead

  PngObject (by Gustavo Huffenbacher Daud)
    http://www.trichview.com/resources/thirdparty/pngimage.zip
  Note: for Delphi 2009+, use the built in TPngImage instead)
}

{.$DEFINE USE_GIFIMAGE}
{.$DEFINE USE_PNGOBJECT}


uses
  Windows, Messages, SysUtils,
  Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  ActnList, StdActns, ImgList, ToolWin,
  Menus, ShellApi, Printers, ExtCtrls,

  RVUni, RVMisc, RVScroll, RichView, RVEdit,
  RVStyle, CRVFData, RVTable, RVItem, CRVData, RVFuncs,

  RichViewActions, RVFontCombos, Ruler, RVRuler,
  RVALocalize, RVALocRuler,
  // RVAAddictLanguages,

  SRVPageScroll, SclRView, SclRVRuler, SRVToolWindow,
  SRVToolBar,

  {$IFDEF USE_GIFIMAGE}
  {$IFDEF RICHVIEWDEF2007}GifImg,{$ELSE}GifImage,{$ENDIF}
  {$ENDIF}
  {$IFDEF USE_PNGOBJECT}
  PngImage,
  {$ENDIF}
  RVTypes;

type
  TForm3 = class(TForm)
    MainMenu1: TMainMenu;
    mitFile: TMenuItem;
    mitEdit: TMenuItem;
    New1: TMenuItem;
    Load1: TMenuItem;
    N1: TMenuItem;
    mitExit: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    n2: TMenuItem;
    mitFont: TMenuItem;
    Bold1: TMenuItem;
    Italic1: TMenuItem;
    Underline1: TMenuItem;
    N3: TMenuItem;
    mitPara: TMenuItem;
    Leftjustify1: TMenuItem;
    N4: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    Changefont1: TMenuItem;
    Save1: TMenuItem;
    Strikeout1: TMenuItem;
    mitTable: TMenuItem;
    InsertTable1: TMenuItem;
    N5: TMenuItem;
    SelectAll1: TMenuItem;
    AlignLeft1: TMenuItem;
    AlignCenter1: TMenuItem;
    AlignRight1: TMenuItem;
    N6: TMenuItem;
    DecreaseIndent1: TMenuItem;
    IncreaseIndent1: TMenuItem;
    N7: TMenuItem;
    Justify1: TMenuItem;
    InsertRowAbove1: TMenuItem;
    InsertRowBelow1: TMenuItem;
    N8: TMenuItem;
    InsertColumnLeft1: TMenuItem;
    InsertColumnRight1: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    DeleteRows1: TMenuItem;
    rvActionTableDeleteCols11: TMenuItem;
    N11: TMenuItem;
    MergeCells1: TMenuItem;
    SplitCells1: TMenuItem;
    N12: TMenuItem;
    mitTableSelect: TMenuItem;
    SelectTable1: TMenuItem;
    SelectColumns1: TMenuItem;
    SelectRows1: TMenuItem;
    SelectCell1: TMenuItem;
    mitFontStyle: TMenuItem;
    mitFontSize: TMenuItem;
    ShrinkFont1: TMenuItem;
    GrowFont1: TMenuItem;
    N13: TMenuItem;
    ShrinkFontByOnePoint1: TMenuItem;
    GrowFontByOnePoint1: TMenuItem;
    N14: TMenuItem;
    AllCapitals1: TMenuItem;
    Overline1: TMenuItem;
    N15: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    ToolButton11: TToolButton;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    btnQuickPrint: TToolButton;
    ToolButton17: TToolButton;
    ToolButton18: TToolButton;
    ToolButton19: TToolButton;
    ToolButton20: TToolButton;
    ToolButton21: TToolButton;
    ToolBar2: TToolBar;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    ToolButton43: TToolButton;
    ToolButton44: TToolButton;
    ToolButton49: TToolButton;
    ToolButton50: TToolButton;
    ToolButton51: TToolButton;
    ToolButton53: TToolButton;
    ToolButton54: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolBar3: TToolBar;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton12: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton23: TToolButton;
    ToolButton24: TToolButton;
    ToolButton25: TToolButton;
    ToolButton26: TToolButton;
    ToolButton28: TToolButton;
    ToolButton8: TToolButton;
    ToolButton27: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    ToolButton31: TToolButton;
    ToolButton32: TToolButton;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton35: TToolButton;
    N16: TMenuItem;
    ToolButton36: TToolButton;
    ToolButton37: TToolButton;
    extColor1: TMenuItem;
    ToolButton38: TToolButton;
    extBackgroundColor1: TMenuItem;
    N17: TMenuItem;
    ParagraphBackgroundColor1: TMenuItem;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    mitFormat: TMenuItem;
    BackgroundColor1: TMenuItem;
    DeleteTable1: TMenuItem;
    ToolButton45: TToolButton;
    N18: TMenuItem;
    rvActionParagraph11: TMenuItem;
    RVAControlPanel1: TRVAControlPanel;
    Font1: TMenuItem;
    FillColor1: TMenuItem;
    SaveAs1: TMenuItem;
    Export1: TMenuItem;
    mitInsert: TMenuItem;
    File1: TMenuItem;
    Picture1: TMenuItem;
    ToolButton46: TToolButton;
    PasteSpecial1: TMenuItem;
    N19: TMenuItem;
    SingleLineSpacing1: TMenuItem;
    N15LineSpacing1: TMenuItem;
    DoubleLineSpacing1: TMenuItem;
    N20: TMenuItem;
    InsertPageBreak1: TMenuItem;
    RemovePageBreak1: TMenuItem;
    N21: TMenuItem;
    mitTableAlignCellContents: TMenuItem;
    AlignCellToTheTop1: TMenuItem;
    AlignCellToTheMiddle1: TMenuItem;
    AlignCellToTheBottom1: TMenuItem;
    DefaultCellVerticalAlignment1: TMenuItem;
    ParagraphBorders1: TMenuItem;
    N22: TMenuItem;
    Properties1: TMenuItem;
    HorizontalLine1: TMenuItem;
    HypertextLink1: TMenuItem;
    ToolButton47: TToolButton;
    N23: TMenuItem;
    ableProperties1: TMenuItem;
    N24: TMenuItem;
    ShowGridLines1: TMenuItem;
    N25: TMenuItem;
    BulletsandNumbering1: TMenuItem;
    InsertSymbol1: TMenuItem;
    mitTableCellBorders: TMenuItem;
    LeftBorder1: TMenuItem;
    rvActionTableCellTopBorder11: TMenuItem;
    rvActionTableCellRightBorder11: TMenuItem;
    rvActionTableCellBottomBorder11: TMenuItem;
    rvActionTableCellAllBorders11: TMenuItem;
    rvActionTableCellNoBorders11: TMenuItem;
    ToolBar4: TToolBar;
    ToolButton48: TToolButton;
    ToolButton52: TToolButton;
    ToolButton55: TToolButton;
    ToolButton56: TToolButton;
    ToolButton58: TToolButton;
    ToolButton59: TToolButton;
    Bullets1: TMenuItem;
    Numbering1: TMenuItem;
    ToolButton57: TToolButton;
    ToolButton60: TToolButton;
    ToolButton61: TToolButton;
    ToolBar5: TToolBar;
    cmbFont: TRVFontComboBox;
    RVAPopupMenu1: TRVAPopupMenu;
    Background1: TMenuItem;
    ColorDialog1: TColorDialog;
    cmbFontSize: TRVFontSizeComboBox;
    N26: TMenuItem;
    CharacterCase1: TMenuItem;
    ToolButton62: TToolButton;
    ToolButton63: TToolButton;
    pmFakeDropDown: TPopupMenu;
    srvtlwndw1: TSRVToolWindow;
    il1: TImageList;
    ilMenuV: TImageList;
    ilMenuH: TImageList;
    Panel1: TPanel;
    Panel3: TPanel;
    SclRVRuler1: TSclRVRuler;
    Panel4: TPanel;
    RVRulerItemSelector1: TRVRulerItemSelector;
    ListZoom: TComboBox;
    ListFormat: TComboBox;
    fd: TFindDialog;
    rd: TReplaceDialog;
    pmTableIcon: TPopupMenu;
    SampleHintTablemenu1: TMenuItem;
    mitPageSetup: TMenuItem;
    mitPrint: TMenuItem;
    PrintDialog1: TPrintDialog;
    ListUnits: TComboBox;
    OpenDialog1: TOpenDialog;
    btnPreview: TToolButton;
    ToolButton13: TToolButton;
    ToolButton22: TToolButton;
    ToolButton64: TToolButton;
    N27: TMenuItem;
    rvActionSubscript11: TMenuItem;
    rvActionSuperscript11: TMenuItem;
    SRVPageScroll1: TSRVPageScroll;
    stat1: TStatusBar;
    Button1: TButton;
    SclRVRuler2: TSclRVRuler;
    SRichViewEdit1: TSRichViewEdit;
    Splitter1: TSplitter;
    btnThumbnails: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mitExitClick(Sender: TObject);
    procedure RichViewEdit1_Jump(Sender: TObject; id: Integer);
    procedure RichViewEdit1_ReadHyperlink(Sender: TCustomRichView;
      const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
      ItemTag: Integer; var ItemName: TRVRawByteString);
    procedure cmbFontClick(Sender: TObject);
    procedure cmbKeyPress(Sender: TObject; var Key: Char);
    procedure RichViewEdit1_CurTextStyleChanged(Sender: TObject);
    procedure cmbFontSizeClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RichViewEdit1_WriteHyperlink(Sender: TCustomRichView;
      id: Integer; RVData: TCustomRVData; ItemNo: Integer;
      SaveFormat: TRVSaveFormat; var Target, Extras: String);
    procedure RVAControlPanel1MarginsChanged(Sender: TrvAction;
      Edit: TCustomRichViewEdit);
    procedure RVAControlPanel1Download(Sender: TrvAction;
      const Source: String);
    procedure RichViewEdit1_KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure pmFakeDropDownPopup(Sender: TObject);
    procedure RichViewEdit1_KeyPress(Sender: TObject; var Key: Char);
    procedure ListZoomChange(Sender: TObject);
    procedure ListFormatChange(Sender: TObject);
    procedure SRichViewEdit1CurrentPageChange(Sender: TObject);
    procedure SRichViewEdit1HMenuClickButton(Sender: TObject;
      ToolButton: TSRVToolButton);
    procedure SRichViewEdit1PageScrolled(Sender: TObject);
    procedure SRichViewEdit1VMenuClickButton(Sender: TObject;
      ToolButton: TSRVToolButton);
    procedure SRichViewEdit1CaretMove(Sender: TObject);
    procedure srvtlwndw1ClickButton(Sender: TObject;
      ToolButton: TSRVToolButton);
    procedure fdFind(Sender: TObject);
    procedure SclRVRuler1MarginDblClick(Sender: TObject;
      Margin: TMarginType);
    procedure mitPageSetupClick(Sender: TObject);
    procedure mitPrintClick(Sender: TObject);
    procedure btnQuickPrintClick(Sender: TObject);
    procedure RVAControlPanel1BackgroundChange(Sender: TrvAction;
      Edit: TCustomRichViewEdit);
    procedure ListUnitsChange(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure btnThumbnailsClick(Sender: TObject);
    procedure SRichViewEdit1TableIconClick(Sender: TSRichViewEdit;
      Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
  private
    { Private declarations }
    HToolButton, VToolButton: TSRVToolButton;
    UpdatingCombos: Boolean;
    procedure ColorPickerShow(Sender: TObject);
    procedure ColorPickerHide(Sender: TObject);
    procedure rvActionSave1DocumentFileChange(Sender: TObject;
      Editor: TCustomRichViewEdit; const FileName: String;
      FileFormat: TrvFileSaveFilter; IsNew: Boolean);
    procedure ApplicationHint(Sender: TObject);
    procedure Localize;
    procedure ToggleThumbnails(Show: Boolean);
    procedure Print(UseDialog: Boolean);
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses dmActions, Math, f_PageProperty;
{$R *.dfm}

var
  RememberZoomMode : TRVZoomMode;
  RememberZoomPercent : Single;

procedure ShowInfo(const msg,cpt: String);
begin
  Application.MessageBox(PChar(msg),PChar(cpt),MB_OK or MB_ICONINFORMATION);
end;

{----------------------------- View Modes -------------------------------------}
// Normal view mode (as one long page)
procedure OnePageMode(srve : TSRichViewEdit);
begin
  srve.PageProperty.AutoWidth := False;
  srve.PageProperty.PageFormat := srvfmA4;
  srve.PageProperty.PageViewMode := False;
  srve.PageProperty.BorderPen.Style := psClear;
  srve.PageProperty.BoundLeftRight := 20;
  srve.BackgroundProperty.Visible := False;
  srve.Color := clWhite;
  srve.ViewProperty.ShowScrollHint := True;
  srve.ViewProperty.AlignPageH := srvaphLeft;
  srve.ViewProperty.AlignPageV := srvapvTop;
  srve.ViewProperty.ZoomPercent := RememberZoomPercent;
  srve.ViewProperty.ZoomMode := RememberZoomMode;
end;
// Web view mode
procedure WebMode(srve : TSRichViewEdit);
begin
  RememberZoomPercent := srve.ViewProperty.ZoomPercent;
  RememberZoomMode := srve.ViewProperty.ZoomMode;
  srve.PageProperty.PageViewMode := False;
  srve.PageProperty.BoundLeftRight := 0;
  srve.ViewProperty.ShowScrollHint := False;
  srve.BackgroundProperty.Visible := False;
  srve.Color := clWhite;
  srve.ViewProperty.AlignPageH := srvaphLeft;
  srve.ViewProperty.AlignPageV := srvapvTop;
  srve.PageProperty.BorderPen.Style := psClear;
  srve.PageProperty.AutoWidth := True;
  srve.ViewProperty.ZoomPercent := RememberZoomPercent;
end;
// Page view mode
procedure MultiPageMode(srve : TSRichViewEdit);
begin
  srve.PageProperty.AutoWidth := False;
  srve.PageProperty.PageViewMode := True;
  srve.PageProperty.PageFormat := srvfmA4;
  srve.ViewProperty.ShowScrollHint := True;
  srve.BackgroundProperty.Visible := True;
  srve.Color := $0099A8AC;
  srve.PageProperty.BoundLeftRight := 20;
  srve.PageProperty.MinPageBreakHeight := 5;
  srve.PageProperty.MaxPageBreakHeight := 25;
  srve.PageProperty.BorderPen.Style := psSolid;
  srve.ViewProperty.AlignPageH := srvaphCenter;
  srve.ViewProperty.AlignPageV := srvapvCenter;
  srve.ViewProperty.ZoomPercent := RememberZoomPercent;
  srve.ViewProperty.ZoomMode := RememberZoomMode;
end;
{------------------------------------------------------------------------------}
procedure TForm3.FormCreate(Sender: TObject);
begin
  // Almost all these assignments could be done at design time in the Object Inspector
  // But in this demo we do not want to modify rvActionsResource
  // (and we recommend to use a copy of it in your applications)

  rvActionsResource.rvActionSave1.OnDocumentFileChange := rvActionSave1DocumentFileChange;

  // Code for making color-picking buttons stay pressed while a
  // color-picker window is visible.
  rvActionsResource.rvActionColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionParaColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionParaColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontBackColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontBackColor1.OnHideColorPicker := ColorPickerHide;

  // Delphi 4 and 5 do not have ActionComponent property for actions.
  // Coloring actions have a substitution - CallerControl property
  // It is ignored in Delphi 6 and 7
  rvActionsResource.rvActionParaColor1.CallerControl := ToolButton39;
  rvActionsResource.rvActionFontBackColor1.CallerControl := ToolButton38;
  rvActionsResource.rvActionFontColor1.CallerControl := ToolButton36;

  {$IFDEF RICHVIEWDEF6}
  // AutoComplete feature causes OnClick generation when editing combo-box's text.
  // Since in OnClick we move input focus in RichViewEdit1, this effect is
  // undesirable
  cmbFont.AutoComplete := False;
  cmbFontSize.AutoComplete := False;
  {$ENDIF}

  Localize;

  // Displaying hints on the status bar
  Application.OnHint := ApplicationHint;

  // Loading initial file via ActionOpen (allowing to update user interface)
  rvActionsResource.rvActionOpen1.LoadFile(SRichViewEdit1.RichViewEdit,
    ExtractFilePath(Application.ExeName)+'readme.rvf', ffiRVF);

  VToolButton := nil;

  {
  // alternative way to start
    rvActionsResource.rvActionNew1.ExecuteTarget(SRichViewEdit1.RichViewEdit);
  }

end;


{------------------- Working with document ------------------------------------}

// When document is created, saved, loaded...
procedure TForm3.rvActionSave1DocumentFileChange(Sender: TObject;
  Editor: TCustomRichViewEdit; const FileName: String;
  FileFormat: TrvFileSaveFilter; IsNew: Boolean);
var s: String;
begin
  s := ExtractFileName(FileName);
  rvActionsResource.rvActionPrint1.Title := s;
  rvActionsResource.rvActionQuickPrint1.Title := s;
  if IsNew then
    s := s+' (*)';
  Caption := s + ' - RichViewActionsTest';
end;

// Prompt for saving...
procedure TForm3.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := rvActionsResource.rvActionSave1.CanCloseDoc(SRichViewEdit1.RichViewEdit);
end;

procedure TForm3.mitExitClick(Sender: TObject);
begin
  Close;
end;

{--------------- Working with color-picking buttons ---------------------------}

// Code for making color-picking buttons pressed while
// a color-picker window is visible.
procedure TForm3.ColorPickerShow(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := True;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := True;
  {$ENDIF};
end;

procedure TForm3.ColorPickerHide(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := False;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := False;
  {$ENDIF}
end;

{-------------- Set of events for processing hypertext links ------------------}

// Hyperlink click
procedure TForm3.RichViewEdit1_Jump(Sender: TObject; id: Integer);
begin
  rvActionsResource.rvActionInsertHyperlink1.GoToLink(SRichViewEdit1.RichViewEdit, id);
end;

// Importing hyperlink
procedure TForm3.RichViewEdit1_ReadHyperlink(Sender: TCustomRichView;
  const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
  ItemTag: Integer; var ItemName: TRVRawByteString);
var URL: String;
begin
  if DocFormat=rvlfURL then
    StyleNo :=
      rvActionsResource.rvActionInsertHyperlink1.GetHyperlinkStyleNo(SRichViewEdit1.RichViewEdit);
  URL := rvActionsResource.rvActionInsertHyperlink1.EncodeTarget(Target);
  ItemTag := Integer(StrNew(PChar(URL)));
end;

// Exporting hyperlink to RTF and HTML
procedure TForm3.RichViewEdit1_WriteHyperlink(Sender: TCustomRichView;
  id: Integer; RVData: TCustomRVData; ItemNo: Integer;
  SaveFormat: TRVSaveFormat; var Target, Extras: String);
begin
  Target := PChar(RVData.GetItemTag(ItemNo));
end;

// URL detection on typing
procedure TForm3.RichViewEdit1_KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key in [VK_SPACE, VK_RETURN, VK_TAB] then begin
    {
      // uncomment if you use Addict3
      RVA_Addict3AutoCorrect(RichViewEdit1);
    }
    rvActionsResource.rvActionInsertHyperlink1.DetectURL(SRichViewEdit1.RichViewEdit);
    rvActionsResource.rvActionInsertHyperlink1.TerminateHyperlink(SRichViewEdit1.RichViewEdit);
  end;
end;

procedure TForm3.RichViewEdit1_KeyPress(Sender: TObject; var Key: Char);
begin
  {
  // uncomment if you use Addict3
  if (Key='''') or ((Key<>' ') and (Pos(Key, RichViewEdit1.Delimiters)<>0)) then
    RVA_Addict3AutoCorrect(RichViewEdit1);
  }
end;

{----------------------- Insert table popup      -----------------------------}
{ We use a trick: insert-table button has style tbsDropDown and assigned
  DropDownMenu (pmFakeDropDown). This menu is empty, but shows table size
  popup instead of itself }
procedure TForm3.pmFakeDropDownPopup(Sender: TObject);
begin
  rvActionsResource.rvActionInsertTable1.ShowTableSizeDialog(SRichViewEdit1.RichViewEdit,
    ToolButton12);
end;

{--------------------- Working with font combo-boxes --------------------------}

// Current font is changed. Updating the combo-boxes.
procedure TForm3.RichViewEdit1_CurTextStyleChanged(Sender: TObject);
var CurStyle: TFontInfo;
begin
  UpdatingCombos := True;
  try
    CurStyle := SRichViewEdit1.RichViewEdit.Style.TextStyles[SRichViewEdit1.RichViewEdit.CurTextStyleNo];
    cmbFont.Text := CurStyle.FontName;
    cmbFont.OnClick(Sender);
    cmbFontSize.FontName := CurStyle.FontName;
    cmbFontSize.Text := IntToStr(CurStyle.Size);
  finally
    UpdatingCombos := False;
  end;
end;

// Applying the font name
procedure TForm3.cmbFontClick(Sender: TObject);
var FontName: String;
begin
  if cmbFont.ItemIndex<0 then
    FontName := cmbFont.Text
  else
    FontName := cmbFont.Items[cmbFont.ItemIndex];
  if UpdatingCombos then
    exit;
  UpdatingCombos := True;
  cmbFontSize.FontName := FontName;
  UpdatingCombos := False;
  if cmbFont.ItemIndex<0 then
    cmbFont.ItemIndex := cmbFont.Items.IndexOf(FontName);
  if cmbFont.ItemIndex<0 then begin
      if Visible then beep
    end
  else
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimFontName];
      Font.Name := FontName;
      Execute;
      UserInterface := True;
    end;
  SRichViewEdit1.RichViewEdit.SetFocus;
end;

// Changing the font size
procedure TForm3.cmbFontSizeClick(Sender: TObject);
var FontSize: Integer;
begin
  if UpdatingCombos then
    exit;
  try
    FontSize := StrToInt(cmbFontSize.Text);
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimSize];
      Font.Size := FontSize;
      Execute;
      UserInterface := True;
    end;
  except
    if Visible then beep;
  end;
  SRichViewEdit1.RichViewEdit.SetFocus;
end;

procedure TForm3.cmbKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then begin
    Key := #0;
    TComboBox(Sender).OnClick(Sender);
  end;
end;

{------- Synchronizing ScaleRichView after non-editing operations -------------}
// Returns paper format name
function GetPaperFormatName(PaperFormat: TSRVPageFormat): String;
begin
  case PaperFormat of
    srvfmA0:
      Result := 'A0';
    srvfmA1:
      Result := 'A1';
    srvfmA2:
      Result := 'A2';
    srvfmA3:
      Result := 'A3';
    srvfmA4:
      Result := 'A4';
    srvfmA5:
      Result := 'A5';
    srvfmA6:
      Result := 'A6';
    srvfmLetter:
      Result := 'Letter';
    srvfmLegal:
      Result := 'Legal';
    else
      Result := '';
  end;
end;
// Returns name for measurement units
function GetUnitsName(Units: TRVUnits): String;
begin
  case Units of
    rvuMillimeters:
      Result := 'mm';
    rvuCentimeters:
      Result := 'cm';
    rvuPicas:
      Result := 'picas';
    rvuPixels:
      Result := 'pixels';
    rvuPoints:
      Result := 'points';
    rvuInches:
      Result := 'inch';
    else
      Result := '';
  end;
end;

procedure TForm3.RVAControlPanel1MarginsChanged(Sender: TrvAction;
  Edit: TCustomRichViewEdit);
begin
  SRichViewEdit1.RichViewEdit.RVData.State :=
    SRichViewEdit1.RichViewEdit.RVData.State + [rvstSkipFormatting];
  SRichViewEdit1.SetRVMargins;
  SRichViewEdit1.RichViewEdit.Modified := False;

  case SRichViewEdit1.ViewProperty.ZoomMode of
    rvzmPageWidth:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf('PageWidth');
    rvzmFullPage:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf('FullPage');
    rvzmCustom:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf(
        IntToStr(Round(SRichViewEdit1.ViewProperty.ZoomPercent)));
  end;

  if SRichViewEdit1.PageProperty.PageFormat = srvfmA0 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A0')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA1 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A1')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA2 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A2')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA3 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A3')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA4 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A4')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA5 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A5')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmA6 then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('A6')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmLetter then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('Letter')
  else if SRichViewEdit1.PageProperty.PageFormat = srvfmLegal then
    ListFormat.ItemIndex := ListFormat.Items.IndexOf('Legal');

  ListFormat.ItemIndex :=
    ListFormat.Items.IndexOf(GetPaperFormatName(SRichViewEdit1.PageProperty.PageFormat));

  ListUnits.ItemIndex :=
    ListUnits.Items.IndexOf(GetUnitsName(SRichViewEdit1.UnitsProgram));

  SclRVRuler1.UnitsDisplay := TRulerUnits(SRichViewEdit1.UnitsProgram);
  SclRVRuler2.UnitsDisplay := TRulerUnits(SRichViewEdit1.UnitsProgram);
  SRichViewEdit1.RichViewEdit.RVData.State :=
     SRichViewEdit1.RichViewEdit.RVData.State - [rvstSkipFormatting];
  SRichViewEdit1.RefreshData;
end;

procedure TForm3.RVAControlPanel1BackgroundChange(Sender: TrvAction;
  Edit: TCustomRichViewEdit);
begin
  SRichViewEdit1.Repaint;
end;

{---------------------------- Localization ------------------------------------}

procedure TForm3.Button1Click(Sender: TObject);
begin
  if RVA_ChooseLanguage then
    Localize;
end;

procedure TForm3.Localize;
begin
  // Fonts
  Font.Charset            := RVA_GetCharset;
  stat1.Font.Charset := RVA_GetCharset;
  {$IFDEF RICHVIEWDEF6}
  Screen.HintFont.Charset := RVA_GetCharset;
  Screen.MenuFont.Charset := RVA_GetCharset;
  {$ENDIF}
  // Localizing all actions on rvActionsResource
  RVA_LocalizeForm(rvActionsResource);
  // Localizing all actions on this form
  RVA_LocalizeForm(Self);
  // Localizing ruler
  RVALocalizeRuler(SclRVRuler1);
  // Localizing menus (not all menus in this demo are translated)
  mitFile.Caption := RVA_GetS(rvam_menu_File);
  mitEdit.Caption := RVA_GetS(rvam_menu_Edit);
  mitFont.Caption := RVA_GetS(rvam_menu_Font);
  mitPara.Caption := RVA_GetS(rvam_menu_Para);
  mitFormat.Caption := RVA_GetS(rvam_menu_Format);
  mitInsert.Caption := RVA_GetS(rvam_menu_Insert);
  mitTable.Caption := RVA_GetS(rvam_menu_Table);
  mitExit.Caption := RVA_GetS(rvam_menu_Exit);
  mitPageSetup.Caption := RVA_GetS(rvam_act_PageSetup);
  mitPrint.Caption := RVA_GetS(rvam_act_Print);  
  btnQuickPrint.Caption := RVA_GetS(rvam_act_QuickPrint);
  btnQuickPrint.Hint := RVA_GetS(rvam_act_QuickPrintH);

  mitFontSize.Caption := RVA_GetS(rvam_menu_FontSize);
  mitFontStyle.Caption := RVA_GetS(rvam_menu_FontStyle);
  mitTableSelect.Caption := RVA_GetS(rvam_menu_TableSelect);
  mitTableCellBorders.Caption := RVA_GetS(rvam_menu_TableCellBorders);
  mitTableAlignCellContents.Caption := RVA_GetS(rvam_menu_TableCellAlign);
  // In your application, you can use either TrvActionFonts or TrvActionFontEx
  rvActionsResource.rvActionFonts1.Caption := rvActionsResource.rvActionFonts1.Caption+' (Standard)';
  rvActionsResource.rvActionFontEx1.Caption := rvActionsResource.rvActionFontEx1.Caption+' (Advanced)';

  {
  // uncomment if you use Addict3. It's assumed that RVAddictSpell31
  // and RVThesaurus31 are on this form.
  RVAddictSpell31.UILanguage := GetAddictSpellLanguage(RVA_GetLanguageName);
  RVThesaurus31.UILanguage := GetAddictThesLanguage(RVA_GetLanguageName);
  }
end;

{-------------------------------- Misc. ---------------------------------------}

procedure TForm3.RVAControlPanel1Download(Sender: TrvAction;
  const Source: String);
begin
  if Source='' then
    Application.Hint := ''
  else
    Application.Hint := 'Downloading '+Source+'...';
end;

procedure TForm3.SRichViewEdit1TableIconClick(Sender: TSRichViewEdit;
  Button: TMouseButton; Shift: TShiftState; X, Y, PageNo: Integer);
begin
  SRichViewEdit1.GetTableIconItem.SelectRows(0, SRichViewEdit1.GetTableIconItem.RowCount);
  SRichViewEdit1.Repaint;
end;

{---------------------- Live spelling with Addict 3 ---------------------------}
(*
// Add these events if you use Addict3
// (Assuming that you have RVAddictSpell31: TRVAddictSpell3 on the form)

// RichViewEdit1.OnSpellingCheck event
procedure TForm3.RichViewEdit1SpellingCheck(Sender: TCustomRichView;
  const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
begin
  Misspelled := not RVAddictSpell31.WordAcceptable(AWord);
end;

// RVAddictSpell31.OnParserIgnoreWord: if Ignore All or Add buttons were pressed
// in spellchecker dialog, removing underlines from the ignored word
procedure TForm3.RVAddictSpell31ParserIgnoreWord(Sender: TObject;
  Before: Boolean; State: Integer);
begin
  if not Before and (State in [IgnoreState_IgnoreAll, IgnoreState_Add]) then
    RichViewEdit1.LiveSpellingValidateWord(RVAddictSpell31.CurrentWord);
end;

// Besides, if you want spelling check starting when loading document, call
// RichViewEdit1.StartLiveSpelling in rvActionFileOpen.OnOpenFile event
*)

{------------------ Zoom, paper format, units combo-boxes ---------------------}
// Applying zooming
procedure TForm3.ListZoomChange(Sender: TObject);
var procent : Integer;
begin
  procent:= StrToIntDef(ListZoom.Text, 0);
  if procent > 0 then
    SRichViewEdit1.ViewProperty.ZoomPercent:= procent
  else
    if ListZoom.Text = 'PageWidth' then
      SRichViewEdit1.ViewProperty.ZoomMode:= rvzmPageWidth
    else if ListZoom.Text = 'FullPage' then
      SRichViewEdit1.ViewProperty.ZoomMode:= rvzmFullPage;
  RememberZoomMode := SRichViewEdit1.ViewProperty.ZoomMode;
  RememberZoomPercent := SRichViewEdit1.ViewProperty.ZoomPercent;
end;

// Applying paper format
procedure TForm3.ListFormatChange(Sender: TObject);
var text : String;
begin
  text:= trim(ListFormat.Text);
  if text = 'A0' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA0;
  if text = 'A1' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA1;
  if text = 'A2' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA2;
  if text = 'A3' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA3;
  if text = 'A4' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA4;
  if text = 'A5' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA5;
  if text = 'A6' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA6;
  if text = 'Letter' then SRichViewEdit1.PageProperty.PageFormat:= srvfmLetter;
  if text = 'Legal' then SRichViewEdit1.PageProperty.PageFormat:= srvfmLegal;
end;
// Applying units
procedure TForm3.ListUnitsChange(Sender: TObject);
var
     RulerUnit : TRulerUnits;
     SRVUnit : TRVUnits;
begin
  case ListUnits.ItemIndex of
    1 :
      begin
        RulerUnit := ruMillimeters;
        SRVUnit := rvuMillimeters;
      end;
    2 :
      begin
        RulerUnit := ruCentimeters;
        SRVUnit := rvuCentimeters;
      end;
    3 :
      begin
        RulerUnit := ruPicas;
        SRVUnit := rvuPicas;
      end;
    4 :
      begin
        RulerUnit := ruPixels;
        SRVUnit := rvuPixels;
      end;
    5 :
      begin
        RulerUnit := ruPoints;
        SRVUnit := rvuPoints;
      end;
  else
    begin
      RulerUnit := ruInches;
      SRVUnit := rvuInches;
    end;
  end;
  SRichViewEdit1.UnitsProgram := SRVUnit;
  SclRVRuler1.UnitsDisplay := RulerUnit;
  SclRVRuler2.UnitsDisplay := RulerUnit;
end;
{------------------------------ Status bar ------------------------------------}
procedure TForm3.SRichViewEdit1CurrentPageChange(Sender: TObject);
begin
  stat1.Panels.Items[1].Text :=
    'Page '+IntToStr(SRichViewEdit1.CurrentPage) + ' of ' +
    IntToStr(SRichViewEdit1.PageCount);
end;

procedure TForm3.SRichViewEdit1PageScrolled(Sender: TObject);
begin
  stat1.Panels.Items[0].Text  := 'View page ' + IntToStr(SRichViewEdit1.ScrolledPage);
end;

procedure TForm3.SRichViewEdit1CaretMove(Sender: TObject);
var Line, Column : Integer;
begin
  SRichViewEdit1.GetCurrentLineCol(Line, Column);
  stat1.Panels.Items[2].Text := 'Line ' + IntToStr(Line);
  stat1.Panels.Items[3].Text := 'Col ' + IntToStr(Column);
end;
{--------------------- Buttons on scroll-bars ---------------------------------}
// On horizontal scroll bar (view modes)
procedure TForm3.SRichViewEdit1HMenuClickButton(Sender: TObject;
  ToolButton: TSRVToolButton);
begin
  HToolButton := ToolButton;
  if ToolButton = nil then Exit;
  SRichViewEdit1.CanUpdate := False;
  case (ToolButton.Index) of
    0 : OnePageMode(SRichViewEdit1);
    1 : WebMode(SRichViewEdit1);
    2 : MultiPageMode(SRichViewEdit1);
  end;
  SRichViewEdit1.CanUpdate := True;
end;
// On vertical scroll bar
procedure TForm3.SRichViewEdit1VMenuClickButton(Sender: TObject;
  ToolButton: TSRVToolButton);
var
     sbX, sbY : Integer;
     p : TPoint;
begin
  if ToolButton = nil then Exit;
  case ToolButton.Index of
    0 :  // "Up arrows" button, performs search to the top
      begin
        if VToolButton = nil then
          SRichViewEdit1.PriorCurPage
        else
          case VToolButton.Index of
            0 : SRichViewEdit1.PriorCurPage;
            1 : SRichViewEdit1.PriorCurItem([rvsTable]);
            2 : SRichViewEdit1.PriorCurItem([rvsPicture, rvsHotspot, rvsHotPicture]);
            3 : SRichViewEdit1.PriorCurItem([rvsHeading]); // just for demo, this style is not used for headers
            4 : SRichViewEdit1.PriorCurHyperlink;
            6 :
              begin
                fd.Options := fd.Options - [frDown];
                fdFind(nil);
              end;
          end;
      end;
    1 : // "Circle" button, shows tool window
      begin
        sbX := SRichViewEdit1.MenuVertical.SRVToolBar.Width;
        sbY := SRichViewEdit1.MenuVertical.SRVToolBar.Height div 3;

        p := SRichViewEdit1.MenuVertical.SRVToolBar.ClientToScreen(Point(0, 0));
        p.Y := p.Y + sbY;

        srvtlwndw1.Execute(Bounds(p.x, p.y, sbX, sbY));
      end;
    2 : // "Down arrows" button, performs search to the bottom
      begin
        if VToolButton = nil then
          SRichViewEdit1.NextCurPage
        else
          case VToolButton.Index of
            0 : SRichViewEdit1.NextCurPage;
            1 : SRichViewEdit1.NextCurItem([rvsTable]);
            2 : SRichViewEdit1.NextCurItem([rvsPicture, rvsHotspot, rvsHotPicture]);
            3 : SRichViewEdit1.NextCurItem([rvsHeading]); // just for demo, this style is not used for headers
            4 : SRichViewEdit1.NextCurHyperlink;
            6 :
              begin
                fd.Options := fd.Options + [frDown];
                fdFind(nil);
              end;
          end;
      end;
  end;
end;
// Button on the tool window is clicked
procedure TForm3.srvtlwndw1ClickButton(Sender: TObject;
  ToolButton: TSRVToolButton);
var
     s: String;
     posit: Integer;
begin
  VToolButton := ToolButton;
  if ToolButton = nil then Exit;
  if ToolButton.Index = 6 then // starting text search
    begin
      SRichViewEdit1.SetFocus;
      fd.CloseDialog;
      if SRichViewEdit1.RichViewEdit.SelectionExists then
        begin
          s := SRichViewEdit1.RichViewEdit.GetSelText;
          posit := Pos(#13,s);
          if posit<>0 then
            s := Copy(s,1,posit-1);
          fd.FindText := s;
        end;
      fd.Execute;
    end
  else // starting search
    SRichViewEdit1VMenuClickButton(Sender,
      TSRVToolButton(SRichViewEdit1.MenuVButtons.Items[2]));
end;
// text search
procedure TForm3.fdFind(Sender: TObject);
begin
  if not SRichViewEdit1.RichViewEdit.SearchText(fd.FindText,GetRVESearchOptions(fd.Options)) then
    ShowInfo('String not found','Search and Replace');
  SRichViewEdit1.Repaint;
end;
{------------------------------- Printing -------------------------------------}
//  Double clicking on the rulers' margins shows the page setup dialog
procedure TForm3.SclRVRuler1MarginDblClick(Sender: TObject;
  Margin: TMarginType);
begin
  mitPageSetupClick(nil);
end;
// File | Page Setup
procedure TForm3.mitPageSetupClick(Sender: TObject);
begin
  SRichViewEdit1.CanUpdate := FALSE;

  With FPageProperty do
    begin
      PageLeft.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.LeftMargin * 100) * 0.01);
      PageRight.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.RightMargin * 100) * 0.01);

      PageTop.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.TopMargin * 100) * 0.01);
      PageBottom.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.BottomMargin * 100) * 0.01);

      if SRichViewEdit1.PageProperty.Orientation = poPortrait then
        begin
          RadioGroup1.ItemIndex := 0;
        end
      else
        begin
          RadioGroup1.ItemIndex := 1;
        end;

      case SRichViewEdit1.PageProperty.PageFormat of
        srvfmA4: ListPaper.ItemIndex := 0;
        srvfmA5: ListPaper.ItemIndex := 1;
      else
        ListPaper.ItemIndex := 0;
      end;
    end;

  if FPageProperty.ShowModal = mrOK then
    begin
      With FPageProperty do
        begin
          SRichViewEdit1.SetMarginUnit(StrToFloat(Trim(PageLeft.Text)),
                                       StrToFloat(Trim(PageTop.Text)),
                                       StrToFloat(Trim(PageRight.Text)),
                                       StrToFloat(Trim(PageBottom.Text)));
{          SRichViewEdit1.SetMarginMM(Round(PageLeft.Value),
                                 Round(PageTop.Value),
                                 Round(PageRight.Value),
                                 Round(PageBottom.Value));}
          SclRVRuler1.Scrolled;
          SclRVRuler2.Scrolled;

          if RadioGroup1.ItemIndex = 0 then
            begin
              if SRichViewEdit1.PageProperty.Orientation <> poPortrait then
                SRichViewEdit1.PageProperty.Orientation := poPortrait;
            end
          else
            begin
              if SRichViewEdit1.PageProperty.Orientation <> poLandscape then
                SRichViewEdit1.PageProperty.Orientation := poLandscape;
            end;

          case ListPaper.ItemIndex of
            0 : if SRichViewEdit1.PageProperty.PageFormat <> srvfmA4 then
                  SRichViewEdit1.PageProperty.PageFormat := srvfmA4;
            1 : if SRichViewEdit1.PageProperty.PageFormat <> srvfmA5 then
                  SRichViewEdit1.PageProperty.PageFormat := srvfmA5;
          end;
        end;
    end;
  SRichViewEdit1.CanUpdate := TRUE;
end;
// Printing
procedure TForm3.Print(UseDialog: Boolean);
begin
  if HToolButton <> nil then begin
    // for printing we need to switch to multipage mode
    SRichViewEdit1.CanUpdate := False;
    MultiPageMode(SRichViewEdit1);
  end;

  if UseDialog then begin
    PrintDialog1.MinPage := 1;
    PrintDialog1.MaxPage := SRichViewEdit1.PageCount;
    PrintDialog1.FromPage := PrintDialog1.MinPage;
    PrintDialog1.ToPage   := PrintDialog1.MaxPage;
    if PrintDialog1.Execute then
      case PrintDialog1.PrintRange of
        prAllPages:
          SRichViewEdit1.PrintAll;
        prPageNums:
          SRichViewEdit1.PrintRange(PrintDialog1.FromPage, PrintDialog1.ToPage);
      end;
    end
  else
    SRichViewEdit1.PrintAll;

  if HToolButton <> nil then
    // restoring the original view mode
    SRichViewEdit1HMenuClickButton(SRichViewEdit1, HToolButton);
end;
// File | Print
procedure TForm3.mitPrintClick(Sender: TObject);
begin
  Print(True);
end;
// "Quick Print" tool button
procedure TForm3.btnQuickPrintClick(Sender: TObject);
begin
  Print(False);
end;
// "Preview" tool button
procedure TForm3.btnPreviewClick(Sender: TObject);
begin
  if SRichViewEdit1.ViewProperty.ViewMode = srvvmEditMode then
    SRichViewEdit1.ViewProperty.ViewMode := srvvmPreviewMode
  else
    SRichViewEdit1.ViewProperty.ViewMode := srvvmEditMode;
  btnPreview.Down := SRichViewEdit1.ViewProperty.ViewMode = srvvmPreviewMode;
end;

// Displaying hints in status bar
procedure TForm3.ApplicationHint(Sender: TObject);
var s: String;
begin
  s := GetLongHint(Application.Hint);
  stat1.SimplePanel := s<>'';
  stat1.SimpleText := s;
  stat1.Repaint;
end;
// Showing/hiding page scroller
procedure TForm3.ToggleThumbnails(Show: Boolean);
begin
  if Show then
    SRVPageScroll1.SRichViewEdit := SRichViewEdit1
  else
    SRVPageScroll1.SRichViewEdit := nil;
  SRVPageScroll1.Visible := Show;
  Splitter1.Visible := Show;
end;

procedure TForm3.btnThumbnailsClick(Sender: TObject);
begin
  ToggleThumbnails(btnThumbnails.Down);
end;

initialization

{$IFDEF USE_GIFIMAGE}
  RegisterClasses([TGifImage]);
  // uncomment the line below if Gif does not appear in Insert | Image
  //TPicture.RegisterFileFormat('gif', 'Gif Image', TGifImage);
  RV_RegisterHTMLGraphicFormat(TGifImage);
{$ENDIF}
{$IFDEF USE_PNGOBJECT}
  {$IFDEF RICHVIEWDEF2009}
  RegisterClass(TPngImage);
  RV_RegisterHTMLGraphicFormat(TPngImage);
  RV_RegisterPngGraphic(TPngImage);
  {$ELSE}
  RegisterClass(TPngObject);
  RV_RegisterHTMLGraphicFormat(TPngObject);
  RV_RegisterPngGraphic(TPngObject);  
  {$ENDIF}
{$ENDIF}

  RVA_GetRichViewEditFromPopupComponent :=
   SRVGetRichViewEditFromPopupComponent;

end.
