
unit MFInsertControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ComCtrls, ToolWin, SclRView, RVScroll, Ruler, RVRuler, RVStyle,
  ExtCtrls, stdctrls, SRVButton, SRVCheckBox, SRVEdit, SRVGroupBox, SRVLabel,
  SRVPanel, SRVRadioButton, SRVMediaPlayer, SRVPaintBox, Menus, Grids, Printers,
  ExtDlgs, SclRVRuler, RVFuncs, SRVControl;

type
  TFInsertControls = class(TForm)
    ImageList1: TImageList;
    Panel1: TPanel;
    Panel3: TPanel;
    SclRVRuler1: TSclRVRuler;
    Panel4: TPanel;
    RVRulerItemSelector1: TRVRulerItemSelector;
    Panel5: TPanel;
    SRichViewEdit1: TSRichViewEdit;
    SclRVRuler2: TSclRVRuler;
    stat1: TStatusBar;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolBar2: TToolBar;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton15: TToolButton;
    ToolButton17: TToolButton;
    TabSheet3: TTabSheet;
    ToolBar3: TToolBar;
    ToolButton18: TToolButton;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    mitOpenRVF: TMenuItem;
    mitSaveRVF: TMenuItem;
    N1: TMenuItem;
    mitExit: TMenuItem;
    mitPreview: TMenuItem;
    OpenRVF: TOpenDialog;
    SaveRVF: TSaveDialog;
    Panel6: TPanel;
    ListZoom: TComboBox;
    ListFormat: TComboBox;
    ListUnits: TComboBox;
    InspectorProperty: TStringGrid;
    mitPageSetup: TMenuItem;
    OpenBMP: TOpenPictureDialog;
    SelectFont: TFontDialog;
    OpenMedia: TOpenDialog;
    ColorDialog1: TColorDialog;
    ListImageTB: TImageList;
    N2: TMenuItem;
    mitPrint: TMenuItem;
    mitSimplePrint: TMenuItem;
    PrintDialog1: TPrintDialog;
    ToolButton14: TToolButton;
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton7Click(Sender: TObject);
    procedure ToolButton8Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure ToolButton11Click(Sender: TObject);
    procedure ToolButton12Click(Sender: TObject);
    procedure ToolButton13Click(Sender: TObject);
    procedure ToolButton15Click(Sender: TObject);
    procedure ToolButton17Click(Sender: TObject);
    procedure ToolButton18Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mitOpenRVFClick(Sender: TObject);
    procedure mitSaveRVFClick(Sender: TObject);
    procedure ListZoomChange(Sender: TObject);
    procedure ListFormatChange(Sender: TObject);
    procedure ListUnitsChange(Sender: TObject);
    procedure mitPageSetupClick(Sender: TObject);
    procedure InspectorPropertyKeyPress(Sender: TObject; var Key: Char);
    procedure InspectorPropertyMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure mitPreviewClick(Sender: TObject);
    procedure mitPrintClick(Sender: TObject);
    procedure mitSimplePrintClick(Sender: TObject);
    procedure SRichViewEdit1CheckControl(Sender: TSRichViewEdit;
      AControl: TControl);
    procedure SRichViewEdit1CaretMove(Sender: TObject);
    procedure mitExitClick(Sender: TObject);
    procedure ToolButton14Click(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject; R: TRect; Canvas: TCanvas);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LoadProperty(FileName : String);
    procedure UpdateProperty;
    function ExecuteEditor(PropertyName, TypeValue : String; var PropertyValue : String) : Boolean;
  end;

var
  FInsertControls: TFInsertControls;
  CurControl : TControl;
  TypeValue : array of String;

implementation

uses f_PageProperty, MPropertyControls, MFSelectText, MFSelectValue,
  MFSelectDate, MFAddButton, MFPreview;

{$R *.DFM}

procedure TFInsertControls.ToolButton3Click(Sender: TObject);
var
     c : TSRVCheckBox;
begin
  c := TSRVCheckBox.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVCheckBox';
  c.Caption := 'SRVCheckBox';
  c.Color:=clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton1Click(Sender: TObject);
var  c : TSRVButton;
begin
  c := TSRVButton.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVButton';
  c.Caption := 'SRVButton';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton2Click(Sender: TObject);
var
     c : TSRVEdit;
begin
  c := TSRVEdit.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name:= 'SRVEdit';
  c.Text:='SRVEdit';
  c.Color:=clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton6Click(Sender: TObject);
var
     c : TSRVGroupBox;
begin
  c := TSRVGroupBox.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name:= 'SRVGroupBox';
  c.Caption := 'SRVGroupBox';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton4Click(Sender: TObject);
var
     c : TSRVRadioButton;
begin
  c := TSRVRadioButton.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVRadioButton';
  c.Caption := 'SRVRadioButton';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton5Click(Sender: TObject);
var
     c : TSRVLabel;
begin
  c := TSRVLabel.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVLabel';
  c.Caption := 'SRVLabel';
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton7Click(Sender: TObject);
var
     c : TSRVPanel;
begin
  c := TSRVPanel.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVPanel';
  c.Caption := 'SRVPanel';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton8Click(Sender: TObject);
var
     c : TButton;
begin
  c := TButton.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name :='Button';
  c.Caption :='Button';
  c.Font.Name := 'Microsoft Sans Serif';
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton9Click(Sender: TObject);
var
     c : TCheckBox;
begin
  c := TCheckBox.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'CheckBox';
  c.Font.Name := 'Microsoft Sans Serif';
  c.Caption := 'CheckBox';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton10Click(Sender: TObject);
var
     c : TRadioButton;
begin
  c := TRadioButton.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'RadioButton';
  c.Font.Name := 'Microsoft Sans Serif';
  c.Caption := 'RadioButton';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton11Click(Sender: TObject);
var
     c : TEdit;
begin
  c := TEdit.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'Edit';
  c.Text := 'Edit';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton12Click(Sender: TObject);
var
     c : TMemo;
begin
  c := TMemo.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'Memo';
  c.Text := 'Memo';
  c.Color := clWhite;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton13Click(Sender: TObject);
var
     c : TPanel;
begin
  c := TPanel.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'Panel';
  c.Caption := 'Panel';
  c.Font.Name := 'Microsoft Sans Serif';
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton15Click(Sender: TObject);
var
     c : TMonthCalendar;
begin
  c := TMonthCalendar.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Font.Name := 'Arial'; // we need True Type font for proper drawing
  c.Name := 'MonthCalendar';
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton17Click(Sender: TObject);
var
     c : TProgressBar;
begin
  c := TProgressBar.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'Gauge';
  c.Position := 50;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.ToolButton18Click(Sender: TObject);
var
     c : TSRVMediaPlayer;
begin
  c := TSRVMediaPlayer.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVMediaPlayer';
  c.Display := SRichViewEdit1;
  c.FileName := 'cool.avi';
  c.Parent := SRichViewEdit1;
  c.Open;
  c.Width := c.VideoWidth;
  c.Height := c.VideoHeight;

  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);

  c.Play;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.FormCreate(Sender: TObject);
begin
  SetLength(TypeValue, 30);

  ListZoom.ItemIndex:= ListZoom.Items.IndexOf('PageWidth');
  ListFormat.ItemIndex:= ListFormat.Items.IndexOf('A4');
  ListUnits.ItemIndex:= ListUnits.Items.IndexOf('cm');
  ListZoomChange(nil);
  ListFormatChange(nil);
  ListUnitsChange(nil);
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.FormDestroy(Sender: TObject);
begin
  Finalize(TypeValue);
end;
{------------------------------------------------------------------------------}
{ Events on selecting in combo boxes }
// Applying zoom mode
procedure TFInsertControls.ListZoomChange(Sender: TObject);
var procent : Integer;
begin
  procent:= StrToIntDef(ListZoom.Text, 0);
  if procent > 0 then
    SRichViewEdit1.ViewProperty.ZoomPercent:= procent
  else
    if ListZoom.Text = 'PageWidth' then
      SRichViewEdit1.ViewProperty.ZoomMode:= rvzmPageWidth
    else if ListZoom.Text = 'FullPage' then
      SRichViewEdit1.ViewProperty.ZoomMode:= rvzmFullPage;
end;
// Applying page format
procedure TFInsertControls.ListFormatChange(Sender: TObject);
var text : String;
begin
  text:= trim(ListFormat.Text);
  if text = 'A0' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA0;
  if text = 'A1' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA1;
  if text = 'A2' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA2;
  if text = 'A3' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA3;
  if text = 'A4' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA4;
  if text = 'A5' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA5;
  if text = 'A6' then SRichViewEdit1.PageProperty.PageFormat:= srvfmA6;
  if text = 'Letter' then SRichViewEdit1.PageProperty.PageFormat:= srvfmLetter;
  if text = 'Legal' then SRichViewEdit1.PageProperty.PageFormat:= srvfmLegal;
end;
// Applying measurement units
procedure TFInsertControls.ListUnitsChange(Sender: TObject);
var
     RulerUnit : TRulerUnits;
     SRVUnit : TRVUnits;
begin
  case ListUnits.ItemIndex of
    1 :
      begin
        RulerUnit := ruMillimeters;
        SRVUnit := rvuMillimeters;
      end;
    2 :
      begin
        RulerUnit := ruCentimeters;
        SRVUnit := rvuCentimeters;
      end;
    3 :
      begin
        RulerUnit := ruPicas;
        SRVUnit := rvuPicas;
      end;
    4 :
      begin
        RulerUnit := ruPixels;
        SRVUnit := rvuPixels;
      end;
    5 :
      begin
        RulerUnit := ruPoints;
        SRVUnit := rvuPoints;
      end;
  else
    begin
      RulerUnit := ruInches;
      SRVUnit := rvuInches;
    end;
  end;
  SRichViewEdit1.UnitsProgram := SRVUnit;
  SclRVRuler1.UnitsDisplay := RulerUnit;
  SclRVRuler2.UnitsDisplay := RulerUnit;
end;
{------------------------------------------------------------------------------}
{ Returns paper format name }
function GetPaperFormatName(PaperFormat: TSRVPageFormat): String;
begin
  case PaperFormat of
    srvfmA0:
      Result := 'A0';
    srvfmA1:
      Result := 'A1';
    srvfmA2:
      Result := 'A2';
    srvfmA3:
      Result := 'A3';
    srvfmA4:
      Result := 'A4';
    srvfmA5:
      Result := 'A5';
    srvfmA6:
      Result := 'A6';
    srvfmLetter:
      Result := 'Letter';
    srvfmLegal:
      Result := 'Legal';
    else
      Result := '';
  end;
end;
{------------------------------------------------------------------------------}
{ Returns name for measurement units}
function GetUnitsName(Units: TRVUnits): String;
begin
  case Units of
    rvuMillimeters:
      Result := 'mm';
    rvuCentimeters:
      Result := 'cm';
    rvuPicas:
      Result := 'picas';
    rvuPixels:
      Result := 'pixels';
    rvuPoints:
      Result := 'points';
    rvuInches:
      Result := 'inch';
    else
      Result := '';
  end;
end;
{------------------------------------------------------------------------------}
{ File | Open RVF }
procedure TFInsertControls.mitOpenRVFClick(Sender: TObject);
begin
  if not OpenRVF.Execute then
    exit;

  SRichViewEdit1.LoadRVF(OpenRVF.FileName);

  // The file may contain page properties. Updating user interface  

  case SRichViewEdit1.ViewProperty.ZoomMode of
    rvzmPageWidth:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf('PageWidth');
    rvzmFullPage:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf('FullPage');
    rvzmCustom:
      ListZoom.ItemIndex := ListZoom.Items.IndexOf(
        IntToStr(Round(SRichViewEdit1.ViewProperty.ZoomPercent)));
  end;

  ListFormat.ItemIndex :=
    ListFormat.Items.IndexOf(GetPaperFormatName(SRichViewEdit1.PageProperty.PageFormat));

  ListUnits.ItemIndex :=
    ListUnits.Items.IndexOf(GetUnitsName(SRichViewEdit1.UnitsProgram));

  SclRVRuler1.UnitsDisplay := TRulerUnits(SRichViewEdit1.UnitsProgram);
  SclRVRuler2.UnitsDisplay := TRulerUnits(SRichViewEdit1.UnitsProgram);

  SRichViewEdit1.ProcessControls;
end;
{------------------------------------------------------------------------------}
{ File | Save RVF }
procedure TFInsertControls.mitSaveRVFClick(Sender: TObject);
begin
  if SaveRVF.Execute then
    SRichViewEdit1.RichViewEdit.SaveRVF(SaveRVF.FileName, False);
end;
{------------------------------------------------------------------------------}
{ File | Page Setup }
procedure TFInsertControls.mitPageSetupClick(Sender: TObject);
begin
  SRichViewEdit1.CanUpdate := FALSE;

  With FPageProperty do
    begin
      PageLeft.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.LeftMargin * 100) * 0.01);
      PageRight.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.RightMargin * 100) * 0.01);

      PageTop.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.TopMargin * 100) * 0.01);
      PageBottom.Text := FloatToStr(Round(SRichViewEdit1.PageProperty.BottomMargin * 100) * 0.01);

      if SRichViewEdit1.PageProperty.Orientation = poPortrait then
        begin
          RadioGroup1.ItemIndex := 0;
        end
      else
        begin
          RadioGroup1.ItemIndex := 1;
        end;

      case SRichViewEdit1.PageProperty.PageFormat of
        srvfmA4: ListPaper.ItemIndex := 0;
        srvfmA5: ListPaper.ItemIndex := 1;
      else
        ListPaper.ItemIndex := 0;
      end;
    end;

  if FPageProperty.ShowModal = mrOK then
    begin
      With FPageProperty do
        begin
          SRichViewEdit1.SetMarginUnit(StrToFloat(Trim(PageLeft.Text)),
                                       StrToFloat(Trim(PageTop.Text)),
                                       StrToFloat(Trim(PageRight.Text)),
                                       StrToFloat(Trim(PageBottom.Text)));
{          SRichViewEdit1.SetMarginMM(Round(PageLeft.Value),
                                 Round(PageTop.Value),
                                 Round(PageRight.Value),
                                 Round(PageBottom.Value));}
          SclRVRuler1.Scrolled;
          SclRVRuler2.Scrolled;

          if RadioGroup1.ItemIndex = 0 then
            begin
              if SRichViewEdit1.PageProperty.Orientation <> poPortrait then
                SRichViewEdit1.PageProperty.Orientation := poPortrait;
            end
          else
            begin
              if SRichViewEdit1.PageProperty.Orientation <> poLandscape then
                SRichViewEdit1.PageProperty.Orientation := poLandscape;
            end;

          case ListPaper.ItemIndex of
            0 : if SRichViewEdit1.PageProperty.PageFormat <> srvfmA4 then
                  SRichViewEdit1.PageProperty.PageFormat := srvfmA4;
            1 : if SRichViewEdit1.PageProperty.PageFormat <> srvfmA5 then
                  SRichViewEdit1.PageProperty.PageFormat := srvfmA5;
          end;
        end;
    end;
  SRichViewEdit1.CanUpdate := TRUE;
end;
{------------------------------------------------------------------------------}
{ File | Preview }
procedure TFInsertControls.mitPreviewClick(Sender: TObject);
begin
  FPreview.SRVPrint1.Orientation := SRichViewEdit1.PageProperty.Orientation;
  FPreview.ShowModal;
end;
{------------------------------------------------------------------------------}
{ File | Print... }
procedure TFInsertControls.mitPrintClick(Sender: TObject);
begin
  if PrintDialog1.Execute then
    FPreview.SRVPrint1.Print('ScaleRichView', PrintDialog1.Copies, PrintDialog1.Collate);
end;
{ File | Simple Print }
{------------------------------------------------------------------------------}
procedure TFInsertControls.mitSimplePrintClick(Sender: TObject);
begin
  SRichViewEdit1.PrintAll;
end;
{------------------------------------------------------------------------------}
{ File | Exit }
procedure TFInsertControls.mitExitClick(Sender: TObject);
begin
  Close;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.SRichViewEdit1CaretMove(Sender: TObject);
begin
  if CurControl <> SRichViewEdit1.CurControl then
    begin
      CurControl := SRichViewEdit1.CurControl;
      UpdateProperty;
    end;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.LoadProperty(FileName : String);
var
     FP : TStringList;
     i : Integer;
     s, PropertyName, PropertyValue, PropertyType : String;
begin
  InspectorProperty.RowCount := 1;
  InspectorProperty.Cells[0, 0] := 'Name';
  InspectorProperty.Cells[1, 0] := CurControl.Name;

  If not FileExists(FileName) then exit;
  FP := TStringList.Create;
  FP.LoadFromFile(FileName);
  if Length(TypeValue) < FP.Count then
    SetLength(TypeValue, FP.Count);

  for i := 0 to FP.Count-1 do
    begin
      s := FP.Strings[i];
      PropertyName := Trim(Copy(s, 1, Pos('|', s) - 1));
      PropertyType := Trim(Copy(s, Pos('|', s) + 1, Length(s)));
      PropertyValue := GetPropertyValue(CurControl, PropertyName);
      InspectorProperty.Cells[0, i] := PropertyName;
      InspectorProperty.Cells[1, i] := PropertyValue;
      TypeValue[i] := PropertyType;
      InspectorProperty.RowCount := i + 1;
    end;
  FP.Free;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.UpdateProperty;
begin
  if CurControl = nil then
    begin
      InspectorProperty.RowCount := 1;
      InspectorProperty.Cells[0, 0] := '';
      InspectorProperty.Cells[1, 0] := '';
      exit;
    end;
  LoadProperty(ExtractFilePath(Application.ExeName) + 'Property\' +
               CurControl.ClassName + '.txt');
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.InspectorPropertyKeyPress(Sender: TObject;
  var Key: Char);
var
     PropertyName, PropertyValue : String;
begin
  if Key = chr(13) then
    begin
      if InspectorProperty.Row = -1 then exit;
      PropertyName := InspectorProperty.Cells[0, InspectorProperty.Row];
      PropertyValue := InspectorProperty.Cells[1, InspectorProperty.Row];
      if CurControl = nil then exit;
      SetPropertyValue(CurControl, PropertyName, PropertyValue);
      UpdateProperty;
      SRichViewEdit1.RichViewEdit.Reformat;
    end;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.InspectorPropertyMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
     ACol, ARow: Integer;
     PropertyName, PropertyValue, PropertyType : String;
begin
  InspectorProperty.MouseToCell(X, Y, ACol, ARow);
  if InspectorProperty.Row = -1 then exit;
  PropertyName := InspectorProperty.Cells[0, InspectorProperty.Row];
  PropertyValue := InspectorProperty.Cells[1, InspectorProperty.Row];
  PropertyType := TypeValue[InspectorProperty.Row];
  if CurControl = nil then exit;
  if ExecuteEditor(PropertyName, PropertyType, PropertyValue) then
    begin
      SetPropertyValue(CurControl, PropertyName, PropertyValue);
      UpdateProperty;
      SRichViewEdit1.RichViewEdit.Reformat;
    end;
end;
{------------------------------------------------------------------------------}
function TFInsertControls.ExecuteEditor(PropertyName, TypeValue : String;
  var PropertyValue : String) : Boolean;
var
     tb : TToolButton;
begin
  Result := False;
  If TypeValue = 'String' then
    begin
      FSelectText.Editor.Text := PropertyValue;
      Result := FSelectText.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectText.Editor.Text;
    end;
  If TypeValue = 'Strings' then
    begin
      FSelectText.Editor.Text := PropertyValue;
      Result := FSelectText.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectText.Editor.Text;
      Result := True;
    end;
  If TypeValue = 'Boolean' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('True');
      FSelectValue.ListValue.Items.Append('False');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
      Result := True;
    end;
  If TypeValue = 'TAlignment' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('taLeftJustify');
      FSelectValue.ListValue.Items.Append('taRightJustify');
      FSelectValue.ListValue.Items.Append('taCenter');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
      Result := True;
    end;
  If TypeValue = 'TAlign' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('alNone');
      FSelectValue.ListValue.Items.Append('alTop');
      FSelectValue.ListValue.Items.Append('alBottom');
      FSelectValue.ListValue.Items.Append('alLeft');
      FSelectValue.ListValue.Items.Append('alRight');
      FSelectValue.ListValue.Items.Append('alClient');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
      Result := True;
    end;
  If TypeValue = 'TModalResult' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('mrNone');
      FSelectValue.ListValue.Items.Append('mrOk');
      FSelectValue.ListValue.Items.Append('mrCancel');
      FSelectValue.ListValue.Items.Append('mrAbort');
      FSelectValue.ListValue.Items.Append('mrRetry');
      FSelectValue.ListValue.Items.Append('mrIgnore');
      FSelectValue.ListValue.Items.Append('mrYes');
      FSelectValue.ListValue.Items.Append('mrNo');
      FSelectValue.ListValue.Items.Append('mrAll');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
      Result := True;
    end;
  If TypeValue = 'TSRVCheckBoxState' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('cbUnchecked');
      FSelectValue.ListValue.Items.Append('cbChecked');
      FSelectValue.ListValue.Items.Append('cbGrayed');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
      Result := True;
    end;
  If TypeValue = 'TSRVEditCharCase' then
    begin
      FSelectValue.ListValue.Clear;
      FSelectValue.ListValue.Items.Append('srvecNormal');
      FSelectValue.ListValue.Items.Append('srvecUpperCase');
      FSelectValue.ListValue.Items.Append('srvecLowerCase');
      FSelectValue.ListValue.ItemIndex :=
        FSelectValue.ListValue.Items.IndexOf(PropertyValue);
      Result := FSelectValue.ShowModal = mrOk;
      if Result then
        PropertyValue := FSelectValue.ListValue.Text;
    end;
  If TypeValue = 'TColor' then
    begin
      ColorDialog1.Color := StrToInt(PropertyValue);
      Result := ColorDialog1.Execute;
      if Result then
        PropertyValue := '$' + IntToHex(ColorDialog1.Color, 8);
    end;
  If TypeValue = 'AddButton' then
    begin
      with TToolBar(CurControl) do begin
        FAddButton.ButCaption.Text := 'Button' + IntToStr(ButtonCount + 1);
        FAddButton.ButName.Text := FAddButton.ButCaption.Text;
        FAddButton.ButImage.ItemIndex := ButtonCount;
        FAddButton.ButEnabled.Checked := True;
        FAddButton.ButDown.Checked := False;
        FAddButton.ButGrouped.Checked := False;
        FAddButton.ButWrap.Checked := False;
        Result := FAddButton.ShowModal = mrOk;
        if Result then
          begin
            tb := TToolButton.Create(nil);
            tb.Caption := FAddButton.ButCaption.Text;
            tb.Name := FAddButton.ButName.Text;
            tb.ImageIndex := FAddButton.ButImage.ItemIndex;
            tb.Enabled := FAddButton.ButEnabled.Checked;
            tb.Down := FAddButton.ButDown.Checked;
            tb.Grouped := FAddButton.ButGrouped.Checked;
            tb.Wrap := FAddButton.ButWrap.Checked;

            AutoSize := False;
            Width := Width * 2;
            InsertControl(tb);
            AutoSize := True;
          end;
      end;
    end;
  If TypeValue = 'SelectMedia' then
    begin
      OpenMedia.FileName := PropertyValue;
      Result := OpenMedia.Execute;
      if Result then
        begin
          PropertyValue := OpenMedia.FileName;
          if ExtractFilePath(PropertyValue) = ExtractFilePath(Application.ExeName) then
            PropertyValue := ExtractFileName(PropertyValue);
          TSRVMediaPlayer(CurControl).FileName := PropertyValue;
          TSRVMediaPlayer(CurControl).Open;
          TSRVMediaPlayer(CurControl).Width :=
            TSRVMediaPlayer(CurControl).VideoWidth;
          TSRVMediaPlayer(CurControl).Height :=
            TSRVMediaPlayer(CurControl).VideoHeight;
          TSRVMediaPlayer(CurControl).Play;
        end;
    end;
  If TypeValue = 'SelectImage' then
    begin
      OpenBMP.FileName := PropertyValue;
      Result := OpenBMP.Execute;
      if Result then
        PropertyValue := OpenBMP.FileName;
    end;
  If TypeValue = 'TFont' then
    begin
      SelectFont.Font.Assign(CurFont);
      Result := SelectFont.Execute;
      if Result then
        CurFont.Assign(SelectFont.Font);
    end;
  If TypeValue = 'TDate' then
    begin
      FSelectDate.Calendar.Date := StrToDate(PropertyValue);
      Result := FSelectDate.ShowModal = mrOk;
      if Result then
        PropertyValue := DateToStr(FSelectDate.Calendar.Date);
    end;
end;
{------------------------------------------------------------------------------}
procedure TFInsertControls.SRichViewEdit1CheckControl(
  Sender: TSRichViewEdit; AControl: TControl);
begin
  if AControl is TSRVMediaPlayer then
    begin
      TSRVMediaPlayer(AControl).Display := Sender;
      TSRVMediaPlayer(AControl).Open;
      TSRVMediaPlayer(AControl).Play;
    end;
end;

procedure TFInsertControls.ToolButton14Click(Sender: TObject);
var
     c : TSRVPaintBox;
begin
  c := TSRVPaintBox.Create(nil);
  c.Parent := SRichViewEdit1.RichViewEdit;
  c.Name := 'SRVPaintBox';
  c.Caption := 'SRVPaintBox';
  c.Width := 150;
  c.OnPaint := PaintBox1Paint;
  SRichViewEdit1.RichViewEdit.InsertControl('teste', c, rvvaMiddle);
end;

procedure TFInsertControls.PaintBox1Paint(Sender: TObject; R: TRect;
  Canvas: TCanvas);
var
     X, Y : Integer;
     Text : string;
begin
  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := clRed;
  Canvas.FillRect(R);
  Canvas.Brush.Color := clGreen;
  Canvas.Ellipse(R.Left, R.Top, R.Right, R.Bottom);
  Canvas.Font.Color := clWhite;
  Canvas.Brush.Style := bsClear;

  Text := 'SRVPaintBox';
  X := R.Left + ((R.Right - R.Left - Canvas.TextWidth(Text)) div 2);
  Y := R.Top + ((R.Bottom - R.Top - Canvas.TextHeight(Text)) div 2);
  Canvas.TextRect(R, X, Y, Text);
  Canvas.Font.Color := clBlue;
  Canvas.TextRect(R, X+1, Y+1, Text);
end;

initialization
  RegisterClass(TSRVButton);
  RegisterClass(TSRVEdit);
  RegisterClass(TSRVCheckBox);
  RegisterClass(TSRVRadioButton);
  RegisterClass(TSRVLabel);
  RegisterClass(TSRVGroupBox);
  RegisterClass(TSRVPanel);
  RegisterClass(TSRVPaintBox);
  RegisterClass(TSRVMediaPlayer);

  RegisterClass(TButton);
  RegisterClass(TCheckBox);
  RegisterClass(TRadioButton);
  RegisterClass(TEdit);
  RegisterClass(TMemo);
  RegisterClass(TPanel);
  RegisterClass(TToolBar);
  RegisterClass(TToolButton);
  RegisterClass(TMonthCalendar);
  RegisterClass(TTrackBar);
  RegisterClass(TProgressBar);

end.
