unit Unit1;

interface

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RVTypes,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVStyle, RVScroll, RichView, RVEdit, ComCtrls, StdCtrls, SclRView;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    RVStyle1: TRVStyle;
    Button1: TButton;
    Edit1: TEdit;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    TabSheet4: TTabSheet;
    rv5: TRichView;
    Label2: TLabel;
    Button4: TButton;
    ImageList1: TImageList;
    srv1: TSRichViewEdit;
    srv2: TSRichViewEdit;
    srv3: TSRichViewEdit;
    srv4: TSRichViewEdit;
    srv5: TSRichViewEdit;
    srv6: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure rve6KeyPress(Sender: TObject; var Key: Char);
    procedure rve6KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure rv5RVFImageListNeeded(Sender: TCustomRichView;
      ImageListTag: Integer; var il: TCustomImageList);
  private
    { Private declarations }
    procedure AddWithIcons(rv: TCustomRichView; s: String; StyleNo: Integer; var ParaNo: Integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  srv1.RichViewEdit.Clear;
  srv1.RichViewEdit.AddNL('John: ', 3, 0);
  srv1.RichViewEdit.AddNL('Funny, very funny :)', 0, -1);
  srv1.RichViewEdit.AddNL('Rob: ', 3, 0);
  srv1.RichViewEdit.AddNL('I do not think so :(...', 0, -1);
  srv1.RichViewEdit.Format;

  srv4.RichViewEdit.Clear;
  srv4.RichViewEdit.AddNL('La la la:):):):)', 1, 0);
  srv4.RichViewEdit.AddNL('La la la:):):):)', 2, -1);
  srv4.RichViewEdit.AddNL('La la la:):):):)', 0, -1);
  srv4.RichViewEdit.Format;
end;


{------------------------------------------------------------------------------}
// Using Search feature of RichViewEdit to insert emotion icons

procedure TForm1.Button1Click(Sender: TObject);

  procedure SearchAndInsertIcon(const Code: String; ImageIndex: Integer);
  begin
    srv1.RichViewEdit.SetSelectionBounds(0, srv1.RichViewEdit.GetOffsBeforeItem(0), 0, srv1.RichViewEdit.GetOffsBeforeItem(0));
    while srv1.RichViewEdit.SearchText(Code, [rvseoDown]) do
      srv1.RichViewEdit.InsertBullet(ImageIndex, ImageList1);
  end;

begin
  LockWindowUpdate(srv1.RichViewEdit.Handle);
  try
    SearchAndInsertIcon(':)', 0);
    SearchAndInsertIcon(':|', 1);
    SearchAndInsertIcon(':(', 2);
  finally
    LockWindowUpdate(0);
  end;
end;

{------------------------------------------------------------------------------}
function GetImageIndex(mouth: Char): Integer;
begin
  case mouth of
    ')': Result := 0;
    '|': Result := 1;
    else Result := 2;
  end;
end;
{------------------------------------------------------------------------------}
procedure TForm1.AddWithIcons(rv: TCustomRichView; s: String; StyleNo: Integer; var ParaNo: Integer);
var s2: String;
    p: Integer;
begin
  s2 := '';
  while s<>'' do
  begin
    p := Pos(':', s); // searching for "eyes"
    if p=0 then
    begin
      // not found
      rv.AddNL(s2+s, StyleNo, ParaNo);
      ParaNo := -1;
      exit;
    end;
    // is it really "eyes"?
    if (Length(s)>p) and (s[p+1] in [')','|','(']) then
    begin
      // a smile is found
      s2 := s2+Copy(s, 1, p-1);
      if s2<>'' then
      begin
        rv.AddNL(s2, StyleNo, ParaNo);
        s2 := '';
        ParaNo := -1;
      end;
      rv.AddBulletEx( '', GetImageIndex(s[p+1]), ImageList1, ParaNo);
      ParaNo := -1;
      s := Copy(s, p+2, Length(s));
    end
    else
    begin
      // this is not a smile
      s2 := Copy(s, 1, p);
      s := Copy(s, p+1, Length(s));
    end;
  end;

  if s2<>'' then
    begin
      rv.AddNL(s2, StyleNo, ParaNo);
      s2 := '';
      ParaNo := -1;
    end;
end;
{------------------------------------------------------------------------------}
// From TEdit
procedure TForm1.Button2Click(Sender: TObject);
var ParaNo: Integer;
begin
  if Edit1.Text<>'' then
  begin
    srv2.RichViewEdit.AddNL('Me: ',3,0);
    ParaNo := -1; // adding to the same line
    AddWithIcons(srv2.RichViewEdit, Edit1.Text, 0, ParaNo);
    srv2.RichViewEdit.FormatTail;
    Edit1.Text := '';
  end
  else
    Beep;
end;
{------------------------------------------------------------------------------}
// From TRichViewEdit with emoticons detection
procedure TForm1.Button3Click(Sender: TObject);
var i: Integer;
    ParaNo: Integer;
begin
  // this example has the following limitations:
  // - non-text will be ignored
  // - assumes that styles of rv3 and rve4 are the same
  ParaNo := 0;
  for i := 0 to srv4.RichViewEdit.ItemCount-1 do
  begin
    if srv4.RichViewEdit.IsFromNewLine(i) then
      ParaNo := srv4.RichViewEdit.GetItemPara(i);
    if srv4.RichViewEdit.GetItemStyle(i)>=0 then
      AddWithIcons(srv3.RichViewEdit, srv4.RichViewEdit.GetItemText(i), srv4.RichViewEdit.GetItemStyle(i), ParaNo);
  end;
  srv3.RichViewEdit.FormatTail;
  srv4.RichViewEdit.SetFocus;
end;
{------------------------------------------------------------------------------}
// From TRichViewEdit as is
procedure TForm1.Button4Click(Sender: TObject);
var Stream: TMemoryStream;
begin
  Stream := TMemoryStream.Create;
  srv6.RichViewEdit.SaveRVFToStream(Stream, False);
  Stream.Position := 0;
  srv5.RichViewEdit.InsertRVFFromStream(Stream, srv5.RichViewEdit.ItemCount);
  Stream.Free;
  srv5.RichViewEdit.FormatTail;
  srv6.RichViewEdit.SetFocus;
end;
{------------------------------------------------------------------------------}
// Emoticons autodetection on typing
procedure TForm1.rve6KeyPress(Sender: TObject; var Key: Char);
var
  rve: TCustomRichViewEdit;
  ItemNo, Offs: Integer;
  s: String;

  function GetImageIndex(mouth: Char): Integer;
  begin
    case mouth of
      ')': Result := 0;
      '|': Result := 1;
      else Result := 2;
    end;
  end;

begin
  if not (Key in [')', '(', '|']) then
    exit;
  rve := (Sender as TRichViewEdit).TopLevelEditor;
  ItemNo := rve.CurItemNo;
  if rve.GetItemStyle(ItemNo)<0 then
    exit;
  Offs := rve.OffsetInCurItem;
  s := rve.GetItemText(ItemNo);
  if (s='') or (Offs=1) then
    exit;
  if s[Offs-1]=':' then begin
    rve.SetSelectionBounds(ItemNo, Offs-1, ItemNo, Offs);
    rve.InsertBullet(GetImageIndex(Key), ImageList1);
    Key := #0;
  end;
end;
{------------------------------------------------------------------------------}
// BACKSPACE disassembles emoticon
procedure TForm1.rve6KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  rve: TCustomRichViewEdit;
  ItemNo, Offs: Integer;

  function GetBulletImageIndex: Integer;
  var s: TRVAnsiString;
      tag: Integer;
      il: TCustomImageList;
  begin
    rve.GetBulletInfo(ItemNo, s, Result, il, tag);
  end;

  function GetSmile(ImageIndex: Integer): String;
  begin
    case ImageIndex of
      0: Result := ':)';
      1: Result := ':|';
      else Result := ':(';
    end;
  end;

begin
  if Key<>VK_BACK then
    exit;
  rve := (Sender as TRichViewEdit).TopLevelEditor;
  if rve.SelectionExists then
    exit;
  ItemNo := rve.CurItemNo;
  Offs := rve.OffsetInCurItem;
  if (rve.GetItemStyle(ItemNo)=rvsBullet) and (Offs=1) then begin
    Key := 0;
    rve.SetSelectionBounds(ItemNo, 0, ItemNo, 1);
    rve.InsertText(GetSmile(GetBulletImageIndex), False);
  end;
end;
{------------------------------------------------------------------------------}
procedure TForm1.rv5RVFImageListNeeded(Sender: TCustomRichView;
  ImageListTag: Integer; var il: TCustomImageList);
begin
  il := ImageList1;
end;

end.
