unit MFSRVPrint;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SRVPrint, ExtCtrls, RVScroll, CRVPP, SRVPreview, SclRView, StdCtrls, Printers,
  RVStyle;

type
  TFSRVPrint = class(TForm)
    srve: TSRichViewEdit;
    srvprvw: TSRVPreview;
    Splitter1: TSplitter;
    SRVPrint1: TSRVPrint;
    Panel1: TPanel;
    cmbDocPageFormat: TComboBox;
    Label1: TLabel;
    rgOrientation: TRadioGroup;
    Label3: TLabel;
    cmbPrinter: TComboBox;
    btnPreview: TButton;
    cbAutoUpdate: TCheckBox;
    Label2: TLabel;
    lblPaper: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure cmbDocPageFormatChange(Sender: TObject);
    procedure rgOrientationClick(Sender: TObject);
    procedure cmbPrinterChange(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure cbAutoUpdateClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure UpdateControlsForPrinter;
    procedure AssignPageFormat;
  end;

var
  FSRVPrint: TFSRVPrint;

implementation

{$R *.DFM}

procedure TFSRVPrint.UpdateControlsForPrinter;
begin
  cmbDocPageFormat.ItemIndex := 3;

  if (Printer.Orientation = poPortrait) then
    rgOrientation.ItemIndex := 0
  else
    rgOrientation.ItemIndex := 1;
end;

procedure TFSRVPrint.FormCreate(Sender: TObject);
var
     index : Integer;
begin
  // Printers
  if (Printer.Printers.Count > 0) then
    for index := 0 to (Printer.Printers.Count-1) do
      cmbPrinter.Items.Append(Printer.Printers.Strings[index]);
  cmbPrinter.ItemIndex := Printer.PrinterIndex;

  // Paper
  UpdateControlsForPrinter;

  // Page
  cmbDocPageFormatChange(nil);
  cbAutoUpdateClick(nil);
end;

procedure TFSRVPrint.cmbPrinterChange(Sender: TObject);
begin
  if (Printer.Printers.Count > 0) then
    begin
      Printer.PrinterIndex := cmbPrinter.ItemIndex;
      UpdateControlsForPrinter;
    end;
end;

procedure TFSRVPrint.AssignPageFormat;
var
     pW : Extended;
     pH : Extended;
begin
  case cmbDocPageFormat.ItemIndex of
    0: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA1, srve.UnitsProgram, pW, pH);
    1: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA2, srve.UnitsProgram, pW, pH);
    2: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA3, srve.UnitsProgram, pW, pH);
    3: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA4, srve.UnitsProgram, pW, pH);
    4: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA5, srve.UnitsProgram, pW, pH);
    5: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA6, srve.UnitsProgram, pW, pH);
    6: srve.PageProperty.ConvertPageFormatToPageSize(srvfmLetter, srve.UnitsProgram, pW, pH);
    7: srve.PageProperty.ConvertPageFormatToPageSize(srvfmLegal, srve.UnitsProgram, pW, pH);
  else
    srve.PageProperty.ConvertPageFormatToPageSize(srvfmA4, srve.UnitsProgram, pW, pH);
  end;
  if srve.PageProperty.Orientation = poLandscape then begin
    srve.PageProperty.PageWidth := pH;
    srve.PageProperty.PageHeight := pW;
    end
  else begin
    srve.PageProperty.PageWidth := pW;
    srve.PageProperty.PageHeight := pH;
  end;
  srve.ViewProperty.ZoomMode := srve.ViewProperty.ZoomMode;
end;

procedure TFSRVPrint.cmbDocPageFormatChange(Sender: TObject);
var
     index : Integer;
     Device : array[0..255] of char;
     Driver : array[0..255] of char;
     Port   : array[0..255] of char;
     hDMode : THandle;
     PDMode : PDEVMODE;
begin
  index := cmbDocPageFormat.ItemIndex;
  if (index = -1) then
    Exit;

  AssignPageFormat;
  SRVPrint1.Update;
  srvprvw.ZoomMode := rvzmFullPage;

  Printer.GetPrinter(Device, Driver, Port, hDMode);
  if hDMode <> 0 then begin
    pDMode := GlobalLock(hDMode);
    if pDMode <> nil then begin
      lblPaper.Caption := pDMode^.dmFormName;
      if lblPaper.Caption = '' then
        lblPaper.Caption := IntToStr(pDMode^.dmPaperSize)+' (see DMPAPER_*)';
      GlobalUnlock(hDMode);
    end;
  end;

end;

procedure TFSRVPrint.rgOrientationClick(Sender: TObject);
begin
  if (rgOrientation.ItemIndex = 0) then
    srve.PageProperty.Orientation := poPortrait
  else
    srve.PageProperty.Orientation := poLandscape;
  SRVPrint1.Update;
end;

procedure TFSRVPrint.btnPreviewClick(Sender: TObject);
begin
  SRVPrint1.Update;
end;

procedure TFSRVPrint.cbAutoUpdateClick(Sender: TObject);
begin
  SRVPrint1.AutoUpdate := cbAutoUpdate.Checked;
  btnPreview.Enabled := not cbAutoUpdate.Checked;
end;

procedure TFSRVPrint.FormResize(Sender: TObject);
begin
  srvprvw.ZoomMode := rvzmFullPage;
end;

end.
