function addCalculator(pValue) {
  var Elem = formByName('portalitem_calculator').elements['calc'];
  if (pValue == '') {
    var I = Elem.value.length;
    if (I > 0)
      Elem.value = Elem.value.substr(0, I - 1);
  } else if (pValue == 'CE')
    Elem.value = '0';
  else if (Elem.value == '0' && pValue != '.')
    Elem.value = pValue;
  else
    Elem.value += pValue;
  if (Elem.value == '')
    Elem.value = '0';
}

function bookmarkHomepage(pTitle) {
  try {
    window.sidebar.addPanel(pTitle, document.URL, '');
    return;
  } catch (Err) {}
  try {
    window.external.AddFavorite(document.URL, pTitle);
    return;
  } catch (Err) {}
  try { 
    var Elem = newElem('a');
    attrElem(Elem, 'href', document.URL);
    attrElem(Elem, 'rel', 'sidebar');
    attrElem(Elem, 'title', pTitle);
	Elem.click();
	return;
  } catch (Err) {}
}

function calcCalculator() {
  selFloat(formByName('portalitem_calculator').elements['calc'], -1, true);
}

function doConfirmActionDeleteBoard(pMsg, pIndex) {
  if (confirm(pMsg))
    getDynPortalItem('board', 'action=deleteboard&index=' + pIndex);
}

function doConfirmActionResetSettings(pMsg) {
  if (confirm(pMsg)) {
    loadPage('&action=reset');
    hidePopup();
  }
}

function doPopupViewDashboard(pIndex) {
  with (formByName('popup'))
    viewPopup('plain.php?page=dashboard.pop', 'index=' + pIndex + '&d1=' + elements['d1'].value + '&d2=' + elements['d2'].value + '&m1=' + elements['m1'].value + '&m2=' + elements['m2'].value + '&y1=' + elements['y1'].value + '&y2=' + elements['y2'].value);
}

function doPromptActionAddBoard(pMsg) {
  var S = prompt(pMsg, '');
  if (S != null && S != '')
    getDynPortalItem('board', 'action=addboard&text=' + encodeURIComponent(S));
}

function dragStartPortal(pName) {
  _DragAction = 'dragEndPortal("' + pName + '");';
  _DragParam = pName;
  var Elem1 = elementById('portalitem_' + pName);
  var Elem2 = newElem('div');
  attrElem(Elem2, 'id', 'id_dragportal');
  var Elem3 = newElem('div');
  Elem3.className = 'h2';
  Elem3.style.border = '1px dashed #CACACA';
  var I = Elem1.firstChild.offsetHeight + Elem1.firstChild.nextSibling.offsetHeight;
  Elem3.style.height = I + 'px';
  Elem2.appendChild(Elem3);
  Elem2.appendChild(newElem('br'));
  displayElem(Elem1, 'none');
  Elem1.parentNode.insertBefore(Elem2, Elem1);
  getElemBody().style.cursor = 'move';
}

function dragEndPortal(pName) {
  var Elem1 = elementById('dragportal');
  var Elem2 = elementById('portalitem_' + pName);
  Elem1.parentNode.replaceChild(Elem2, Elem1);
  displayElem(Elem2, 'block');
  if (pName != _DragParam)
    doHttpRequest('plain.php?page=setpos.dyn', '', '', 'dest=' + encodeURIComponent(_DragParam) + '&source=' + encodeURIComponent(pName));
}

function dragOverPortal(pName) {
  if (_DragAction.match(/^dragEndPortal/)) {
    _DragParam = pName;
    var Elem = elementById('portalitem_' + pName);
    Elem.parentNode.insertBefore(elementById('dragportal'), Elem);
  }
}

function dragOverPortalEmpty(pName) {
  if (_DragAction.match(/^dragEndPortal/)) {
    _DragParam = '_' + pName;
    var Elem = elementById('portalempty_' + pName);
    Elem.parentNode.insertBefore(elementById('dragportal'), Elem);
  }
}

function getDynPersonalize() {
  var Form = formByName('popup').elements;
  var ListAll = getAllOptSelValues(Form['selportal']);
  var ListPos = new Array(new Array(), new Array(), new Array());
  for (var I = 0; I < ListAll.length; I++)
    ListPos[getOptSelValue(Form['selpos_' + ListAll[I]])].push(ListAll[I]);
  doHttpRequest('plain.php?page=personalize.dyn', 'setDynPersonalize', '', 'filterpersonal=' + (Form['filterpersonal'].checked ? '1' : '') + '&selleft=' + encodeURIComponent(ListPos[0].join('|')) + '&selmiddle=' + encodeURIComponent(ListPos[1].join('|')) + '&selright=' + encodeURIComponent(ListPos[2].join('|')));
}

function getDynPortalItem(pName, pRawPostData) {
  doHttpRequest('plain.php?page=portalitems' + encodeURIComponent('/' + pName), 'setHtml', 'portalitem_' + pName + '_content', pRawPostData);
}

function getDynPwd() {
  with (formByName('popup'))
    doHttpRequest('plain.php?page=pwd.dyn', 'setDynPwd', '', 'confirmpwd=' + encodeURIComponent(elements['confirmpwd'].value) + '&newpwd=' + encodeURIComponent(elements['newpwd'].value) + '&oldpwd=' + encodeURIComponent(elements['oldpwd'].value));
}

function setDynPersonalize(pValue, pParam) {
  loadPage('');
  hidePopup();
}

function setDynPwd(pValue, pParam) {
  if (pValue == '')
    hidePopup();
  else
    window.alert(pValue);
}

function updatePortalItemAgenda(pFilter) {
  with (formByName('portalitem_agenda'))
    getDynPortalItem('agenda', 'filter=' + pFilter + '&filter2=' + getSelectSelValue(elements['filter2']));
}

function updatePortalItemCalendar() {
  with (formByName('portalitem_calendar'))
    getDynPortalItem('calendar', 'm=' + getSelectSelValue(elements['m']) + '&y=' + elements['y'].value);
}

function updatePortalItemNotes(pFilter) {
  with (formByName('portalitem_notes'))
    getDynPortalItem('notes', 'filter=' + pFilter + '&filter2=' + getSelectSelValue(elements['filter2']));
}

function updatePortalItemReminders(pFilter) {
  with (formByName('portalitem_reminders'))
    getDynPortalItem('reminders', 'filter=' + pFilter + '&filter2=' + getSelectSelValue(elements['filter2']));
}

function updatePortalItemTasks(pFilter) {
  with (formByName('portalitem_tasks'))
    getDynPortalItem('tasks', 'filter=' + pFilter + '&filter2=' + getSelectSelValue(elements['filter2']));
}

function viewPopupDashboard(pIndex) {
  viewPopup('plain.php?page=dashboard.pop', 'index=' + pIndex);
}

function viewPopupPersonalize() {
  viewPopup('plain.php?page=personalize.pop', '');
}

function viewPopupPwd() {
  viewPopup('plain.php?page=pwd.pop', '');
}