/*++
Copyright:      (c) 1997-1998 Jetico, Inc.
Module Name:	bc_alg.h
Abstract:       This file includes data declarations for common code 
                for all encryption algorithm drivers in Windows NT.
Author:         Sergey A. Frolov
Environment:    Kernel mode only.
Notes:
Revision History:
--*/

#ifndef __BC_ALG__
#define __BC_ALG__

//#define DBG 1

typedef struct  _BC_ALG_EXTENSION
  { PDEVICE_OBJECT  DeviceObject;
    UNICODE_STRING  deviceLinkUString;
  } BCALG_EXTENSION, *PBCALG_EXTENSION;


typedef struct _KEY_ELEMENT 
  { UCHAR *keyExtended;
	UCHAR *pool;
  } KEY_ELEMENT, *PKEY_ELEMENT;


#define DISPLAY_NAME_LENGTH 32
#define SERVICE_NAME_LENGTH 32

#define EYE_CATCH_STRING    "__BCALGDRV__"
#define EYE_CATCH_STRING_1  "__BCB_SIZE__"

typedef struct _BC_ALGID_BLOCK
  { char  eyeCatchString[16];
    DWORD algorithmID;
    DWORD keyLength;
    char  displayName[ DISPLAY_NAME_LENGTH ];
    char  serviceName[ SERVICE_NAME_LENGTH ];
    char  eyeCatchString_1[16];
    DWORD structSize;
    DWORD blockSize;
  } BC_ALGID_BLOCK, *PBC_ALGID_BLOCK;


#if DBG
#define BCDBUGCHECK            ((ULONG)0x80000000)
#define BCDDIAG1               ((ULONG)0x00000001)
#define BCDDIAG2               ((ULONG)0x00000002)
#define BCDERRORS              ((ULONG)0x00000004)

#define BCalgDump(LEVEL, STRING) \
        do { \
            if (BCDiskDebugLevel & LEVEL) { \
                DbgPrint STRING; \
            } \
            if (LEVEL == BCDBUGCHECK) { \
                ASSERT(FALSE); \
            } \
        } while (0)
#else
#define BCalgDump(LEVEL,STRING) do {NOTHING;} while (0)
#endif

int
sprintf(char *s, const char *format, ...);

//
// Device driver routine declarations.
//

NTSTATUS
DriverEntry(
    IN OUT PDRIVER_OBJECT   DriverObject,
    IN PUNICODE_STRING      RegistryPath
    );

NTSTATUS
BCalgInitializeDriver(
    IN PDRIVER_OBJECT       DriverObject
    );

NTSTATUS
BCalgCreateClose(
    IN PDEVICE_OBJECT       DeviceObject,
    IN PIRP                 Irp
    );

NTSTATUS
BCalgDeviceControl(
    IN PDEVICE_OBJECT       DeviceObject,
    IN PIRP                 Irp
    );

VOID
BCalgUnloadDriver(
    IN PDRIVER_OBJECT       DriverObject
    );

NTSTATUS
BCalgCreateKey(IN PCREATEKEY_BUFFER CkBuffer);

BOOL 
BC_ExtendKey( PUCHAR KeyFrom, PUCHAR KeyTo );


NTSTATUS 
BC_TestKey( KEY_HANDLE KeyHandle );

NTSTATUS 
BC_FreeKey( KEY_HANDLE KeyHandle );

NTSTATUS 
BC_Encrypt( KEY_HANDLE KeyHandle,
            PUCHAR     IVector,
            PUCHAR     InBuffer,
            PUCHAR     OutBuffer,
            DWORD      Length );       // in bytes

NTSTATUS 
BC_Decrypt( KEY_HANDLE KeyHandle,
            PUCHAR     IVector,
            PUCHAR     InBuffer,
            PUCHAR     OutBuffer,
            DWORD      Length );       // in bytes

#endif
