#ifndef __BC_IDEA
#define __BC_IDEA

#define SERVICE_NAME	"BC_IDEA"
#define DISPLAY_NAME    "IDEA"
#define ALGORITHM_ID     0x20

#define DRIVER_MAJOR_VERSION	0
#define DRIVER_MINOR_VERSION	1


#define IDEA_ROUNDS             8
#define IDEA_SUBKEYS_PER_ROUND  6
#define IDEA_FINAL_SUBKEYS      4

// Key lengths in bytes
#define IDEA_KEY_LENGTH_BYTES   16

// Expanded key length in 16-bit words
#define IDEA_EXPANDED_KEY_SIZE (IDEA_SUBKEYS_PER_ROUND*IDEA_ROUNDS + IDEA_FINAL_SUBKEYS)

// Key length in bites - required for external definitions of 
// BestCrypt Algorithm modules
#define KEY_LENGTH          (128)
// We need to reserve space both for encryption and decryption keys
#define KEY_LENGTH_EXTENDED (IDEA_EXPANDED_KEY_SIZE*2*16)


#define ALGORITHM_BLOCK_SIZE_BYTES 8


/* IdeaExtKey structure describes a place in memory for extended Idea key */
typedef struct IdeaExtKey_ {
    WORD encryptKeys[ IDEA_EXPANDED_KEY_SIZE ];
    WORD decryptKeys[ IDEA_EXPANDED_KEY_SIZE ];
} IdeaExtKey; //IdeaData; 


/******* Exported functions *********/

#define IN

BOOL
KeyExtend( PUCHAR KeySource,          // 8-bit  uchars
           PDWORD KeyDestination );   // 32-bit dwords

VOID
Encrypt( DWORD *IVector, 
         DWORD *KeyAdress,
         DWORD *SrcBuffer,
         DWORD *DstBuffer,
         DWORD Length );    // in bytes

VOID
Decrypt( DWORD *IVector, 
         DWORD *KeyAdress,
         DWORD *SrcBuffer,
         DWORD *DstBuffer,
         DWORD Length );    // in bytes

/* 
   Declare IDEA encryption in Electronic Code Book mode 
   for testing the IDEA implementation - not for using
   in the BestCrypt Encryption Algorithm Module
 */

BOOL 
IdeaECB( UCHAR      *InBlock, 
         UCHAR      *OutBlock,
         IdeaExtKey *ExtKey,
         BOOL       Encrypt);

#endif
