/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBTextDataBinder;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;

public class JdbEditorPane
extends JEditorPane
implements ColumnAware,
Serializable {
    protected DBTextDataBinder dataBinder;

    public JdbEditorPane() {
        this.commonInit();
    }

    public JdbEditorPane(URL initialPage) throws IOException {
        super(initialPage);
        this.commonInit();
    }

    public JdbEditorPane(String url) throws IOException {
        super(url);
        this.commonInit();
    }

    public JdbEditorPane(String type, String text) {
        super(type, text);
        this.commonInit();
    }

    protected void commonInit() {
        this.setEditable(false);
        this.setCaretColor(UIManager.getColor("TextPane.caretForeground"));
        this.dataBinder = new DBTextDataBinder(this);
    }

    public void setDataSet(DataSet dataSet) {
        this.dataBinder.setDataSet(dataSet);
    }

    public DataSet getDataSet() {
        return this.dataBinder.getDataSet();
    }

    public void setColumnName(String columnName) {
        this.dataBinder.setColumnName(columnName);
    }

    public String getColumnName() {
        return this.dataBinder.getColumnName();
    }

    public void setColumnNameURL(String columnName) {
        this.dataBinder.setColumnNameURL(columnName);
    }

    public String getColumnNameURL() {
        return this.dataBinder.getColumnNameURL();
    }

    public void setEnablePopupMenu(boolean popupEnabled) {
        this.dataBinder.setEnablePopupMenu(popupEnabled);
    }

    public boolean isEnablePopupMenu() {
        return this.dataBinder.isEnablePopupMenu();
    }

    public void setPostOnFocusLost(boolean postOnFocusLost) {
        this.dataBinder.setPostOnFocusLost(postOnFocusLost);
    }

    public boolean isPostOnFocusLost() {
        return this.dataBinder.isPostOnFocusLost();
    }

    public void setPostOnRowPosted(boolean postOnRowPosted) {
        this.dataBinder.setPostOnRowPosted(postOnRowPosted);
    }

    public boolean isPostOnRowPosted() {
        return this.dataBinder.isPostOnRowPosted();
    }

    public void setEnableClearAll(boolean enableClearAll) {
        this.dataBinder.setEnableClearAll(enableClearAll);
    }

    public boolean isEnableClearAll() {
        return this.dataBinder.isEnableClearAll();
    }

    public void setEnableUndoRedo(boolean enableUndoRedo) {
        this.dataBinder.setEnableUndoRedo(enableUndoRedo);
    }

    public boolean isEnableUndoRedo() {
        return this.dataBinder.isEnableUndoRedo();
    }

    public void setEnableFileLoading(boolean enableFileLoading) {
        this.dataBinder.setEnableFileLoading(enableFileLoading);
    }

    public boolean isEnableFileLoading() {
        return this.dataBinder.isEnableFileLoading();
    }

    public void setEnableFileSaving(boolean enableFileSaving) {
        this.dataBinder.setEnableFileSaving(enableFileSaving);
    }

    public boolean isEnableFileSaving() {
        return this.dataBinder.isEnableFileSaving();
    }

    public void setEnableColorChange(boolean enableColorChange) {
        this.dataBinder.setEnableColorChange(enableColorChange);
    }

    public boolean isEnableColorChange() {
        return this.dataBinder.isEnableColorChange();
    }

    public void setEnableFontChange(boolean enableFontChange) {
        this.dataBinder.setEnableFontChange(enableFontChange);
    }

    public boolean isEnableFontChange() {
        return this.dataBinder.isEnableFontChange();
    }

    public void setEnableURLLoading(boolean enableURLLoading) {
        this.dataBinder.setEnableURLLoading(enableURLLoading);
    }

    public boolean isEnableURLLoading() {
        return this.dataBinder.isEnableURLLoading();
    }

    public void setEnableURLAutoCache(boolean enableURLCache) {
        this.dataBinder.setEnableURLAutoCache(enableURLCache);
    }

    public boolean isEnableURLAutoCache() {
        return this.dataBinder.isEnableURLAutoCache();
    }

    public void setPageURL(String urlString) {
        try {
            if (urlString != null) {
                super.setPage(urlString);
            }
        }
        catch (Exception e2) {
            DBExceptionHandler.handleException(e2);
        }
    }

    public String getPageURL() {
        URL page = super.getPage();
        if (page != null) {
            return page.toString();
        }
        return null;
    }

    DBTextDataBinder getDataBinder() {
        return this.dataBinder;
    }
}

