/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBLabelDataBinder;
import com.borland.dbswing.DBUtilities;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSet;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;

public class JdbLabel
extends JLabel
implements ColumnAware,
Serializable {
    private String textWithMnemonic;
    protected DBLabelDataBinder dataBinder;
    private boolean iconEditable = false;

    public JdbLabel(String text, Icon icon, int horizontalAlignment) {
        super(DBUtilities.excludeMnemonicSymbol(text), icon, horizontalAlignment);
        if (DBUtilities.containsMnemonic(text)) {
            this.setTextWithMnemonic(text);
        }
        this.dataBinder = new DBLabelDataBinder(this);
    }

    public JdbLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public JdbLabel(String text) {
        this(text, null, 2);
    }

    public JdbLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public JdbLabel(Icon image) {
        this(null, image, 0);
    }

    public JdbLabel() {
        this("", null, 2);
    }

    public void setDataSet(DataSet dataSet) {
        this.dataBinder.setDataSet(dataSet);
    }

    public DataSet getDataSet() {
        return this.dataBinder.getDataSet();
    }

    public void setColumnName(String columnName) {
        this.dataBinder.setColumnName(columnName);
    }

    public String getColumnName() {
        return this.dataBinder.getColumnName();
    }

    public void setColumnNameIcon(String columnNameIcon) {
        this.dataBinder.setColumnNameIcon(columnNameIcon);
    }

    public String getColumnNameIcon() {
        return this.dataBinder.getColumnNameIcon();
    }

    public void setTextWithMnemonic(String text) {
        String oldText = this.textWithMnemonic;
        if (oldText != text) {
            this.textWithMnemonic = text;
            this.setText(DBUtilities.excludeMnemonicSymbol(text));
            this.setDisplayedMnemonic(DBUtilities.extractMnemonicChar(text));
            this.firePropertyChange("textWithMnemonic", oldText, text);
        }
    }

    public String getTextWithMnemonic() {
        return this.textWithMnemonic;
    }

    public void setIconEditable(boolean iconEditable) {
        this.dataBinder.setIconEditable(iconEditable);
    }

    public boolean isIconEditable() {
        return this.dataBinder.isIconEditable();
    }

    DBLabelDataBinder getDataBinder() {
        return this.dataBinder;
    }
}

