/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dbswing.JdbNavToolBar;
import com.borland.dbswing.Res;
import com.borland.dbswing.StatusLabelEvent;
import com.borland.dbswing.StatusLabelListener;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.jb.util.EventMulticaster;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JdbStatusLabel
extends JLabel
implements NavigationListener,
StatusListener,
AccessListener,
FocusListener,
DataChangeListener,
ChangeListener,
Serializable {
    private Component[] dataAwareComponents;
    private Component[] userSetDataAwareComponents;
    private DataSet dataSet;
    private boolean autoDetect = true;
    private DataSet currentDataSet = null;
    private String currentMessage = " ";
    private boolean displayMessages = true;
    private transient EventMulticaster statusListeners;
    private boolean registeredWithRuntime = false;
    private boolean dataSetEventsEnabled = true;

    public JdbStatusLabel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setOpaque(true);
    }

    public void addNotify() {
        super.addNotify();
        if (this.autoDetect) {
            this.registerWithDataAwareComponents(DBRuntimeSupport.getInstance().getComponents());
            if (!this.registeredWithRuntime) {
                this.registeredWithRuntime = true;
                DBRuntimeSupport.getInstance().addChangeListener(this);
            }
        }
        if (this.getText().equals("")) {
            this.updateCurrentMessage(0);
        }
    }

    public void setAutoDetect(boolean autoDetect) {
        boolean oldAutoDetect = this.autoDetect;
        if (autoDetect) {
            this.registerWithDataAwareComponents(DBRuntimeSupport.getInstance().getComponents());
            if (!this.registeredWithRuntime) {
                this.registeredWithRuntime = true;
                DBRuntimeSupport.getInstance().addChangeListener(this);
            }
        } else {
            this.registerWithDataAwareComponents(this.userSetDataAwareComponents);
            if (this.registeredWithRuntime) {
                DBRuntimeSupport.getInstance().removeChangeListener(this);
                this.registeredWithRuntime = false;
            }
        }
        this.firePropertyChange("autoDetect", oldAutoDetect, autoDetect);
    }

    public boolean isAutoDetect() {
        return this.autoDetect;
    }

    public void setDataSetAwareComponents(Component[] dataAwareComponents) {
        this.userSetDataAwareComponents = dataAwareComponents;
        this.autoDetect = dataAwareComponents == null;
        this.registerWithDataAwareComponents(this.userSetDataAwareComponents);
    }

    public Component[] getDataSetAwareComponents() {
        return this.userSetDataAwareComponents;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        boolean bl = this.autoDetect = dataSet == null;
        if (this.dataAwareComponents != null) {
            this.registerWithDataAwareComponents(null);
        }
        this.updateCurrentDataSet(dataSet);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setFocusedDataSet(DataSet dataSet) {
        this.updateCurrentDataSet(dataSet);
    }

    public DataSet getFocusedDataSet() {
        return this.currentDataSet;
    }

    public void setDisplayMessages(boolean displayMessages) {
        this.displayMessages = displayMessages;
    }

    public boolean isDisplayMessages() {
        return this.displayMessages;
    }

    public final void addStatusLabelListener(StatusLabelListener listener) {
        this.statusListeners = EventMulticaster.add(this.statusListeners, listener);
    }

    public final void removeStatusLabelListener(StatusLabelListener listener) {
        this.statusListeners = EventMulticaster.remove(this.statusListeners, listener);
    }

    private void registerWithDataAwareComponents(Component[] dataAwareComponents) {
        int index;
        Component[] oldDataAwareComponents = this.dataAwareComponents;
        if (this.dataAwareComponents != null) {
            for (index = 0; index < this.dataAwareComponents.length; ++index) {
                this.dataAwareComponents[index].removeFocusListener(this);
            }
        }
        this.dataAwareComponents = dataAwareComponents;
        if (dataAwareComponents != null) {
            for (index = 0; index < dataAwareComponents.length; ++index) {
                if (dataAwareComponents[index] instanceof JdbNavToolBar) continue;
                dataAwareComponents[index].addFocusListener(this);
                if (this.currentDataSet != null) continue;
                this.updateCurrentDataSet(DBRuntimeSupport.getInstance().getDataSet(dataAwareComponents[index]));
            }
        }
        this.firePropertyChange("dataSetAwareComponents", oldDataAwareComponents, dataAwareComponents);
    }

    public void stateChanged(ChangeEvent e2) {
        if (this.autoDetect && e2.getSource() == DBRuntimeSupport.getInstance()) {
            this.updateCurrentDataSet(null);
            this.registerWithDataAwareComponents(DBRuntimeSupport.getInstance().getComponents());
        }
    }

    public void focusLost(FocusEvent e2) {
    }

    public void focusGained(FocusEvent e2) {
        if (DBRuntimeSupport.getInstance().containsComponent(e2.getComponent())) {
            this.updateCurrentDataSet(DBRuntimeSupport.getInstance().getDataSet(e2.getComponent()));
        } else {
            Component subComponent = e2.getComponent();
            while (!(subComponent instanceof DataSetAware)) {
                subComponent = subComponent.getParent();
            }
            DataSetAware component = (DataSetAware)((Object)subComponent);
            if (component instanceof DataSetAware) {
                DataSet dataSet = component.getDataSet();
                this.updateCurrentDataSet(dataSet);
            }
        }
    }

    void updateCurrentDataSet(DataSet dataSet) {
        if (dataSet != this.currentDataSet) {
            if (this.currentDataSet != null) {
                this.currentDataSet.removeStatusListener(this);
                this.currentDataSet.removeAccessListener(this);
                this.currentDataSet.removeNavigationListener(this);
                this.currentDataSet.removeDataChangeListener(this);
            }
            if (dataSet != null) {
                dataSet.addStatusListener(this);
                dataSet.addAccessListener(this);
                dataSet.addNavigationListener(this);
                dataSet.addDataChangeListener(this);
            }
            this.currentDataSet = dataSet;
            this.updateCurrentMessage(5);
        }
    }

    public void statusMessage(StatusEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        if (this.displayMessages) {
            int code = 1;
            Serializable message = event;
            if (event.getCode() == 9) {
                code = 2;
                message = event.getException();
            }
            if (this.fireStatusLabelEvent(code, message)) {
                this.setText(event.getMessage());
            }
        }
    }

    boolean fireStatusLabelEvent(int code, Object message) {
        boolean messageAccepted = true;
        if (this.statusListeners != null) {
            messageAccepted = this.statusListeners.vetoableDispatch(new StatusLabelEvent(this, code, message));
        }
        return messageAccepted;
    }

    public void dataChanged(DataChangeEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        if (event.getID() == 3 && this.displayMessages && this.fireStatusLabelEvent(7, " ")) {
            this.setText(" ");
        }
    }

    public void postRow(DataChangeEvent event) {
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            this.updateCurrentMessage(3);
        } else {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            if (this.displayMessages && this.fireStatusLabelEvent(4, " ")) {
                this.setText(" ");
            }
        }
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateCurrentMessage(6);
    }

    private void updateCurrentMessage(int statusLabelEvent) {
        block6: {
            if (this.currentDataSet != null && this.currentDataSet.isOpen()) {
                try {
                    if (this.currentDataSet.getRowCount() > 0) {
                        this.currentMessage = Res.bundle.format(4, Integer.toString(this.currentDataSet.getRow() + 1), Integer.toString(this.currentDataSet.getRowCount()));
                        break block6;
                    }
                    this.currentMessage = " ";
                }
                catch (Exception e2) {
                    DBExceptionHandler.handleException(this.currentDataSet, e2);
                }
            } else {
                this.currentMessage = " ";
            }
        }
        if (this.displayMessages && this.fireStatusLabelEvent(statusLabelEvent, this.currentMessage)) {
            this.setText(this.currentMessage);
        }
    }
}

