/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.TableRowNoRenderer;
import com.borland.dbswing.plaf.basic.BasicJdbTableRowHeaderUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableRowHeader
extends JComponent
implements TableModelListener,
PropertyChangeListener,
Serializable {
    public static final int PAINT = 0;
    public static final int PREF_SIZE = 1;
    public static final int MIN_SIZE = 2;
    public static final int MAX_SIZE = 3;
    private static final String uiClassID = "TableRowHeaderUI";
    boolean heightResizable = true;
    boolean resizeTableWhileSizing = true;
    TableCellRenderer renderer;
    JTable table;
    TableModel model;

    public TableRowHeader() {
        this(null);
    }

    public TableRowHeader(JTable table) {
        this(table, null);
    }

    public TableRowHeader(JTable table, TableCellRenderer renderer) {
        this.setTable(table);
        this.setCellRenderer(renderer);
        this.updateUI();
    }

    public void updateUI() {
        this.setUI(BasicJdbTableRowHeaderUI.createUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    public void setTable(JTable table) {
        if (this.table != null) {
            this.table.removePropertyChangeListener(this);
        }
        this.table = table;
        if (table != null) {
            table.addPropertyChangeListener(this);
            this.setModel(table.getModel());
        } else {
            this.setModel(null);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public void setModel(TableModel model) {
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        this.model = model;
        if (model != null) {
            model.addTableModelListener(this);
        }
    }

    public TableModel getModel() {
        if (this.model == null) {
            this.model = new DefaultTableModel();
        }
        return this.model;
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        this.renderer = renderer;
    }

    public TableCellRenderer getCellRenderer() {
        if (this.renderer == null) {
            this.renderer = new TableRowNoRenderer();
        }
        return this.renderer;
    }

    public void setHeightResizable(boolean heightResizable) {
        this.heightResizable = heightResizable;
    }

    public boolean isHeightResizable() {
        return this.heightResizable;
    }

    public void setResizeTableWhileSizing(boolean resizeTableWhileSizing) {
        this.resizeTableWhileSizing = resizeTableWhileSizing;
    }

    public boolean isResizeTableWhileSizing() {
        return this.resizeTableWhileSizing;
    }

    public void repaintRows(int firstRow, int lastRow) {
        ((BasicJdbTableRowHeaderUI)this.ui).repaintRows(firstRow, lastRow);
    }

    public void propertyChange(PropertyChangeEvent e2) {
        Object model;
        if (e2.getPropertyName().equals("model") && (model = e2.getNewValue()) != null && model instanceof TableModel) {
            this.setModel((TableModel)model);
        }
    }

    public void tableChanged(TableModelEvent e2) {
        int firstRow = this.getModel().getRowCount() - 1;
        if (firstRow < 0) {
            firstRow = 0;
        }
        int lastRow = firstRow + (e2.getLastRow() - e2.getFirstRow() + 1);
        if (e2.getType() == 1) {
            this.repaintRows(firstRow, lastRow);
        } else if (e2.getType() == -1) {
            this.repaintRows(firstRow, lastRow);
        }
    }
}

