/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class PlasticToggleButtonUI
extends MetalToggleButtonUI {
    public static final PlasticToggleButtonUI am = new PlasticToggleButtonUI();
    public boolean ak;
    public PropertyChangeListener aj;

    public static ComponentUI createUI(JComponent jComponent) {
        return am;
    }

    public final void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        jb.rz(abstractButton, this.getPropertyPrefix());
        this.ak = Boolean.TRUE.equals(UIManager.get("ToggleButton.borderPaintsFocus"));
    }

    public final void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        if (this.aj == null) {
            this.aj = new i9(this.getPropertyPrefix());
        }
        abstractButton.addPropertyChangeListener("jgoodies.isNarrow", this.aj);
    }

    public final void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        abstractButton.removePropertyChangeListener(this.aj);
    }

    public final void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.isOpaque()) {
            if (this.qs(abstractButton)) {
                jComponent.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (this.qg(abstractButton)) {
                    Rectangle rectangle = new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 1);
                    ic.qd(graphics, rectangle);
                }
            }
        }
        this.paint(graphics, jComponent);
    }

    public final void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (!this.ak) {
            int n2 = abstractButton.getWidth() - 1 - 4;
            int n3 = abstractButton.getHeight() - 1 - 4;
            graphics.setColor(this.getFocusColor());
            graphics.drawRect(2, 2, n2 - 1, n3 - 1);
        }
    }

    public final void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = abstractButton.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        graphics.setColor(abstractButton.getBackground());
        if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (abstractButton.getIcon() != null) {
            ((BasicToggleButtonUI)this).paintIcon(graphics, abstractButton, rectangle2);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, jComponent, rectangle3, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle3, rectangle2);
        }
    }

    public final boolean qs(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    public final boolean qg(AbstractButton abstractButton) {
        if (ic.qf(abstractButton)) {
            return true;
        }
        if (ic.qe(abstractButton)) {
            return false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        return ic.qg("ToggleButton.") && abstractButton.isBorderPainted() && buttonModel.isEnabled() && !buttonModel.isPressed() && !(abstractButton.getBorder() instanceof EmptyBorder);
    }
}

