/*
 * Decompiled with CFR 0.152.
 */
package com.kplab.webeasy;

import com.kplab.webeasy.ItemBean;
import com.kplab.webeasy.MemberBean;
import com.kplab.webeasy.OrderInfo;
import com.kplab.webeasy.OrderItem;
import com.kplab.webeasy.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OrderServlet
extends HttpServlet {
    String cart_page;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.cart_page = Util.getCartPage();
    }

    public void destroy() {
        super.destroy();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("Action");
        String string2 = "";
        if (string != null) {
            if (string.equals("ADD")) {
                this.addOrder(httpServletRequest);
                string2 = "ADDED";
            } else if (string.equals("UPDATE")) {
                this.updateOrder(httpServletRequest);
                string2 = "ADDED";
            } else if (string.equals("CONFIRM")) {
                int n = this.confirmOrder(httpServletRequest);
                string2 = n == -1 ? "FAILED" : "CONFIRMED";
            }
        }
        String string3 = "Status=" + string2;
        if (string2.equals("CONFIRMED")) {
            Util.gotoSecurePage(this.cart_page, string3, httpServletRequest, httpServletResponse);
            return;
        }
        Util.gotoPage(this.cart_page, string3, httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    private void addOrder(HttpServletRequest httpServletRequest) {
        OrderItem orderItem;
        HttpSession httpSession = httpServletRequest.getSession(true);
        Vector<OrderItem> vector = (Vector<OrderItem>)httpSession.getValue("Order");
        if (vector == null) {
            vector = new Vector<OrderItem>();
        }
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("ItemID"));
            n2 = Integer.parseInt(httpServletRequest.getParameter("Qty"));
        }
        catch (Exception exception) {
            bl = false;
        }
        if (n2 < 1) {
            bl = false;
        }
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            orderItem = (OrderItem)vector.elementAt(n4);
            int n5 = orderItem.getItemID();
            if (n == n5) {
                bl = false;
            }
            ++n4;
        }
        if (bl) {
            orderItem = new OrderItem(n, n2);
            vector.addElement(orderItem);
            httpSession.removeValue("Order");
            httpSession.putValue("Order", vector);
        }
    }

    private void updateOrder(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        Vector vector = (Vector)httpSession.getValue("Order");
        if (vector == null) {
            vector = new Vector();
        }
        Vector<OrderItem> vector2 = new Vector<OrderItem>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            boolean bl = true;
            try {
                n3 = Integer.parseInt(httpServletRequest.getParameter("Qty" + Integer.toString(n2)));
            }
            catch (Exception exception) {
                bl = false;
            }
            if (n3 < 1) {
                bl = false;
            }
            if (bl) {
                OrderItem orderItem = (OrderItem)vector.elementAt(n2);
                int n4 = orderItem.getItemID();
                OrderItem orderItem2 = new OrderItem(n4, n3);
                vector2.addElement(orderItem2);
            }
            ++n2;
        }
        httpSession.removeValue("Order");
        if (vector2.size() > 0) {
            httpSession.putValue("Order", vector2);
        }
    }

    private synchronized int confirmOrder(HttpServletRequest httpServletRequest) {
        if (!this.validate(httpServletRequest)) {
            return -1;
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        Vector vector = (Vector)httpSession.getValue("Order");
        if (vector == null) {
            return -1;
        }
        int n = vector.size();
        if (n < 1) {
            return -1;
        }
        OrderInfo orderInfo = new OrderInfo();
        Vector<OrderItem> vector2 = new Vector<OrderItem>();
        int n2 = 1;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string;
                connection = Util.getConnection();
                if (Util.getRollBackSupport()) {
                    connection.setAutoCommit(false);
                }
                if ((resultSet = (preparedStatement = connection.prepareStatement(string = new String("SELECT (MAX(ORDER_ID) + 1) as MAX_ORDERID FROM ORDER_INFO"))).executeQuery()).next() && (n2 = resultSet.getInt("MAX_ORDERID")) == 0) {
                    n2 = 1;
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                String string2 = (String)httpSession.getValue("UserID");
                MemberBean memberBean = new MemberBean();
                MemberBean.Member member = memberBean.getMember(string2);
                int n3 = member.getLanguage();
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                String string3 = member.getLastName();
                String string4 = member.getFirstName();
                String string5 = httpServletRequest.getParameter("PaymentMethod");
                String string6 = httpServletRequest.getParameter("CardHolderName");
                String string7 = httpServletRequest.getParameter("CardNumber");
                int n4 = Integer.parseInt(httpServletRequest.getParameter("ExpiryMonth"));
                int n5 = Integer.parseInt(httpServletRequest.getParameter("ExpiryYear"));
                String string8 = httpServletRequest.getParameter("LastName");
                String string9 = httpServletRequest.getParameter("FirstName");
                String string10 = httpServletRequest.getParameter("Phone");
                String string11 = httpServletRequest.getParameter("Address");
                String string12 = new String("INSERT INTO ORDER_INFO (ORDER_ID, LANGUAGE, ORDER_TIME, CUSTOMER_ID, CUSTOMER_LAST_NAME, CUSTOMER_FIRST_NAME, PAYMENT_METHOD, CARDHOLDER_NAME, CARD_NUMBER, EXPIRY_MONTH, EXPIRY_YEAR, RECIPIENT_LAST_NAME, RECIPIENT_FIRST_NAME, RECIPIENT_PHONE, RECIPIENT_ADDRESS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                preparedStatement = connection.prepareStatement(string12);
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n3);
                preparedStatement.setTimestamp(3, timestamp);
                preparedStatement.setString(4, string2);
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, string4);
                preparedStatement.setString(7, string5);
                preparedStatement.setString(8, string6);
                preparedStatement.setString(9, string7);
                preparedStatement.setInt(10, n4);
                preparedStatement.setInt(11, n5);
                preparedStatement.setString(12, string8);
                preparedStatement.setString(13, string9);
                preparedStatement.setString(14, string10);
                preparedStatement.setString(15, string11);
                preparedStatement.executeUpdate();
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                orderInfo = new OrderInfo(n2, n3, timestamp, string2, string3, string4, string5, string6, string7, n4, n5, string8, string9, string10, string11, -1.0);
                int n6 = 0;
                while (n6 < n) {
                    OrderItem orderItem = (OrderItem)vector.elementAt(n6);
                    int n7 = orderItem.getItemID();
                    int n8 = orderItem.getQty();
                    ItemBean itemBean = new ItemBean();
                    ItemBean.Item item = itemBean.getItem(n7, n3);
                    String string13 = item.getItemName();
                    double d = item.getItemPrice();
                    String string14 = new String("INSERT INTO ORDER_ITEM (ORDER_ID, ITEM_ID, ITEM_NAME, QTY, ITEM_PRICE) VALUES (?, ?, ?, ?, ?)");
                    preparedStatement = connection.prepareStatement(string14);
                    preparedStatement.setInt(1, n2);
                    preparedStatement.setInt(2, n7);
                    preparedStatement.setString(3, string13);
                    preparedStatement.setInt(4, n8);
                    preparedStatement.setDouble(5, d);
                    preparedStatement.executeUpdate();
                    OrderItem orderItem2 = new OrderItem(n2, n7, string13, n8, d);
                    vector2.addElement(orderItem2);
                    ++n6;
                }
                connection.commit();
            }
            catch (Exception exception) {
                Util.log("OrderServlet.confirmOrder(): JDBC insert error. " + exception.toString());
                if (Util.getRollBackSupport()) {
                    try {
                        connection.rollback();
                    }
                    catch (Exception exception2) {}
                }
                n2 = -1;
            }
            Object var12_40 = null;
        }
        catch (Throwable throwable) {
            Object var12_41 = null;
            try {
                if (connection != null) {
                    connection.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (connection != null) {
                connection.setAutoCommit(true);
            }
        }
        catch (Exception exception) {}
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {}
        if (n2 == -1) {
            return -1;
        }
        httpSession.removeValue("ConfirmedInfo");
        httpSession.putValue("ConfirmedInfo", (Object)orderInfo);
        httpSession.removeValue("ConfirmedDetail");
        httpSession.putValue("ConfirmedDetail", vector2);
        httpSession.removeValue("Order");
        return n2;
    }

    private boolean validate(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("PaymentMethod");
        String string2 = httpServletRequest.getParameter("CardHolderName");
        String string3 = httpServletRequest.getParameter("CardNumber");
        String string4 = httpServletRequest.getParameter("LastName");
        String string5 = httpServletRequest.getParameter("FirstName");
        String string6 = httpServletRequest.getParameter("Phone");
        String string7 = httpServletRequest.getParameter("Address");
        if (Util.isMissing(string) || Util.isMissing(string2) || Util.isMissing(string3) || Util.isMissing(string4) || Util.isMissing(string5) || Util.isMissing(string6) || Util.isMissing(string7)) {
            return false;
        }
        try {
            Integer.parseInt(httpServletRequest.getParameter("ExpiryMonth"));
            Integer.parseInt(httpServletRequest.getParameter("ExpiryYear"));
        }
        catch (Exception exception) {
            Util.log("OrderServlet.validate(): ExpiryMonth or ExpiryYear is not integer.");
            return false;
        }
        return true;
    }
}

