<%
    /*****************************************************************/
    /*****  Discussion Forum Show Message Page given Thread ID.  *****/
    /*****************************************************************/
%>

<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int thread_id=0, show_message=0;

    try {
      thread_id    = Integer.parseInt(request.getParameter("ThreadID"));
      show_message = Integer.parseInt(request.getParameter("MessageID"));
    }
    catch (Exception e) {
      %>Sorry, the page you selected does not exist.<%
      return;
    }

    MessageBean.refreshMessageList(thread_id, MessageBean.MESSAGE_MODE);
    int num_of_message = MessageBean.getMessageListSize();
%>


<table border="0" width="100%" cellspacing="5" cellpadding="0">

<%
    /****************************************************/
    /******* Show messages in the selected thread *******/
    /****************************************************/

    for (int i=0; i<num_of_message; i++)
    {
      String subject="", title="";

      Message  msg = MessageBean.getMessageAt(i);
      if (i == 0)  subject = msg.getSubject();
      int      msg_id      = msg.getMessageID();
      String   message_id  = Integer.toString(msg_id);
      String   user_id     = msg.getUserID();
      String   date        = msg.getCreateDate();
      int      level       = msg.getLevel();
      String   span_column = Integer.toString(MAX_LEVEL - level);
      Member   user        = MemberBean.getMember(user_id);
      String   firstname   = user.getFirstName();
      if (i == 0)  title   = new String(subject + " (by " + firstname + " on " + date + ")");
      else         title   = new String(firstname + " on " + date);
      String   hyperlink   = new String("Forum.jsp?Parm=SHOW&ThreadID=" +
                                        thread_id + "&MessageID=" + message_id);
      String   replylink   = new String("Forum.jsp?Parm=REPLY&MessageID=" + message_id);
%>
      <tr>
<%
        for (int j=0; j<level; j++) { %><td>&nbsp;</td><% }
%>
        <td align="left" valign="top" width="2%"><img src="../images/bullet.gif"></td>
<%

        /****************************************************************/
        /******* Show content and reply link of selected message. *******/
        /****************************************************************/

        if (msg_id == show_message)
        {
          String content = Util.encodeHTML(Util.addBR(MessageBean.getMessageContent(msg_id)));
%>
          <td align="left" valign="top" colspan=
              "<%= span_column %>" width="2000"><strong><%= title %></strong></td>
      </tr>
      <tr>
<%
          for (int j=0; j<=level; j++) { %><td>&nbsp;</td><% }
%>
          <td align="left" valign="top" colspan="<%= span_column %>" width="2000"><%= content %></td>
      </tr>
      <tr>
<%
          for (int j=0; j<=level; j++) { %><td>&nbsp;</td><% }
%>
          <td align="left" valign="top" colspan="<%= span_column %>" width="2000"><a href=
              "<%= replylink %>">Reply this message</a></td>
<%
        } else {
%>
          <td align="left" valign="top" colspan="<%= span_column %>" width="2000"><a href=
              "<%= hyperlink %>"><%= title %></a></td>
<%
        }
%>
      </tr>
<%
    }
%>

</table>
