package com.softviewtech.jbillboard;

import java.awt.*;
import javax.swing.*;
import com.borland.jbcl.layout.*;
import java.awt.event.*;
import java.io.*;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 */

public class DlgImageProp extends JDialog {

    JPanel panel1 = new JPanel();
    XYLayout xYLayout1 = new XYLayout();
    JTextField txtURL = new JTextField();
    JTextField txtSound = new JTextField();

    String[] pauseOption={"1", "2", "3", "4", "5", "6", "7",
                            "8", "9", "10"};
    String[] dotSizeOption={"1", "2", "3"};
    JComboBox cmbPause = new JComboBox(pauseOption);
    String[] TransitionOption={"Cut in", "Fade", "Fade thro' black/white",
            "Sand & pepper", "Sweep", "Slip in", "Flip",
            "Random lines", "Puzzle"};
    String[] directionOption8={"Up","Down","Left","Right","Up-left","Up-right",
                                "Down-left", "Down-right"};
    String[] directionOption4={"Up","Down","Left","Right"};
    String[] directionOption2H={"Left","Right"};
    String[] directionOption2V={"Up","Down"};
    String[] directionOption2={"Horizontal","Vertical"};
    String[] directionOption3={"Horizontal","Vertical","Horizontal & Vertical"};

    JComboBox cmbTransition = new JComboBox(TransitionOption);
    String[] paramOption;
    String[] directionOption;
    JComboBox cmbParam = new JComboBox();
    JButton btnOK = new JButton("OK");
    JButton btnCancel = new JButton("Cancel");
    JButton btnHelp = new JButton("Help");
    JLabel lblPause = new JLabel();
    JLabel lblTransition = new JLabel();
    JLabel lblParam = new JLabel("");
    JLabel lblURL = new JLabel();
    JLabel lblSound = new JLabel();
    JButton btnURL = new JButton();
    JButton btnSound = new JButton();

    String filename;
    private Image image=null;
    private String imagePath=null;
    private String audioPath=null;

    private Object[] selectedValues=new Object[10];
    JFileChooser fileChooser = new JFileChooser(".");

    HTMLFilter htmlFilter=new HTMLFilter();
    AudioFilter audioFilter=new AudioFilter();
    JLabel lblFileName = new JLabel();
    JPanel pnlThumbnail = new PnlThumbnail();
    JComboBox cmbDirection = new JComboBox();
    JLabel lblDirection = new JLabel("Direction");

    static private String strwStrap=null;
    private boolean txtAuFocusGained=false;

    public DlgImageProp(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            jbInit();
            pack();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    public DlgImageProp() {
        this(null, "", false);
    }

    void jbInit() throws Exception {
        panel1.setLayout(xYLayout1);
        panel1.setPreferredSize(new Dimension(400, 475));
        btnOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnOK_actionPerformed(e);
            }
        });
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCancel_actionPerformed(e);
            }
        });
        btnHelp.setVisible(false);
        btnHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnHelp_actionPerformed(e);
            }
        });
        lblPause.setText("Pause (sec)");
        lblTransition.setText("Transitions");
        lblURL.setText("URL");
        lblSound.setText("Sound");
        btnURL.setText("...");
        btnURL.setVisible(false);
        btnURL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnURL_actionPerformed(e);
            }
        });
        btnSound.setToolTipText("");
        btnSound.setText("...");
        btnSound.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnSound_actionPerformed(e);
            }
        });
        cmbParam.setVisible(false);
        cmbTransition.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cmbTransition_actionPerformed(e);
            }
        });
        lblFileName.setText("Image File: ");
        txtSound.setEditable(false);
        txtSound.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(FocusEvent e) {
                txtSound_focusGained(e);
            }
            public void focusLost(FocusEvent e) {
                txtSound_focusLost(e);
            }
        });
        this.getContentPane().add(panel1, BorderLayout.CENTER);

        panel1.add(cmbParam, new XYConstraints(120, 245, 150, -1));
        panel1.add(cmbTransition, new XYConstraints(120, 215, 170, -1));
        panel1.add(lblTransition, new XYConstraints(43, 217, -1, -1));
        panel1.add(lblParam, new XYConstraints(18, 252, -1, -1));
        panel1.add(cmbPause, new XYConstraints(120, 165, 89, -1));
        panel1.add(lblPause, new XYConstraints(34, 167, 71, -1));
        panel1.add(pnlThumbnail, new XYConstraints(120, 17, 157, 99));
        panel1.add(lblFileName, new XYConstraints(41, 123, -1, -1));
        panel1.add(btnHelp, new XYConstraints(311, 435, 62, 25));
        panel1.add(btnOK, new XYConstraints(134, 435, 75, 25));
        panel1.add(btnCancel, new XYConstraints(222, 435, 75, 25));
        cmbDirection.setVisible(false);
        panel1.add(cmbDirection, new XYConstraints(120, 275, 150, -1));
        panel1.add(txtURL, new XYConstraints(120, 325, 218, -1));
        panel1.add(btnURL, new XYConstraints(344, 324, 29, 22));
        panel1.add(lblURL, new XYConstraints(80, 327, -1, -1));
        panel1.add(lblSound, new XYConstraints(69, 377, -1, -1));
        panel1.add(txtSound, new XYConstraints(120, 375, 218, -1));
        panel1.add(btnSound, new XYConstraints(344, 374, 29, 22));
        lblDirection.setVisible(false);
        panel1.add(lblDirection, new XYConstraints(49, 277, -1, -1));

        fileChooser.setDialogTitle("Choosing the path");
    }

    void btnOK_actionPerformed(ActionEvent e) {
        selectedValues[0]=filename;
        selectedValues[1]=(String)cmbPause.getSelectedItem();
        selectedValues[2]=(String)cmbTransition.getSelectedItem();
        selectedValues[3]=(String)cmbParam.getSelectedItem();
        selectedValues[4]=(String)cmbDirection.getSelectedItem();
        selectedValues[5]=txtURL.getText();

        selectedValues[7]=image;
        selectedValues[8]=imagePath;
        selectedValues[9]=txtSound.getText();

        // special process for transition of flip
        if(cmbTransition.getSelectedItem()!=null &&
                ((String)cmbTransition.getSelectedItem()).equals("Flip"))
            strwStrap=(String)cmbParam.getSelectedItem();

        setVisible(false);
        dispose();
    }

    void btnCancel_actionPerformed(ActionEvent e) {

        setVisible(false);
        dispose();
    }

    public Object[] getSelectedValues() {
        return selectedValues;
    }

    public void setInitValues(Object[] values) {
        filename=(String)values[0];
        lblFileName.setText("Image File:   "+filename);
        if(values[1]==null)
            cmbPause.setSelectedItem("2");  // default value for pause
        else
            cmbPause.setSelectedItem((String)values[1]);
        cmbTransition.setSelectedItem((String)values[2]);
        cmbParam.setSelectedItem((String)values[3]);
        cmbDirection.setSelectedItem((String)values[4]);
        txtURL.setText((String)values[5]);
        // audio path is only used in ImageJTable
        image=(Image)values[7];
        imagePath=(String)values[8];
        txtSound.setText((String)values[9]);

        // the following values are used for Option_Cancel
        selectedValues[0]=filename;
        selectedValues[1]=(String)cmbPause.getSelectedItem();
        selectedValues[2]=(String)cmbTransition.getSelectedItem();
        selectedValues[3]=(String)cmbParam.getSelectedItem();
        selectedValues[4]=(String)cmbDirection.getSelectedItem();
        selectedValues[5]=txtURL.getText();
        // audio path is only used in ImageJTable
        selectedValues[7]=image;
        selectedValues[8]=imagePath;
        selectedValues[9]=txtSound.getText();
    }

    public void setImage(Image image) {
        this.image=image;
    }

    private void refreshCmbParamDir() {
        // refresh cmbParam
        if(paramOption==null) {
            lblParam.setText("");
            cmbParam.setVisible(false);
            cmbParam.setSelectedIndex(-1);
        }
        else {
            cmbParam.removeAllItems();
            for(int i=0; i<paramOption.length; i++) {
                cmbParam.addItem(paramOption[i]);
            }
            cmbParam.setVisible(true);

            // special process for transition of flip
            if(((String)cmbTransition.getSelectedItem()).equals("Flip"))
                if(strwStrap!=null)
                    cmbParam.setSelectedItem(strwStrap);
        }
        // refresh cmbDirection
        if(directionOption==null) {
            lblDirection.setVisible(false);
            cmbDirection.setVisible(false);
            cmbDirection.setSelectedIndex(-1);
        }
        else {
            lblDirection.setVisible(true);
            cmbDirection.removeAllItems();
            for(int i=0; i<directionOption.length; i++) {
                cmbDirection.addItem(directionOption[i]);
            }
            cmbDirection.setVisible(true);
        }
    }

    void cmbTransition_actionPerformed(ActionEvent e) {
// options: "Cut in", "Fade", "Fade thro' black/white",
//            "Sand & pepper", "Sweep", "Slip in", "Flip",
//            "Random lines", "Puzzle"};
        switch(cmbTransition.getSelectedIndex()) {
        case 0: // Cut in
            paramOption=null;
            directionOption=null;
            break;
        case 1: // Fade
            paramOption=null;
            directionOption=null;
            break;
        case 2: // Fade thro' white/black
            lblParam.setText("             Through");
            paramOption=new String[2];
            paramOption[0]="white";
            paramOption[1]="black";
            directionOption=null;
            break;
        case 3: // Sand & pepper
            lblParam.setText("            Dot size");
            paramOption=new String[30];
            for(int i=0; i<30; i++) {
                paramOption[i]=(""+(i+1));
            }
            directionOption=null;
            break;
        case 4: // Sweep
            paramOption=dotSizeOption;
            directionOption=directionOption2;
            lblParam.setText("            Dot size");
            break;
        case 5: // Slip in
            paramOption=null;
            directionOption=directionOption4;
            break;
        case 6: // Flip
            lblParam.setText("         strap width");
            paramOption=new String[11];
            for(int i=0; i<=10; i++) {
                paramOption[i]=(""+(i+10));
            }
            directionOption=null;
            break;
        case 7: // Random lines
            lblParam.setText("           Line width");
            paramOption=dotSizeOption;
            directionOption=directionOption3;
            break;
        case 8: // Puzzle
            paramOption=null;
            directionOption=null;
            break;
        }
        refreshCmbParamDir();
    }

    void btnURL_actionPerformed(ActionEvent e) {
        fileChooser.setFileFilter(htmlFilter);

        int option=fileChooser.showOpenDialog(this);
        if(option==fileChooser.CANCEL_OPTION)
            return;
        if(option==fileChooser.APPROVE_OPTION) {
            File f=fileChooser.getSelectedFile();
            txtURL.setText(f.getPath());
        }
    }

    private void chooseAudioFile() {
        fileChooser.setFileFilter(audioFilter);

        int option=fileChooser.showOpenDialog(this);
        if(option==fileChooser.CANCEL_OPTION)
            return;
        if(option==fileChooser.APPROVE_OPTION) {
            File f=fileChooser.getSelectedFile();
            txtSound.setText(f.getPath());
        }
    }

    void btnSound_actionPerformed(ActionEvent e) {
        chooseAudioFile();
    }

    void txtSound_focusGained(FocusEvent e) {
        if(!txtAuFocusGained) {
            chooseAudioFile();
            txtAuFocusGained=true;
        }
    }

    void txtSound_focusLost(FocusEvent e) {
        txtAuFocusGained=false;
    }

    class PnlThumbnail extends JPanel {
        ImageIcon thumbnail=null;

        public PnlThumbnail() {}

        public void paint(Graphics g) {
            if(thumbnail==null)
                thumbnail=new ImageIcon(
                        image.getScaledInstance(146, -1, Image.SCALE_DEFAULT));

            int x = getWidth()/2 - thumbnail.getIconWidth()/2;
            int y = getHeight()/2 - thumbnail.getIconHeight()/2;
            if(y < 0) {
                y = 0;
            }

            if(x < 5) {
                x = 5;
            }
            thumbnail.paintIcon(this, g, x, y);
        }
    }

    void btnHelp_actionPerformed(ActionEvent e) {
        HelpBrowser helpBrowser=new HelpBrowser(
                "jar:file:jbillboard.jar!/docs/helpsetprop.html");
    }

}