package com.softviewtech.jbillboard;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 *
 * This class is purposed to add image information into JTable
 */

import javax.swing.table.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.io.*;

public class ImageJTable extends JTable {
    public ImageJTable() {
        super();
    }

    public ImageJTable(TableModel model) {
        super(model);

        // data structure of table is:
        // imagename|pause|transition|param|direction|URL|audiofilename
        // + hiden column:
        // imagedata|imagefilepath|audiofilepath
        TableColumn column=null;
        for(int col=7; col<10; col++) {
            column=getColumnModel().getColumn(col);
            column.setMaxWidth(0);
            column.setMinWidth(0);
            column.setWidth(0);
            column.setPreferredWidth(0);
            column.setResizable(false);
        }

    }

    public void addImageData(Image image, File f) {
        DefaultTableModel model = (DefaultTableModel)getModel();
        Object[] newRow = new Object[10];
        newRow[0]=f.getName();
        newRow[7]=image;
        newRow[8]=f.getPath();
        model.addRow(newRow);
    }

    // set visible data
    public void setImageData(int row, Object[] value) { // value[6] is null
        for(int i=0; i<10; i++) {
            if(i==6)
                continue;
            setValueAt(value[i], row, i);
        }

        String auPath=(String)value[9];
        int i=auPath.lastIndexOf('\\');
        i=Math.max(i, auPath.lastIndexOf('/'));
        if(i!=-1) {
            String auFileName=auPath.substring(i+1);
            setValueAt(auFileName, row, 6);
        }
        else
            setValueAt(auPath, row, 6);
    }

    public Object[] getImageData(int row) {
        Object value[]=new Object[10];
        for(int i=0; i<10; i++)
            value[i]=getValueAt(row, i);
        return(value);
    }

    public Image getImage(int row) {
        return((Image)getValueAt(row, 7));
    }

    public void addImage(int row, Image image) {
        setValueAt(image, row, 7);
    }

    public void removeAll() {
        // remove each row in the jtable
        DefaultTableModel model = (DefaultTableModel)getModel();
        while(this.getRowCount()>0)
            model.removeRow(0);
    }

    public void removeSelectedRows() {
        // remove each row in the jtable
        DefaultTableModel model = (DefaultTableModel)getModel();
        int cnt=getSelectedRowCount();
        int r=getSelectedRow();
        for(int i=0; i<cnt; i++) {
            model.removeRow(r);
        }
    }

    public void moveSelectedRowsUp() {
        // moves selected rows to one row up
        DefaultTableModel model = (DefaultTableModel)getModel();

        int cnt=getSelectedRowCount();
        int r=getSelectedRow();

        if(r==0) return;

        model.moveRow(r, r+cnt-1, r-1);
        setRowSelectionInterval(r-1, r+cnt-2);
    }

    public void moveSelectedRowsDown() {
        // moves selected rows to one row down
        DefaultTableModel model = (DefaultTableModel)getModel();
        int cnt=getSelectedRowCount();
        int r=getSelectedRow();
        if(r+cnt>=getRowCount())
            return;

        model.moveRow(r, r+cnt-1, r+cnt);
        setRowSelectionInterval(r+1, r+cnt);
    }
}

