package com.softviewtech.jbillboard;

import javax.swing.*;
import java.awt.*;
import java.net.*;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 */

public class PnlCover extends JPanel {
    private Image coverImg;
    Thread pause;
    private boolean timeup=false;

    public PnlCover() {
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

        try {
            URL url=new URL("jar:file:jbillboard.jar!/icons/jbcover10.gif");
            coverImg=Toolkit.getDefaultToolkit().getImage(url);
        } catch(Exception e) {
            e.printStackTrace();
        }

        repaint();
    }

    public void showCover() {
        repaint();
        pause=new Thread("Pause");
        try {
            pause.sleep(6000);
        } catch(InterruptedException e) {
            e.printStackTrace();
        }
    }


    public void paint(Graphics g) {
        int x = getWidth()/2 - coverImg.getWidth(this)/2;
        int y = getHeight()/2 - coverImg.getHeight(this)/2;

        g.drawImage(coverImg, x, y, 463, 370, this);
    }

    public void update (Graphics g)  {
//        paint (g);
    }
}