package com.softviewtech.jbillboard;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.net.*;
import java.util.*;
import java.awt.image.*;

/**
 * Title:        jbapplet (used in JBillboard and alone)
 * Description:
 * Copyright:    Copyright (c) 2002, 2003
 * Company:      SoftView Technology
 * @author J.Y. WENG
 * @version 1.0
 */

public class jbapplet extends Applet implements Runnable {
    // if isStandalone is true, line 898 will be substitude by line 899
    // find the line by searching "currentURL"
    // line 1, package is also needed
    boolean isStandalone = false;
    boolean licenced=false;

    private int width, height, length;
    private int pixels[][], currentPix[];
    private boolean pepper[];
    private Image currentImg;


    // obtained from wizard panels
    public Image image[];
    public int nImage;

    // following values are obtained from the parameters of the Applet
    // their values are given directlly by the wizard panals
    private String imagePath[];
    private String audioPath[];
    public String pause[];
    public String transition[];
    public String paramTrans[];
    public String direction[];
    public String url[];
    public AudioClip audio[];

    private String currentURL;

    // variables for straps
    private Image strap[][];
    private Image oneStrap;
    private int strapPix[][];
    private int oneStrapPix[];

    // variables for "flip"
    private int wStrap=15;
    private int nStrap;
    private float wScale[];
    private float wDelta=-0.1f;
    private boolean isStrapNeeded=false;

    private int current=0, next=1;
    Thread engine=null;
    Image offScrImage;
    Graphics offScrGC;
    Cursor normalCursor = new Cursor(Cursor.DEFAULT_CURSOR);
    Cursor handCursor = new Cursor(Cursor.HAND_CURSOR);

    private boolean ready=false;

    MediaTracker mediaTracker;

    Image SoftView;
    Graphics SoftViewGC;

    private int tempi;

    private int[] maskPixV;
    int xm, ym;
    int colPzl;  // 33=12*30
    int rowPzl;
    boolean pzlPlaced[][];

    boolean auPlayed=false;

    /**Construct the applet*/
    public jbapplet() {
    }
    /**Initialize the applet*/
    public void init() {
        // limit the number of pictures shown on billborad is up to 10
        imagePath=new String[12];
        image=new Image[12];
        url=new String[12];
        pause=new String[12];
        transition=new String[12];
        paramTrans=new String[12];
        direction=new String[12];
        audioPath=new String[12];
        audio=new AudioClip[12];

        Dimension dim=getSize();
        width=dim.width;
        height=dim.height;
        length=width*height;

        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }

        if(isStandalone) {
            init1();
        }
    }

    // Obtain Image image[], String url[], int pause[], String transition[],
    // String paraTrans[], width, height and length from the wizard panels
    public void init1() {
        int i=0;
        // gets path of files of images from parameters
        do {
            imagePath[i]=getParameter("image"+(i+1));
            i++;
        } while(imagePath[i-1]!=null);
        nImage=i-1;

        // gets pause times of transitions
        for(i=0; i<nImage; i++) {
            pause[i]=getParameter("pause"+(i+1));
            if(pause[i]==null)
                pause[i]="2";
        }

        // gets styles of transitions
        for(i=0; i<nImage; i++) {
            transition[i]=getParameter("transition"+(i+1));
        }

        // gets parameters for chosen transition
        for(i=0; i<nImage; i++) {
            paramTrans[i]=getParameter("paraOfTransition"+(i+1));
        }

        for(i=0; i<nImage; i++) {
            direction[i]=getParameter("direction"+(i+1));
        }

        // gets links from parameters
        for(i=0; i<nImage; i++) {
            url[i]=getParameter("URL"+(i+1));
        }

        // gets audio
        for(i=0; i<nImage; i++) {
            audioPath[i]=getParameter("audio"+(i+1));
        }

        for(i=0; i<nImage; i++) {
            if(audioPath[i]!=null) {
                audio[i]=getAudioClip(getDocumentBase(), audioPath[i]);
            }
        }

        // create a media tracker to track the loading of image.
        mediaTracker = new MediaTracker(this);

        if(!licenced) {
            nImage++;

            for(i=0; i<nImage-1; i++) {
                image[i]=getImage(getDocumentBase(), imagePath[i]);

                // add your image to the tracker with an arbitrary id
                mediaTracker.addImage(image[i], 0);
            }

            SoftView = createImage(width, height);
            SoftViewGC = SoftView.getGraphics();

            float scale=width/380.0f;
            int midW=width/2;
            int midH=height/2;
            int firstLine=midH-(int)(15*scale);
            int secondLine=midH+(int)(33*scale);

            SoftViewGC.setColor(new Color(218,37,29));
            SoftViewGC.fillRect(0,0,width,height);
            SoftViewGC.setColor(Color.white);

            Font f=new Font("Monospaced", Font.BOLD, (int)(scale*32));
            FontMetrics fm=getFontMetrics(f);
            String str= "Create Billboard";
            String str1="in Minutes";
            int x0=(width-fm.stringWidth(str))/2;
            int y0=height/2;

            SoftViewGC.setFont(f);
            SoftViewGC.drawString(str, x0, y0-(int)(scale*8));

            x0=(width-fm.stringWidth(str1))/2;
            SoftViewGC.drawString(str1, x0, y0+(int)(scale*23));

            image[nImage-1]=SoftView;

            url[nImage-1]="http://www.softviewtech.com/jbillboard";
            pause[nImage-1]=pause[nImage-2];
            transition[nImage-1]=transition[nImage-2];
            paramTrans[nImage-1]=paramTrans[nImage-2];
            direction[nImage-1]=direction[nImage-2];
            audio[nImage-1]=audio[nImage-2];
            if(sum(url[nImage-1])!=3767)
                System.exit(-1);
        }
        else {  // licensed
            for(i=0; i<nImage; i++) {
                image[i]=getImage(getDocumentBase(), imagePath[i]);
                mediaTracker.addImage(image[i], 0);
            }
        }
    }

    /**Component initialization*/
    private void jbInit() throws Exception {
        this.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(MouseEvent e) {
                this_mouseEntered(e);
            }
            public void mouseExited(MouseEvent e) {
                this_mouseExited(e);
            }
            public void mouseClicked(MouseEvent e) {
                this_mouseClicked(e);
            }
        });
    }

    public void run() {
        // try to wait for image to be loaded, catch if loading was interrupted
        if(isStandalone) {
            try
            {
                mediaTracker.waitForID(0);
            }
            catch(InterruptedException e)
            {
                e.printStackTrace();
            }
        }

        pixels = new int[nImage][length];
        currentPix=new int[length];
        pepper=new boolean[length];

        // grabs pixels of each image
        PixelGrabber pixel_grabber=null;
        for(int i=0; i<nImage; i++) {

            // create a pixel grabber object
            // pixels are stored in the default RGB color model
            pixel_grabber = new PixelGrabber(image[i], 0, 0,
                                    width, height, pixels[i], 0, width);
            // grab pixels
            try{
                pixel_grabber.grabPixels();
            }
            catch(InterruptedException e) {
                e.printStackTrace();
            }
        }

        ///////////mask
        maskPixV=new int[72*48];

        // rotation of PI/4
        for(int i=0; i<72; i++)
        for(int j=0; j<48; j++)
            maskPixV[i*48+j]=maskPix[i+j*72];;

        // produce strap images for strap-billboard transition when needed
        for(int i=0; i<nImage; i++) {
            if(transition[i].equals("Flip")) {
                wStrap=Integer.parseInt(paramTrans[current]);
                isStrapNeeded=true;
            }
        }

        if(isStrapNeeded) {
            nStrap=(int)(width/wStrap);
            strap=new Image[nImage][];
            oneStrapPix=new int[wStrap*height];

            for(int i=0; i<nImage; i++) {
                // "flip"
                if(transition[i].equalsIgnoreCase("Flip") ||
                   transition[(i-1+nImage)%nImage].equalsIgnoreCase("Flip")) {
                // only propear ne...
                    strap[i]=new Image[nStrap];
                    for(int j=0; j<nStrap; j++) {
                        strap[i][j]=
                            createOneStrapImage(pixels[i], wStrap, j*wStrap);
                    }
                }
            }
        }

        ///// construct a thread and start it
        requestFocus();

	Thread me = Thread.currentThread();
	me.setPriority(Thread.MIN_PRIORITY);

        offScrImage = createImage(width, height);
        offScrGC = offScrImage.getGraphics();

        wScale=new float[nStrap];
        for(int i=0; i<nStrap; i++)
            wScale[i]=1.0f;

        // shows pictures on the billboard
        ready=true;

        // states for fade transitions
        boolean transitting=false;
        boolean halfDone=false;
        float percentA=0.0f;

        // counter for the pepper effect
        int counter=0;

        // move long x or y direction
        int deltaX=0, deltaY=0;
        int xLast=0, yLast=0;
        int s=10;
        float accX=-2.0f*width/(s*s);
        float accY=-2.0f*height/(s*s);

        // used by sand & pepper
        int dotSize=3; //
        int length1=0;

        // used by random lines
        int width1=0;
        int height1=0;

        // used by fade thro' black/white
        int throughColor=0;

	while(engine == me) {
            long delay=50;

            if(transitting && (!auPlayed)) {
                if(audio[current]!=null) {
                    audio[current].play();
                }
                auPlayed=true;
            }
            if(!transitting)
                auPlayed=false;

//      "Cut in", "Fade", "Fade thro' black/white",
//            "Sand & pepper", "Sweep", "Slip in", "Flip",
//            "Random lines", "Puzzle"};
            currentURL=url[current];
            if(transition[current].equalsIgnoreCase("Sweep")) {
                int widBar=10;
                ////////////////////////////////////////////////////////////////////
                // following deals with wiping effect transition
                if(!transitting) {
                    dotSize=Integer.parseInt(paramTrans[current]);
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;

                    // transition happens in the next loop
                    transitting=true;
                    // copy pixels[current] to currentPix
                    for(int i=0; i<length; i++) {
                        currentPix[i]=pixels[current][i];
                        pepper[i]=false;
                    }
                    if(direction[current].equals("Vertical"))
                        length1=width*widBar;
                    else
                        length1=height*widBar;
                }
                else {
                    // transmitting
                    counter++;

                    deltaY=counter*height/30;
                    deltaX=counter*width/30;
                    if(counter>=30) { //deltaY+widBar>=height-2) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                        yLast=0;
                        xLast=0;
                    }
                    else {
                        if(direction[current].equals("Vertical")) {
                            // add peper dots into
                            if(deltaY+widBar<height)
                                for(int i=0; i<length1/(dotSize*dotSize*2); i++) {
                                    int r=(int)(Math.random()*length1);

                                    for(int j=0; j<dotSize; j++)
                                    for(int k=0; k<dotSize; k++) {
                                        tempi=(deltaY+k)*width +r+j;
                                        currentPix[tempi]=pixels[next][tempi];
                                    }
                                }

                            for(int i=yLast*width; i<deltaY*width; i++)
                                currentPix[i]=pixels[next][i];
                            yLast=deltaY;
                        }
                        else { //"Horizontal"
                            if(deltaX+widBar<width)
                                for(int i=0; i<length1/(dotSize*dotSize*2); i++) {
                                    int r=(int)(Math.random()*length1);

                                    for(int j=0; j<dotSize; j++)
                                    for(int k=0; k<dotSize; k++) {
                                        tempi=(deltaX+k)*height +r+j;
//                                        int X=tempi/height;
//                                        int Y=tempi%height;
//                                        tempi=X+Y*width;
                                        tempi=tempi/height+(tempi%height)*width;

                                        currentPix[tempi]=pixels[next][tempi];
                                    }
                                }

                            for(int i=xLast; i<deltaX; i++)
                            for(int j=0; j<height; j++) {
                                tempi=i+j*width;
                                currentPix[tempi]=pixels[next][tempi];
                            }
                            xLast=deltaX;
                        }

                        createCurrentImageByPix();
                    }
                }

               //     else if(direction[current].
            } // "Sweep"
            else if(transition[current].equalsIgnoreCase("Sand & pepper")) {
                dotSize=Math.min(dotSize, width>>2);
                dotSize=Math.min(dotSize, height>>2);

                ////////////////////////////////////////////////////////////////
                // following deals with pepper transition
                if(!transitting) {
                    dotSize=Integer.parseInt(paramTrans[current]);
                    length1=length-(dotSize-1)-(dotSize-1)*width;
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    // copy pixels[current] to currentPix
                    for(int i=0; i<length; i++) {
                        currentPix[i]=pixels[current][i];
                        pepper[i]=false;
                    }
                }
                else {
                // transmitting
                    counter++;
                    // add peper dots into
                    for(int i=0; i<length/(dotSize*dotSize*8); i++) {
                        int r=(int)(Math.random()*length1);

                        for(int j=0; j<dotSize; j++)
                        for(int k=0; k<dotSize; k++)
                            currentPix[r+j+k*width]=pixels[next][r+j+k*width];
                    }

                    createCurrentImageByPix();

                    if(counter>36) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    }
                }
            } //Sand & pepper
            else if(transition[current].equalsIgnoreCase("Random lines")) {
                // following deals with pepper transition
                if(!transitting) {
                    dotSize=Integer.parseInt(paramTrans[current]);
                    width1=width-dotSize+1;
                    height1=height-dotSize+1;
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    // copy pixels[current] to currentPix
                    for(int i=0; i<length; i++) {
                        currentPix[i]=pixels[current][i];
                        pepper[i]=false;
                    }
                }
                else { // transition
                    counter++;
                    if(direction[current].equals("Vertical")){
                        for(int i=0; i<(counter+1)*width/(dotSize<<6); i++) {
                            int r=(int)(Math.random()*width1);

                            for(int j=0; j<dotSize; j++)
                            for(int k=0; k<height; k++) {
                                tempi=r+j+k*width;
                                currentPix[tempi]=pixels[next][tempi];
                            }
                        }
                        createCurrentImageByPix();
                    }
                    else if(direction[current].equals("Horizontal")) {
                        for(int i=0; i<(counter+1)*height/(dotSize<<6); i++) {
                            int r=(int)(Math.random()*height1);

                            for(int j=0; j<dotSize; j++)
                            for(int k=0; k<width; k++) {
                                tempi=(r+j)*width+k;
                                currentPix[tempi]=pixels[next][tempi];
                            }
                        }
                        createCurrentImageByPix();
                    }
                    else { // "Intersection"
                        for(int i=0; i<(counter+1)*(width+height)/(dotSize<<8); i++) {
                            int r=(int)(Math.random()*width1);

                            for(int j=0; j<dotSize; j++)
                            for(int k=0; k<height; k++) {
                                tempi=r+j+k*width;
                                currentPix[tempi]=pixels[next][tempi];
                            }

                            r=(int)(Math.random()*height1);

                            for(int j=0; j<dotSize; j++)
                            for(int k=0; k<width; k++) {
                                tempi=(r+j)*width+k;
                                currentPix[tempi]=pixels[next][tempi];
                            }
                        }
                        createCurrentImageByPix();
                    }
                    if(counter>36) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    }
                }
            } // "Random lines"

            else if(transition[current].equals("Puzzle")) {

                // following deals with pepper transition
                if(!transitting) {
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    // copy pixels[current] to currentPix
                    for(int i=0; i<length; i++) {
                        currentPix[i]=pixels[current][i];
                    }
                    colPzl=width/43+2;  // 33=12*30
                    rowPzl=height/43+2;
                    pzlPlaced=new boolean[colPzl][rowPzl];
                    for(int c=0; c<colPzl; c++)
                    for(int r=0; r<rowPzl; r++)
                        pzlPlaced[c][r]=false;
                }
                else { // transition
                    counter++;

                    if(counter<=colPzl*rowPzl) {

                        int c=0;
                        int r=0;
                        do {
                            c=(int)(Math.random()*colPzl);
                            r=(int)(Math.random()*rowPzl);
                        } while(pzlPlaced[c][r]);
                        if((c+r)%2==0)  // horizontal
                            placePuzzle(-30+c*43, -30+r*43, false);
                        else
                            placePuzzle(-30+c*43, -30+r*43, true);
                        pzlPlaced[c][r]=true;
                    }
                    else {
                        mixPixelsWithCurrentPix(next, 0.50f);
                        counter=10001;
                    }

                    createCurrentImageByPix();

                    if(counter>10000) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    }
                }
            } // "Puzzle"
            else if(transition[current].equalsIgnoreCase("fade")) {
                ////////////////////////////////////////////////////////////////////
                // following deals with fade transition
                if(!transitting) {
                // display the current picutre for 4 second
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    percentA=0.95f;
                }
                else {
                // transmitting
                    percentA-=0.05f;
                    mixPixels(current, next, percentA);
                    createCurrentImageByPix();

                    if(percentA<=0.05) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                    }
                }
            } // fade
            else if(transition[current].equalsIgnoreCase(
                                                "Fade thro' black/white")) {
                ////////////////////////////////////////////////////////////////
                // following deals with fade transition through white/black
                if(!transitting) {
                // display the current picutre for 4 second
                    if(paramTrans[current].equalsIgnoreCase("white"))
                        throughColor=0x00ffffffff;
                    else
                        throughColor=0x0;
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    percentA=0.93f;
                }
                else if(!halfDone) {
                // transmitting to the color
                    percentA-=0.07f;
                    mixPixelsWithColor(current, throughColor, percentA);
                    createCurrentImageByPix();

                    if(percentA<=0.07f) {
                        halfDone=true;
                    }
                }
                else {
                // transmitting from color to the next picture
                    percentA+=0.07f;
                    delay=50;

                    mixPixelsWithColor(next, throughColor, percentA);
                    createCurrentImageByPix();

                    if(percentA>=0.93f) {
                        halfDone=false;
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                    }
                }
            } // "Fade thro' black/white"
            else if(transition[current].equals("Slip in")) {
                ////////////////////////////////////////////////////////////////
                // slip-in transition
                if(!transitting) {
                // display the current picutre for 4 second
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    offScrGC.drawImage(image[current], 0, 0, this);
                }
                else {
                // transmitting
                    counter++;
                    if(direction[current].equals("Down")) {
                        deltaY=counter*height/29;
                        offScrGC.drawImage(image[next], 0, -height+deltaY, this);
                    }
                    else if(direction[current].equals("Up")) {
                        deltaY=counter*height/29;
                        offScrGC.drawImage(image[next], 0, height-deltaY, this);
                    }
                    else if(direction[current].equals("Right")) {
                        deltaX=counter*width/29;
                        offScrGC.drawImage(image[next], -width+deltaX, 0, this);
                    }
                    else { // "Left"
                        deltaX=counter*width/29;
                        offScrGC.drawImage(image[next], width-deltaX, 0, this);
                    }

                    if(counter>=29) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    }
                    currentImg=offScrImage;
                }
            } // Slip in
            else if(transition[current].equalsIgnoreCase("Slip in 1")) {
                Image bluredImg=null;
                ////////////////////////////////////////////////////////////////
                // slip-in with s=1/2 a t^2 transition
                if(!transitting) {
                // display the current picutre for 4 second
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;

                    offScrGC.drawImage(image[current], 0, 0, this);
                }
                else {
                // transmitting
                    counter++;
                    deltaX=(int)(0.5f*accX*(s-counter)*(s-counter));
                    deltaY=(int)(0.5f*accY*(s-counter)*(s-counter));

//                    offScrGC.drawImage(image[next], 0, -deltaY, this);
                    offScrGC.drawImage(image[next], deltaX, 0, this);

//                    bluredImg=getBluredImg(next);
 //                   offScrGC.drawImage(bluredImg, deltaX, 0, this);

                    if(counter>=s) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    }
                    currentImg=offScrImage;
                }
            } // "Slip in 1"
            else if(transition[current].equals("Flip")) {
                // following deals with strap-billboard transition
                if(!transitting) {
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    offScrGC.drawImage(image[current], 0, 0, this);
                }
                else { // transition
                    if(wScale[nStrap-1]*wStrap<=3) {

                        for(int i=0; i<nStrap; i++)
                            wScale[i]=1.0f;

                        //  moves to the next pair of pictures
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                        counter=0;
                    } else {

                        for(int i=nStrap-1; i>0; i--) {
                            wScale[i]=wScale[i-1];
                        }
                        if(wScale[0]*wStrap>3)
                            wScale[0]-=0.1f;

                        delay=50;
                    }

                    for(int i=0; i<nStrap; i++) {
                        int w=(int)(wStrap*wScale[i]);
                        Image scaledImg=
                            strap[current][i].getScaledInstance(
                                            w, height, Image.SCALE_FAST);
                        offScrGC.drawImage(scaledImg, i*wStrap, 0, this);
                        if(wStrap-w>0) {
                            scaledImg=strap[next][i].getScaledInstance(
                                            wStrap-w, height, Image.SCALE_FAST);
                            offScrGC.drawImage(scaledImg, i*wStrap+w, 0, this);
                        }
                    }
                    currentImg=offScrImage;
                }
            } // "Flip"
            else {
            // default transition: "Cut in"
                if(!transitting) {
                // display the current picutre for 4 second
                    currentImg=image[current];
                    delay=Integer.parseInt(pause[current])*1000;
                    // transition happens in the next loop
                    transitting=true;
                    percentA=0.75f;
                }
                else {
                // transmitting
                    percentA-=0.5f;
                    mixPixels(current, next, percentA);
                    createCurrentImageByPix();

                    if(percentA<=0.25) {
                        transitting=false;
                        current=next;
                        next=(next+1)%nImage;
                    }
                }
            } // Cut in

            repaint();
            try {
                Thread.sleep(delay);
            } catch (InterruptedException e) {
                // Should we do anything?
            }
	}
    }

      /**Start the applet*/
    public void start() {
        if (engine == null) {
            engine = new Thread(this);
            engine.start();
        }
    }
    /**Stop the applet*/
    public void stop() {
//	if (engine != null && engine.isAlive()) {
//	    engine.stop();
//	}
	engine = null;
    }
    /**Destroy the applet*/
    public void destroy() {
        engine.destroy();
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void paint(Graphics g) {
        if(!ready)
            return;

        g.drawImage(currentImg, 0, 0, this);
    }

    private Image createOneStrapImage(int pix[], int w, int xOff) {
        // take submatrix from pixels
        int            oneStrapPix[]=new int[wStrap*height];  //???????????

        for(int x=0; x<w; x++) {
            for(int y=0; y<height; y++) {
                oneStrapPix[y*w+x]=pix[y*width+x+xOff];
            }
        }

        // create an Image from an array the image has size (width,height)
        // and starts with an offset into my_array
        // scansize is the horizontal size of the array
        MemoryImageSource source = new MemoryImageSource(
                                              w,
                                              height,
                                              ColorModel.getRGBdefault(),
                                              oneStrapPix,
                                              0, //off,
                                              w); //scansz);
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    void this_mouseEntered(MouseEvent e) {
        setCursor(handCursor);
    }

    void this_mouseExited(MouseEvent e) {
        setCursor(normalCursor);
    }

    void this_mouseClicked(MouseEvent e) {
        if(currentURL==null || currentURL.equals(""))
            return;
/*        try {
            getAppletContext().showDocument(new URL(currentURL));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        } */
        BrowserControl.displayURL(currentURL);

    }

    private int sum(String str) {
        int s=0;

        for(int i=0; i<str.length(); i++)
            s+=str.charAt(i);
        return s;
    }

    private void createCurrentImageByPix() {
        MemoryImageSource source = new MemoryImageSource(
                                                  width,
                                                  height,
                                                  ColorModel.getRGBdefault(),
                                                  currentPix,
                                                  0, //off,
                                                  width); //scansz);
        currentImg=Toolkit.getDefaultToolkit().createImage(source);
    }

    //
    private void mixPixels(int a, int b, float percentA) {
        int rA=0, gA=0, bA=0;
        int rB=0, gB=0, bB=0;
        int onePixA, onePixB;
        float percentB=1.0001f-percentA;

        for(int i=0; i<length; i++) {
            onePixA=pixels[a][i];
            rA=(onePixA & 0x00ff0000)>>16;
            gA=(onePixA & 0x0000ff00)>>8;
            bA=(onePixA & 0x000000ff);

            onePixB=pixels[b][i];
            rB=(onePixB & 0x00ff0000)>>16;
            gB=(onePixB & 0x0000ff00)>>8;
            bB=(onePixB & 0x000000ff);

            currentPix[i]=((int)(rA*percentA+rB*percentB))<<16 |
                    ((int)(gA*percentA+gB*percentB))<<8 |
                    ((int)(bA*percentA+bB*percentB)) |
                    0xff000000;
        }
    }

    private void mixPixelsWithCurrentPix(int b, float percentA) {
        int rA=0, gA=0, bA=0;
        int rB=0, gB=0, bB=0;
        int onePixA, onePixB;
        float percentB=1.0001f-percentA;

        for(int i=0; i<length; i++) {
            onePixA=currentPix[i];
            rA=(onePixA & 0x00ff0000)>>16;
            gA=(onePixA & 0x0000ff00)>>8;
            bA=(onePixA & 0x000000ff);

            onePixB=pixels[b][i];
            rB=(onePixB & 0x00ff0000)>>16;
            gB=(onePixB & 0x0000ff00)>>8;
            bB=(onePixB & 0x000000ff);

            currentPix[i]=((int)(rA*percentA+rB*percentB))<<16 |
                    ((int)(gA*percentA+gB*percentB))<<8 |
                    ((int)(bA*percentA+bB*percentB)) |
                    0xff000000;
        }
    }

    private void mixPixelsWithColor(int a, int color, float percentA) {
        int rA=0, gA=0, bA=0;
        int rB, gB, bB;
        int onePixA;
        float percentB=1.0001f-percentA;

        rB=(color & 0x00ff0000)>>16;
        gB=(color & 0x0000ff00)>>8;
        bB=(color & 0x000000ff);

        for(int i=0; i<length; i++) {
            onePixA=pixels[a][i];
            rA=(onePixA & 0x00ff0000)>>16;
            gA=(onePixA & 0x0000ff00)>>8;
            bA=(onePixA & 0x000000ff);

            currentPix[i]=((int)(rA*percentA+rB*percentB))<<16 |
                    ((int)(gA*percentA+gB*percentB))<<8 |
                    ((int)(bA*percentA+bB*percentB)) |
                    0xff000000;
        }
    }

    private void placePuzzle(int xm, int ym, boolean isVertical) {
        // (xm, ym) is the right-up corner of rectangular inclosing the pazzle
        if(!isVertical) {  // horizontal
            xm-=12; ym+=12;
            for(int x=0; x<72; x++)
            for(int y=0; y<48; y++) {
                int color=maskPix[x+y*72]&0x00ff;
                if(xm+x<0 || xm+x>=width || ym+y<0 || ym+y>=height )
                    continue;
                tempi=xm+ym*width + x+y*width;
//                if(tempi<0 || tempi>=length)
  //                  continue;
                if(color>0xf0)
                    currentPix[tempi]=pixels[next][tempi];
                else if(color>100)
                    currentPix[tempi]=0xffeeeeee;
                else if(color>40)
                    currentPix[tempi]=0xff333333;
            }
        }
        else { // vertical
            for(int y=0; y<72; y++)     // j--x
            for(int x=0; x<48; x++) {   // i--y
                int color=maskPix[y+x*72]&0x00ff;
                if(xm+x<0 || xm+x>=width || ym+y<0 || ym+y>=height )
                    continue;
                tempi=xm+ym*width + x+y*width;
//                if(tempi<0 || tempi>=length)
  //                  continue;
                if(color>0xf0)
                    currentPix[tempi]=pixels[next][tempi];
                else if(color>100)
                    currentPix[tempi]=0xffeeeeee;
                else if(color>40)
                    currentPix[tempi]=0xff333333;
            }
        }
    }

    private int maskPix[]={
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,128,128,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,128,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,128,128,128,128,128,128,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,
    255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,
    255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,240,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,128,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,85,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,128,128,128,128,128,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,128,128,128,128,128,128,128,128,0,0,0,0,0,0,0,0,0,0,128,128,255,255,255,255,255,255,255,255,255,128,128,128,255,255,255,255,255,
    255,255,255,255,255,255,255,255,128,128,0,0,0,0,0,0,128,128,255,255,255,255,255,255,255,255,255,255,255,255,255,128,128,128,128,255,255,255,255,255,255,255,255,128,128,0,0,0,0,0,0,0,128,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,128,128,128,128,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,128,255,255,255,255,255,255,255,255,255,255,
    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,128,128,
    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    255,255,255,255,255,255,255,255,255,85,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,128,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
    255,255,255,240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,128,128,255,240,255,255,255,255,255,255,255,85,85,255,255,255,255,255,255,255,255,255,255,255,255,
    255,240,85,85,0,0,0,0,0,0,128,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,255,255,255,255,255,255,255,255,255,85,85,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,85,0,0,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,128,128,255,255,255,255,255,255,255,255,255,255,128,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,
    255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,
    255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,240,255,255,255,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,240,255,
    240,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,85,85,85,85,240,255,255,255,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,255,255,255,255,255,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,255,255,255,255,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,255,255,255,255,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0};
}