/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

class ImageButton
extends Canvas {
    protected ActionListener actionListener;
    protected String label = "";
    private boolean staticflag = false;
    private double scale = 1.0;
    protected int nID;
    protected int width;
    protected int height;
    protected Image curimage;
    protected Image orgimage;
    private MemoryImageSource curimagesrc;
    private Point MousePlace = new Point(-2, 16);
    protected char state = (char)73;

    public ImageButton(Image image, int i) {
        this(image, i, 1.0);
    }

    public ImageButton(int[] ai, int i) {
        this(ai, i, 1.0);
    }

    public ImageButton(int[] ai, int i, double d) {
        this(ai, ai[ai.length - 2], ai[ai.length - 1], i, d);
    }

    public ImageButton(int[] ai, int i, int j, int k, double d) {
        this.nID = k;
        this.width = i;
        this.height = j;
        MemoryImageSource memoryimagesource = new MemoryImageSource(i, j, ColorModel.getRGBdefault(), ai, 0, i);
        this.orgimage = this.createImage(memoryimagesource);
        this.setScale(d);
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public ImageButton(Image image, int i, double d) {
        this.orgimage = image;
        this.nID = i;
        this.width = this.orgimage.getWidth(this);
        this.height = this.orgimage.getHeight(this);
        this.setScale(d);
        this.enableEvents(16L);
        this.enableEvents(32L);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        if (this.state == 'I') {
            return;
        }
        int i = (int)(this.scale * (double)this.width);
        int j = (int)(this.scale * (double)this.height);
        if (i < this.getSize().width || j < this.getSize().height) {
            g.setColor(this.getBackground());
            if (i < this.getSize().width) {
                g.fillRect(i, 0, this.getSize().width - i, this.getSize().height);
            }
            if (j < this.getSize().height) {
                g.fillRect(0, j, this.getSize().width, this.getSize().height - j);
            }
            g.setColor(this.getForeground());
        }
        g.drawImage(this.curimage, 0, 0, i, j, this);
    }

    protected synchronized void setCursor() {
        if (this.staticflag) {
            return;
        }
        switch (this.state) {
            case 'X': {
                this.setCursor(Cursor.getPredefinedCursor(3));
                return;
            }
            case 'F': 
            case 'N': {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            case 'D': 
            case 'd': {
                this.setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
        }
    }

    public boolean contains() {
        return this.contains(this.MousePlace);
    }

    public synchronized void mouseReleased(MouseEvent mouseevent) {
        if (this.staticflag) {
            return;
        }
        switch (this.state) {
            case 'd': {
                if (!this.contains()) {
                    this.setState('N');
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            case 'D': {
                this.setState('F');
                this.setCursor();
                if ((mouseevent.getModifiers() & 0xC) != 0) {
                    return;
                }
                if (this.actionListener == null) break;
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
            }
        }
    }

    public void mousePressed(MouseEvent mouseevent) {
        if (this.staticflag) {
            return;
        }
        switch (this.state) {
            case 'F': {
                this.setState('D');
                this.setCursor();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
        if (this.staticflag) {
            return;
        }
        switch (this.state) {
            case 'N': {
                this.setState('F');
            }
        }
        this.setCursor();
    }

    public void mouseExited(MouseEvent mouseevent) {
        if (this.staticflag) {
            return;
        }
        switch (this.state) {
            case 'F': {
                this.setState('N');
            }
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
        if (this.state == 'D') {
            this.setState('d');
        }
        this.MousePlace = mouseevent.getPoint();
    }

    public void mouseMoved(MouseEvent mouseevent) {
        if (this.state == 'D' || this.state == 'd') {
            return;
        }
        this.MousePlace = mouseevent.getPoint();
        if (this.contains()) {
            this.setCursor();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public double getScale() {
        return this.scale;
    }

    public Image getImage() {
        return this.orgimage;
    }

    public char getState() {
        return this.state;
    }

    public int getID() {
        return this.nID;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void setStatic(boolean flag) {
        this.staticflag = flag;
    }

    public void setID(int i) {
        this.nID = i;
    }

    public void setScale(double d) {
        if (d < 0.7) {
            d = 0.7;
        } else if (d > 1.6) {
            d = 1.6;
        }
        if (this.scale == d) {
            return;
        }
        this.scale = d;
        this.repaint();
    }

    public void setImage(Image image) {
        this.orgimage = image;
        this.setImage();
    }

    protected final synchronized void setImage() {
        if (this.curimagesrc == null) {
            this.curimagesrc = new MemoryImageSource(this.width, this.height, ColorModel.getRGBdefault(), this.getPoker(), 0, this.width);
            this.curimagesrc.setAnimated(true);
            this.curimage = this.createImage(this.curimagesrc);
            this.repaint();
            return;
        }
        this.curimagesrc.newPixels(this.getPoker(), ColorModel.getRGBdefault(), 0, this.width);
        this.repaint();
    }

    public synchronized boolean setState(char c) {
        if (this.state == c) {
            return false;
        }
        if (this.state == 'I') {
            this.setEnabled(true);
            this.setVisible(true);
        } else if (c == 'I') {
            this.setEnabled(false);
            this.setVisible(false);
        }
        this.state = c;
        if (this.state == 'I') {
            return false;
        }
        if (this.state == 'd') {
            return false;
        }
        this.setImage();
        return true;
    }

    private final int handlePixel(int i, int j) {
        if (i == j) {
            return 0;
        }
        return this.handlePixel(i);
    }

    private final int handlePixel(int i) {
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        if (this.state == 'X') {
            j = j * 80 / 100;
            k = k * 80 / 100;
            l = l * 80 / 100;
        } else if (this.state == 'D') {
            j = j * 70 / 100;
            k = k * 70 / 100;
            l = l * 70 / 100;
        } else {
            k = k * 70 / 100;
            l = 255 - (255 - l) * 70 / 100;
        }
        if (j < 0) {
            j = 0;
        } else if (j > 255) {
            j = 255;
        }
        if (k < 0) {
            k = 0;
        } else if (k > 255) {
            k = 255;
        }
        if (l < 0) {
            l = 0;
        } else if (l > 255) {
            l = 255;
        }
        i = i & 0xFF000000 | j << 16 | k << 8 | l;
        return i;
    }

    private final int handlePixel(int i, int j, int k, int l) {
        if (i == l) {
            return 0;
        }
        return this.handlePixel(i, j, k);
    }

    private final int handlePixel(int i, int j, int k) {
        int i1;
        i = this.handlePixel(i);
        int l = Math.min(Math.abs(this.width - j), j);
        int j1 = Math.min(l, i1 = Math.min(Math.abs(this.height - k), k));
        if (j1 > 5) {
            return i;
        }
        int k1 = i >> 16 & 0xFF;
        int l1 = i >> 8 & 0xFF;
        int i2 = i & 0xFF;
        int j2 = 30 - j1 * 5;
        k1 = k1 * (100 - j2) / 100;
        l1 = l1 * (100 - j2) / 100;
        i2 = i2 * (100 - j2) / 100;
        i = i & 0xFF000000 | k1 << 16 | l1 << 8 | i2;
        return i;
    }

    private final int[] getPixels(boolean flag) {
        int[] ai;
        block8: {
            Image image = this.orgimage;
            ai = new int[this.width * this.height];
            PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, ai, 0, this.width);
            try {
                pixelgrabber.grabPixels();
            }
            catch (InterruptedException _ex) {
                System.err.println("Failed: interrupted  waiting  for  pixels!");
                return null;
            }
            if ((pixelgrabber.status() & 0x80) != 0) {
                System.err.println("Failed: image  fetch  aborted  or  errored");
                return null;
            }
            if (this.state == 'N') break block8;
            if (flag) {
                for (int i = 0; i < this.height; ++i) {
                    for (int k = 0; k < this.width; ++k) {
                        ai[i * this.width + k] = this.handlePixel(ai[i * this.width + k], k, i);
                    }
                }
            } else {
                for (int j = 0; j < this.height * this.width; ++j) {
                    ai[j] = this.handlePixel(ai[j]);
                }
            }
        }
        return ai;
    }

    protected final int[] getImage(int[] ai, int i) {
        int[] ai1 = this.state == 'D' ? this.getPixels(true) : this.getPixels(false);
        if (ai1 == null) {
            return null;
        }
        for (int j = 0; j < i; ++j) {
            ai1[ai[j]] = 0;
        }
        return ai1;
    }

    protected int[] getPoker() {
        int[] ai = new int[12];
        int i = 0;
        ai[i] = this.width;
        ai[++i] = 2 * this.width - 1;
        ai[++i] = (this.height - 2) * this.width;
        ai[++i] = (this.height - 1) * this.width - 1;
        ai[++i] = this.width - 1;
        ai[++i] = this.width - 2;
        ai[++i] = this.height * this.width - 2;
        ai[++i] = this.height * this.width - 1;
        ai[++i] = 0;
        ai[++i] = 1;
        ai[++i] = (this.height - 1) * this.width;
        ai[++i] = (this.height - 1) * this.width + 1;
        ++i;
        return this.getImage(ai, 12);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionlistener);
        this.enableEvents(16L);
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionlistener);
    }

    public void processMouseEvent(MouseEvent mouseevent) {
        switch (mouseevent.getID()) {
            case 501: {
                this.mousePressed(mouseevent);
                return;
            }
            case 502: {
                this.mouseReleased(mouseevent);
                return;
            }
            case 504: {
                this.mouseEntered(mouseevent);
                return;
            }
            case 505: {
                this.mouseExited(mouseevent);
                return;
            }
            case 500: {
                this.mouseClicked(mouseevent);
                return;
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseevent) {
        switch (mouseevent.getID()) {
            case 506: {
                this.mouseDragged(mouseevent);
                return;
            }
            case 503: {
                this.mouseMoved(mouseevent);
                return;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }
}

