/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.Random;
import net.caigen.pyramid.StatusPanel;

final class Message
extends Canvas
implements ImageObserver,
Runnable,
MouseListener {
    public static final int DEFEN = 10;
    public static final int HELP = 11;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    private Thread m_thread;
    private StatusPanel parent;
    private String message;
    private int kind = 11;
    private int alignment = 0;
    private Font Fonttype;
    private int Fontsize = 16;
    private int space = 2;
    private int descent;
    private int time = 1000;
    private int x = this.space;
    private int length;
    private boolean suspend = false;
    private Color color = Color.black;

    public Message(StatusPanel statuspanel) {
        this(statuspanel, statuspanel.m_resource.message);
    }

    public Message(StatusPanel statuspanel, String s) {
        this.parent = statuspanel;
        this.message = s;
        this.addMouseListener(this);
    }

    public void setBounds(int i, int j, int k, int l) {
        super.setBounds(i, j, k, l);
        this.Fonttype = this.getFont();
        this.Fontsize = l -= this.space * 2;
        for (int i1 = 0; i1 < 20; ++i1) {
            this.Fonttype = new Font(this.Fonttype.getName(), this.Fonttype.getStyle(), this.Fontsize);
            FontMetrics fontmetrics = this.getFontMetrics(this.Fonttype);
            this.descent = fontmetrics.getDescent();
            int j1 = fontmetrics.getHeight();
            if (l == j1) {
                this.Fontsize = l;
                break;
            }
            if (j1 > l) {
                --this.Fontsize;
                continue;
            }
            ++this.Fontsize;
        }
        FontMetrics fontmetrics1 = this.getFontMetrics(this.Fonttype);
        this.length = fontmetrics1.stringWidth(this.message);
        i = this.length > k - this.space ? k - 1 : this.space;
        this.setFont(this.Fonttype);
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
            this.suspend = false;
            return;
        }
        if (this.suspend) {
            this.setSuspend(false);
        }
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
        }
    }

    public void run() {
        while (this.m_thread != null) {
            try {
                if (!this.suspend) {
                    if (this.kind == 10) {
                        this.parent.JianFen();
                    } else {
                        this.repaint();
                    }
                }
                Thread.sleep(this.time);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void mouseReleased(MouseEvent mouseevent) {
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mousePressed(MouseEvent mouseevent) {
        if (this.m_thread == null) {
            return;
        }
        if (this.kind == 10) {
            if (!this.suspend) {
                this.parent.m_frame.pokerpanel.jianfen();
            }
            return;
        }
        this.setSuspend(!this.suspend);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int i = this.getSize().width;
        int j = this.getSize().height;
        if (this.kind == 10) {
            g.setColor(Color.magenta);
            g.drawRect(0, 0, i - 1, j - 1);
            g.setColor(this.getBackground());
            g.fillRect(1, 1, i - 2, j - 2);
            g.setColor(this.color);
            g.drawString(this.message, (i - this.length) / 2, this.Fontsize - this.descent + this.space + 4);
            return;
        }
        g.setColor(this.getBackground());
        g.fill3DRect(-1, 0, i + 1, j, true);
        g.setColor(this.color);
        if (this.m_thread == null || this.length < i - this.space) {
            if (this.alignment == 1) {
                g.drawString(this.message, (i - this.length) / 2, this.Fontsize - this.descent + this.space);
                return;
            }
            g.drawString(this.message, this.space, this.Fontsize - this.descent + this.space);
            return;
        }
        g.drawString(this.message, this.x, this.Fontsize - this.descent + this.space);
        --this.x;
        if (this.length + this.x < 1) {
            this.x = i - 1;
            Random random = new Random();
            Color color1 = this.getBackground();
            int bc = color1.getRed() << 16 | color1.getGreen() << 8 | color1.getBlue();
            int rgb = random.nextInt();
            if (rgb == bc) {
                rgb = bc / 2;
            }
            int i1 = rgb >> 16 & 0xFF;
            int j1 = rgb >> 8 & 0xFF;
            int k1 = rgb & 0xFF;
            this.color = new Color(i1, j1, k1);
            switch (rgb % 3) {
                case 0: {
                    this.Fonttype = new Font(this.Fonttype.getName(), 1, this.Fonttype.getSize());
                    this.setFont(this.Fonttype);
                    return;
                }
                case 1: {
                    this.Fonttype = new Font(this.Fonttype.getName(), 2, this.Fonttype.getSize());
                    this.setFont(this.Fonttype);
                    return;
                }
                case 2: {
                    this.Fonttype = new Font(this.Fonttype.getName(), 0, this.Fonttype.getSize());
                    this.setFont(this.Fonttype);
                    return;
                }
            }
        }
    }

    public void setAlignment(int i) {
        if (i == 0) {
            this.alignment = i;
            return;
        }
        this.alignment = 1;
    }

    public void setTime(int i) {
        this.time = i;
        this.start();
    }

    public void setStyle(int i) {
        this.Fonttype = this.getFont();
        this.Fonttype = new Font(this.Fonttype.getName(), i, this.Fonttype.getSize());
        this.setFont(this.Fonttype);
    }

    public void setColor(Color color1) {
        this.color = color1;
    }

    public String getText() {
        return this.message;
    }

    public void setkind(int i) {
        this.kind = i;
        if (i == 10) {
            this.alignment = 1;
        }
    }

    public void setSuspend(boolean flag) {
        if (this.suspend == flag || this.m_thread == null) {
            return;
        }
        this.suspend = flag;
    }

    public void setText() {
        if (this.message == null || !this.message.equals(this.parent.m_resource.message)) {
            this.setText(this.parent.m_resource.message);
        }
    }

    public synchronized boolean setText(String s) {
        try {
            this.message = s;
            this.Fonttype = this.getFont();
            FontMetrics fontmetrics = this.getFontMetrics(this.Fonttype);
            this.length = fontmetrics.stringWidth(s);
            if (this.kind == 10) {
                return true;
            }
            if (this.length > this.getSize().width - this.space) {
                this.x = this.getSize().width - 1;
                this.start();
            } else {
                this.x = this.space;
                this.color = Color.black;
                this.stop();
                this.repaint();
            }
            return true;
        }
        catch (NullPointerException _ex) {
            return false;
        }
    }
}

