/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import net.caigen.pyramid.ImageButton;
import net.caigen.pyramid.PokerPanel;

final class Poker
extends ImageButton {
    private PokerPanel pokerpanel;
    protected int value;
    protected Poker prior;
    protected Poker next;
    protected boolean leftflag = false;
    protected boolean rightflag = false;
    protected int x;
    protected int y;

    public Poker(PokerPanel pokerpanel1, Image image, int i, double d, int j) {
        super(image, i, d);
        this.pokerpanel = pokerpanel1;
        this.value = j;
    }

    private final int handlePixel(char c, int i) {
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        if (c == 'X') {
            j = j * 80 / 100;
            k = k * 80 / 100;
            l = l * 80 / 100;
        } else {
            k = k * 70 / 100;
            l = 255 - (255 - l) * 70 / 100;
        }
        if (j < 0) {
            j = 0;
        } else if (j > 255) {
            j = 255;
        }
        if (k < 0) {
            k = 0;
        } else if (k > 255) {
            k = 255;
        }
        if (l < 0) {
            l = 0;
        } else if (l > 255) {
            l = 255;
        }
        i = i & 0xFF000000 | j << 16 | k << 8 | l;
        return i;
    }

    public synchronized void paint(Graphics g) {
        super.paint(g);
        if (this.state == 'B') {
            g.setColor(Color.magenta);
            String s = String.valueOf(this.pokerpanel.maipainum);
            g.drawString(s, 8, 24);
        }
    }

    private final int leftUp(int i) {
        if (this.state == 'B') {
            return 0;
        }
        if (this.nID > 27) {
            if (this.next == null) {
                return 0;
            }
        } else {
            if (!this.leftflag) {
                return 0;
            }
            if (this.state == 'X') {
                return i;
            }
        }
        return this.handlePixel('X', -1);
    }

    private final int rightUp(int i) {
        if (this.state == 'B') {
            return 0;
        }
        if (this.nID > 27) {
            return 0;
        }
        if (!this.rightflag) {
            return 0;
        }
        if (this.state == 'X') {
            return i;
        }
        return this.handlePixel('X', -1);
    }

    private final int leftDown(int i) {
        if (this.state == 'B') {
            return 0;
        }
        if (this.nID > 27 && this.next != null) {
            return i;
        }
        return 0;
    }

    private final int rightDown(int i) {
        return 0;
    }

    protected final synchronized int[] getPoker() {
        Image image = this.orgimage;
        if (this.state == 'B') {
            image = this.pokerpanel.m_ini.backimage;
        }
        int[] ai = new int[this.width * this.height];
        PixelGrabber pixelgrabber = new PixelGrabber(image, 0, 0, this.width, this.height, ai, 0, this.width);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException _ex) {
            System.err.println("Failed: interrupted  waiting  for  pixels!");
            return null;
        }
        if ((pixelgrabber.status() & 0x80) != 0) {
            System.err.println("Failed: image  fetch  aborted  or  errored");
            return null;
        }
        int i = ai[2];
        if (this.state == 'F' || this.state == 'X') {
            for (int j = 0; j < this.height * this.width; ++j) {
                ai[j] = this.handlePixel(this.state, ai[j]);
            }
        }
        ai[this.width] = this.leftUp(ai[this.width]);
        ai[2 * this.width - 1] = this.rightUp(ai[2 * this.width - 1]);
        int k = ai[(this.height - 2) * this.width];
        ai[(this.height - 2) * this.width] = this.state != 'B' ? (this.nID <= 27 || this.next == null ? 0 : k) : 0;
        ai[(this.height - 1) * this.width - 1] = 0;
        ai[this.width - 1] = this.rightUp(ai[this.width - 1]);
        ai[this.width - 2] = this.rightUp(ai[this.width - 2]);
        ai[this.height * this.width - 2] = 0;
        ai[this.height * this.width - 1] = 0;
        if (this.nID < 28 || this.state == 'B' || this.next == null) {
            ai[0] = this.leftUp(ai[0]);
            ai[1] = this.leftUp(ai[1]);
            int l = ai[(this.height - 1) * this.width];
            ai[(this.height - 1) * this.width] = this.state != 'B' ? (this.nID <= 27 || this.next == null ? 0 : l) : 0;
            l = ai[(this.height - 1) * this.width + 1];
            ai[(this.height - 1) * this.width + 1] = this.state != 'B' ? (this.nID <= 27 || this.next == null ? 0 : l) : 0;
        } else {
            ai[0] = ai[1] = (i = this.handlePixel(this.next.state, i));
            int n = i;
            ai[(this.height - 1) * this.width + 1] = n;
            ai[(this.height - 1) * this.width] = n;
        }
        return ai;
    }

    public void setxy(int i, int j) {
        this.x = i;
        this.y = j;
    }

    protected void setCursor() {
        switch (this.state) {
            case 'X': {
                this.setCursor(Cursor.getPredefinedCursor(3));
                return;
            }
            case 'B': 
            case 'N': {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            case 'F': {
                this.setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
        }
    }

    public void mousePressed(MouseEvent mouseevent) {
    }

    public void mouseDragged(MouseEvent mouseevent) {
        super.mouseDragged(mouseevent);
        if (this.state == 'N') {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    public synchronized void mouseReleased(MouseEvent mouseevent) {
        if (!this.contains()) {
            return;
        }
        if ((mouseevent.getModifiers() & 0xC) != 0) {
            return;
        }
        switch (this.state) {
            case 'I': {
                return;
            }
            case 'N': {
                this.setState('F');
                this.setCursor();
                break;
            }
            case 'F': {
                this.setState('N');
                this.setCursor();
            }
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.label));
        }
    }

    public void mouseEntered(MouseEvent mouseevent) {
        this.setCursor();
    }

    public void mouseExited(MouseEvent mouseevent) {
    }
}

