/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Random;
import net.caigen.pyramid.Layout;
import net.caigen.pyramid.Poker;
import net.caigen.pyramid.PyramidFrame;
import net.caigen.pyramid.PyramidIni;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

final class PokerPanel
extends Panel
implements ActionListener {
    protected static final int NO = 0;
    private static final int LOSER = 1;
    private static final int WINNER = 2;
    private static final int WRONG = 3;
    private static final int RIGHT = 4;
    private static final String[] aufile = new String[]{"audio/no.au", "audio/loser.au", "audio/winner.au", "audio/wrong.au", "audio/right.au"};
    Applet m_applet;
    PyramidFrame m_frame;
    PyramidIni m_ini;
    Layout m_Layout;
    Poker[] pokers = new Poker[52];
    Poker pyramidhead;
    Poker fanpaihead;
    int maipainum;
    int fanpainum;
    int sum;
    private int Fen1 = 13;
    private int Fen2 = 14;
    private int Fen3 = 14;
    private int error;
    private boolean startflag;
    public int width = 71;
    public int height = 96;
    public int wscale = 71;
    public int hscale = 96;

    public synchronized boolean playSound(int i) {
        AudioStream audioclip = PyramidIni.getAudioStream(this, aufile[i], this.m_applet);
        if (audioclip == null) {
            return false;
        }
        AudioPlayer.player.start((InputStream)audioclip);
        return true;
    }

    public PokerPanel(Applet applet, PyramidFrame pyramidframe) {
        this.m_applet = applet;
        this.m_frame = pyramidframe;
    }

    public synchronized boolean init(PyramidIni pyramidini, int i, int j) {
        this.m_ini = pyramidini;
        this.width = this.m_ini.backimage.getWidth(this);
        this.height = this.m_ini.backimage.getHeight(this);
        this.wscale = (int)((double)this.width * this.m_ini.scale);
        this.hscale = (int)((double)this.height * this.m_ini.scale);
        boolean flag = false;
        MediaTracker mediatracker = new MediaTracker(this);
        int k = 0;
        Image[] aimage = new Image[52];
        for (int l = 0; l < 4; ++l) {
            String s1;
            switch (l) {
                case 0: {
                    s1 = "images/h";
                    break;
                }
                case 1: {
                    s1 = "images/x";
                    break;
                }
                case 2: {
                    s1 = "images/m";
                    break;
                }
                default: {
                    s1 = "images/f";
                }
            }
            for (int j1 = 1; j1 < 14; ++j1) {
                aimage[k] = PyramidIni.getImage(this, s1 + j1 + ".gif", this.m_applet);
                mediatracker.addImage(aimage[k], 0);
                ++k;
            }
        }
        try {
            mediatracker.waitForAll();
            flag = !mediatracker.isErrorAny();
        }
        catch (InterruptedException interruptedexception) {
            System.out.println(interruptedexception);
        }
        if (!flag) {
            System.err.println("Failed: Error loading images!");
            if (this.m_applet != null) {
                this.m_applet.stop();
            } else {
                this.m_frame.exit();
            }
            return false;
        }
        k = 0;
        for (int i1 = 0; i1 < 4; ++i1) {
            for (int k1 = 1; k1 < 14; ++k1) {
                this.pokers[k] = new Poker(this, aimage[k], k, this.m_ini.scale, k1);
                this.pokers[k].addActionListener(this);
                ++k;
            }
        }
        this.m_Layout = new Layout(this, i, j);
        this.m_Layout.setResizeKind(60);
        this.setLayout(this.m_Layout);
        return true;
    }

    public synchronized void start() {
        if (this.pyramidhead != null) {
            this.m_frame.statuspanel.HelpMessage.setText(this.m_frame.m_ini.resource.encourageName);
            this.m_frame.statuspanel.HelpMessage.repaint();
            this.m_frame.statuspanel.FenshuMessage.setText(this.m_frame.m_ini.resource.FailName + "!");
            this.m_frame.statuspanel.FenshuMessage.repaint();
            this.playSound(1);
        } else {
            this.playSound(2);
        }
        this.shuffle();
        int i = 0;
        for (int j = 1; j <= 7; ++j) {
            for (int k = 1; k <= j; ++k) {
                if (k == j) {
                    this.pokers[i].rightflag = false;
                    this.pokers[i].leftflag = k != 1;
                } else {
                    this.pokers[i].rightflag = true;
                    this.pokers[i].leftflag = k != 1;
                }
                ++i;
            }
        }
        this.pokers[27].prior = null;
        for (int l = 0; l < 27; ++l) {
            this.pokers[l].prior = this.pokers[l + 1];
        }
        this.pokers[0].next = null;
        for (int i1 = 1; i1 < 28; ++i1) {
            this.pokers[i1].next = this.pokers[i1 - 1];
        }
        for (int j1 = 28; j1 < 52; ++j1) {
            this.pokers[j1].prior = null;
            this.pokers[j1].next = null;
        }
        this.pyramidhead = this.pokers[27];
        this.fanpaihead = null;
        this.maipainum = 24;
        this.fanpainum = 0;
        this.sum = 0;
        this.error = 0;
        this.setxy(false);
        this.pokers[51].setState('B');
        for (int k1 = 51; k1 > 27; --k1) {
            this.m_Layout.add(this.pokers[k1], this.pokers[k1].x, this.pokers[k1].y, this.wscale, this.hscale);
        }
        for (int l1 = 27; l1 > 20; --l1) {
            this.pokers[l1].setState('N');
            this.m_Layout.add(this.pokers[l1], this.pokers[l1].x, this.pokers[l1].y, this.wscale, this.hscale);
        }
        for (int i2 = 20; i2 >= 0; --i2) {
            this.pokers[i2].setState('X');
            this.m_Layout.add(this.pokers[i2], this.pokers[i2].x, this.pokers[i2].y, this.wscale, this.hscale);
        }
        this.m_frame.statuspanel.refresh();
        this.startflag = true;
    }

    public synchronized boolean setneighbor(int i) {
        int l;
        if (i < 1) {
            return false;
        }
        if (i > 27) {
            Poker poker = this.pokers[i].next;
            if (poker == null || poker.state == 'I') {
                return false;
            }
            if (this.pokers[i].state == 'F' || this.pokers[i].state == 'I') {
                if (poker.state != 'N') {
                    if (poker.state == 'F') {
                        this.sum -= poker.value;
                    }
                    poker.setState('N');
                }
                poker = poker.next;
            }
            while (poker != null && poker.state != 'X') {
                if (poker.state == 'F') {
                    this.sum -= poker.value;
                }
                poker.setState('X');
                poker = poker.next;
            }
            return true;
        }
        if (!this.pokers[i].leftflag) {
            int j;
            for (j = 7; j > 1 && j * (j - 1) / 2 != i; --j) {
            }
            if (j < 2) {
                return false;
            }
            j = (j - 1) * (j - 2) / 2;
            if (this.pokers[j].state == 'I') {
                return false;
            }
            if (!(this.pokers[i].state != 'F' && this.pokers[i].state != 'I' || this.pokers[i + 1].state != 'F' && this.pokers[i + 1].state != 'I')) {
                if (this.pokers[j].state == 'X') {
                    this.pokers[j].setState('N');
                }
            } else if (this.pokers[j].state != 'X') {
                if (this.pokers[j].state == 'F') {
                    this.sum -= this.pokers[j].value;
                }
                this.pokers[j].setState('X');
            } else {
                return false;
            }
            this.setneighbor(j);
            return true;
        }
        if (!this.pokers[i].rightflag) {
            int k;
            for (k = 8; k > 2 && k * (k - 1) / 2 != i + 1; --k) {
            }
            if (k < 3) {
                return false;
            }
            k -= 2;
            k = k * (k - 1) / 2 + k - 1;
            if (this.pokers[k].state == 'I') {
                return false;
            }
            if (!(this.pokers[i].state != 'F' && this.pokers[i].state != 'I' || this.pokers[i - 1].state != 'F' && this.pokers[i - 1].state != 'I')) {
                if (this.pokers[k].state == 'X') {
                    this.pokers[k].setState('N');
                }
            } else if (this.pokers[k].state != 'X') {
                if (this.pokers[k].state == 'F') {
                    this.sum -= this.pokers[k].value;
                }
                this.pokers[k].setState('X');
            } else {
                return false;
            }
            this.setneighbor(k);
            return true;
        }
        for (l = 7; l > 2 && (l * (l - 1) / 2 >= i || l * (l + 1) / 2 <= i); --l) {
        }
        if (l < 3) {
            return false;
        }
        l = i - l;
        boolean[] aflag = new boolean[2];
        aflag[1] = true;
        aflag[0] = true;
        if (this.pokers[l].state == 'I') {
            aflag[0] = false;
        } else if (!(this.pokers[i].state != 'F' && this.pokers[i].state != 'I' || this.pokers[i - 1].state != 'F' && this.pokers[i - 1].state != 'I')) {
            if (this.pokers[l].state == 'X') {
                this.pokers[l].setState('N');
            }
        } else if (this.pokers[l].state != 'X') {
            if (this.pokers[l].state == 'F') {
                this.sum -= this.pokers[l].value;
            }
            this.pokers[l].setState('X');
        } else {
            aflag[0] = false;
        }
        if (this.pokers[++l].state == 'I') {
            aflag[1] = false;
        } else if (!(this.pokers[i].state != 'F' && this.pokers[i].state != 'I' || this.pokers[i + 1].state != 'F' && this.pokers[i + 1].state != 'I')) {
            if (this.pokers[l].state == 'X') {
                this.pokers[l].setState('N');
            }
        } else if (this.pokers[l].state != 'X') {
            if (this.pokers[l].state == 'F') {
                this.sum -= this.pokers[l].value;
            }
            this.pokers[l].setState('X');
        } else {
            aflag[1] = false;
        }
        if (aflag[0]) {
            this.setneighbor(l - 1);
        }
        if (aflag[1]) {
            this.setneighbor(l);
        }
        return true;
    }

    public synchronized void shuffle() {
        this.m_Layout.removeAll();
        for (int i = 0; i < 52; ++i) {
            this.pokers[i].setState('I');
        }
        for (int c = 0; c < 7; c = (int)((char)(c + 1))) {
            Random random = new Random();
            for (int c1 = 0; c1 < 52; c1 = (int)((char)(c1 + 1))) {
                char c2 = (char)random.nextInt();
                c2 = (char)(c2 % 52);
                Poker poker = this.pokers[c1];
                this.pokers[c1] = this.pokers[c2];
                this.pokers[c2] = poker;
            }
        }
        for (int j = 0; j < 52; ++j) {
            this.pokers[j].setID(j);
        }
    }

    public synchronized boolean fanpai(int i) {
        if (this.startflag) {
            this.m_frame.statuspanel.FenshuMessage.setSuspend(false);
            this.startflag = false;
        }
        this.m_frame.statuspanel.HelpMessage.setSuspend(false);
        --this.maipainum;
        ++this.fanpainum;
        i = 51 - this.maipainum;
        if (this.maipainum > 0) {
            this.pokers[51].repaint();
        }
        this.pokers[i].setState('N');
        int j = this.getSize().height - this.hscale - 8;
        int k = this.fanpainum * this.wscale / 4 + this.wscale + 10;
        this.m_Layout.move(this.pokers[i], k, j);
        if (this.fanpaihead != null) {
            this.fanpaihead.prior = this.pokers[i];
        }
        this.pokers[i].next = this.fanpaihead;
        this.pokers[i].prior = null;
        this.fanpaihead = this.pokers[i];
        Poker poker = this.pokers[i].next;
        while (poker != null && poker.state != 'X') {
            if (poker.state == 'F') {
                this.sum -= poker.value;
            }
            poker.setState('X');
            poker = poker.next;
        }
        return true;
    }

    public synchronized boolean getfocus(int i) {
        if (this.startflag) {
            this.m_frame.statuspanel.FenshuMessage.setSuspend(false);
            this.startflag = false;
        }
        this.m_frame.statuspanel.HelpMessage.setSuspend(false);
        this.sum += this.pokers[i].value;
        if (this.sum == this.Fen1 || this.sum == this.Fen2 || this.sum == this.Fen3) {
            this.defen();
        }
        this.setneighbor(i);
        return true;
    }

    public synchronized boolean losefocus(int i) {
        this.sum -= this.pokers[i].value;
        if (this.sum == this.Fen1 || this.sum == this.Fen2 || this.sum == this.Fen3) {
            this.defen();
        }
        this.setneighbor(i);
        return true;
    }

    public synchronized void jianfen() {
        this.Fen3 = 12;
        this.defen();
        this.Fen3 = this.Fen2;
    }

    public synchronized boolean defen() {
        if (this.pyramidhead == null) {
            return false;
        }
        if (this.sum != this.Fen1 && this.sum != this.Fen2 && this.sum != this.Fen3) {
            return false;
        }
        int i = this.sum;
        int j = 0;
        while (this.fanpaihead != null && this.fanpaihead.state == 'F') {
            this.sum -= this.fanpaihead.value;
            --this.fanpainum;
            j += 25;
            this.fanpaihead.setState('I');
            this.m_Layout.remove(this.fanpaihead);
            this.fanpaihead = this.fanpaihead.next;
        }
        if (this.fanpaihead != null) {
            this.fanpaihead.prior = null;
        }
        Poker poker = this.pyramidhead;
        while (this.sum > 0) {
            if (poker.state == 'F') {
                this.sum -= poker.value;
                if (poker.prior == null) {
                    this.pyramidhead = poker.next;
                } else {
                    poker.prior.next = poker.next;
                }
                if (poker.next != null) {
                    poker.next.prior = poker.prior;
                }
                j += 50;
                poker.setState('I');
                this.m_Layout.remove(poker);
            }
            poker = poker.next;
        }
        if (i == this.Fen1) {
            this.m_frame.statuspanel.JiaFen(j);
            this.playSound(4);
        } else {
            this.m_frame.statuspanel.JianFen(j / 2);
            ++this.error;
            this.playSound(3);
        }
        if (this.pyramidhead == null) {
            this.m_frame.statuspanel.FenshuMessage.setSuspend(true);
            this.m_frame.statuspanel.JiaFen(this.maipainum * 50);
            if (this.error < 1) {
                this.m_frame.statuspanel.HelpMessage.setText(this.m_frame.m_ini.resource.congrutuationName);
                this.playSound(4);
                this.playSound(2);
                this.playSound(4);
            } else {
                this.m_frame.statuspanel.HelpMessage.setText(this.m_frame.m_ini.resource.getError(this.error));
            }
            if (this.m_ini.setScore(this.m_frame.statuspanel.fenshu)) {
                this.playSound(2);
                this.playSound(1);
                this.playSound(4);
            }
            this.playSound(2);
        }
        return true;
    }

    public synchronized void setbackimage() {
        this.pokers[51].setState('I');
        this.pokers[51].setState('B');
    }

    public synchronized void setScale() {
        this.wscale = (int)((double)this.width * this.m_ini.scale);
        this.hscale = (int)((double)this.height * this.m_ini.scale);
        this.setxy(true);
        for (int i = 0; i < 52; ++i) {
            this.pokers[i].setScale(this.m_ini.scale);
            this.m_Layout.setBounds(this.pokers[i], this.pokers[i].x, this.pokers[i].y, this.wscale, this.hscale);
        }
    }

    protected synchronized boolean setxy(boolean flag) {
        int l;
        int k;
        int i = this.getSize().width;
        int j = this.getSize().height;
        int byte0 = 6;
        for (k = 8; k > 0 && this.wscale * 7 + 52 >= i; k -= 2) {
        }
        for (l = (int)((double)this.wscale * 0.4); l > 5 && 6 * l + 2 * this.hscale + 16 >= j; l -= 3) {
        }
        int i1 = 0;
        int l1 = byte0;
        for (int i2 = 1; i2 <= 7; ++i2) {
            int j1 = (i - (i2 - 1) * k - i2 * this.wscale) / 2;
            for (int j2 = 1; j2 <= i2; ++j2) {
                this.pokers[i1].setxy(j1, l1);
                if (flag) {
                    this.m_Layout.move(this.pokers[i1], j1, l1);
                }
                ++i1;
                j1 += this.wscale + k;
            }
            l1 += l;
        }
        l1 = j - this.hscale - 8;
        int k1 = this.wscale + 10;
        for (int k2 = 28; k2 < 52 - this.maipainum; ++k2) {
            if (this.pokers[k2].state != 'I') {
                k1 += this.wscale / 4;
            }
            this.pokers[k2].setxy(k1, l1);
            if (!flag) continue;
            this.m_Layout.move(this.pokers[k2], k1, l1);
        }
        for (int l2 = 52 - this.maipainum; l2 < 52; ++l2) {
            this.pokers[l2].setxy(byte0, l1);
            if (!flag) continue;
            this.m_Layout.move(this.pokers[l2], byte0, l1);
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj instanceof Poker) {
            Poker poker = (Poker)obj;
            char c = poker.getState();
            int i = poker.getID();
            switch (c) {
                case 'F': {
                    this.getfocus(i);
                    return;
                }
                case 'N': {
                    this.losefocus(i);
                    return;
                }
                case 'B': {
                    this.fanpai(i);
                    return;
                }
                case 'X': {
                    this.playSound(0);
                    return;
                }
            }
        }
    }
}

