/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.net.MalformedURLException;
import java.net.URL;
import net.caigen.pyramid.About;
import net.caigen.pyramid.Layout;
import net.caigen.pyramid.Options;
import net.caigen.pyramid.PokerPanel;
import net.caigen.pyramid.Pyramid;
import net.caigen.pyramid.PyramidIni;
import net.caigen.pyramid.PyramidMenu;
import net.caigen.pyramid.Score;
import net.caigen.pyramid.StatusPanel;

final class PyramidFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener {
    Pyramid m_applet;
    Layout m_Layout;
    PyramidIni m_ini;
    PokerPanel pokerpanel;
    StatusPanel statuspanel;
    PyramidMenu menubar;

    public PyramidFrame(String s, Pyramid pyramid) {
        super(s);
        this.m_applet = pyramid;
        this.addWindowListener(this);
    }

    public boolean exit() {
        if (this.m_applet == null) {
            this.m_ini.write();
            this.dispose();
            System.exit(0);
        } else {
            this.setVisible(false);
        }
        return true;
    }

    public void init() {
        this.init(1);
    }

    public void init(int i) {
        if (this.pokerpanel != null) {
            return;
        }
        this.m_ini = new PyramidIni(this.m_applet, this, i);
        this.m_ini.read();
        this.setBackground(Color.darkGray);
        int[] ai = About.icon_gif;
        MemoryImageSource memoryimagesource = new MemoryImageSource(ai[ai.length - 2], ai[ai.length - 1], ColorModel.getRGBdefault(), ai, 0, ai[ai.length - 2]);
        Image image = this.createImage(memoryimagesource);
        this.setIconImage(image);
        this.show();
        this.setVisible(false);
        int j = this.m_ini.width;
        int k = this.m_ini.height;
        this.setSize(j, k);
        this.menubar = new PyramidMenu(this, this.m_applet);
        this.setMenuBar(this.menubar);
        this.m_Layout = new Layout(this, j, k);
        this.m_Layout.setResizeKind(20);
        this.setLayout(this.m_Layout);
        Insets insets = this.getInsets();
        this.pokerpanel = new PokerPanel(this.m_applet, this);
        this.pokerpanel.setBackground(new Color(128, 128, 255));
        this.m_Layout.add(this.pokerpanel, 0, 0, j -= insets.left + insets.right, (k -= insets.top + insets.bottom) - 30);
        this.pokerpanel.init(this.m_ini, j, k - 30);
        this.statuspanel = new StatusPanel(this);
        this.statuspanel.setBackground(Color.white);
        this.m_Layout.add(this.statuspanel, 0, k - 30, j, 30);
        this.statuspanel.init(j, 30);
        this.setSize(this.m_ini.width, this.m_ini.height);
        Dimension paneSize = this.getPreferredSize();
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        this.show();
    }

    public void actionPerformed(ActionEvent actionevent) {
        Object obj = actionevent.getSource();
        if (obj instanceof MenuItem) {
            String s = ((MenuItem)obj).getLabel();
            if (s.equals(this.m_ini.resource.IDR_NewName)) {
                if (this.statuspanel.fenshu > 500) {
                    this.m_ini.setScore(this.statuspanel.fenshu);
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.pokerpanel.start();
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (s.equals(this.m_ini.resource.IDR_ExitName)) {
                if (this.m_applet == null) {
                    this.m_ini.write();
                    this.dispose();
                    System.exit(0);
                    return;
                }
                this.setVisible(false);
                return;
            }
            if (s.equals(this.m_ini.resource.IDR_OptionsName)) {
                Options options = new Options(this, true);
                options.init();
                return;
            }
            if (s.equals(this.m_ini.resource.IDR_HelpName)) {
                try {
                    String s1 = "Help4Pyramid.html";
                    if (this.m_ini.language == 2) {
                        s1 = "ChineseHelp4Pyramid.html";
                    }
                    URL url = new URL(this.m_applet.getCodeBase(), s1);
                    AppletContext appletcontext = this.m_applet.getAppletContext();
                    appletcontext.showDocument(url);
                    return;
                }
                catch (MalformedURLException _ex) {
                    return;
                }
            }
            if (s.equals(this.m_ini.resource.IDR_AboutName)) {
                if (this.m_applet != null) {
                    try {
                        String s2 = "Pyramid06.html";
                        if (this.m_ini.language == 2) {
                            s2 = "ChinesePyramid06.html";
                        }
                        URL url1 = new URL(this.m_applet.getCodeBase(), s2);
                        AppletContext appletcontext1 = this.m_applet.getAppletContext();
                        appletcontext1.showDocument(url1);
                    }
                    catch (MalformedURLException _ex) {
                        // empty catch block
                    }
                }
                About about = new About(this, true);
                about.init();
                return;
            }
            if (s.equals(this.m_ini.resource.IDR_ScoreName)) {
                Score score = new Score(this, true);
                score.init();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemevent) {
        Object obj = itemevent.getSource();
        if (obj == this.menubar.IDR_Language && this.menubar.IDR_Language.getState()) {
            this.m_ini.changeLanguage();
            if (this.m_applet == null) {
                this.m_ini.write();
                this.dispose();
                PyramidFrame pyramidframe = new PyramidFrame("Pyramid - Poker of ZYH", null);
                pyramidframe.init(this.m_ini.language);
                return;
            }
            this.setVisible(false);
            this.m_applet.stop();
            PyramidFrame pyramidframe1 = this.m_applet.m_frame = new PyramidFrame("Pyramid - Poker of ZYH", this.m_applet);
            pyramidframe1.init(this.m_ini.language);
        }
    }

    public void windowClosed(WindowEvent windowevent) {
    }

    public void windowOpened(WindowEvent windowevent) {
    }

    public void windowClosing(WindowEvent windowevent) {
        if (this.m_applet == null) {
            this.m_ini.write();
            this.dispose();
            System.exit(0);
            return;
        }
        this.setVisible(false);
    }

    public void windowIconified(WindowEvent windowevent) {
    }

    public void windowDeiconified(WindowEvent windowevent) {
    }

    public void windowActivated(WindowEvent windowevent) {
    }

    public void windowDeactivated(WindowEvent windowevent) {
    }
}

