/*
 * Decompiled with CFR 0.152.
 */
package net.caigen.pyramid;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import net.caigen.pyramid.PyramidFrame;
import net.caigen.pyramid.PyramidResource;
import sun.audio.AudioStream;

public final class PyramidIni {
    private Applet m_applet = null;
    private PyramidFrame m_frame = null;
    private String backfile = "images/b1.gif";
    private Vector records = new Vector();
    private Vector recordscores = new Vector();
    private Vector players = new Vector();
    private Vector playerscores = new Vector();
    public int language;
    private boolean initlanguageflag;
    public Image backimage;
    public double scale;
    public int width;
    public int height;
    public PyramidResource resource;
    private static boolean tryLoadFromUserHome = true;

    public PyramidIni(Applet applet, PyramidFrame pyramidframe, int language) {
        language = 1;
        this.initlanguageflag = false;
        this.scale = 1.0;
        this.width = 540;
        this.height = 420;
        this.resource = new PyramidResource();
        this.m_applet = applet;
        this.m_frame = pyramidframe;
        if (language == 1) {
            return;
        }
        this.language = language;
        this.initlanguageflag = true;
    }

    public String[] getPlayer() {
        Object[] players = new String[this.players.size()];
        this.players.copyInto(players);
        return players;
    }

    public String getScore() {
        String s = this.resource.TopScoreName;
        if (this.playerscores.size() > 0 && Integer.parseInt((String)this.playerscores.get(0)) > 0) {
            s = s + this.playerscores.get(0);
        }
        return s;
    }

    public boolean setScore(int score) {
        boolean flag = false;
        int i = 0;
        for (i = 0; i < this.recordscores.size(); ++i) {
            int recordscore = Integer.parseInt((String)this.recordscores.get(i));
            if (score <= recordscore) continue;
            flag = true;
            break;
        }
        if (i < 5) {
            this.recordscores.insertElementAt(score + "", i);
            this.records.insertElementAt(this.players.get(0), i);
        }
        if (this.playerscores.size() > 0 && Integer.parseInt((String)this.playerscores.get(0)) > score) {
            return flag;
        }
        this.playerscores.set(0, score + "");
        return flag;
    }

    public String[] sortPlayer(int index) {
        if (index > 0 && index < this.players.size()) {
            this.players.insertElementAt(this.players.remove(index), 0);
            this.playerscores.insertElementAt(this.playerscores.remove(index), 0);
            return this.getPlayer();
        }
        return null;
    }

    public String[] addPlayer(String name) {
        if (name == null || this.players.contains(name)) {
            return null;
        }
        this.players.insertElementAt(name, 0);
        this.playerscores.insertElementAt("0", 0);
        return this.getPlayer();
    }

    public String[] getRecord() {
        String[] as = new String[this.records.size()];
        int i = 0;
        while (i < this.records.size()) {
            int j = this.records.size() - i - 1;
            as[i] = new String(" " + (j + 1) + ".");
            String temp = (String)this.records.get(j);
            if (temp.length() >= 16) {
                int n = i;
                as[n] = as[n] + temp.substring(0, 16);
            } else {
                int n = i;
                as[n] = as[n] + temp.substring(0);
                for (int k = temp.length(); k < 16; ++k) {
                    int n2 = i;
                    as[n2] = as[n2] + " ";
                }
            }
            int n = i;
            as[n] = as[n] + " ";
            String s = "";
            int v = Integer.parseInt((String)this.recordscores.get(j));
            if (v > 0) {
                s = s + v;
            }
            for (int l = s.length(); l < 4; ++l) {
                s = " " + s;
            }
            int n3 = i++;
            as[n3] = as[n3] + s;
        }
        return as;
    }

    protected static Image getImage(Object container, String file, Applet applet) {
        if (applet != null) {
            try {
                InputStream is = container.getClass().getResourceAsStream(file);
                byte[] bytes = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int read = 0;
                while ((read = is.read(bytes)) >= 0) {
                    byteArrayOutputStream.write(bytes, 0, read);
                }
                return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
            }
            catch (IOException exception) {
                System.err.println("Failed: Error loading image!");
                if (applet != null) {
                    applet.stop();
                } else {
                    System.exit(0);
                }
                return null;
            }
        }
        return Toolkit.getDefaultToolkit().getImage(container.getClass().getResource(file));
    }

    protected static AudioStream getAudioStream(Object container, String file, Applet applet) {
        try {
            if (applet != null) {
                InputStream is = container.getClass().getResourceAsStream(file);
                return new AudioStream(is);
            }
            return new AudioStream(container.getClass().getResource(file).openStream());
        }
        catch (IOException exception) {
            System.err.println("Failed: Error loading music!");
            if (applet != null) {
                applet.stop();
            } else {
                System.exit(0);
            }
            return null;
        }
    }

    public boolean read() {
        String score;
        String name;
        int i;
        Properties prop = new Properties();
        try {
            InputStream is = null;
            if (tryLoadFromUserHome) {
                try {
                    String file = System.getProperty("user.home") + File.separator + "pyramid.ini";
                    is = new FileInputStream(file);
                }
                catch (SecurityException ex) {
                    tryLoadFromUserHome = false;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (is == null) {
                is = this.m_applet == null ? this.getClass().getResource("pyramid.ini").openStream() : this.getClass().getResourceAsStream("pyramid.ini");
            }
            prop.load(is);
            is.close();
        }
        catch (IOException _ex) {
            this.write();
            this.setini();
            return false;
        }
        String temp = prop.getProperty("pyramid.language");
        if (temp != null) {
            int i2 = Integer.valueOf(temp);
            if (i2 != this.language && this.initlanguageflag) {
                this.initlanguageflag = false;
            } else {
                this.language = i2;
            }
            this.resource.change(this.language);
        }
        if ((temp = prop.getProperty("pyramid.backimage")) != null) {
            this.backfile = temp;
        }
        if ((temp = prop.getProperty("pyramid.scale")) != null) {
            this.scale = Double.valueOf(temp);
        }
        if ((temp = prop.getProperty("pyramid.width")) != null) {
            this.width = Integer.valueOf(temp);
        }
        if ((temp = prop.getProperty("pyramid.height")) != null) {
            this.height = Integer.valueOf(temp);
        }
        this.records.clear();
        this.recordscores.clear();
        for (i = 0; i < 5; ++i) {
            name = prop.getProperty("pyramid.record.name" + (i + 1));
            if (name == null || (score = prop.getProperty("pyramid.record.score" + (i + 1))) == null) continue;
            this.records.add(name);
            this.recordscores.add(score);
        }
        this.players.clear();
        this.playerscores.clear();
        for (i = 0; i < 5; ++i) {
            name = prop.getProperty("pyramid.player.name" + (i + 1));
            if (name == null || (score = prop.getProperty("pyramid.player.score" + (i + 1))) == null) continue;
            this.players.add(name);
            this.playerscores.add(score);
        }
        this.setini();
        return true;
    }

    private boolean setini() {
        if (this.scale < 0.7) {
            this.scale = 0.7;
        } else if (this.scale > 1.6) {
            this.scale = 1.6;
        }
        if (this.width < 240) {
            this.width = 240;
        }
        if (this.height < 160) {
            this.height = 160;
        }
        if (this.backimage != null) {
            this.backimage.flush();
            this.backimage = null;
        }
        boolean flag = false;
        MediaTracker mediatracker = new MediaTracker(this.m_frame);
        this.backimage = PyramidIni.getImage(this, this.backfile, this.m_applet);
        mediatracker.addImage(this.backimage, 0);
        try {
            mediatracker.waitForAll();
            flag = !mediatracker.isErrorAny();
        }
        catch (InterruptedException interruptedexception) {
            System.out.println(interruptedexception);
        }
        if (!flag) {
            System.err.println("Failed: Error loading back image!");
            if (this.m_applet != null) {
                this.m_applet.stop();
            } else {
                System.exit(0);
            }
            return false;
        }
        return true;
    }

    public boolean setini(String s, double d) {
        this.backfile = s;
        this.scale = d;
        return this.setini();
    }

    public boolean setini(String s) {
        this.backfile = s;
        return this.setini();
    }

    public boolean setini(double d) {
        this.scale = d;
        return this.setini();
    }

    public void changeLanguage() {
        this.resource.languagekind = this.language = this.language == 1 ? 2 : 1;
    }

    public void setlanguage(int i) {
        if (this.language != i) {
            this.resource.languagekind = this.language = i;
            return;
        }
    }

    public void write() {
        int i;
        if (!tryLoadFromUserHome) {
            return;
        }
        Properties prop = new Properties();
        prop.put("pyramid.language", this.language + "");
        prop.put("pyramid.backimage", this.backfile);
        prop.put("pyramid.scale", this.scale + "");
        prop.put("pyramid.width", this.m_frame.getSize().width + "");
        prop.put("pyramid.height", this.m_frame.getSize().height + "");
        for (i = 0; i < this.records.size() && i < 5; ++i) {
            prop.put("pyramid.record.name" + (i + 1), this.records.get(i));
            prop.put("pyramid.record.score" + (i + 1), this.recordscores.get(i));
        }
        for (i = 0; i < this.players.size() && i < 5; ++i) {
            prop.put("pyramid.player.name" + (i + 1), this.players.get(i));
            prop.put("pyramid.player.score" + (i + 1), this.playerscores.get(i));
        }
        try {
            String file = System.getProperty("user.home") + File.separator + "pyramid.ini";
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            prop.store(fileoutputstream, "Pyramid - Poker of ZYH");
            fileoutputstream.close();
            return;
        }
        catch (IOException _ex) {
            System.out.println("Security Exception: Can't write to pyramid.ini");
            return;
        }
        catch (SecurityException _ex) {
            System.out.println("Security Exception: Can't write to pyramid.ini");
            tryLoadFromUserHome = false;
            return;
        }
    }
}

