/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.CommonMethods;
import unity.annotation.SourceTable;

public class SourceDatabase {
    protected String databaseName;
    protected HashMap sourceTables = new HashMap();
    protected String databaseProductName;
    protected String databaseProductVersion;
    protected String urlJDBC;
    protected String driverName;
    protected String urlJava;
    protected String javaDriverName;

    public SourceDatabase() {
        this("", "", "", "", "");
    }

    public SourceDatabase(String name, String productName, String version, String url, String driver) {
        this.databaseName = name;
        this.databaseProductName = productName;
        this.databaseProductVersion = version;
        this.urlJDBC = url;
        this.driverName = driver;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setSourceTables(HashMap tables) {
        this.sourceTables = tables;
    }

    public HashMap getSourceTables() {
        return this.sourceTables;
    }

    public void setDatabaseProductName(String name) {
        this.databaseProductName = name;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductVersion(String name) {
        this.databaseProductVersion = name;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public String getURLJDBC() {
        return this.urlJDBC;
    }

    public void setURLJDBC(String url) {
        this.urlJDBC = url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String name) {
        this.driverName = name;
    }

    public String getURLJava() {
        return this.urlJava;
    }

    public void setURLJava(String url) {
        this.urlJava = url;
    }

    public String getJavaDriverName() {
        return this.javaDriverName;
    }

    public void setJavaDriverName(String name) {
        this.javaDriverName = name;
    }

    public void addTable(SourceTable table) {
        this.sourceTables.put(table.getTableName().toLowerCase(), table);
    }

    public SourceTable getTable(String tableName) {
        return (SourceTable)this.sourceTables.get(tableName);
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("    <databaseName>" + this.databaseName + "</databaseName>\n");
        buf.append("    <databaseProductName>" + CommonMethods.exportString(this.databaseProductName) + "</databaseProductName>\n");
        buf.append("    <databaseProductVersion>" + CommonMethods.exportString(this.databaseProductVersion) + "</databaseProductVersion>\n");
        buf.append("    <urlJDBC>" + CommonMethods.makeXMLParserSafe(this.urlJDBC) + "</urlJDBC>\n");
        buf.append("    <driverName>" + CommonMethods.exportString(this.driverName) + "</driverName>\n");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(10000);
        buf.append("Database: " + this.databaseName + "\n");
        buf.append("Database System: " + this.databaseProductName + " " + this.databaseProductVersion + "\n\n");
        Iterator tables = this.sourceTables.values().iterator();
        while (tables.hasNext()) {
            buf.append(String.valueOf(tables.next().toString()) + "\n");
        }
        buf.append("url: " + this.urlJDBC + "\n");
        buf.append("driver: " + this.driverName);
        return buf.toString();
    }
}

