/*
 * Decompiled with CFR 0.152.
 */
package unity.extractor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultMutableTreeNode;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;

public class ExtractorGUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    Highlighter.HighlightPainter myHighlightPainter = new MyHighlightPainter(Color.yellow);
    private JPanel expertPanel;
    private JTextField expertSave;
    private JTextArea expertTextArea;
    private JMenuItem expertView;
    private JMenu fileMenu;
    private JMenuBar jMenuBar1;
    private JMenuItem quitOption;
    private JTree xspecTree;
    private JPanel normalPanel;
    private JMenuItem normalView;
    private JButton saveButton;
    private JScrollPane saveScrollPane;
    private JScrollPane treeScrollPane;
    private JMenu viewMenu;
    private JLabel xmlLabel;
    private DefaultMutableTreeNode top;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextField jTextField1;
    private JTextField jTextField2;

    private void initComponents() {
        this.normalPanel = new JPanel();
        this.normalPanel.setVisible(true);
        this.treeScrollPane = new JScrollPane();
        this.xspecTree = new JTree(this.top);
        this.jTextField2 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.expertPanel = new JPanel();
        this.expertPanel.setVisible(false);
        this.expertSave = new JTextField();
        this.saveButton = new JButton();
        this.saveScrollPane = new JScrollPane();
        this.expertTextArea = new JTextArea();
        this.xmlLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.quitOption = new JMenuItem();
        this.viewMenu = new JMenu();
        this.normalView = new JMenuItem();
        this.expertView = new JMenuItem();
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(3);
        this.setTitle("Extractor GUI");
        this.normalPanel.setLayout(null);
        this.xspecTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ExtractorGUI.this.xspecTreeValueChanged(evt);
            }
        });
        this.treeScrollPane.setViewportView(this.xspecTree);
        this.normalPanel.add(this.treeScrollPane);
        this.treeScrollPane.setBounds(2, 2, 260, 580);
        this.normalPanel.add(this.jTextField2);
        this.jTextField2.setBounds(420, 90, 140, 19);
        this.jLabel1.setText("Name");
        this.normalPanel.add(this.jLabel1);
        this.jLabel1.setBounds(350, 40, 50, 14);
        this.jLabel3.setText("Semantic");
        this.normalPanel.add(this.jLabel3);
        this.jLabel3.setBounds(350, 90, 70, 14);
        this.normalPanel.add(this.jTextField1);
        this.jTextField1.setBounds(420, 40, 140, 19);
        this.getContentPane().add(this.normalPanel);
        this.normalPanel.setBounds(0, 0, 740, 610);
        this.expertPanel.setLayout(null);
        this.expertSave.setFont(new Font("Microsoft Sans Serif", 0, 12));
        this.expertSave.setHorizontalAlignment(4);
        this.expertPanel.add(this.expertSave);
        this.expertSave.setBounds(10, 50, 100, 20);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractorGUI.this.saveButtonActionPerformed(evt);
            }
        });
        this.expertPanel.add(this.saveButton);
        this.saveButton.setBounds(40, 90, 80, 23);
        this.saveScrollPane.setViewportView(this.expertTextArea);
        this.expertPanel.add(this.saveScrollPane);
        this.saveScrollPane.setBounds(150, 10, 570, 590);
        this.xmlLabel.setFont(new Font("Microsoft Sans Serif", 0, 12));
        this.xmlLabel.setText(".xml");
        this.expertPanel.add(this.xmlLabel);
        this.xmlLabel.setBounds(110, 50, 50, 20);
        this.getContentPane().add(this.expertPanel);
        this.expertPanel.setBounds(0, 0, 730, 610);
        this.fileMenu.setText("File");
        this.quitOption.setText("Quit");
        this.quitOption.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ExtractorGUI.this.quitOptionMousePressed(evt);
            }
        });
        this.fileMenu.add(this.quitOption);
        this.jMenuBar1.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.normalView.setText("Normal");
        this.normalView.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ExtractorGUI.this.normalViewMouseReleased(evt);
            }
        });
        this.viewMenu.add(this.normalView);
        this.expertView.setText("Expert");
        this.expertView.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ExtractorGUI.this.expertViewMouseReleased(evt);
            }
        });
        this.viewMenu.add(this.expertView);
        this.jMenuBar1.add(this.viewMenu);
        this.setJMenuBar(this.jMenuBar1);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 765) / 2, (screenSize.height - 662) / 2, 765, 662);
    }

    private void xspecTreeValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.xspecTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof AnnotatedSourceTable) {
            this.jTextField1.setText(((AnnotatedSourceTable)nodeInfo).getTableName());
            this.jTextField2.setText(((AnnotatedSourceTable)nodeInfo).getSemanticTableName());
        } else {
            this.jTextField1.setText(((AnnotatedSourceField)nodeInfo).getColumnName());
            this.jTextField2.setText(((AnnotatedSourceField)nodeInfo).getSemanticFieldName());
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.expertSave.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Please input a valid file name!");
        } else {
            String printOut = this.expertTextArea.getText();
            try {
                PrintWriter fout = new PrintWriter(new FileWriter("Tests\\xspec\\" + this.expertSave.getText() + ".xml"));
                printOut.replaceAll("\n", "");
                fout.print(printOut);
                fout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        JOptionPane.showMessageDialog(null, "XSPEC saved to Tests\\xspec\\" + this.expertSave.getText() + ".xml");
    }

    private void quitOptionMousePressed(MouseEvent evt) {
        System.exit(0);
    }

    private void normalViewMouseReleased(MouseEvent evt) {
        this.expertPanel.setVisible(false);
        this.normalPanel.setVisible(true);
    }

    private void expertViewMouseReleased(MouseEvent evt) {
        this.normalPanel.setVisible(false);
        this.expertPanel.setVisible(true);
    }

    public void setTree(DefaultMutableTreeNode t) {
        this.top = t;
    }

    public void showIt(File f) {
        this.initComponents();
        String showInBox = "";
        try {
            String line;
            BufferedReader fin = new BufferedReader(new FileReader(f));
            while ((line = fin.readLine()) != null) {
                showInBox = String.valueOf(showInBox) + line + "\n";
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.expertTextArea.setText(showInBox);
        int pos = 0;
        Highlighter h = this.expertTextArea.getHighlighter();
        try {
            while ((pos = showInBox.indexOf("semantic", pos)) >= 0) {
                if (showInBox.charAt(pos - 1) != '/') {
                    h.addHighlight(pos, pos + 8, this.myHighlightPainter);
                }
                ++pos;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.setVisible(true);
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

