/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Log
extends Function {
    private Expression expr;

    public F_Log(Expression e) {
        this.expr = e;
        this.returnType = this.expr.getReturnType();
    }

    public Object evaluate(Tuple t) {
        Object val = this.expr.evaluate(t);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            double v = ((Number)val).doubleValue();
            return new Double(Math.log(v) / Math.log(10.0));
        }
        return null;
    }

    public int getReturnType() {
        return 8;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_NUMBER};
    }

    public static String getFunctionName() {
        return "LOG";
    }

    public String toString(Relation relation) {
        return "LOG(" + this.expr.toString(relation) + ")";
    }
}

