/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Substring
extends Function {
    private Expression expr;
    private Expression startLoc;
    private Expression length;

    public F_Substring(Expression exp, Expression start, Expression len) {
        this.expr = exp;
        this.startLoc = start;
        this.length = len;
    }

    public Object evaluate(Tuple t) {
        Object len;
        int stringLength;
        String string = (String)this.expr.evaluate(t);
        if (string == null) {
            return null;
        }
        Object st = this.startLoc.evaluate(t);
        if (st == null) {
            return null;
        }
        int start = (Integer)st;
        if (start < 1) {
            start = 1;
        }
        if (start > (stringLength = string.length())) {
            return "";
        }
        if (this.length != null) {
            len = this.length.evaluate(t);
            if (len == null) {
                return null;
            }
        } else {
            return string.substring(start - 1);
        }
        int count = (Integer)len;
        if (count <= 0) {
            return "";
        }
        if (start + count - 1 > stringLength) {
            return string.substring(start - 1);
        }
        return string.substring(start - 1, start + count - 1);
    }

    public int getReturnType() {
        return Attribute.TYPE_STRING;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_STRING, Attribute.TYPE_INT, Attribute.TYPE_INT};
    }

    public static String getFunctionName() {
        return "SUBSTRING";
    }

    public String toString(Relation relation) {
        if (this.length != null) {
            return "SUBSTRING(" + this.expr.toString(relation) + "," + this.startLoc.toString(relation) + "," + this.length.toString(relation) + ")";
        }
        return "SUBSTRING(" + this.expr.toString(relation) + "," + this.startLoc.toString(relation) + ")";
    }
}

