/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceField;

public class LocalResultSetMetaData
implements ResultSetMetaData {
    private String[] columnHeaders;
    private ArrayList metadata;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;

    LocalResultSetMetaData(String[] colhead, ArrayList md) throws SQLException {
        this.metadata = md;
        this.columnHeaders = colhead;
    }

    public int getColumnCount() throws SQLException {
        return this.columnHeaders.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getNullable();
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getColumnSize();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.columnHeaders[column - 1];
    }

    public String getColumnName(int column) throws SQLException {
        return this.columnHeaders[column - 1];
    }

    public String getSchemaName(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getTableSchema();
    }

    public int getPrecision(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getDecimalDigits();
    }

    public int getScale(int column) throws SQLException {
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getTableName();
    }

    public String getCatalogName(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getTableCatalog();
    }

    public int getColumnType(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getDataType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        AnnotatedSourceField asf = (AnnotatedSourceField)this.metadata.get(column - 1);
        return asf.getDataTypeName();
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }
}

