/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import java.util.HashMap;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.EquiJoinPredicate;
import unity.query.GQDatabaseRef;
import unity.query.LocalQuery;
import unity.relational.Relation;
import unity.relational.Tuple;

public class DistributedJoin
extends Operator {
    private Tuple[] tupleBuffer;
    private int BUFFER_SIZE = 2000;
    private EquiJoinPredicate pred;
    private GQDatabaseRef gqdr;
    private boolean swap;
    private Relation firstRelation;
    private Relation secondRelation;
    private Operator firstInput;
    private Operator secondInput;
    private int[] firstRelationJoinAttrs;
    private int[] secondRelationJoinAttrs;
    private ResultSetScan rs;
    private int currentLoc;
    private int tupleCount;
    private Tuple currentTuple;

    public DistributedJoin(Operator[] in, EquiJoinPredicate p, GQDatabaseRef dbRef, boolean swap) {
        super(in, 0, 0);
        this.pred = p;
        this.gqdr = dbRef;
        this.swap = swap;
        if (swap) {
            this.firstInput = this.input[1];
            this.secondInput = this.input[0];
            this.firstRelationJoinAttrs = this.pred.getRelation2Locs();
            this.secondRelationJoinAttrs = this.pred.getRelation1Locs();
        } else {
            this.firstInput = this.input[0];
            this.secondInput = this.input[1];
            this.firstRelationJoinAttrs = this.pred.getRelation1Locs();
            this.secondRelationJoinAttrs = this.pred.getRelation2Locs();
        }
        this.firstRelation = this.firstInput.getOutputRelation();
        this.secondRelation = this.secondInput.getOutputRelation();
        Relation out = new Relation(this.firstRelation);
        out.mergeRelation(this.secondRelation);
        this.setOutputRelation(out);
    }

    public void init() throws IOException {
        this.tupleBuffer = new Tuple[this.BUFFER_SIZE];
        this.firstInput.init();
        this.tupleCount = 0;
        while (this.tupleCount < this.BUFFER_SIZE) {
            Tuple t = this.firstInput.next();
            if (t == null) break;
            this.tupleBuffer[this.tupleCount] = t;
            ++this.tupleCount;
        }
        if (this.tupleCount == 0) {
            this.currentTuple = null;
            return;
        }
        int numJoinAttr = this.pred.getNumAttr();
        StringBuffer[] inSet = new StringBuffer[numJoinAttr];
        StringBuffer newWHEREClause = new StringBuffer("");
        HashMap values = new HashMap(this.tupleCount);
        int i = 0;
        while (i < numJoinAttr) {
            inSet[i] = new StringBuffer();
            int j = 0;
            while (j < this.tupleCount) {
                String val;
                String st;
                if (this.firstRelation.getAttributeType(this.firstRelationJoinAttrs[i]) == 12) {
                    st = this.tupleBuffer[j].getString(this.firstRelationJoinAttrs[i]);
                    val = "'" + st + "',";
                } else {
                    st = this.tupleBuffer[j].getObject(this.firstRelationJoinAttrs[i]).toString();
                    val = String.valueOf(st) + ",";
                }
                if (!values.containsKey(st)) {
                    values.put(st, null);
                    inSet[i].append(val);
                }
                ++j;
            }
            newWHEREClause.append(String.valueOf(this.secondRelation.getAttribute(this.secondRelationJoinAttrs[i]).getName()) + " IN (" + inSet[i].substring(0, inSet[i].length() - 1) + ") ");
            if (i < numJoinAttr - 1) {
                newWHEREClause.append(" AND ");
            }
            ++i;
        }
        String orgSQLString = ((ResultSetScan)this.secondInput).getSQLString();
        StringBuffer newSQLString = new StringBuffer(orgSQLString);
        int whereIndex = orgSQLString.indexOf("WHERE");
        int groupByIndex = orgSQLString.indexOf("GROUP BY");
        int orderByIndex = orgSQLString.indexOf("ORDER BY");
        int insertLocation = whereIndex + 6;
        if (whereIndex < 0) {
            insertLocation = groupByIndex;
            if (insertLocation < 0) {
                insertLocation = orderByIndex;
            }
            if (insertLocation < 0) {
                insertLocation = orgSQLString.length();
            }
            newWHEREClause.insert(0, " WHERE ");
        }
        if (whereIndex > 0) {
            newSQLString.insert(insertLocation, newWHEREClause + " AND ");
        } else {
            newSQLString.insert(insertLocation, newWHEREClause);
        }
        ((ResultSetScan)this.secondInput).setSQLString(newSQLString.toString());
        ((ResultSetScan)this.secondInput).setDelayedExecution(false);
        if (UnityDriver.DEBUG) {
            System.out.println("Original SQL: " + orgSQLString);
            System.out.println("Modified SQL: " + newSQLString);
        }
        LocalQuery lq = new LocalQuery(this.gqdr);
        lq.setSQLQueryString(newSQLString.toString());
        lq.setResultSetScanOp((ResultSetScan)this.secondInput);
        try {
            lq.execute();
        }
        catch (Exception e) {
            System.out.println(" Exception generated ***** ");
            e.printStackTrace();
        }
        this.rs = new ResultSetScan(lq.getResultSet());
        this.rs.init();
        this.currentLoc = 0;
        this.currentTuple = this.rs.next();
    }

    public Tuple next() throws IOException {
        while (this.currentTuple != null) {
            while (this.currentLoc < this.tupleCount) {
                Tuple tup1 = this.tupleBuffer[this.currentLoc];
                boolean equal = this.swap ? this.pred.isEqual(this.currentTuple, tup1) : this.pred.isEqual(tup1, this.currentTuple);
                ++this.currentLoc;
                if (!equal) continue;
                if (this.swap) {
                    return new Tuple(this.currentTuple, tup1, this.outputRelation);
                }
                return new Tuple(tup1, this.currentTuple, this.outputRelation);
            }
            this.currentTuple = this.rs.next();
            this.currentLoc = 0;
        }
        return null;
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("DISTRIBUTED JOIN: ");
        if (this.swap) {
            sb.append(this.pred.toString(this.secondRelation, this.firstRelation));
        } else {
            sb.append(this.pred.toString(this.firstRelation, this.secondRelation));
        }
        return sb.toString();
    }
}

