/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import unity.io.FileManager;
import unity.operators.BufferOperator;
import unity.operators.Operator;
import unity.predicates.EquiJoinPredicate;
import unity.predicates.SortComparator;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.HashFunc;

public class HashMergeJoin
extends Operator {
    private int NUM_BUCKETS;
    private int PARTITION_SIZE;
    private EquiJoinPredicate pred;
    private Relation leftSchema;
    private Relation rightSchema;
    private SortComparator[] sorter;
    private int MERGE_BUFFER_SIZE = 10000;
    private int keyType;
    private int[] keyIdxLeft;
    private int[] keyIdxRight;
    private int numAttrs;
    private DualHashTable dualHashTable;
    private int currentInput;
    private int lastInput;
    private boolean endLeft;
    private boolean endRight;
    private Tuple currentTuple;
    private boolean processingProbe;
    private boolean processingInput;
    private boolean blocked;
    private boolean midBlockProcessing;
    public int totalBlockTuples;
    public int thisBlockTuples;
    private int tester;
    private int FAN_IN;

    public HashMergeJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numb, int a, int b, int fan, int partitionSize) {
        super(in, bfr, bsize);
        this.NUM_BUCKETS = numb;
        this.PARTITION_SIZE = partitionSize;
        this.FAN_IN = fan;
        this.pred = p;
        this.sorter = new SortComparator[this.numInputs];
        int i = 0;
        while (i < this.numInputs) {
            int[] locs = i == 0 ? this.pred.getRelation1Locs() : this.pred.getRelation2Locs();
            boolean[] sortAsc = new boolean[locs.length];
            Arrays.fill(sortAsc, true);
            this.sorter[i] = new SortComparator(locs, sortAsc);
            ++i;
        }
        this.leftSchema = this.input[0].getOutputRelation();
        this.rightSchema = this.input[1].getOutputRelation();
        Relation out = new Relation(this.leftSchema);
        out.mergeRelation(this.rightSchema);
        this.setOutputRelation(out);
    }

    public void init() throws IOException {
        this.input[0].init();
        this.input[1].init();
        this.numAttrs = this.pred.getNumAttr();
        this.keyIdxLeft = this.pred.getRelation1Locs();
        this.keyIdxRight = this.pred.getRelation2Locs();
        if (this.numAttrs > 1) {
            this.keyType = 3;
        } else if (this.leftSchema.getAttributeType(this.keyIdxLeft[0]) == Attribute.TYPE_INT) {
            this.keyType = 1;
        } else if (this.leftSchema.getAttributeType(this.keyIdxRight[0]) == Attribute.TYPE_STRING) {
            this.keyType = 2;
        }
        this.dualHashTable = new DualHashTable(this.NUM_BUCKETS, this.BUFFER_SIZE * this.BLOCKING_FACTOR, this.PARTITION_SIZE);
        this.currentInput = 0;
        this.lastInput = 0;
        this.endLeft = false;
        this.endRight = false;
        this.processingProbe = false;
        this.processingInput = true;
        this.blocked = false;
        this.midBlockProcessing = false;
        this.thisBlockTuples = 0;
        this.totalBlockTuples = 0;
        this.tester = 0;
    }

    public Tuple next() throws IOException {
        while (true) {
            if (this.processingProbe) {
                Tuple result = this.dualHashTable.probe();
                if (result == null) {
                    this.dualHashTable.checkFlush();
                    this.processingProbe = false;
                } else {
                    return result;
                }
            }
            if (this.blocked) {
                this.processingInput = false;
            }
            if (this.processingInput) {
                if (this.readInputTuple()) {
                    int probeSource = this.lastInput;
                    this.dualHashTable.insert(this.currentTuple, probeSource);
                    this.dualHashTable.initProbe(this.currentTuple, probeSource);
                    this.processingProbe = true;
                    continue;
                }
                if (this.blocked) continue;
                if (this.getTuplesRead() > this.BUFFER_SIZE * this.BLOCKING_FACTOR) {
                    this.processingInput = false;
                    this.dualHashTable.initMerge();
                    continue;
                }
                return null;
            }
            if (this.blocked) {
                if (this.midBlockProcessing) {
                    Tuple t = this.dualHashTable.merge();
                    if (t != null) {
                        ++this.totalBlockTuples;
                        ++this.thisBlockTuples;
                        return t;
                    }
                    System.out.println("tuples output this blockage: " + this.thisBlockTuples);
                    this.blocked = false;
                    this.processingInput = true;
                    this.midBlockProcessing = false;
                    continue;
                }
                this.thisBlockTuples = 0;
                int x = this.dualHashTable.beginBlockedMerge();
                if (x == -1) {
                    System.out.println("found no partition to merge during blocking");
                    this.blocked = false;
                    this.processingInput = true;
                    continue;
                }
                System.out.println("found a partition to merge during blocking");
                this.midBlockProcessing = true;
                continue;
            }
            if (!this.processingInput) break;
        }
        return this.dualHashTable.merge();
    }

    public void close() throws IOException {
        super.close();
        this.dualHashTable.close();
    }

    private boolean readInputTuple() throws IOException {
        this.lastInput = this.currentInput;
        ++this.tester;
        if (!this.endLeft && !this.endRight) {
            this.currentInput = (this.currentInput + 1) % 2;
        }
        BufferOperator op = (BufferOperator)this.input[this.currentInput];
        int otherInput = (this.currentInput + 1) % 2;
        BufferOperator op2 = (BufferOperator)this.input[otherInput];
        long startTime = System.currentTimeMillis();
        while (true) {
            if (!this.endLeft && otherInput == 1 && op.endInput()) {
                System.out.println("HFinished left input at: " + this.tester);
                this.endLeft = true;
            }
            if (!this.endRight && otherInput == 0 && op.endInput()) {
                System.out.println("HFinished right input at: " + this.tester);
                this.endRight = true;
                op.close();
            }
            if (this.endLeft && this.endRight) {
                System.out.println("HFinished all input at: " + this.tester);
                return false;
            }
            if (!op.endInput() && op.hasNext()) break;
            if (!op2.endInput() && op2.hasNext()) {
                this.currentInput = otherInput;
                break;
            }
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - startTime;
            if (elapsedTime > 40L) {
                this.blocked = true;
                System.out.println("Blocked Elapsed time: " + elapsedTime);
                return false;
            }
            Thread.yield();
        }
        this.currentTuple = this.input[this.currentInput].next();
        if (this.currentTuple == null) {
            if (this.currentInput == 0) {
                System.out.println("Finished left input at: " + this.tester);
                this.endLeft = true;
            } else {
                System.out.println("Finished right input at: " + this.tester);
                this.endRight = true;
            }
            if (this.endLeft && this.endRight) {
                System.out.println("Finished all input at: " + this.tester);
                return false;
            }
            return this.readInputTuple();
        }
        this.incrementTuplesRead();
        return true;
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        this.incrementTuplesOutput();
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("HASH MERGE JOIN: ");
        sb.append(this.pred.toString(this.leftSchema, this.rightSchema));
        sb.append("   (BufferSizeInTuples=" + this.BUFFER_SIZE * this.BLOCKING_FACTOR + ")");
        return sb.toString();
    }

    private class DualHashTable {
        private int NUM_BUCKETS;
        private int NUM_PARTITIONS;
        private int MAX_SIZE;
        private LinkedList[][] buckets;
        private int[] tupleCount;
        private int[][] partitionCount;
        private int[] flushCount;
        private ArrayList[][] partitionFileName;
        private int A;
        private int B;
        private ListIterator iterator;
        private Tuple probeTuple;
        private boolean leftProbe;
        private int currentPartition;
        private Tuple[][] buffer;
        private int[][] readCount;
        private BufferedInputStream[][] inputFile;
        private boolean[][] endInput;
        private int[] numFilesSource;
        private Tuple smallestLeft;
        private Tuple smallestRight;
        private int smallestLeftIndex;
        private int smallestRightIndex;
        private Tuple[] mergeBuffer;
        private int[] sourceIndex;
        private boolean inBuffer;
        private int numInBuffer;
        private int curBufferPosition;
        private boolean endPartitionInput;
        private boolean lastMergePass;
        private int startFileIndex;
        private int endFileIndex;
        private BufferedOutputStream[] mergeOutFile;

        public DualHashTable(int numb, int maxsize, int partitionSize) {
            this.NUM_BUCKETS = numb;
            this.MAX_SIZE = maxsize;
            HashMergeJoin.this.PARTITION_SIZE = partitionSize;
            this.NUM_PARTITIONS = (int)Math.ceil((double)this.NUM_BUCKETS * 1.0 / (double)HashMergeJoin.this.PARTITION_SIZE);
            this.buckets = new LinkedList[2][this.NUM_BUCKETS];
            int i = 0;
            while (i < this.NUM_BUCKETS) {
                this.buckets[0][i] = new LinkedList();
                this.buckets[1][i] = new LinkedList();
                ++i;
            }
            this.partitionCount = new int[2][this.NUM_PARTITIONS];
            this.flushCount = new int[this.NUM_PARTITIONS];
            this.partitionFileName = new ArrayList[2][this.NUM_PARTITIONS];
            i = 0;
            while (i < this.NUM_PARTITIONS) {
                this.partitionCount[0][i] = 0;
                this.partitionCount[1][i] = 0;
                this.flushCount[i] = 0;
                this.partitionFileName[0][i] = new ArrayList();
                this.partitionFileName[1][i] = new ArrayList();
                ++i;
            }
            this.tupleCount = new int[2];
            this.tupleCount[0] = 0;
            this.tupleCount[1] = 0;
            this.A = this.MAX_SIZE / this.NUM_BUCKETS;
            this.B = this.MAX_SIZE / 5;
        }

        public int beginBlockedMerge() throws IOException {
            int max = -1;
            int i = 0;
            while (i < this.NUM_PARTITIONS) {
                if (this.flushCount[i] > 1) {
                    max = this.flushCount[i];
                    this.currentPartition = i;
                    break;
                }
                ++i;
            }
            if (max == -1) {
                return max;
            }
            if (max > HashMergeJoin.this.FAN_IN) {
                max = HashMergeJoin.this.FAN_IN;
            }
            this.flushCount[this.currentPartition] = this.flushCount[this.currentPartition] - (max - 1);
            this.buffer = new Tuple[2][max];
            this.inputFile = new BufferedInputStream[2][max];
            this.endInput = new boolean[2][max];
            this.numFilesSource = new int[2];
            this.readCount = new int[2][max];
            i = 0;
            while (i < max) {
                this.buffer[0][i] = new Tuple(HashMergeJoin.this.leftSchema);
                this.buffer[1][i] = new Tuple(HashMergeJoin.this.rightSchema);
                this.readCount[0][i] = 0;
                this.readCount[1][i] = 0;
                ++i;
            }
            this.smallestLeft = new Tuple(HashMergeJoin.this.leftSchema);
            this.smallestRight = new Tuple(HashMergeJoin.this.rightSchema);
            this.smallestLeftIndex = -1;
            this.smallestRightIndex = -1;
            this.inBuffer = false;
            this.mergeBuffer = new Tuple[HashMergeJoin.this.MERGE_BUFFER_SIZE];
            this.sourceIndex = new int[HashMergeJoin.this.MERGE_BUFFER_SIZE];
            this.mergeOutFile = new BufferedOutputStream[2];
            this.startFileIndex = 0;
            this.endFileIndex = max;
            String fileName = FileManager.createTempFileName("mergeLeft");
            this.mergeOutFile[0] = FileManager.openOutputFile(fileName);
            this.partitionFileName[0][this.currentPartition].add(fileName);
            fileName = FileManager.createTempFileName("mergeRight");
            this.mergeOutFile[1] = FileManager.openOutputFile(fileName);
            this.partitionFileName[1][this.currentPartition].add(fileName);
            int sourceIndex = 0;
            while (sourceIndex <= 1) {
                ArrayList fileNameList = this.partitionFileName[sourceIndex][this.currentPartition];
                int i2 = this.startFileIndex;
                while (i2 < this.endFileIndex) {
                    int bufferIdx = i2 - this.startFileIndex;
                    this.inputFile[sourceIndex][bufferIdx] = FileManager.openInputFile((String)fileNameList.get(i2));
                    this.endInput[sourceIndex][bufferIdx] = false;
                    if (!this.buffer[sourceIndex][bufferIdx].read(this.inputFile[sourceIndex][bufferIdx])) {
                        this.endInput[sourceIndex][bufferIdx] = true;
                    } else {
                        HashMergeJoin.this.incrementPageIOs();
                        HashMergeJoin.this.incrementTupleIOs();
                        this.readCount[sourceIndex][bufferIdx] = HashMergeJoin.this.BLOCKING_FACTOR - 1;
                    }
                    ++i2;
                }
                this.getSmallestTuple(sourceIndex, -1);
                ++sourceIndex;
            }
            this.endPartitionInput = false;
            return max;
        }

        public void insert(Tuple cur, int source) throws IOException {
            int hv = this.hash(cur, source);
            int partNum = hv / HashMergeJoin.this.PARTITION_SIZE;
            this.buckets[source][hv].add(new Tuple(cur));
            int n = source;
            this.tupleCount[n] = this.tupleCount[n] + 1;
            int[] nArray = this.partitionCount[source];
            int n2 = partNum;
            nArray[n2] = nArray[n2] + 1;
        }

        public void checkFlush() throws IOException {
            if (this.tupleCount[0] + this.tupleCount[1] > this.MAX_SIZE) {
                int flushBucketIndex = this.adaptiveIndex();
                this.flush(flushBucketIndex);
            }
        }

        public void initProbe(Tuple prTuple, int probeSource) {
            this.probeTuple = prTuple;
            this.leftProbe = probeSource == 0;
            int bucket = this.hash(this.probeTuple, probeSource);
            this.iterator = this.buckets[(probeSource + 1) % 2][bucket].listIterator();
        }

        public Tuple probe() throws IOException {
            while (this.iterator.hasNext()) {
                Tuple t = (Tuple)this.iterator.next();
                if (this.leftProbe) {
                    if (!HashMergeJoin.this.pred.isEqual(this.probeTuple, t)) continue;
                    return HashMergeJoin.this.outputJoinTuple(this.probeTuple, t);
                }
                if (!HashMergeJoin.this.pred.isEqual(t, this.probeTuple)) continue;
                return HashMergeJoin.this.outputJoinTuple(t, this.probeTuple);
            }
            return null;
        }

        public void close() {
            int sourceIndex = 0;
            while (sourceIndex <= 1) {
                int partitionNum = 0;
                while (partitionNum < this.NUM_PARTITIONS) {
                    ArrayList fileNameList = this.partitionFileName[sourceIndex][partitionNum];
                    int i = 0;
                    while (i < fileNameList.size()) {
                        File f = new File((String)fileNameList.get(i));
                        f.delete();
                        ++i;
                    }
                    ++partitionNum;
                }
                ++sourceIndex;
            }
        }

        public void initMerge() throws IOException {
            System.out.println("Init merge phase.  Results produced: " + HashMergeJoin.this.getTuplesOutput());
            int i = 0;
            while (i < this.NUM_PARTITIONS) {
                if (this.flushCount[i] > 0) {
                    this.flush(i);
                }
                ++i;
            }
            System.out.println("Phase I IOs Tuples: " + HashMergeJoin.this.getTupleIOs() + " Pages: " + HashMergeJoin.this.getPageIOs());
            int max = -1;
            int i2 = 0;
            while (i2 < this.NUM_PARTITIONS) {
                if (this.flushCount[i2] > max) {
                    max = this.flushCount[i2];
                }
                ++i2;
            }
            if (max > HashMergeJoin.this.FAN_IN) {
                max = HashMergeJoin.this.FAN_IN;
            }
            this.buffer = new Tuple[2][max];
            this.inputFile = new BufferedInputStream[2][max];
            this.endInput = new boolean[2][max];
            this.numFilesSource = new int[2];
            this.readCount = new int[2][max];
            i2 = 0;
            while (i2 < max) {
                this.buffer[0][i2] = new Tuple(HashMergeJoin.this.leftSchema);
                this.buffer[1][i2] = new Tuple(HashMergeJoin.this.rightSchema);
                this.readCount[0][i2] = 0;
                this.readCount[1][i2] = 0;
                ++i2;
            }
            this.smallestLeft = new Tuple(HashMergeJoin.this.leftSchema);
            this.smallestRight = new Tuple(HashMergeJoin.this.rightSchema);
            this.smallestLeftIndex = -1;
            this.smallestRightIndex = -1;
            this.currentPartition = -1;
            this.inBuffer = false;
            this.mergeBuffer = new Tuple[HashMergeJoin.this.MERGE_BUFFER_SIZE];
            this.sourceIndex = new int[HashMergeJoin.this.MERGE_BUFFER_SIZE];
            this.mergeOutFile = new BufferedOutputStream[2];
            this.lastMergePass = true;
            this.setupPartitionMerge();
        }

        public Tuple merge() throws IOException {
            while (true) {
                if (this.inBuffer) {
                    while (true) {
                        if (this.curBufferPosition < this.numInBuffer) {
                            if (this.smallestRightIndex != this.sourceIndex[this.curBufferPosition]) {
                                return HashMergeJoin.this.outputJoinTuple(this.mergeBuffer[this.curBufferPosition++], this.smallestRight);
                            }
                            ++this.curBufferPosition;
                            continue;
                        }
                        this.curBufferPosition = 0;
                        if (this.getSmallestTuple(1, this.smallestRightIndex) == -1) {
                            this.inBuffer = false;
                            return this.nextPartition();
                        }
                        if (!HashMergeJoin.this.pred.isEqual(this.mergeBuffer[0], this.smallestRight)) break;
                    }
                    this.inBuffer = false;
                    continue;
                }
                if (this.endPartitionInput) break;
                while (true) {
                    if (HashMergeJoin.this.pred.isLessThan(this.smallestLeft, this.smallestRight)) {
                        if (this.getSmallestTuple(0, this.smallestLeftIndex) != -1) continue;
                        return this.nextPartition();
                    }
                    while (HashMergeJoin.this.pred.isGreaterThan(this.smallestLeft, this.smallestRight)) {
                        if (this.getSmallestTuple(1, this.smallestRightIndex) != -1) continue;
                        return this.nextPartition();
                    }
                    if (HashMergeJoin.this.pred.isEqual(this.smallestLeft, this.smallestRight)) break;
                }
                this.numInBuffer = 0;
                do {
                    this.mergeBuffer[this.numInBuffer] = new Tuple(this.smallestLeft);
                    this.sourceIndex[this.numInBuffer] = this.smallestLeftIndex;
                    ++this.numInBuffer;
                    if (this.getSmallestTuple(0, this.smallestLeftIndex) != -1) continue;
                    this.endPartitionInput = true;
                    break;
                } while (HashMergeJoin.this.pred.isEqual(this.smallestLeft, this.smallestRight));
                this.inBuffer = true;
                this.curBufferPosition = 0;
            }
            return this.nextPartition();
        }

        private Tuple nextPartition() throws IOException {
            if (!this.setupPartitionMerge()) {
                return null;
            }
            return this.merge();
        }

        private int getSmallestTuple(int sourceIndex, int lastSmallestIndex) throws IOException {
            int bufferIdx;
            int fileIndex = this.startFileIndex;
            int smallestIndex = -1;
            Tuple smallest = null;
            if (lastSmallestIndex >= 0) {
                if (!this.lastMergePass) {
                    this.buffer[sourceIndex][lastSmallestIndex].write(this.mergeOutFile[sourceIndex]);
                    HashMergeJoin.this.incrementTupleIOs();
                    int[] nArray = this.readCount[sourceIndex];
                    int n = lastSmallestIndex;
                    int n2 = nArray[n];
                    nArray[n] = n2 - 1;
                    if (n2 == 0) {
                        HashMergeJoin.this.incrementPageIOs();
                    }
                }
                boolean bl = this.endInput[sourceIndex][lastSmallestIndex] = !this.buffer[sourceIndex][lastSmallestIndex].read(this.inputFile[sourceIndex][lastSmallestIndex]);
                if (!this.endInput[sourceIndex][lastSmallestIndex]) {
                    HashMergeJoin.this.incrementTupleIOs();
                    int[] nArray = this.readCount[sourceIndex];
                    int n = lastSmallestIndex;
                    int n3 = nArray[n];
                    nArray[n] = n3 - 1;
                    if (n3 == 0) {
                        HashMergeJoin.this.incrementPageIOs();
                        this.readCount[sourceIndex][lastSmallestIndex] = HashMergeJoin.this.BLOCKING_FACTOR - 1;
                    }
                }
            }
            while (fileIndex < this.endFileIndex) {
                bufferIdx = fileIndex - this.startFileIndex;
                if (!this.endInput[sourceIndex][bufferIdx]) {
                    smallest = this.buffer[sourceIndex][bufferIdx];
                    smallestIndex = bufferIdx;
                    break;
                }
                ++fileIndex;
            }
            ++fileIndex;
            while (fileIndex < this.endFileIndex) {
                bufferIdx = fileIndex - this.startFileIndex;
                if (!this.endInput[sourceIndex][bufferIdx] && HashMergeJoin.this.sorter[sourceIndex].compare(this.buffer[sourceIndex][bufferIdx], smallest) < 0) {
                    smallest = this.buffer[sourceIndex][bufferIdx];
                    smallestIndex = bufferIdx;
                }
                ++fileIndex;
            }
            if (sourceIndex == 0) {
                this.smallestLeftIndex = smallestIndex;
                this.smallestLeft = smallest;
            } else {
                this.smallestRightIndex = smallestIndex;
                this.smallestRight = smallest;
            }
            return smallestIndex;
        }

        private boolean setupPartitionMerge() throws IOException {
            int numFiles;
            int bufferIdx;
            int i;
            ArrayList fileNameList;
            if (this.currentPartition != -1) {
                if (!this.lastMergePass) {
                    if (this.smallestLeftIndex != -1) {
                        while (this.getSmallestTuple(0, this.smallestLeftIndex) != -1) {
                        }
                    }
                    if (this.smallestRightIndex != -1) {
                        while (this.getSmallestTuple(1, this.smallestRightIndex) != -1) {
                        }
                    }
                }
                int sourceIndex = 0;
                while (sourceIndex <= 1) {
                    fileNameList = this.partitionFileName[sourceIndex][this.currentPartition];
                    i = this.startFileIndex;
                    while (i < this.endFileIndex) {
                        bufferIdx = i - this.startFileIndex;
                        FileManager.closeFile(this.inputFile[sourceIndex][bufferIdx]);
                        File f = new File((String)fileNameList.get(i));
                        f.delete();
                        ++i;
                    }
                    ++sourceIndex;
                }
                if (HashMergeJoin.this.blocked) {
                    sourceIndex = 0;
                    while (sourceIndex <= 1) {
                        fileNameList = this.partitionFileName[sourceIndex][this.currentPartition];
                        i = this.startFileIndex;
                        while (i < this.endFileIndex) {
                            fileNameList.remove(this.startFileIndex);
                            ++i;
                        }
                        ++sourceIndex;
                    }
                    FileManager.closeFile(this.mergeOutFile[0]);
                    FileManager.closeFile(this.mergeOutFile[1]);
                    return false;
                }
            }
            if (this.lastMergePass) {
                ++this.currentPartition;
                while (this.currentPartition < this.NUM_PARTITIONS && this.partitionFileName[0][this.currentPartition].size() == 0) {
                    ++this.currentPartition;
                }
                if (this.currentPartition == this.NUM_PARTITIONS) {
                    return false;
                }
                this.startFileIndex = 0;
                this.endFileIndex = numFiles = this.partitionFileName[0][this.currentPartition].size();
                boolean bl = this.lastMergePass = numFiles <= HashMergeJoin.this.FAN_IN;
                if (!this.lastMergePass) {
                    this.endFileIndex = HashMergeJoin.this.FAN_IN;
                }
            } else {
                FileManager.closeFile(this.mergeOutFile[0]);
                FileManager.closeFile(this.mergeOutFile[1]);
                this.startFileIndex += HashMergeJoin.this.FAN_IN;
                this.endFileIndex = this.startFileIndex + HashMergeJoin.this.FAN_IN;
                numFiles = this.partitionFileName[0][this.currentPartition].size();
                boolean bl = this.lastMergePass = this.endFileIndex >= numFiles;
                if (this.lastMergePass) {
                    this.endFileIndex = numFiles;
                }
            }
            if (!this.lastMergePass) {
                String fileName = FileManager.createTempFileName("mergeLeft");
                this.mergeOutFile[0] = FileManager.openOutputFile(fileName);
                this.partitionFileName[0][this.currentPartition].add(fileName);
                fileName = FileManager.createTempFileName("mergeRight");
                this.mergeOutFile[1] = FileManager.openOutputFile(fileName);
                this.partitionFileName[1][this.currentPartition].add(fileName);
            }
            System.out.println("Merging files in a partition starting: " + this.startFileIndex + " End: " + this.endFileIndex + " Total files: " + this.partitionFileName[0][this.currentPartition].size());
            int sourceIndex = 0;
            while (sourceIndex <= 1) {
                fileNameList = this.partitionFileName[sourceIndex][this.currentPartition];
                i = this.startFileIndex;
                while (i < this.endFileIndex) {
                    bufferIdx = i - this.startFileIndex;
                    this.inputFile[sourceIndex][bufferIdx] = FileManager.openInputFile((String)fileNameList.get(i));
                    this.endInput[sourceIndex][bufferIdx] = false;
                    if (!this.buffer[sourceIndex][bufferIdx].read(this.inputFile[sourceIndex][bufferIdx])) {
                        this.endInput[sourceIndex][bufferIdx] = true;
                    } else {
                        HashMergeJoin.this.incrementPageIOs();
                        HashMergeJoin.this.incrementTupleIOs();
                        this.readCount[sourceIndex][bufferIdx] = HashMergeJoin.this.BLOCKING_FACTOR - 1;
                    }
                    ++i;
                }
                this.getSmallestTuple(sourceIndex, -1);
                ++sourceIndex;
            }
            this.endPartitionInput = false;
            return true;
        }

        private int hash(Tuple t, int source) {
            int loc;
            int[] currentIdx = source == 0 ? HashMergeJoin.this.keyIdxLeft : HashMergeJoin.this.keyIdxRight;
            if (HashMergeJoin.this.keyType == 1) {
                loc = HashFunc.hash(t.getInt(currentIdx[0]), this.NUM_BUCKETS);
            } else if (HashMergeJoin.this.keyType == 2) {
                loc = HashFunc.hash(t.getString(currentIdx[0]), this.NUM_BUCKETS);
            } else {
                Object[] vals = new Object[HashMergeJoin.this.numAttrs];
                int k = 0;
                while (k < HashMergeJoin.this.numAttrs) {
                    vals[k] = t.getObject(currentIdx[k]);
                    ++k;
                }
                loc = HashFunc.hash(vals, this.NUM_BUCKETS);
            }
            return loc;
        }

        private void flush(int flushIndex) throws IOException {
            int maxFlushSize = this.partitionCount[0][flushIndex] + this.partitionCount[1][flushIndex];
            if (this.partitionCount[0][flushIndex] + this.partitionCount[1][flushIndex] > maxFlushSize) {
                maxFlushSize = this.partitionCount[0][flushIndex] + this.partitionCount[1][flushIndex];
            }
            Tuple[] buffer = new Tuple[maxFlushSize];
            int sourceIndex = 0;
            while (sourceIndex <= 1) {
                int count = 0;
                int bucketNum = flushIndex * HashMergeJoin.this.PARTITION_SIZE;
                while (bucketNum < (flushIndex + 1) * HashMergeJoin.this.PARTITION_SIZE && bucketNum < this.NUM_BUCKETS) {
                    ListIterator it = this.buckets[sourceIndex][bucketNum].listIterator();
                    while (it.hasNext()) {
                        buffer[count++] = (Tuple)it.next();
                    }
                    this.buckets[sourceIndex][bucketNum].clear();
                    ++bucketNum;
                }
                Arrays.sort(buffer, 0, count, HashMergeJoin.this.sorter[sourceIndex]);
                String fileName = FileManager.createTempFileName(String.valueOf(sourceIndex) + "." + flushIndex + "." + this.flushCount[flushIndex]);
                BufferedOutputStream outFile = FileManager.openOutputFile(fileName);
                this.partitionFileName[sourceIndex][flushIndex].add(fileName);
                int i = 0;
                while (i < count) {
                    buffer[i].write(outFile);
                    ++i;
                }
                FileManager.closeFile(outFile);
                HashMergeJoin.this.incrementTupleIOs(count);
                HashMergeJoin.this.incrementPageIOs((int)Math.ceil((double)count / (double)HashMergeJoin.this.BLOCKING_FACTOR));
                this.partitionCount[sourceIndex][flushIndex] = 0;
                this.tupleCount[sourceIndex] = this.tupleCount[sourceIndex] - count;
                ++sourceIndex;
            }
            int n = flushIndex;
            this.flushCount[n] = this.flushCount[n] + 1;
        }

        private int maximumIndex() {
            int max = -1;
            int maxIndex = -1;
            int i = 0;
            while (i < this.NUM_PARTITIONS) {
                int sum = this.partitionCount[0][i] + this.partitionCount[1][i];
                if (sum > max) {
                    max = sum;
                    maxIndex = i;
                }
                ++i;
            }
            return maxIndex;
        }

        private int adaptiveIndex() {
            boolean memoryBalanced;
            boolean bl = memoryBalanced = Math.abs(this.tupleCount[0] - this.tupleCount[1]) < this.B;
            if (memoryBalanced) {
                int max = -1;
                int maxIndex = -1;
                int maxPB = -1;
                int maxPBIndex = -1;
                int i = 0;
                while (i < this.NUM_PARTITIONS) {
                    int sum = this.partitionCount[0][i] + this.partitionCount[1][i];
                    if (sum > max) {
                        max = sum;
                        maxIndex = i;
                    }
                    if (sum > maxPB && Math.abs(this.tupleCount[0] - this.partitionCount[0][i] - (this.tupleCount[1] - this.partitionCount[1][i])) < this.B) {
                        maxPB = sum;
                        maxPBIndex = i;
                    }
                    ++i;
                }
                if (maxPBIndex != maxIndex) {
                    return maxPBIndex;
                }
                return maxIndex;
            }
            int max = -1;
            int maxIndex = -1;
            boolean leftBigger = this.tupleCount[0] > this.tupleCount[1];
            int i = 0;
            while (i < this.NUM_PARTITIONS) {
                int sum = this.partitionCount[0][i] + this.partitionCount[1][i];
                if (sum > max && (leftBigger && this.partitionCount[0][i] < this.partitionCount[1][i] || !leftBigger && this.partitionCount[0][i] > this.partitionCount[1][i])) {
                    max = sum;
                    maxIndex = i;
                }
                ++i;
            }
            if (maxIndex == -1) {
                return this.maximumIndex();
            }
            return maxIndex;
        }
    }
}

