/*
 * Decompiled with CFR 0.152.
 */
package unity.parser;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.globalschema.GlobalSchema;
import unity.jdbc.UnityDriver;
import unity.parser.ASTAll;
import unity.parser.ASTAs;
import unity.parser.ASTMatchConditions;
import unity.parser.ASTMatchFunctions;
import unity.parser.ASTMerge;
import unity.parser.ASTMergeOpcode;
import unity.parser.ASTOrderby;
import unity.parser.ASTSelect;
import unity.parser.ASTStart;
import unity.parser.ASTUnion;
import unity.parser.ASTWhere;
import unity.parser.Node;
import unity.parser.SimpleNode;
import unity.parser.uql;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQMergeNode;
import unity.query.LQNode;
import unity.query.LQTree;
import unity.query.LQTreeBuilder;
import unity.query.LQUnionNode;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class PTreeBuilderValidater {
    private ASTStart parseTreeRoot;
    private GlobalSchema gs;
    private static StringReader sb = new StringReader("");
    private static uql textParser = new uql(sb);

    public PTreeBuilderValidater(GlobalSchema s) {
        this.gs = s;
    }

    public SimpleNode buildPTree(String semQuery) throws SQLException {
        try {
            StringReader sb = new StringReader(semQuery);
            uql.ReInit(sb);
            textParser.parseString();
            this.parseTreeRoot = textParser.gettree();
            return this.parseTreeRoot;
        }
        catch (Exception e) {
            throw new SQLException("Parse Exception: " + e);
        }
    }

    public GlobalQuery validatePTree(String semQuery, SimpleNode parseTreeRoot) throws SQLException {
        GlobalQuery gq = new GlobalQuery();
        LQNode current = null;
        ArrayList<LQTree> lqtrees = new ArrayList<LQTree>();
        SubQuery lastSq = null;
        int i = 0;
        while (i < parseTreeRoot.jjtGetNumChildren()) {
            SimpleNode node = (SimpleNode)parseTreeRoot.jjtGetChild(i);
            if (node instanceof ASTSelect || node instanceof ASTUnion || node instanceof ASTMerge) {
                SubQuery sq = new SubQuery();
                HashMap tableReferences = new HashMap();
                HashMap fieldReferences = new HashMap();
                SimpleNode subQueryRoot = node instanceof ASTSelect ? (SimpleNode)((SimpleNode)parseTreeRoot.jjtGetChild((int)i)).parent : (SimpleNode)parseTreeRoot.jjtGetChild(i);
                this.ParseQuery(subQueryRoot, sq, tableReferences, fieldReferences);
                LQTreeBuilder lqtree = new LQTreeBuilder();
                LQTree lqt = lqtree.BuildLQTree(sq, subQueryRoot, this.gs, tableReferences, fieldReferences);
                lqtrees.add(lqt);
                sq.setLogicalQueryTree(lqt);
                gq.addSubQuery(sq);
                if (node instanceof ASTSelect) {
                    current = lqt.getRoot();
                    lastSq = sq;
                } else if (node instanceof ASTUnion) {
                    LQUnionNode unionNode = new LQUnionNode();
                    unionNode.addChild(current);
                    unionNode.addChild(lqt.getRoot());
                    current = unionNode;
                } else if (node instanceof ASTMerge) {
                    LQCondNode condition;
                    LQMergeNode mergeNode = new LQMergeNode(lastSq, sq);
                    mergeNode.addChild(current);
                    mergeNode.addChild(lqt.getRoot());
                    current = mergeNode;
                    SimpleNode joinNode = null;
                    SimpleNode matchNode = null;
                    SimpleNode whereNode = null;
                    int j = 0;
                    while (j < node.jjtGetNumChildren()) {
                        SimpleNode tmp = (SimpleNode)node.jjtGetChild(j);
                        if (tmp instanceof ASTMergeOpcode) {
                            joinNode = tmp;
                        } else if (tmp instanceof ASTMatchFunctions) {
                            matchNode = tmp;
                        } else if (tmp instanceof ASTMatchConditions) {
                            whereNode = tmp;
                        }
                        ++j;
                    }
                    if (joinNode != null) {
                        SimpleNode jNode = (SimpleNode)joinNode.jjtGetChild(0);
                        if (lqtree.isJoinCondition(jNode)) {
                            condition = lqtree.buildConditionNode(jNode, 200, null);
                            mergeNode.setCondition(condition);
                        } else {
                            throw new SQLException("Only equi-joins supported in merge on clause.");
                        }
                    }
                    if (matchNode != null && matchNode.jjtGetNumChildren() > 0) {
                        ArrayList<LQExprNode> matchFunctions = new ArrayList<LQExprNode>();
                        LQExprNode en = null;
                        SimpleNode snCurrent = (SimpleNode)matchNode.jjtGetChild(0);
                        int k = 1;
                        boolean allFieldsFlag = false;
                        if (snCurrent instanceof ASTAll) {
                            allFieldsFlag = true;
                            if (matchNode.jjtGetNumChildren() > 1) {
                                snCurrent = (SimpleNode)matchNode.jjtGetChild(1);
                                k = 2;
                            }
                        }
                        while (k < matchNode.jjtGetNumChildren()) {
                            SimpleNode snAhead = (SimpleNode)matchNode.jjtGetChild(k);
                            if (snAhead instanceof ASTAs) {
                                matchNode.jjtRemoveChild(k - 1);
                                snCurrent.jjtSetParent(snAhead);
                                snAhead.InsertChild(0, snCurrent);
                                en = lqtree.BuildExpressionNode(200, snAhead, 0, null);
                                snCurrent = k < matchNode.jjtGetNumChildren() ? (SimpleNode)matchNode.jjtGetChild(k) : null;
                            } else {
                                en = lqtree.BuildExpressionNode(200, snCurrent, 0, null);
                                snCurrent = snAhead;
                            }
                            matchFunctions.add(en);
                            ++k;
                        }
                        if (snCurrent != null) {
                            en = lqtree.BuildExpressionNode(200, snCurrent, 0, null);
                            matchFunctions.add(en);
                        }
                        mergeNode.setMatchFunctions(matchFunctions);
                        mergeNode.setOutputAllFields(allFieldsFlag);
                    }
                    if (whereNode != null) {
                        SimpleNode wNode = (SimpleNode)whereNode.jjtGetChild(0);
                        condition = lqtree.buildConditionNode(wNode, 208, mergeNode);
                        mergeNode.setFilterCondition(condition);
                    }
                    lastSq = lastSq == null ? sq : SubQuery.mergeSubqueries(lastSq, sq, mergeNode);
                }
            }
            ++i;
        }
        if (lqtrees.size() == 1) {
            gq.setLogicalQueryTree((LQTree)lqtrees.get(0));
        } else {
            gq.setLogicalQueryTree(new LQTree(current));
        }
        return gq;
    }

    public void ParseQuery(SimpleNode snQueryRoot, SubQuery sq, HashMap tableReferences, HashMap fieldReferences) throws SQLException {
        if (UnityDriver.DEBUG) {
            snQueryRoot.dump("");
        }
        if (snQueryRoot.jjtGetNumChildren() == 1) {
            throw new SQLException("Queries without FROM clause are not supported.");
        }
        int k = 0;
        boolean fromFound = false;
        while (k < snQueryRoot.jjtGetNumChildren()) {
            if (snQueryRoot.jjtGetChild(k).toString().equalsIgnoreCase("FROM")) {
                fromFound = true;
                break;
            }
            ++k;
        }
        if (fromFound) {
            SimpleNode fromClause = (SimpleNode)snQueryRoot.jjtGetChild(k);
            int i = 0;
            while (i < fromClause.jjtGetNumChildren()) {
                String refName;
                ArrayList matches;
                SimpleNode childNode = (SimpleNode)fromClause.jjtGetChild(i);
                String nodeText = childNode.toString();
                String tableName = nodeText.startsWith("Ident") ? nodeText.substring(12, nodeText.length()) : nodeText.substring(8, nodeText.length());
                String tmp = tableName;
                if (tableName.indexOf("\"") < 0) {
                    tmp = tableName.toLowerCase();
                }
                if ((matches = this.gs.findTable(tmp)) == null) {
                    throw new SQLException("Non-existing table referenced: " + tableName);
                }
                if (matches.size() > 1) {
                    throw new SQLException("Ambiguous table reference: " + tableName + " Possible matches: " + matches.toString());
                }
                if (i < fromClause.jjtGetNumChildren() - 1 && ((SimpleNode)fromClause.jjtGetChild(i + 1)).toString().equals("As")) {
                    SimpleNode asNode = (SimpleNode)fromClause.jjtGetChild(i + 1);
                    Node nMoveNode = fromClause.jjtGetChild(i);
                    nMoveNode.jjtSetParent(asNode);
                    fromClause.jjtRemoveChild(i);
                    asNode.InsertChild(0, nMoveNode);
                    refName = asNode.jjtGetChild(1).toString();
                    refName = refName.substring(12, refName.length()).toLowerCase();
                } else {
                    refName = tmp;
                }
                tableReferences.put(refName, matches.get(0));
                AnnotatedSourceTable ast = (AnnotatedSourceTable)matches.get(0);
                String dbName = ast.getParentDatabase().getDatabaseName().toLowerCase();
                GQDatabaseRef dbref = sq.getDBRef(dbName);
                if (dbref == null) {
                    dbref = new GQDatabaseRef((AnnotatedSourceDatabase)ast.getParentDatabase(), dbName, dbName);
                    sq.addDatabaseRef(dbName, dbref);
                }
                sq.addTableRef(refName, new GQTableRef(ast, refName, refName, dbref));
                ++i;
            }
            if (UnityDriver.DEBUG) {
                Iterator iIterate = tableReferences.keySet().iterator();
                while (iIterate.hasNext()) {
                    String strKey = (String)iIterate.next();
                    AnnotatedSourceTable ast = (AnnotatedSourceTable)tableReferences.get(strKey);
                    System.out.println(String.valueOf(strKey) + " maps to " + ast.getParentDatabase().getDatabaseName() + "." + ast.getTableName());
                }
            }
            this.ValidateFields(snQueryRoot, tableReferences, fieldReferences, sq);
        }
    }

    private AnnotatedSourceField validateField(String fieldName, HashMap tableReferences, SubQuery sq) throws SQLException {
        AnnotatedSourceField fieldRef = null;
        String tableRefName = null;
        GQTableRef tref = null;
        String orgFldName = fieldName;
        if (fieldName.indexOf("*") == 0) {
            return null;
        }
        String[] fieldComponents = StringFunc.divideIdentifier(fieldName);
        if (fieldComponents.length > 1) {
            fieldName = fieldComponents[fieldComponents.length - 1];
            tableRefName = fieldComponents[0];
            int k = 1;
            while (k < fieldComponents.length - 1) {
                tableRefName = String.valueOf(tableRefName) + "." + fieldComponents[k];
                ++k;
            }
            tref = sq.getTableRef(tableRefName);
            if (tref == null && fieldComponents.length > 2) {
                tableRefName = fieldComponents.length == 3 ? fieldComponents[1] : String.valueOf(fieldComponents[1]) + "." + fieldComponents[2];
                ArrayList tableMatches = this.gs.findTable(tableRefName);
                if (tableMatches == null) {
                    throw new SQLException("Field: " + orgFldName + " is ambiguous.  No suitable table reference found.");
                }
                if (tableMatches.size() != 1) {
                    throw new SQLException("Field: " + orgFldName + " is ambiguous.  Multiple possible table references in different databases.");
                }
                tableRefName = ((AnnotatedSourceTable)tableMatches.get(0)).getFullName().toLowerCase();
                tref = sq.getTableRef(tableRefName);
            }
            if (tref == null) {
                throw new SQLException("Field: " + orgFldName + " does not have its table declared in the FROM clause.");
            }
            fieldRef = (AnnotatedSourceField)tref.getTable().getField(fieldName);
            if (fieldRef == null) {
                throw new SQLException("Field: " + orgFldName + " is not found in table reference: " + tableRefName);
            }
        } else {
            fieldName = fieldComponents[0];
            ArrayList matches = this.gs.findField(fieldName);
            if (matches == null) {
                throw new SQLException("Field: " + orgFldName + " does not exist in the global schema.");
            }
            int countRefs = 0;
            String savedTableRefName = null;
            Collection values = tableReferences.values();
            Object[] trefs = values.toArray();
            Object[] keys = tableReferences.keySet().toArray();
            int i = 0;
            while (i < matches.size()) {
                AnnotatedSourceField asf = (AnnotatedSourceField)matches.get(i);
                AnnotatedSourceTable fieldTable = (AnnotatedSourceTable)asf.getParentTable();
                int k = 0;
                while (k < trefs.length) {
                    if (trefs[k] == fieldTable) {
                        fieldRef = asf;
                        savedTableRefName = (String)keys[k];
                        ++countRefs;
                    }
                    ++k;
                }
                ++i;
            }
            if (countRefs == 0) {
                throw new SQLException("Field: " + orgFldName + " is not a valid field based on tables in the query.");
            }
            if (countRefs > 1) {
                throw new SQLException("Field: " + orgFldName + " is ambiguous.  Multiple possible table references for the query.");
            }
            tref = sq.getTableRef(savedTableRefName);
            tableRefName = savedTableRefName;
        }
        GQFieldRef gqfref = null;
        String fullName = tableRefName != null ? String.valueOf(tableRefName) + "." + fieldName : fieldName;
        if (sq.getFieldRef(fullName) == null) {
            gqfref = new GQFieldRef(fieldRef, fieldName, fullName, tref);
            sq.addFieldRef(fullName, gqfref);
            String canonicalName = fieldComponents[0];
            int k = 1;
            while (k < fieldComponents.length - 1) {
                canonicalName = String.valueOf(canonicalName) + "." + fieldComponents[k];
                ++k;
            }
            if (!canonicalName.equals(fullName)) {
                sq.addFieldRef(canonicalName, gqfref);
            }
        }
        return fieldRef;
    }

    public void ValidateFields(SimpleNode snQueryRoot, HashMap tableReferences, HashMap fieldReferences, SubQuery sq) throws SQLException {
        if (UnityDriver.DEBUG) {
            System.out.println("\nValidation starts for fields in SELECT and WHERE clause.\n");
        }
        int k = 0;
        while (k < snQueryRoot.jjtGetNumChildren()) {
            if (snQueryRoot.jjtGetChild(k) instanceof ASTSelect) break;
            ++k;
        }
        ArrayList identifiers = new ArrayList();
        SimpleNode SelectNode = (SimpleNode)snQueryRoot.jjtGetChild(k);
        if (((SimpleNode)SelectNode.jjtGetChild(0)).toString().indexOf("Identifier: *") == -1) {
            this.getIdentifiers((SimpleNode)snQueryRoot.jjtGetChild(k), identifiers, new ArrayList());
            int i = 0;
            while (i < identifiers.size()) {
                String fieldName = (String)identifiers.get(i);
                fieldReferences.put(fieldName, this.validateField(fieldName, tableReferences, sq));
                ++i;
            }
        } else {
            HashMap subqueryTableRefs = sq.getTableRefs();
            Iterator iIterate = subqueryTableRefs.keySet().iterator();
            while (iIterate.hasNext()) {
                String strKey = (String)iIterate.next();
                GQTableRef tref = (GQTableRef)subqueryTableRefs.get(strKey);
                AnnotatedSourceTable ast = tref.getTable();
                Iterator iIterateFields = ast.getSourceFields().keySet().iterator();
                while (iIterateFields.hasNext()) {
                    String strKey2 = (String)iIterateFields.next();
                    AnnotatedSourceField asf = (AnnotatedSourceField)ast.getSourceFields().get(strKey2);
                    String strFieldFullName = asf.getFullSQLColumnName();
                    GQFieldRef gqfref = new GQFieldRef(asf, asf.getName(), strFieldFullName, tref);
                    sq.addFieldRef(asf.getName(), gqfref);
                    sq.addFieldRef(strFieldFullName, gqfref);
                    fieldReferences.put(asf.getName(), asf);
                }
            }
        }
        boolean whereFound = false;
        while (k < snQueryRoot.jjtGetNumChildren()) {
            if (snQueryRoot.jjtGetChild(k) instanceof ASTWhere) {
                whereFound = true;
                break;
            }
            ++k;
        }
        if (whereFound) {
            identifiers.clear();
            this.getIdentifiers((SimpleNode)snQueryRoot.jjtGetChild(k), identifiers, new ArrayList());
            int i = 0;
            while (i < identifiers.size()) {
                String fieldName = (String)identifiers.get(i);
                fieldReferences.put(fieldName, this.validateField(fieldName, tableReferences, sq));
                ++i;
            }
        }
        boolean orderByFound = false;
        while (k < snQueryRoot.jjtGetNumChildren()) {
            if (snQueryRoot.jjtGetChild(k) instanceof ASTOrderby) {
                orderByFound = true;
                break;
            }
            ++k;
        }
        if (orderByFound) {
            identifiers.clear();
            this.getIdentifiers((SimpleNode)snQueryRoot.jjtGetChild(k), identifiers, new ArrayList());
            int i = 0;
            while (i < identifiers.size()) {
                String fieldName = (String)identifiers.get(i);
                fieldReferences.put(fieldName, this.validateField(fieldName, tableReferences, sq));
                ++i;
            }
        }
    }

    private void getIdentifiers(SimpleNode root, ArrayList identifiers, ArrayList nodeRefs) {
        if (root == null) {
            return;
        }
        String nodeText = root.toString();
        String lowerNodeText = nodeText.toLowerCase();
        if (lowerNodeText.startsWith("identifier: ") || lowerNodeText.startsWith("string: \"")) {
            nodeText = lowerNodeText.startsWith("ident") ? nodeText.substring(12, nodeText.length()) : nodeText.substring(8, nodeText.length());
            identifiers.add(nodeText);
            nodeRefs.add(root);
        } else if (!lowerNodeText.startsWith("as")) {
            int i = 0;
            while (i < root.jjtGetNumChildren()) {
                this.getIdentifiers((SimpleNode)root.jjtGetChild(i), identifiers, nodeRefs);
                ++i;
            }
        }
    }
}

