/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityResultSet;
import unity.query.GlobalQuery;
import unity.query.LocalQuery;
import unity.query.ResultRowData;

public class Evaluator {
    private GlobalQuery globalQuery;

    public Evaluator(GlobalQuery gq) {
        this.globalQuery = gq;
    }

    public UnityResultSet execute(int resultSetType, int resultSetConcurrency) throws SQLException {
        ArrayList localQueries = this.globalQuery.getLocalQueries();
        int numQueries = localQueries.size();
        if (numQueries > 1) {
            Thread[] t = new Thread[numQueries];
            int i = 0;
            while (i < numQueries) {
                t[i] = null;
                QueryThread qt = new QueryThread((LocalQuery)localQueries.get(i));
                t[i] = new Thread(qt);
                t[i].start();
                ++i;
            }
        } else {
            LocalQuery lqry = (LocalQuery)localQueries.get(0);
            lqry.setResultSetType(resultSetType);
            lqry.setResultSetConcurrency(resultSetConcurrency);
            lqry.execute();
        }
        ResultRowData rrd = new ResultRowData(this.globalQuery, resultSetType);
        UnityResultSet urs = new UnityResultSet(rrd);
        return urs;
    }

    private class QueryThread
    implements Runnable {
        private LocalQuery localquery;

        public QueryThread(LocalQuery lq) {
            this.localquery = lq;
        }

        public void run() {
            if (UnityDriver.DEBUG) {
                System.out.println("Started local query: " + this.localquery.getSQLQueryString());
            }
            try {
                long startTime = System.currentTimeMillis();
                this.localquery.execute();
                long endTime = System.currentTimeMillis();
                if (UnityDriver.DEBUG) {
                    System.out.println("Finished query at: " + (endTime - startTime));
                }
            }
            catch (Exception e) {
                this.localquery.setErrorMessage("Local query execution error: " + e);
            }
        }
    }
}

