/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.jdbc.UnityDriver;
import unity.operators.BufferOperator;
import unity.operators.DistributedJoin;
import unity.operators.DynamicHashJoin;
import unity.operators.EarlyHashJoin;
import unity.operators.NestedLoopJoin;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.EquiJoinPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.LQCondNode;
import unity.query.LQNode;
import unity.relational.Relation;

public class LQJoinNode
extends LQNode {
    protected LQCondNode conditionRoot;
    protected double cost;
    protected int numTuples;
    protected int tupleSize;
    protected double penaltyFactor;
    protected int joinType;
    protected boolean swapChildren = false;
    protected boolean noDistributedJoin = false;
    protected int oneSideRelation;
    protected ArrayList leftFields;
    protected ArrayList rightFields;
    protected boolean isRightOuterJoin;
    protected boolean isLeftOuterJoin;

    public LQJoinNode() {
        this.type = 207;
        this.joinType = 304;
    }

    public void setLeftFields(ArrayList a) {
        this.leftFields = a;
    }

    public void setRightFields(ArrayList a) {
        this.rightFields = a;
    }

    public int getOneSideRelation() {
        return this.oneSideRelation;
    }

    public void setNoDistributedJoin(boolean b) {
        this.noDistributedJoin = b;
    }

    public boolean getNoDistributedJoin() {
        return this.noDistributedJoin;
    }

    public void setSwap() {
        this.swapChildren = true;
    }

    public void setJoinType(int jtype) {
        this.joinType = jtype;
    }

    public void setCondition(LQCondNode cond) {
        this.conditionRoot = cond;
    }

    public LQCondNode getCondition() {
        return this.conditionRoot;
    }

    public String generateSQL() {
        return this.conditionRoot.generateSQL();
    }

    private boolean is1NJoin() {
        boolean is1NJoin = false;
        AnnotatedSourceTable leftRelation = ((GQFieldRef)this.leftFields.get(0)).getTable().getTable();
        AnnotatedSourceTable rightRelation = ((GQFieldRef)this.rightFields.get(0)).getTable().getTable();
        ArrayList<AnnotatedSourceField> leftFieldsASF = new ArrayList<AnnotatedSourceField>(this.leftFields.size());
        ArrayList<AnnotatedSourceField> rightFieldsASF = new ArrayList<AnnotatedSourceField>(this.rightFields.size());
        int i = 0;
        while (i < this.leftFields.size()) {
            leftFieldsASF.add(((GQFieldRef)this.leftFields.get(i)).getField());
            rightFieldsASF.add(((GQFieldRef)this.rightFields.get(i)).getField());
            ++i;
        }
        if (leftRelation.isPrimaryKey(leftFieldsASF)) {
            return true;
        }
        if (rightRelation.isPrimaryKey(rightFieldsASF)) {
            return true;
        }
        return is1NJoin;
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        EquiJoinPredicate predicate = null;
        if (this.conditionRoot != null) {
            predicate = this.conditionRoot.buildJoinPredicate(children, this);
        }
        this.outputRelation = new Relation(((LQNode)this.children.get(0)).getOutputRelation());
        this.outputRelation.mergeRelation(((LQNode)this.children.get(1)).getOutputRelation());
        if (this.joinType == 301) {
            int blockingFactor = 10;
            int bufferSizeTuples = (int)this.memorySizeTuples / blockingFactor;
            if (bufferSizeTuples < 1000) {
                bufferSizeTuples = 1000 / blockingFactor;
            }
            int numBuckets = 23;
            if (UnityDriver.DEBUG) {
                System.out.println("Allocating join memory size of: " + bufferSizeTuples * 10);
            }
            return new DynamicHashJoin(children, predicate, bufferSizeTuples, blockingFactor, numBuckets);
        }
        if (this.joinType == 303 || this.joinType == 304) {
            int blockingFactor = 10;
            int bufferSizeTuples = (int)this.memorySizeTuples;
            if (bufferSizeTuples < 1000) {
                bufferSizeTuples = 1000;
            }
            boolean isMNJoin = !this.is1NJoin();
            int numPartitions = 23;
            int leftRead1 = 1;
            int rightRead1 = 1;
            int leftRead2 = 10;
            int rightRead2 = 1;
            boolean useBGTable = false;
            double tableScaleFactor = 1.0;
            if (UnityDriver.DEBUG) {
                System.out.println("Allocating join memory size of: " + bufferSizeTuples + " 1:N join? " + !isMNJoin);
            }
            Operator[] childOps = children;
            if (this.joinType == 303) {
                int MAX_BUF_SIZE = 5000;
                childOps = new Operator[]{new BufferOperator(children[0], MAX_BUF_SIZE, MAX_BUF_SIZE / 2, MAX_BUF_SIZE / 3), new BufferOperator(children[1], MAX_BUF_SIZE, MAX_BUF_SIZE / 2, MAX_BUF_SIZE / 3)};
            }
            EarlyHashJoin ehj = new EarlyHashJoin(childOps, predicate, bufferSizeTuples, blockingFactor, numPartitions, isMNJoin, leftRead1, rightRead1, leftRead2, rightRead2, useBGTable, tableScaleFactor, this.isLeftOuterJoin, this.isRightOuterJoin);
            this.setOperator(ehj);
            return ehj;
        }
        if (this.joinType == 302) {
            GQDatabaseRef dbref = null;
            if (this.swapChildren) {
                dbref = (GQDatabaseRef)((LQNode)this.children.get(0)).getReference();
                ((ResultSetScan)children[0]).setDelayedExecution(true);
            } else {
                dbref = (GQDatabaseRef)((LQNode)this.children.get(1)).getReference();
                ((ResultSetScan)children[1]).setDelayedExecution(true);
            }
            DistributedJoin dhj = new DistributedJoin(children, predicate, dbref, this.swapChildren);
            this.setOperator(dhj);
            return dhj;
        }
        if (this.joinType == 305) {
            int bufferSizeTuples = 50001;
            NestedLoopJoin nlj = new NestedLoopJoin(children, predicate, bufferSizeTuples);
            nlj.setOutputRelation(this.outputRelation);
            return nlj;
        }
        return null;
    }

    public String toString() {
        String joinString = "";
        if (this.joinType == 301) {
            joinString = "Dynamic Hash";
        } else if (this.joinType == 302) {
            joinString = "Distributed";
        } else if (this.joinType == 303) {
            joinString = "Early Hash";
        } else if (this.joinType == 304) {
            joinString = "Early Hash (not buffered)";
        } else if (this.joinType == 305) {
            joinString = "Nested Loop Join";
        }
        String conditionString = "";
        if (this.conditionRoot != null) {
            conditionString = this.conditionRoot.generateSQL();
        }
        return "JOIN:    " + conditionString + "type: " + joinString;
    }

    public ArrayList getRequiredFields() {
        return this.conditionRoot.getRequiredFields();
    }

    public double getCost() {
        return this.cost;
    }

    public void computeCost() {
        this.numTuples = this.numTuples();
        this.tupleSize = this.tupleSize();
        this.cost = this.penaltyFactor * (double)this.numTuples * (double)this.tupleSize;
    }

    public int getNumTuples() {
        return this.numTuples;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public int numTuples() {
        int ltuples = ((LQNode)this.children.get(0)).numTuples();
        int rtuples = ((LQNode)this.children.get(1)).numTuples();
        if (this.conditionRoot == null) {
            return ltuples * rtuples;
        }
        LQNode lchild = this.conditionRoot.getChild(0);
        LQNode rchild = this.conditionRoot.getChild(1);
        if (lchild.getType() == 114) {
            lchild = this.conditionRoot.getChild(0).getChild(0);
            rchild = this.conditionRoot.getChild(0).getChild(1);
        }
        if (rchild.getContent() instanceof String) {
            return ltuples * rtuples;
        }
        GQFieldRef rfield = (GQFieldRef)rchild.getContent();
        GQFieldRef lfield = (GQFieldRef)lchild.getContent();
        this.penaltyFactor = rfield.getTable().getParentDB() != lfield.getTable().getParentDB() ? 10.0 : 1.0;
        int ldistinct = lfield.getField().getNumDistinctValues();
        int rdistinct = rfield.getField().getNumDistinctValues();
        if (ltuples > rtuples) {
            LQNode tmp = this.getChild(1);
            this.setChild(1, this.getChild(0));
            this.setChild(0, tmp);
            tmp = this.conditionRoot.getChild(1);
            this.conditionRoot.setChild(1, this.conditionRoot.getChild(0));
            this.conditionRoot.setChild(0, tmp);
        }
        double estimate = ldistinct <= 0 && rdistinct <= 0 ? (double)(Math.max(ltuples, rtuples) * 10) : 1.0 * (double)ltuples * (double)rtuples / (double)Math.max(ldistinct, rdistinct);
        return (int)estimate;
    }

    public int tupleSize() {
        return ((LQNode)this.children.get(0)).tupleSize() + ((LQNode)this.children.get(1)).tupleSize();
    }
}

