/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.functions.Expression;
import unity.operators.MatchOperator;
import unity.operators.Operator;
import unity.operators.Selection;
import unity.predicates.MatchPredicate;
import unity.predicates.SelectionPredicate;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQJoinNode;
import unity.query.SubQuery;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQMergeNode
extends LQJoinNode {
    private ArrayList matchFuncs;
    private LQCondNode whereCond;
    private SubQuery leftSubquery;
    private SubQuery rightSubquery;
    private boolean outputAllFields;

    public LQMergeNode(SubQuery leftSQ, SubQuery rightSQ) {
        this.type = 200;
        this.joinType = 304;
        this.isLeftOuterJoin = true;
        this.isRightOuterJoin = true;
        this.matchFuncs = null;
        this.whereCond = null;
        this.leftSubquery = leftSQ;
        this.rightSubquery = rightSQ;
        this.outputAllFields = false;
    }

    public void setMatchFunctions(ArrayList f) {
        this.matchFuncs = f;
    }

    public ArrayList getMatchFunctions() {
        return this.matchFuncs;
    }

    public LQExprNode findMatchFunction(LQExprNode func) {
        String funcStr = func.toString();
        int i = 0;
        while (i < this.matchFuncs.size()) {
            LQExprNode en = (LQExprNode)this.matchFuncs.get(i);
            if (en.toString().equals(funcStr)) {
                return en;
            }
            ++i;
        }
        return null;
    }

    public void setFilterCondition(LQCondNode c) {
        this.whereCond = c;
    }

    public LQCondNode getFilterCondition() {
        return this.whereCond;
    }

    public String generateSQL() {
        return "";
    }

    public void setOutputAllFields(boolean b) {
        this.outputAllFields = b;
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        int q2Offset = children[0].getOutputRelation().getNumAttributes();
        if (this.conditionRoot == null) {
            this.joinType = 305;
        } else {
            this.conditionRoot.validateMerge(this.leftSubquery, this.rightSubquery);
        }
        Operator joinOp = super.buildOperator(children);
        Relation joinOutputRelation = joinOp.getOutputRelation();
        Relation leftRelation = this.leftSubquery.getLogicalQueryTree().getRoot().getOutputRelation();
        Relation rightRelation = this.rightSubquery.getLogicalQueryTree().getRoot().getOutputRelation();
        Expression[] funcs = null;
        Relation matchFuncRelation = null;
        if (this.matchFuncs != null) {
            funcs = new Expression[this.matchFuncs.size()];
            Attribute[] attrs = new Attribute[this.matchFuncs.size()];
            int i = 0;
            while (i < this.matchFuncs.size()) {
                LQExprNode en = (LQExprNode)this.matchFuncs.get(i);
                ArrayList exprNodes = LQMergeNode.getAllExprNodes(en);
                int j = 0;
                while (j < exprNodes.size()) {
                    LQCondNode.validateExpression((LQExprNode)exprNodes.get(j), leftRelation, rightRelation, q2Offset, null);
                    ++j;
                }
                Attribute outputAttribute = new Attribute();
                funcs[i] = en.buildExpression(joinOutputRelation, outputAttribute);
                attrs[i] = outputAttribute;
                ++i;
            }
            matchFuncRelation = new Relation(attrs);
        }
        MatchPredicate pred = new MatchPredicate(funcs);
        this.outputRelation = pred.generateOutputRelation(joinOutputRelation, this.outputAllFields, matchFuncRelation);
        MatchOperator matchOp = new MatchOperator(joinOp, pred);
        matchOp.setOutputRelation(this.outputRelation);
        if (this.whereCond != null) {
            this.whereCond.validateFilter(this.leftSubquery, this.rightSubquery, this.outputRelation);
            SelectionPredicate predicate = this.whereCond.buildSelectionPredicate(this.outputRelation);
            Selection filterOp = new Selection(matchOp, predicate);
            filterOp.setOutputRelation(this.outputRelation);
            return filterOp;
        }
        return matchOp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1000);
        String conditionString = "";
        if (this.conditionRoot != null) {
            conditionString = this.conditionRoot.generateSQL();
        }
        buf.append("MERGE:    " + conditionString + " EXTRACT: ");
        if (this.matchFuncs == null) {
            buf.append(" (none) ");
        } else {
            if (this.matchFuncs.size() > 0) {
                buf.append(((LQExprNode)this.matchFuncs.get(0)).generateSQL());
            }
            int i = 1;
            while (i < this.matchFuncs.size()) {
                LQExprNode en = (LQExprNode)this.matchFuncs.get(i);
                buf.append(", " + en.generateSQL());
                ++i;
            }
        }
        if (this.whereCond != null) {
            buf.append(" WHERE " + this.whereCond.generateSQL());
        }
        return buf.toString();
    }
}

