/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.functions.Expression;
import unity.jdbc.UnityDriver;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.predicates.ExprSortComparator;
import unity.predicates.SortComparator;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQOrderByNode
extends LQNode {
    private ArrayList orderList;
    private ArrayList sortOrderList;
    private boolean projectLast;

    public LQOrderByNode() {
        this.type = 4;
        this.orderList = new ArrayList();
        this.sortOrderList = new ArrayList();
        this.projectLast = false;
    }

    public void addExpression(LQExprNode exprNode, String direction) {
        this.orderList.add(exprNode);
        this.sortOrderList.add(direction);
    }

    public String generateSQL() {
        if (this.orderList == null || this.orderList.size() == 0) {
            return "";
        }
        String result = String.valueOf(((LQExprNode)this.orderList.get(0)).generateSQL()) + " " + this.sortOrderList.get(0);
        int i = 1;
        while (i < this.orderList.size()) {
            LQExprNode child = (LQExprNode)this.orderList.get(i);
            result = String.valueOf(result) + ", " + child.generateSQL() + " " + this.sortOrderList.get(i);
            ++i;
        }
        return result;
    }

    public String toString() {
        return "ORDER BY: " + this.generateSQL();
    }

    public boolean getProjectLast() {
        return this.projectLast;
    }

    public void setProjectLast(boolean b) {
        this.projectLast = b;
    }

    public Operator buildOperator(Operator[] children) throws SQLException {
        int[] fieldLocs = new int[this.orderList.size()];
        boolean[] ascDesc = new boolean[this.orderList.size()];
        boolean simpleFieldOnlySort = true;
        Relation inputRelation = children[0].getOutputRelation();
        int i = 0;
        while (i < this.orderList.size()) {
            LQExprNode en = (LQExprNode)this.orderList.get(i);
            if (en.getType() != 100) {
                simpleFieldOnlySort = false;
            } else if (simpleFieldOnlySort) {
                fieldLocs[i] = inputRelation.getAttributeIndex(en.getContent());
            }
            String type = (String)this.sortOrderList.get(i);
            ascDesc[i] = type.equals("ASC");
            ++i;
        }
        SortComparator sorter = null;
        if (!simpleFieldOnlySort) {
            Expression[] exprList = new Expression[this.orderList.size()];
            int i2 = 0;
            while (i2 < this.orderList.size()) {
                LQExprNode en = (LQExprNode)this.orderList.get(i2);
                exprList[i2] = en.buildExpression(inputRelation, new Attribute());
                ++i2;
            }
            sorter = new ExprSortComparator(exprList, ascDesc);
        } else {
            sorter = new SortComparator(fieldLocs, ascDesc);
        }
        int bsize = (int)(this.memorySizeTuples / 10L);
        if (UnityDriver.DEBUG) {
            System.out.println("Allocating sort memory size of: " + bsize * 10);
        }
        int bfr = 10;
        MergeSort mergeSortOp = new MergeSort(children[0], bsize, bfr, sorter);
        this.setOperator(mergeSortOp);
        this.outputRelation = new Relation(inputRelation);
        return mergeSortOp;
    }

    public ArrayList getRequiredFields(ArrayList requiredFields) {
        int i = 0;
        while (i < this.orderList.size()) {
            LQExprNode child = (LQExprNode)this.orderList.get(i);
            if (child.getType() == 100) {
                requiredFields.add(child.getContent());
            }
            ++i;
        }
        return requiredFields;
    }

    public String getDirection(int index) {
        if (this.sortOrderList != null) {
            return (String)this.sortOrderList.get(index);
        }
        return "ASC";
    }

    public int getOrderNumChildren() {
        return this.orderList.size() == 0 ? 0 : this.orderList.size();
    }

    public LQNode getOrderChild(int index) {
        return index >= this.getOrderNumChildren() || index < 0 ? null : (LQNode)this.orderList.get(index);
    }

    public int numTuples() {
        return ((LQNode)this.children.get(0)).numTuples();
    }
}

