/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.functions.Expression;
import unity.operators.Operator;
import unity.operators.Projection;
import unity.query.GQFieldRef;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.relational.Attribute;
import unity.relational.Relation;

public class LQProjNode
extends LQNode {
    private ArrayList selList = new ArrayList();

    public LQProjNode() {
        this.type = 1;
    }

    public void addExpression(LQExprNode exprNode) {
        this.selList.add(exprNode);
    }

    public void addNoDupExpression(LQExprNode newExprNode) {
        int i = 0;
        while (i < this.selList.size()) {
            LQExprNode expr = (LQExprNode)this.selList.get(i);
            if (expr.getContent() == newExprNode.getContent()) {
                return;
            }
            ++i;
        }
        this.selList.add(newExprNode);
    }

    public boolean hasExpression(String st) {
        int i = 0;
        while (i < this.selList.size()) {
            String expr = ((LQExprNode)this.selList.get(i)).generateSQL();
            if (st.indexOf(expr) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String generateSQL() {
        if (this.selList == null || this.selList.size() == 0) {
            return "";
        }
        String result = ((LQExprNode)this.selList.get(0)).generateSQL();
        int i = 1;
        while (i < this.selList.size()) {
            LQExprNode child = (LQExprNode)this.selList.get(i);
            result = String.valueOf(result) + ", " + child.generateSQL();
            ++i;
        }
        return result;
    }

    public String toString() {
        return "PROJECT: " + this.generateSQL();
    }

    public Relation buildOutputRelation() {
        Attribute[] attr = new Attribute[this.selList.size()];
        int i = 0;
        while (i < this.selList.size()) {
            attr[i] = ((LQExprNode)this.selList.get(i)).buildAttribute();
            ++i;
        }
        this.outputRelation = new Relation(attr);
        return this.outputRelation;
    }

    public Operator buildOperator(Operator[] opchildren) throws SQLException {
        Attribute[] attr = new Attribute[this.selList.size()];
        Relation inputRelation = ((LQNode)this.children.get(0)).getOutputRelation();
        Expression[] exprList = new Expression[this.selList.size()];
        int i = 0;
        while (i < this.selList.size()) {
            attr[i] = new Attribute();
            exprList[i] = ((LQExprNode)this.selList.get(i)).buildExpression(inputRelation, attr[i]);
            ++i;
        }
        this.outputRelation = new Relation(attr);
        Projection projOp = new Projection(opchildren[0], exprList, this.outputRelation);
        this.setOperator(projOp);
        return projOp;
    }

    public ArrayList getProjectedFields(ArrayList projectFields) {
        int i = 0;
        while (i < this.selList.size()) {
            LQExprNode child = (LQExprNode)this.selList.get(i);
            if (child.getType() == 100) {
                projectFields.add(child.getContent());
            } else {
                this.CollectIdentifierExpression(child, projectFields);
            }
            ++i;
        }
        return projectFields;
    }

    public void CollectIdentifierExpression(LQExprNode lqNode, ArrayList projectFields) {
        if (lqNode.getType() == 100) {
            projectFields.add(lqNode.getContent());
        }
        int j = 0;
        while (j < lqNode.getNumChildren()) {
            this.CollectIdentifierExpression((LQExprNode)lqNode.getChild(j), projectFields);
            ++j;
        }
    }

    public ArrayList getExpressions() {
        return this.selList;
    }

    public ArrayList getRequiredFields() {
        ArrayList a = new ArrayList();
        return this.getProjectedFields(a);
    }

    public int numTuples() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).numTuples();
        }
        return -9;
    }

    public int tupleSize() {
        int totalSize = 0;
        int i = 0;
        while (i < this.selList.size()) {
            LQExprNode child = (LQExprNode)this.selList.get(i);
            if (child.getType() == 100) {
                GQFieldRef fref = (GQFieldRef)child.getContent();
                int size = fref.getField().getColumnSize();
                totalSize += size;
            } else {
                totalSize += 10;
            }
            ++i;
        }
        return totalSize;
    }
}

