/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import unity.util.CryptoModule;
import unity.util.FindMac;

public class VerifySystem {
    private static String expiryDate;

    public static void verifyReg() throws SQLException {
    }

    private static int verify() {
        if (!VerifySystem.FileExistsinJar("k.class") || !VerifySystem.FileExistsinJar("s.class")) {
            System.out.println("Cannot find files in JAR.");
            return 2;
        }
        String key = VerifySystem.getKey();
        if (key == null || key.length() != 8) {
            System.out.println("Improper key length.");
            return 2;
        }
        if (VerifySystem.FileExistsinJar("t.class")) {
            Date expirationDate;
            expiryDate = VerifySystem.getExpiryDate();
            if (expiryDate == null) {
                System.out.println("Null expiry date for trial version.");
                return 2;
            }
            if (expiryDate.equals("0")) {
                return 0;
            }
            Date currentDate = new Date();
            try {
                DateFormat fmt = DateFormat.getDateInstance();
                expirationDate = fmt.parse(expiryDate);
            }
            catch (Exception e) {
                System.out.println("Exception: " + e);
                return 2;
            }
            if (currentDate.after(expirationDate)) {
                return 1;
            }
            return 0;
        }
        String fileMachineid = VerifySystem.getMachineId();
        String localMachineid = VerifySystem.getSystemId();
        if (fileMachineid != null && localMachineid != null) {
            if (fileMachineid.equals(localMachineid)) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    public static String getSystemId() {
        String mac = FindMac.getMacAddress().substring(1);
        return mac;
    }

    public static boolean FileExistsinJar(String name) {
        JarEntry ze;
        try {
            JarFile jarFile = new JarFile("UnityJDBC.jar");
            ze = jarFile.getJarEntry(name);
            jarFile.close();
        }
        catch (Exception ex) {
            return false;
        }
        return ze != null;
    }

    public static String getExpiryDate() {
        CryptoModule crypt = new CryptoModule();
        String tdate = crypt.decrypt(VerifySystem.getStringFromJarFile("t.class"));
        return tdate;
    }

    public static String getKey() {
        CryptoModule crypt = new CryptoModule();
        String key = crypt.decrypt(VerifySystem.getStringFromJarFile("k.class"));
        return key;
    }

    public static String getMachineId() {
        CryptoModule crypt = new CryptoModule();
        String machineId = crypt.decrypt(VerifySystem.getStringFromJarFile("s.class"));
        return machineId;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromJarFile(String fileName) {
        String ret = null;
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile("UnityJDBC.jar");
                JarEntry ze = jarFile.getJarEntry(fileName);
                InputStream is = jarFile.getInputStream(ze);
                byte[] buf = new byte[2000];
                is.read(buf);
                ret = new String(buf);
            }
            catch (Exception e) {
                String string = null;
                Object var6_8 = null;
                try {
                    if (jarFile == null) return string;
                    jarFile.close();
                    return string;
                }
                catch (IOException e2) {
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {}
            catch (IOException e2) {
                return null;
            }
            if (jarFile == null) throw throwable;
            jarFile.close();
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (IOException e2) {
            return null;
        }
        if (jarFile == null) return ret;
        jarFile.close();
        return ret;
    }
}

