/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.domapi;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.domapi.XPathResultImpl;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathExpression;

public class XPathExpressionImpl
implements XPathExpression {
    private PrefixResolver m_resolver;
    private XPath m_xpath;
    private Document m_doc = null;

    XPathExpressionImpl(XPath xpath, Document doc) {
        this.m_xpath = xpath;
        this.m_doc = doc;
    }

    public Object evaluate(Node contextNode, short type, Object result) throws XPathException, DOMException {
        if (this.m_doc != null) {
            if (contextNode != this.m_doc && !contextNode.getOwnerDocument().equals(this.m_doc)) {
                String fmsg = XSLMessages.createXPATHMessage("ER_WRONG_DOCUMENT", null);
                throw new DOMException(4, fmsg);
            }
            short nodeType = contextNode.getNodeType();
            if (nodeType != 9 && nodeType != 1 && nodeType != 2 && nodeType != 3 && nodeType != 4 && nodeType != 8 && nodeType != 7 && nodeType != 13) {
                String fmsg = XSLMessages.createXPATHMessage("ER_WRONG_NODETYPE", null);
                throw new DOMException(9, fmsg);
            }
        }
        if (!XPathResultImpl.isValidType(type)) {
            String fmsg = XSLMessages.createXPATHMessage("ER_INVALID_XPATH_TYPE", new Object[]{new Integer(type)});
            throw new XPathException(2, fmsg);
        }
        XPathContext xpathSupport = new XPathContext();
        if (null != this.m_doc) {
            xpathSupport.getDTMHandleFromNode(this.m_doc);
        }
        XObject xobj = null;
        try {
            xobj = this.m_xpath.execute(xpathSupport, contextNode, this.m_resolver);
        }
        catch (TransformerException te) {
            throw new XPathException(1, te.getMessageAndLocation());
        }
        return new XPathResultImpl(type, xobj, contextNode);
    }
}

