/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.util.ArrayList;
import unity.operators.Operator;
import unity.query.LQNode;
import unity.query.LQTreeConstants;
import unity.util.StringFunc;

public class LQTree
implements LQTreeConstants {
    private LQNode lqtroot;
    private ArrayList joinList;

    public LQTree(LQNode root) {
        this.lqtroot = root;
        this.joinList = new ArrayList();
    }

    public LQNode getRoot() {
        return this.lqtroot;
    }

    public ArrayList getJoinList() {
        return this.joinList;
    }

    public void setJoinList(ArrayList a) {
        this.joinList = a;
    }

    public void setRoot(LQNode newRoot) {
        this.lqtroot = newRoot;
    }

    public static void printProgressTree(LQNode root) {
        LQTree.printPTree(root, 1);
    }

    public static void printPTree(LQNode root, int depth) {
        int perc;
        int tupOutput;
        int sizeEst;
        Operator op = root.getOperator();
        if (op != null) {
            sizeEst = root.numTuples();
            tupOutput = root.getOperator().getTuplesOutput();
            perc = 0;
            if (sizeEst > 0) {
                perc = 100 * tupOutput / sizeEst;
            }
        } else {
            return;
        }
        System.out.println(String.valueOf(StringFunc.spaces(depth * 4)) + root.toString() + " Progress: " + tupOutput + " / " + sizeEst + " (" + perc + "%)");
        int newDepth = depth;
        if (root.getNumChildren() > 1) {
            ++newDepth;
        }
        int i = 0;
        while (i < root.getNumChildren()) {
            LQTree.printPTree(root.getChild(i), newDepth);
            ++i;
        }
    }

    public void print() {
        LQTree.printTree(this.lqtroot, 0);
    }

    public static void printTree(LQNode root, int depth) {
        System.out.println(String.valueOf(StringFunc.spaces(depth * 4)) + root.toString());
        int newDepth = depth;
        ++newDepth;
        int i = 0;
        while (i < root.getNumChildren()) {
            LQTree.printTree(root.getChild(i), newDepth);
            ++i;
        }
    }
}

