/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.jdbc.UnityDriver;
import unity.operators.MemoryManager;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.query.LQTree;
import unity.query.LQTreeConstants;
import unity.query.LocalQuery;
import unity.query.SubQuery;

public class Optimizer
implements LQTreeConstants {
    private GlobalQuery globalQuery;
    private ArrayList localQueryRootNodes;

    public Optimizer(GlobalQuery gq) {
        this.globalQuery = gq;
    }

    public GlobalQuery optimize() throws SQLException {
        ArrayList sqs = this.globalQuery.getSubQueries();
        int i = 0;
        while (i < sqs.size()) {
            SubQuery sq = (SubQuery)sqs.get(i);
            this.optimizeSubQuery(sq);
            ++i;
        }
        if (sqs.size() == 1) {
            this.globalQuery.setLocalQueries(((SubQuery)sqs.get(0)).getLocalQueries());
            this.globalQuery.setLocalProcessing(this.globalQuery.getLocalQueries().size() > 1);
        } else {
            this.globalQuery.setLocalProcessing(true);
            ArrayList localQueryNodes = new ArrayList();
            int i2 = 0;
            while (i2 < sqs.size()) {
                SubQuery sq = (SubQuery)sqs.get(i2);
                localQueryNodes.addAll(sq.getLocalQueries());
                ++i2;
            }
            this.globalQuery.setLocalQueries(localQueryNodes);
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\nStarting build execution tree.");
            this.globalQuery.getLogicalQueryTree().print();
        }
        this.buildExecutionTree(this.globalQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("Done build execution tree.");
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\n\nExecution tree:\n");
            Operator.printTree(this.globalQuery.getExecutionTree(), 0);
            System.out.println("\n\n");
        }
        return this.globalQuery;
    }

    public void optimizeSubQuery(SubQuery subQuery) throws SQLException {
        if (subQuery.numDatabases() > 1) {
            if (UnityDriver.DEBUG) {
                System.out.println("\n\n------BEGINNING OPTIMIZATION----- Starting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nStarting heuristic optimization.");
            }
            this.heuristicOptimization(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Done heuristic optimization.  Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nStarting cost optimization.");
            }
            this.costOptimization(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Done cost optimization. Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nStarting to push down multi-table selections.");
            }
            this.pushMultipleTableSelectsDown(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Done pushing down multi-table selections. Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
            }
        }
        if (UnityDriver.DEBUG) {
            System.out.println("\nStarted grouping.");
        }
        this.localQueryGrouping(subQuery);
        if (UnityDriver.DEBUG) {
            System.out.println("Done grouping.");
            subQuery.getLogicalQueryTree().print();
            System.out.println("Done.");
        }
        if (subQuery.numDatabases() > 1) {
            if (UnityDriver.DEBUG) {
                System.out.println("\nStarted post-optimization.");
            }
            this.postOptimization(subQuery);
            if (UnityDriver.DEBUG) {
                System.out.println("Finished post-optimization.  Resulting tree:\n");
                subQuery.getLogicalQueryTree().print();
                System.out.println("\nSearching for distributed joins.");
                this.findDistributedJoins(subQuery);
                System.out.println("Done processing distributed joins.");
            }
        }
    }

    private void heuristicOptimization(SubQuery subQuery) {
        LQTree lqt = subQuery.getLogicalQueryTree();
        ArrayList projectList = new ArrayList();
        ArrayList selectList = new ArrayList();
        ArrayList tableList = new ArrayList();
        ArrayList joinList = lqt.getJoinList();
        this.findProjectSelect(lqt.getRoot(), projectList, selectList, tableList, new ArrayList());
        int i = 0;
        while (i < selectList.size()) {
            LQSelNode sn = (LQSelNode)selectList.get(i);
            if (!sn.bHavingCondition) {
                ArrayList snFieldRefs = sn.getRequiredFields();
                ArrayList<GQTableRef> snTableRefs = new ArrayList<GQTableRef>();
                int j = 0;
                while (j < snFieldRefs.size()) {
                    GQTableRef gtref = ((GQFieldRef)snFieldRefs.get(j)).getTable();
                    if (!snTableRefs.contains(gtref)) {
                        snTableRefs.add(gtref);
                    }
                    ++j;
                }
                if (snTableRefs.size() == 1) {
                    LQNode cn = sn.getChild(0);
                    LQNode pn = sn.getParent();
                    cn.setParent(pn);
                    pn.replaceChild(sn, cn);
                    this.addSelectionNodeAboveTable(sn, tableList);
                    if (snFieldRefs.size() <= 1) {
                        GQFieldRef attrFieldRef = (GQFieldRef)snFieldRefs.get(0);
                        int j2 = 0;
                        while (j2 < joinList.size()) {
                            LQJoinNode jn = (LQJoinNode)joinList.get(j2);
                            LQNode equatedExprNode = this.findEquatedFieldInJoinCondition(jn.getCondition(), attrFieldRef);
                            if (equatedExprNode != null) {
                                LQSelNode newSelNode = new LQSelNode();
                                newSelNode.setCondition((LQCondNode)sn.getCondition().clone());
                                this.replaceFieldInCondition(newSelNode.getCondition(), attrFieldRef, (GQFieldRef)equatedExprNode.getContent());
                                this.addSelectionNodeAboveTable(newSelNode, tableList);
                                jn.setNoDistributedJoin(true);
                                if (UnityDriver.DEBUG) {
                                    System.out.println("Cloning a selection equated through a join.  New selection is: " + newSelNode.generateSQL());
                                }
                            }
                            ++j2;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private LQNode findEquatedFieldInJoinCondition(LQNode root, GQFieldRef fieldRef) {
        LQNode parentNode;
        if (root == null) {
            return null;
        }
        if (root instanceof LQExprNode && root.getContent() == fieldRef && (parentNode = root.getParent()).getContent().equals("=")) {
            if (parentNode.getChild(0) == root) {
                return parentNode.getChild(1);
            }
            return parentNode.getChild(0);
        }
        int i = 0;
        while (i < root.getNumChildren()) {
            LQNode retVal = this.findEquatedFieldInJoinCondition(root.getChild(i), fieldRef);
            if (retVal != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    private void replaceFieldInCondition(LQNode root, GQFieldRef oldField, GQFieldRef newField) {
        if (root == null) {
            return;
        }
        if (root instanceof LQExprNode && root.getContent() == oldField) {
            root.setContent(newField);
        }
        int i = 0;
        while (i < root.getNumChildren()) {
            this.replaceFieldInCondition(root.getChild(i), oldField, newField);
            ++i;
        }
    }

    private void costOptimization(SubQuery subQuery) {
        LQTree lqt = subQuery.getLogicalQueryTree();
        ArrayList joinList = lqt.getJoinList();
        if (UnityDriver.DEBUG) {
            System.out.println("Sizes of joins: ");
        }
        int i = 0;
        while (i < joinList.size()) {
            LQJoinNode jn = (LQJoinNode)joinList.get(i);
            if (UnityDriver.DEBUG) {
                System.out.println("***Join: " + jn);
            }
            jn.computeCost();
            int ntuples = jn.getNumTuples();
            int tsize = jn.getTupleSize();
            if (UnityDriver.DEBUG) {
                System.out.println(" Tuple count: " + ntuples + " Tuple size: " + tsize + " Cost: " + (long)jn.getCost());
            }
            ++i;
        }
        LQNode currentJoinNode = null;
        ArrayList<Object> tablesInJoin = new ArrayList<Object>();
        while (joinList.size() > 0) {
            LQJoinNode smallestCostJoin = (LQJoinNode)joinList.get(0);
            int j = 1;
            while (j < joinList.size()) {
                LQJoinNode jn = (LQJoinNode)joinList.get(j);
                if (smallestCostJoin.getCost() > jn.getCost()) {
                    LQNode ltable = jn.getChild(0);
                    while (ltable.getNumChildren() > 0) {
                        ltable = ltable.getChild(0);
                    }
                    LQNode rtable = jn.getChild(1);
                    while (rtable.getNumChildren() > 0) {
                        rtable = rtable.getChild(0);
                    }
                    if (tablesInJoin.size() == 0 || tablesInJoin.contains(ltable.getContent()) || tablesInJoin.contains(rtable.getContent())) {
                        smallestCostJoin = jn;
                    }
                }
                ++j;
            }
            if (UnityDriver.DEBUG) {
                System.out.println("Smallest cost join is: " + smallestCostJoin);
            }
            LQNode ltable = smallestCostJoin.getChild(0);
            while (ltable.getNumChildren() > 0) {
                ltable = ltable.getChild(0);
            }
            LQNode rtable = smallestCostJoin.getChild(1);
            while (rtable.getNumChildren() > 0) {
                rtable = rtable.getChild(0);
            }
            boolean leftTableInCommon = tablesInJoin.contains(ltable.getContent());
            if (currentJoinNode == null) {
                currentJoinNode = smallestCostJoin;
            } else {
                LQNode pn = currentJoinNode.getParent();
                if (pn == null) {
                    if (leftTableInCommon) {
                        smallestCostJoin.setChild(0, currentJoinNode);
                    } else {
                        smallestCostJoin.setChild(1, smallestCostJoin.getChild(0));
                        smallestCostJoin.setChild(0, currentJoinNode);
                        LQCondNode conditionRoot = smallestCostJoin.getCondition();
                        LQNode tmp = conditionRoot.getChild(1);
                        conditionRoot.setChild(1, conditionRoot.getChild(0));
                        conditionRoot.setChild(0, tmp);
                    }
                    currentJoinNode.setParent(smallestCostJoin);
                    currentJoinNode = smallestCostJoin;
                } else {
                    System.out.println("PROBLEM: Join node has a parent.  Exiting.");
                    System.exit(1);
                }
            }
            smallestCostJoin.getChild(0).setParent(currentJoinNode);
            smallestCostJoin.getChild(1).setParent(currentJoinNode);
            tablesInJoin.add(ltable.getContent());
            tablesInJoin.add(rtable.getContent());
            joinList.remove(joinList.indexOf(smallestCostJoin));
        }
        if (currentJoinNode != null) {
            LQNode cur = lqt.getRoot();
            LQNode lastNode = null;
            while (cur != null && cur.getType() != 207) {
                lastNode = cur;
                cur = cur.getType() == 201 ? cur.getChild(1) : cur.getChild(0);
            }
            if (cur == null) {
                cur = lastNode;
            }
            if ((cur = cur.getParent()).getType() == 201) {
                cur.setChild(1, currentJoinNode);
            } else {
                cur.setChild(0, currentJoinNode);
            }
            currentJoinNode.setParent(cur);
        }
    }

    private void pushMultipleTableSelectsDown(SubQuery subQuery) {
        LQTree lqt = subQuery.getLogicalQueryTree();
        ArrayList selectList = new ArrayList();
        ArrayList tableList = new ArrayList();
        this.findProjectSelect(lqt.getRoot(), new ArrayList(), selectList, tableList, new ArrayList());
        int i = 0;
        while (i < selectList.size()) {
            LQSelNode sn = (LQSelNode)selectList.get(i);
            ArrayList tmp = sn.getRequiredFields();
            ArrayList<GQTableRef> tableRefList = new ArrayList<GQTableRef>();
            int j = 0;
            while (j < tmp.size()) {
                GQTableRef tref = ((GQFieldRef)tmp.get(j)).getTable();
                if (!tableRefList.contains(tref)) {
                    tableRefList.add(tref);
                }
                ++j;
            }
            if (tableRefList.size() > 1) {
                LQNode curNode;
                ArrayList[] ancestorLists = new ArrayList[tableRefList.size()];
                int j2 = 0;
                while (j2 < tableRefList.size()) {
                    int loc = 0;
                    while (loc < tableList.size()) {
                        GQTableRef nodeTableRef;
                        GQTableRef tref = (GQTableRef)tableRefList.get(j2);
                        if (tref == (nodeTableRef = (GQTableRef)((LQNode)tableList.get(loc)).getContent())) break;
                        ++loc;
                    }
                    ArrayList<LQNode> ancestors = new ArrayList<LQNode>();
                    curNode = (LQNode)tableList.get(loc);
                    ancestors.add(curNode);
                    while (curNode.getParent() != null) {
                        curNode = curNode.getParent();
                        ancestors.add(0, curNode);
                    }
                    ancestorLists[j2] = ancestors;
                    ++j2;
                }
                LQNode insertNode = null;
                int k = 0;
                while (k < ancestorLists[0].size()) {
                    curNode = (LQNode)ancestorLists[0].get(k);
                    int j3 = 1;
                    while (j3 < ancestorLists.length) {
                        if (ancestorLists[j3].get(k) != curNode) {
                            insertNode = (LQNode)ancestorLists[0].get(k - 1);
                            k = ancestorLists[0].size();
                            break;
                        }
                        ++j3;
                    }
                    ++k;
                }
                LQNode cn = sn.getChild(0);
                LQNode pn = sn.getParent();
                cn.setParent(pn);
                pn.replaceChild(sn, cn);
                LQNode pn2 = insertNode.getParent();
                pn2.replaceChild(insertNode, sn);
                sn.setParent(pn2);
                sn.removeChild(0);
                sn.addChild(insertNode);
                insertNode.setParent(sn);
            }
            ++i;
        }
    }

    private void localQueryGrouping(SubQuery subQuery) {
        this.findLocalQueries(subQuery);
    }

    private void findProjectSelect(LQNode root, ArrayList projectList, ArrayList selectList, ArrayList tableList, ArrayList joinList) {
        if (root == null) {
            return;
        }
        if (root.getType() == 1) {
            projectList.add(root);
        } else if (root.getType() == 2) {
            selectList.add(root);
        } else if (root.getType() == 6) {
            tableList.add(root);
        } else if (root.getType() == 207) {
            joinList.add(root);
        }
        int i = 0;
        while (i < root.getNumChildren()) {
            this.findProjectSelect(root.getChild(i), projectList, selectList, tableList, joinList);
            ++i;
        }
    }

    private void findLocalQueries(SubQuery subQuery) {
        LQNode curLQNode;
        this.localQueryRootNodes = new ArrayList();
        LQTree lqtree = subQuery.getLogicalQueryTree();
        LQNode root = lqtree.getRoot();
        GQDatabaseRef dbref = this.findLQ(root, this.localQueryRootNodes, curLQNode = null);
        if (dbref != null) {
            this.localQueryRootNodes.add(root);
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Number of roots: " + this.localQueryRootNodes.size());
            int i = 0;
            while (i < this.localQueryRootNodes.size()) {
                System.out.println("Root " + i + ": " + this.localQueryRootNodes.get(i));
                ++i;
            }
        }
        subQuery.setLocalQueries(this.localQueryRootNodes);
    }

    private GQDatabaseRef findLQ(LQNode root, ArrayList lqs, LQNode curLQNode) {
        if (root == null) {
            return null;
        }
        if (root.getType() == 6) {
            return (GQDatabaseRef)root.getReference();
        }
        GQDatabaseRef newDBRef = null;
        ArrayList<GQDatabaseRef> dbRefs = new ArrayList<GQDatabaseRef>();
        int i = 0;
        while (i < root.getNumChildren()) {
            newDBRef = this.findLQ(root.getChild(i), lqs, curLQNode);
            if (!dbRefs.contains(newDBRef)) {
                dbRefs.add(newDBRef);
            }
            ++i;
        }
        if (dbRefs.size() > 1) {
            root.setReference(null);
            i = 0;
            while (i < root.getNumChildren()) {
                LQNode childNode = root.getChild(i);
                if (childNode.getReference() != null) {
                    lqs.add(childNode);
                }
                ++i;
            }
            return null;
        }
        root.setReference(newDBRef);
        return newDBRef;
    }

    private void postOptimization(SubQuery subQuery) {
        int i = 0;
        while (i < this.localQueryRootNodes.size()) {
            LQNode root = (LQNode)this.localQueryRootNodes.get(i);
            if (UnityDriver.DEBUG) {
                System.out.println("Processing local root: " + root);
            }
            ArrayList projectList = new ArrayList();
            this.findProjectSelect(root, projectList, new ArrayList(), new ArrayList(), new ArrayList());
            if (UnityDriver.DEBUG) {
                System.out.println("PROJECT LIST: " + projectList);
            }
            if (projectList.size() == 1) {
                LQNode pNode = (LQNode)projectList.get(0);
                if (pNode == root) {
                    // empty if block
                }
            } else {
                LQProjNode newNode = new LQProjNode();
                ArrayList requiredFields = new ArrayList();
                LQNode cur = root.getParent();
                while (cur != null) {
                    ArrayList flds = cur.getRequiredFields();
                    requiredFields.addAll(flds);
                    cur = cur.getParent();
                }
                int j = 0;
                while (j < projectList.size()) {
                    LQProjNode pNode = (LQProjNode)projectList.get(j);
                    ArrayList exprList = pNode.getExpressions();
                    int k = 0;
                    while (k < exprList.size()) {
                        LQExprNode child = (LQExprNode)exprList.get(k);
                        if (child.getType() == 100) {
                            GQFieldRef fref = (GQFieldRef)child.getContent();
                            if (requiredFields.contains(fref)) {
                                newNode.addExpression(child);
                            }
                        } else {
                            newNode.addExpression(child);
                        }
                        ++k;
                    }
                    LQNode parent = pNode.getParent();
                    if (parent != null) {
                        parent.replaceChild(pNode, pNode.getChild(0));
                        pNode.getChild(0).setParent(parent);
                    } else {
                        newNode.addChild(pNode.getChild(0));
                        pNode.getChild(0).setParent(newNode);
                    }
                    ++j;
                }
                LQNode parent = root.getParent();
                newNode.setParent(parent);
                if (newNode.getNumChildren() == 0) {
                    newNode.addChild(root);
                }
                parent.replaceChild(root, newNode);
                this.localQueryRootNodes.set(i, newNode);
                newNode.setReference(root.getReference());
            }
            ++i;
        }
    }

    private void findDistributedJoins(SubQuery subQuery) {
        double MAX_RATIO = 0.02;
        int MAX_SMALLER_SIZE = 1500;
        int MIN_LARGER_SIZE = 500;
        boolean leftSmallest = true;
        LQTree lqt = subQuery.getLogicalQueryTree();
        ArrayList joinList = new ArrayList();
        this.findProjectSelect(lqt.getRoot(), new ArrayList(), new ArrayList(), new ArrayList(), joinList);
        int i = 0;
        while (i < joinList.size()) {
            LQJoinNode join_node = (LQJoinNode)joinList.get(i);
            if (join_node.getNoDistributedJoin()) {
                if (UnityDriver.DEBUG) {
                    System.out.println("Flag set to avoid distributed join for node: " + join_node);
                }
            } else {
                ArrayList children = join_node.getChildren();
                LQNode leftChildNode = (LQNode)children.get(0);
                LQNode rightChildNode = (LQNode)children.get(1);
                Object lchild_ref = leftChildNode.getReference();
                Object rchild_ref = rightChildNode.getReference();
                int ltuples = leftChildNode.numTuples();
                int rtuples = rightChildNode.numTuples();
                if (join_node.getReference() == null && (rchild_ref != null || lchild_ref != null)) {
                    double ratio;
                    int largestTuples;
                    int smallestTuples;
                    boolean bl = leftSmallest = ltuples <= rtuples;
                    if (leftSmallest) {
                        smallestTuples = ltuples;
                        largestTuples = rtuples;
                        ratio = 1.0 * (double)ltuples / (double)rtuples;
                    } else {
                        smallestTuples = rtuples;
                        largestTuples = ltuples;
                        ratio = 1.0 * (double)rtuples / (double)ltuples;
                    }
                    if (UnityDriver.DEBUG) {
                        System.out.println("Distributed join info: Left tuples: " + ltuples + " Right tuples: " + rtuples + " Ratio: " + ratio);
                    }
                    if (ratio < 0.02 && smallestTuples < 1500 && largestTuples > 500) {
                        if (UnityDriver.DEBUG) {
                            System.out.println(" Join type is being changed to Distributed Join!! ");
                        }
                        join_node.setJoinType(302);
                        if (!leftSmallest || rchild_ref == null) {
                            join_node.setSwap();
                        }
                    }
                }
            }
            ++i;
        }
    }

    private GQTableRef getTableRef(LQSelNode sn) {
        ArrayList tmp = sn.getRequiredFields();
        return ((GQFieldRef)tmp.get(0)).getTable();
    }

    private void addSelectionNodeAboveTable(LQSelNode sn, ArrayList tableList) {
        GQTableRef attrTableRef = this.getTableRef(sn);
        int loc = 0;
        while (loc < tableList.size()) {
            GQTableRef nodeTableRef = (GQTableRef)((LQNode)tableList.get(loc)).getContent();
            if (attrTableRef == nodeTableRef) break;
            ++loc;
        }
        LQNode tableNode = (LQNode)tableList.get(loc);
        LQNode pn = tableNode.getParent();
        pn.replaceChild(tableNode, sn);
        sn.setParent(pn);
        sn.removeChild(0);
        sn.addChild(tableNode);
        tableNode.setParent(sn);
    }

    private void buildExecutionTree(GlobalQuery globalQuery) throws SQLException {
        ArrayList lqs = new ArrayList();
        LQNode root = globalQuery.getLogicalQueryTree().getRoot();
        ArrayList localQueryRootNodes = globalQuery.getLocalQueries();
        if (globalQuery.getLocalProcessing()) {
            MemoryManager.allocateQueryMemory(root, localQueryRootNodes);
        }
        globalQuery.setExecutionTree(this.buildExecTree(root, lqs, localQueryRootNodes));
        globalQuery.setLocalQueries(lqs);
    }

    private Operator buildExecTree(LQNode root, ArrayList lqs, ArrayList localQueryRootNodes) throws SQLException {
        if (root == null) {
            return null;
        }
        if (localQueryRootNodes.contains(root)) {
            LQNode lqnode = (LQNode)localQueryRootNodes.get(localQueryRootNodes.indexOf(root));
            LocalQuery lq = new LocalQuery((GQDatabaseRef)lqnode.getReference());
            lq.setSQLQueryString(this.buildSQL(root));
            ResultSetScan op = new ResultSetScan(lq);
            LQNode tmp = root;
            while (tmp != null && !(tmp instanceof LQProjNode)) {
                tmp = tmp.getChild(0);
            }
            if (tmp == null) {
                throw new SQLException("FATAL: Optimizer error related to local query generation.");
            }
            op.setOutputRelation(((LQProjNode)tmp).buildOutputRelation());
            lq.setResultSetScanOp(op);
            lqnode.setOperator(op);
            lqs.add(lq);
            if (UnityDriver.DEBUG) {
                System.out.println("\nGenerated a local query: \n" + lq.getSQLQueryString());
            }
            return op;
        }
        Operator[] children = new Operator[root.getNumChildren()];
        int i = 0;
        while (i < root.getNumChildren()) {
            children[i] = this.buildExecTree(root.getChild(i), lqs, localQueryRootNodes);
            ++i;
        }
        Operator op = root.buildOperator(children);
        return op;
    }

    private String buildSQL(LQNode root) {
        StringBuffer SELECT_clause = new StringBuffer();
        StringBuffer FROM_clause = new StringBuffer();
        StringBuffer WHERE_clause = new StringBuffer();
        StringBuffer ORDERBY_clause = new StringBuffer();
        StringBuffer GROUPBY_clause = new StringBuffer();
        StringBuffer HAVING_clause = new StringBuffer();
        StringBuffer sqlString = new StringBuffer();
        ArrayList<Object> tableList = new ArrayList<Object>();
        if (root == null) {
            return "";
        }
        Stack<LQNode> opStack = new Stack<LQNode>();
        opStack.push(root);
        while (!opStack.empty()) {
            LQNode curNode = (LQNode)opStack.pop();
            int nodeType = curNode.getType();
            if (nodeType == 1) {
                if (SELECT_clause.length() != 0) {
                    SELECT_clause.append(curNode.generateSQL());
                } else {
                    SELECT_clause.append("SELECT " + curNode.generateSQL());
                }
            } else if (nodeType == 16) {
                SELECT_clause.append("SELECT " + curNode.generateSQL() + " ");
            } else if (nodeType == 2) {
                if (!((LQSelNode)curNode).bHavingCondition) {
                    if (WHERE_clause.length() == 0) {
                        WHERE_clause.append(" WHERE " + curNode.generateSQL());
                    } else {
                        WHERE_clause.append(" AND " + curNode.generateSQL());
                    }
                } else {
                    HAVING_clause.append(" HAVING " + curNode.generateSQL());
                }
            } else if (nodeType == 207) {
                if (WHERE_clause.length() == 0) {
                    WHERE_clause.append(" WHERE " + curNode.generateSQL());
                } else {
                    WHERE_clause.append(" AND " + curNode.generateSQL());
                }
            } else if (nodeType == 6 || nodeType == 100) {
                if (FROM_clause.length() == 0) {
                    FROM_clause.append(" FROM " + curNode.generateSQL());
                } else {
                    FROM_clause.append(", " + curNode.generateSQL());
                }
                tableList.add(curNode.getContent());
            } else if (nodeType == 4) {
                if (ORDERBY_clause.length() == 0) {
                    ORDERBY_clause.append(" ORDER BY " + curNode.generateSQL());
                } else {
                    ORDERBY_clause.append(", " + curNode.generateSQL());
                }
            } else if (nodeType == 5 && !((LQGroupByNode)curNode).isEmptyGrouping()) {
                if (GROUPBY_clause.length() == 0) {
                    GROUPBY_clause.append(" GROUP BY " + curNode.generateSQL());
                } else {
                    GROUPBY_clause.append(", " + curNode.generateSQL());
                }
            }
            int i = 0;
            while (i < curNode.getNumChildren()) {
                opStack.push(curNode.getChild(i));
                ++i;
            }
        }
        if (SELECT_clause.length() == 0) {
            SELECT_clause.append("SELECT ");
            int i = 0;
            while (i < tableList.size()) {
                AnnotatedSourceTable ast = (AnnotatedSourceTable)tableList.get(i);
                HashMap sourceFields = ast.getSourceFields();
                Iterator fields = sourceFields.values().iterator();
                while (fields.hasNext()) {
                    AnnotatedSourceField asf = (AnnotatedSourceField)fields.next();
                    SELECT_clause.append(asf.getColumnName());
                    if (!fields.hasNext()) continue;
                    SELECT_clause.append(",");
                }
                if (i < tableList.size() - 1) {
                    SELECT_clause.append(",");
                }
                ++i;
            }
        }
        sqlString.append(SELECT_clause + "\n" + FROM_clause);
        if (WHERE_clause.length() > 0) {
            sqlString.append("\n" + WHERE_clause);
        }
        if (GROUPBY_clause.length() > 0) {
            sqlString.append("\n" + GROUPBY_clause);
        }
        if (ORDERBY_clause.length() > 0) {
            sqlString.append("\n" + ORDERBY_clause);
        }
        if (HAVING_clause.length() > 0) {
            sqlString.append("\n" + HAVING_clause);
        }
        return sqlString.toString();
    }
}

