/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;

public class ARRAY
extends DatumWithConnection
implements Array {
    ArrayDescriptor m_descriptor;
    Object m_objArray;
    Datum[] m_datumArray;
    byte[] m_locator;
    int m_numElems = -1;
    boolean m_enableBuffering = false;
    boolean m_enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int m_accessDirection = 3;
    long m_lastIndex;
    long m_lastOffset;
    long[] m_indexArray;
    long m_imgOffset;
    long m_imgLength;

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.m_descriptor = arrayDescriptor;
        DatumWithConnection.assertNotNull(connection);
        this.setPhysicalConnectionOf(connection);
        this.m_datumArray = object == null ? new Datum[0] : this.m_descriptor.toOracleArray(object, 1L, -1);
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(connection);
        this.setPhysicalConnectionOf(connection);
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.m_descriptor = arrayDescriptor;
        this.m_datumArray = null;
        this.m_locator = null;
    }

    public synchronized String getBaseTypeName() throws SQLException {
        String string = this.m_descriptor.getBaseName();
        return string;
    }

    public synchronized int getBaseType() throws SQLException {
        return this.m_descriptor.getBaseType();
    }

    public synchronized Object getArray() throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.m_enableBuffering);
    }

    public synchronized Object getArray(Map map) throws SQLException {
        return this.m_descriptor.toJavaArray(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized Object getArray(long l2, int n2) throws SQLException {
        if (l2 < 1L || n2 < 0) {
            DBError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l2, n2, this.getMap(), false);
    }

    public synchronized Object getArray(long l2, int n2, Map map) throws SQLException {
        if (l2 < 1L || n2 < 0) {
            DBError.check_error(68, "getArray()");
        }
        return this.m_descriptor.toJavaArray(this, l2, n2, map, false);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        return this.m_descriptor.toResultSet(this, 1L, -1, map, this.m_enableBuffering);
    }

    public synchronized ResultSet getResultSet(long l2, int n2) throws SQLException {
        return this.getResultSet(l2, n2, this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l2, int n2, Map map) throws SQLException {
        if (l2 < 1L || n2 < -1) {
            DBError.check_error(68, "getResultSet()");
        }
        return this.m_descriptor.toResultSet(this, l2, n2, map, false);
    }

    public synchronized Datum[] getOracleArray() throws SQLException {
        return this.m_descriptor.toOracleArray(this, 1L, -1, this.m_enableBuffering);
    }

    public synchronized int length() throws SQLException {
        return this.m_descriptor.toLength(this);
    }

    public synchronized Datum[] getOracleArray(long l2, int n2) throws SQLException {
        if (l2 < 1L || n2 < 0) {
            DBError.check_error(68, "getOracleArray()");
        }
        return this.m_descriptor.toOracleArray(this, l2, n2, false);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        String string = null;
        if (this.m_descriptor != null) {
            string = this.m_descriptor.getName();
        } else {
            DBError.check_error(61, "ARRAY");
        }
        return string;
    }

    public Map getMap() throws SQLException {
        return this.getInternalConnection().getTypeMap();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public synchronized byte[] toBytes() throws SQLException {
        return this.m_descriptor.toBytes(this, this.m_enableBuffering);
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.m_datumArray = datumArray;
    }

    public synchronized void setObjArray(Object object) throws SQLException {
        if (object == null) {
            DBError.throwSqlException(1);
        }
        this.m_objArray = object;
    }

    public synchronized void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.m_locator = byArray;
        }
    }

    public byte[] getLocator() {
        return this.m_locator;
    }

    public synchronized void setLength(int n2) {
        this.m_numElems = n2;
    }

    public boolean hasDataSeg() {
        return this.m_locator == null;
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new Object[n2][];
    }

    public synchronized int[] getIntArray() throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, 1L, -1, 4, this.m_enableBuffering);
    }

    public synchronized int[] getIntArray(long l2, int n2) throws SQLException {
        return (int[])this.m_descriptor.toNumericArray(this, l2, n2, 4, false);
    }

    public synchronized double[] getDoubleArray() throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, 1L, -1, 5, this.m_enableBuffering);
    }

    public synchronized double[] getDoubleArray(long l2, int n2) throws SQLException {
        return (double[])this.m_descriptor.toNumericArray(this, l2, n2, 5, false);
    }

    public synchronized short[] getShortArray() throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, 1L, -1, 8, this.m_enableBuffering);
    }

    public synchronized short[] getShortArray(long l2, int n2) throws SQLException {
        return (short[])this.m_descriptor.toNumericArray(this, l2, n2, 8, false);
    }

    public synchronized long[] getLongArray() throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, 1L, -1, 7, this.m_enableBuffering);
    }

    public synchronized long[] getLongArray(long l2, int n2) throws SQLException {
        return (long[])this.m_descriptor.toNumericArray(this, l2, n2, 7, false);
    }

    public synchronized float[] getFloatArray() throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, 1L, -1, 6, this.m_enableBuffering);
    }

    public synchronized float[] getFloatArray(long l2, int n2) throws SQLException {
        return (float[])this.m_descriptor.toNumericArray(this, l2, n2, 6, false);
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.m_enableBuffering = bl;
    }

    public boolean getAutoBuffering() throws SQLException {
        return this.m_enableBuffering;
    }

    public synchronized void setAutoIndexing(boolean bl, int n2) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = n2;
    }

    public synchronized void setAutoIndexing(boolean bl) throws SQLException {
        this.m_enableIndexing = bl;
        this.m_accessDirection = 3;
    }

    public boolean getAutoIndexing() throws SQLException {
        return this.m_enableIndexing;
    }

    public int getAccessDirection() throws SQLException {
        return this.m_accessDirection;
    }

    public void setLastIndexOffset(long l2, long l3) throws SQLException {
        this.m_lastIndex = l2;
        this.m_lastOffset = l3;
    }

    public void setIndexOffset(long l2, long l3) throws SQLException {
        if (this.m_indexArray == null) {
            this.m_indexArray = new long[this.m_numElems];
        }
        this.m_indexArray[(int)l2 - 1] = l3;
    }

    public long getLastIndex() throws SQLException {
        return this.m_lastIndex;
    }

    public long getLastOffset() throws SQLException {
        return this.m_lastOffset;
    }

    public long getOffset(long l2) throws SQLException {
        long l3 = -1L;
        if (this.m_indexArray != null) {
            l3 = this.m_indexArray[(int)l2 - 1];
        }
        return l3;
    }

    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        this.setShareBytes(byArray);
        this.m_imgOffset = l2;
        this.m_imgLength = l3;
    }

    public void setImageLength(long l2) throws SQLException {
        this.m_imgLength = l2;
    }

    public long getImageOffset() {
        return this.m_imgOffset;
    }

    public long getImageLength() {
        return this.m_imgLength;
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }
}

